package software.amazon.awscdk.services.personalize;

/**
 * <blockquote><p>By default, all new solutions use automatic training.<p></blockquote>
 * <p>
 * With automatic training, you incur training costs while your solution is active. To avoid unnecessary costs, when you are finished you can <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateSolution.html">update the solution</a> to turn off automatic training. For information about training costs, see <a href="https://docs.aws.amazon.com/https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a> .
 * <p>
 * An object that provides information about a solution. A solution includes the custom recipe, customized parameters, and trained models (Solution Versions) that Amazon Personalize uses to generate recommendations.
 * <p>
 * After you create a solution, you can’t change its configuration. If you need to make changes, you can <a href="https://docs.aws.amazon.com/personalize/latest/dg/cloning-solution.html">clone the solution</a> with the Amazon Personalize console or create a new one.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.personalize.*;
 * Object autoMlConfig;
 * Object hpoConfig;
 * CfnSolution cfnSolution = CfnSolution.Builder.create(this, "MyCfnSolution")
 *         .datasetGroupArn("datasetGroupArn")
 *         .name("name")
 *         // the properties below are optional
 *         .eventType("eventType")
 *         .performAutoMl(false)
 *         .performHpo(false)
 *         .recipeArn("recipeArn")
 *         .solutionConfig(SolutionConfigProperty.builder()
 *                 .algorithmHyperParameters(Map.of(
 *                         "algorithmHyperParametersKey", "algorithmHyperParameters"))
 *                 .autoMlConfig(autoMlConfig)
 *                 .eventValueThreshold("eventValueThreshold")
 *                 .featureTransformationParameters(Map.of(
 *                         "featureTransformationParametersKey", "featureTransformationParameters"))
 *                 .hpoConfig(hpoConfig)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:35.634Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution")
public class CfnSolution extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSolution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSolution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.personalize.CfnSolution.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSolution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.personalize.CfnSolutionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSolutionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSolutionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatasetGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "datasetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetGroupArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datasetGroupArn", java.util.Objects.requireNonNull(value, "datasetGroupArn is required"));
    }

    /**
     * The name of the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The event type (for example, 'click' or 'like') that is used for training the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
        return software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The event type (for example, 'click' or 'like') that is used for training the model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventType", value);
    }

    /**
     * <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPerformAutoMl() {
        return software.amazon.jsii.Kernel.get(this, "performAutoMl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformAutoMl(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "performAutoMl", value);
    }

    /**
     * <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformAutoMl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "performAutoMl", value);
    }

    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPerformHpo() {
        return software.amazon.jsii.Kernel.get(this, "performHpo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformHpo(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "performHpo", value);
    }

    /**
     * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformHpo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "performHpo", value);
    }

    /**
     * The ARN of the recipe used to create the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRecipeArn() {
        return software.amazon.jsii.Kernel.get(this, "recipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the recipe used to create the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecipeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "recipeArn", value);
    }

    /**
     * Describes the configuration properties for the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSolutionConfig() {
        return software.amazon.jsii.Kernel.get(this, "solutionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration properties for the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSolutionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "solutionConfig", value);
    }

    /**
     * Describes the configuration properties for the solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSolutionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "solutionConfig", value);
    }
    /**
     * Specifies the hyperparameters and their ranges.
     * <p>
     * Hyperparameters can be categorical, continuous, or integer-valued.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * AlgorithmHyperParameterRangesProperty algorithmHyperParameterRangesProperty = AlgorithmHyperParameterRangesProperty.builder()
     *         .categoricalHyperParameterRanges(List.of(CategoricalHyperParameterRangeProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .continuousHyperParameterRanges(List.of(ContinuousHyperParameterRangeProperty.builder()
     *                 .maxValue(123)
     *                 .minValue(123)
     *                 .name("name")
     *                 .build()))
     *         .integerHyperParameterRanges(List.of(IntegerHyperParameterRangeProperty.builder()
     *                 .maxValue(123)
     *                 .minValue(123)
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.AlgorithmHyperParameterRangesProperty")
    @software.amazon.jsii.Jsii.Proxy(AlgorithmHyperParameterRangesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlgorithmHyperParameterRangesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Provides the name and range of a categorical hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html#cfn-personalize-solution-algorithmhyperparameterranges-categoricalhyperparameterranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html#cfn-personalize-solution-algorithmhyperparameterranges-categoricalhyperparameterranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoricalHyperParameterRanges() {
            return null;
        }

        /**
         * Provides the name and range of a continuous hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html#cfn-personalize-solution-algorithmhyperparameterranges-continuoushyperparameterranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html#cfn-personalize-solution-algorithmhyperparameterranges-continuoushyperparameterranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContinuousHyperParameterRanges() {
            return null;
        }

        /**
         * Provides the name and range of an integer-valued hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html#cfn-personalize-solution-algorithmhyperparameterranges-integerhyperparameterranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-algorithmhyperparameterranges.html#cfn-personalize-solution-algorithmhyperparameterranges-integerhyperparameterranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerHyperParameterRanges() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlgorithmHyperParameterRangesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlgorithmHyperParameterRangesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlgorithmHyperParameterRangesProperty> {
            java.lang.Object categoricalHyperParameterRanges;
            java.lang.Object continuousHyperParameterRanges;
            java.lang.Object integerHyperParameterRanges;

            /**
             * Sets the value of {@link AlgorithmHyperParameterRangesProperty#getCategoricalHyperParameterRanges}
             * @param categoricalHyperParameterRanges Provides the name and range of a categorical hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoricalHyperParameterRanges(software.amazon.awscdk.IResolvable categoricalHyperParameterRanges) {
                this.categoricalHyperParameterRanges = categoricalHyperParameterRanges;
                return this;
            }

            /**
             * Sets the value of {@link AlgorithmHyperParameterRangesProperty#getCategoricalHyperParameterRanges}
             * @param categoricalHyperParameterRanges Provides the name and range of a categorical hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoricalHyperParameterRanges(java.util.List<? extends java.lang.Object> categoricalHyperParameterRanges) {
                this.categoricalHyperParameterRanges = categoricalHyperParameterRanges;
                return this;
            }

            /**
             * Sets the value of {@link AlgorithmHyperParameterRangesProperty#getContinuousHyperParameterRanges}
             * @param continuousHyperParameterRanges Provides the name and range of a continuous hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continuousHyperParameterRanges(software.amazon.awscdk.IResolvable continuousHyperParameterRanges) {
                this.continuousHyperParameterRanges = continuousHyperParameterRanges;
                return this;
            }

            /**
             * Sets the value of {@link AlgorithmHyperParameterRangesProperty#getContinuousHyperParameterRanges}
             * @param continuousHyperParameterRanges Provides the name and range of a continuous hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continuousHyperParameterRanges(java.util.List<? extends java.lang.Object> continuousHyperParameterRanges) {
                this.continuousHyperParameterRanges = continuousHyperParameterRanges;
                return this;
            }

            /**
             * Sets the value of {@link AlgorithmHyperParameterRangesProperty#getIntegerHyperParameterRanges}
             * @param integerHyperParameterRanges Provides the name and range of an integer-valued hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerHyperParameterRanges(software.amazon.awscdk.IResolvable integerHyperParameterRanges) {
                this.integerHyperParameterRanges = integerHyperParameterRanges;
                return this;
            }

            /**
             * Sets the value of {@link AlgorithmHyperParameterRangesProperty#getIntegerHyperParameterRanges}
             * @param integerHyperParameterRanges Provides the name and range of an integer-valued hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerHyperParameterRanges(java.util.List<? extends java.lang.Object> integerHyperParameterRanges) {
                this.integerHyperParameterRanges = integerHyperParameterRanges;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlgorithmHyperParameterRangesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlgorithmHyperParameterRangesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlgorithmHyperParameterRangesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlgorithmHyperParameterRangesProperty {
            private final java.lang.Object categoricalHyperParameterRanges;
            private final java.lang.Object continuousHyperParameterRanges;
            private final java.lang.Object integerHyperParameterRanges;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.categoricalHyperParameterRanges = software.amazon.jsii.Kernel.get(this, "categoricalHyperParameterRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.continuousHyperParameterRanges = software.amazon.jsii.Kernel.get(this, "continuousHyperParameterRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.integerHyperParameterRanges = software.amazon.jsii.Kernel.get(this, "integerHyperParameterRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.categoricalHyperParameterRanges = builder.categoricalHyperParameterRanges;
                this.continuousHyperParameterRanges = builder.continuousHyperParameterRanges;
                this.integerHyperParameterRanges = builder.integerHyperParameterRanges;
            }

            @Override
            public final java.lang.Object getCategoricalHyperParameterRanges() {
                return this.categoricalHyperParameterRanges;
            }

            @Override
            public final java.lang.Object getContinuousHyperParameterRanges() {
                return this.continuousHyperParameterRanges;
            }

            @Override
            public final java.lang.Object getIntegerHyperParameterRanges() {
                return this.integerHyperParameterRanges;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCategoricalHyperParameterRanges() != null) {
                    data.set("categoricalHyperParameterRanges", om.valueToTree(this.getCategoricalHyperParameterRanges()));
                }
                if (this.getContinuousHyperParameterRanges() != null) {
                    data.set("continuousHyperParameterRanges", om.valueToTree(this.getContinuousHyperParameterRanges()));
                }
                if (this.getIntegerHyperParameterRanges() != null) {
                    data.set("integerHyperParameterRanges", om.valueToTree(this.getIntegerHyperParameterRanges()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.AlgorithmHyperParameterRangesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlgorithmHyperParameterRangesProperty.Jsii$Proxy that = (AlgorithmHyperParameterRangesProperty.Jsii$Proxy) o;

                if (this.categoricalHyperParameterRanges != null ? !this.categoricalHyperParameterRanges.equals(that.categoricalHyperParameterRanges) : that.categoricalHyperParameterRanges != null) return false;
                if (this.continuousHyperParameterRanges != null ? !this.continuousHyperParameterRanges.equals(that.continuousHyperParameterRanges) : that.continuousHyperParameterRanges != null) return false;
                return this.integerHyperParameterRanges != null ? this.integerHyperParameterRanges.equals(that.integerHyperParameterRanges) : that.integerHyperParameterRanges == null;
            }

            @Override
            public final int hashCode() {
                int result = this.categoricalHyperParameterRanges != null ? this.categoricalHyperParameterRanges.hashCode() : 0;
                result = 31 * result + (this.continuousHyperParameterRanges != null ? this.continuousHyperParameterRanges.hashCode() : 0);
                result = 31 * result + (this.integerHyperParameterRanges != null ? this.integerHyperParameterRanges.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When the solution performs AutoML ( <code>performAutoML</code> is true in <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> ), Amazon Personalize determines which recipe, from the specified list, optimizes the given metric. Amazon Personalize then uses that recipe for the solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * AutoMLConfigProperty autoMLConfigProperty = AutoMLConfigProperty.builder()
     *         .metricName("metricName")
     *         .recipeList(List.of("recipeList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-automlconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-automlconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.AutoMLConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoMLConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoMLConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric to optimize.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-automlconfig.html#cfn-personalize-solution-automlconfig-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-automlconfig.html#cfn-personalize-solution-automlconfig-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * The list of candidate recipes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-automlconfig.html#cfn-personalize-solution-automlconfig-recipelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-automlconfig.html#cfn-personalize-solution-automlconfig-recipelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRecipeList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoMLConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoMLConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoMLConfigProperty> {
            java.lang.String metricName;
            java.util.List<java.lang.String> recipeList;

            /**
             * Sets the value of {@link AutoMLConfigProperty#getMetricName}
             * @param metricName The metric to optimize.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link AutoMLConfigProperty#getRecipeList}
             * @param recipeList The list of candidate recipes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recipeList(java.util.List<java.lang.String> recipeList) {
                this.recipeList = recipeList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoMLConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoMLConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoMLConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoMLConfigProperty {
            private final java.lang.String metricName;
            private final java.util.List<java.lang.String> recipeList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recipeList = software.amazon.jsii.Kernel.get(this, "recipeList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = builder.metricName;
                this.recipeList = builder.recipeList;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.util.List<java.lang.String> getRecipeList() {
                return this.recipeList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getRecipeList() != null) {
                    data.set("recipeList", om.valueToTree(this.getRecipeList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.AutoMLConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoMLConfigProperty.Jsii$Proxy that = (AutoMLConfigProperty.Jsii$Proxy) o;

                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                return this.recipeList != null ? this.recipeList.equals(that.recipeList) : that.recipeList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName != null ? this.metricName.hashCode() : 0;
                result = 31 * result + (this.recipeList != null ? this.recipeList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the name and range of a categorical hyperparameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * CategoricalHyperParameterRangeProperty categoricalHyperParameterRangeProperty = CategoricalHyperParameterRangeProperty.builder()
     *         .name("name")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-categoricalhyperparameterrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-categoricalhyperparameterrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.CategoricalHyperParameterRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(CategoricalHyperParameterRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CategoricalHyperParameterRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-categoricalhyperparameterrange.html#cfn-personalize-solution-categoricalhyperparameterrange-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-categoricalhyperparameterrange.html#cfn-personalize-solution-categoricalhyperparameterrange-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A list of the categories for the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-categoricalhyperparameterrange.html#cfn-personalize-solution-categoricalhyperparameterrange-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-categoricalhyperparameterrange.html#cfn-personalize-solution-categoricalhyperparameterrange-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CategoricalHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CategoricalHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CategoricalHyperParameterRangeProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link CategoricalHyperParameterRangeProperty#getName}
             * @param name The name of the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CategoricalHyperParameterRangeProperty#getValues}
             * @param values A list of the categories for the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CategoricalHyperParameterRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CategoricalHyperParameterRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CategoricalHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CategoricalHyperParameterRangeProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.CategoricalHyperParameterRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CategoricalHyperParameterRangeProperty.Jsii$Proxy that = (CategoricalHyperParameterRangeProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the name and range of a continuous hyperparameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * ContinuousHyperParameterRangeProperty continuousHyperParameterRangeProperty = ContinuousHyperParameterRangeProperty.builder()
     *         .maxValue(123)
     *         .minValue(123)
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.ContinuousHyperParameterRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(ContinuousHyperParameterRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContinuousHyperParameterRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum allowable value for the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html#cfn-personalize-solution-continuoushyperparameterrange-maxvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html#cfn-personalize-solution-continuoushyperparameterrange-maxvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxValue() {
            return null;
        }

        /**
         * The minimum allowable value for the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html#cfn-personalize-solution-continuoushyperparameterrange-minvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html#cfn-personalize-solution-continuoushyperparameterrange-minvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinValue() {
            return null;
        }

        /**
         * The name of the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html#cfn-personalize-solution-continuoushyperparameterrange-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-continuoushyperparameterrange.html#cfn-personalize-solution-continuoushyperparameterrange-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContinuousHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContinuousHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContinuousHyperParameterRangeProperty> {
            java.lang.Number maxValue;
            java.lang.Number minValue;
            java.lang.String name;

            /**
             * Sets the value of {@link ContinuousHyperParameterRangeProperty#getMaxValue}
             * @param maxValue The maximum allowable value for the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.Number maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousHyperParameterRangeProperty#getMinValue}
             * @param minValue The minimum allowable value for the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.Number minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Sets the value of {@link ContinuousHyperParameterRangeProperty#getName}
             * @param name The name of the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContinuousHyperParameterRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContinuousHyperParameterRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContinuousHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContinuousHyperParameterRangeProperty {
            private final java.lang.Number maxValue;
            private final java.lang.Number minValue;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxValue = builder.maxValue;
                this.minValue = builder.minValue;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Number getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.Number getMinValue() {
                return this.minValue;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxValue() != null) {
                    data.set("maxValue", om.valueToTree(this.getMaxValue()));
                }
                if (this.getMinValue() != null) {
                    data.set("minValue", om.valueToTree(this.getMinValue()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.ContinuousHyperParameterRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContinuousHyperParameterRangeProperty.Jsii$Proxy that = (ContinuousHyperParameterRangeProperty.Jsii$Proxy) o;

                if (this.maxValue != null ? !this.maxValue.equals(that.maxValue) : that.maxValue != null) return false;
                if (this.minValue != null ? !this.minValue.equals(that.minValue) : that.minValue != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxValue != null ? this.maxValue.hashCode() : 0;
                result = 31 * result + (this.minValue != null ? this.minValue.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the properties for hyperparameter optimization (HPO).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * HpoConfigProperty hpoConfigProperty = HpoConfigProperty.builder()
     *         .algorithmHyperParameterRanges(AlgorithmHyperParameterRangesProperty.builder()
     *                 .categoricalHyperParameterRanges(List.of(CategoricalHyperParameterRangeProperty.builder()
     *                         .name("name")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .continuousHyperParameterRanges(List.of(ContinuousHyperParameterRangeProperty.builder()
     *                         .maxValue(123)
     *                         .minValue(123)
     *                         .name("name")
     *                         .build()))
     *                 .integerHyperParameterRanges(List.of(IntegerHyperParameterRangeProperty.builder()
     *                         .maxValue(123)
     *                         .minValue(123)
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .hpoObjective(HpoObjectiveProperty.builder()
     *                 .metricName("metricName")
     *                 .metricRegex("metricRegex")
     *                 .type("type")
     *                 .build())
     *         .hpoResourceConfig(HpoResourceConfigProperty.builder()
     *                 .maxNumberOfTrainingJobs("maxNumberOfTrainingJobs")
     *                 .maxParallelTrainingJobs("maxParallelTrainingJobs")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.HpoConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HpoConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HpoConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hyperparameters and their allowable ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html#cfn-personalize-solution-hpoconfig-algorithmhyperparameterranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html#cfn-personalize-solution-hpoconfig-algorithmhyperparameterranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlgorithmHyperParameterRanges() {
            return null;
        }

        /**
         * The metric to optimize during HPO.
         * <p>
         * <blockquote>
         * <p>
         * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html#cfn-personalize-solution-hpoconfig-hpoobjective">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html#cfn-personalize-solution-hpoconfig-hpoobjective</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHpoObjective() {
            return null;
        }

        /**
         * Describes the resource configuration for HPO.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html#cfn-personalize-solution-hpoconfig-hporesourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoconfig.html#cfn-personalize-solution-hpoconfig-hporesourceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHpoResourceConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HpoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HpoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HpoConfigProperty> {
            java.lang.Object algorithmHyperParameterRanges;
            java.lang.Object hpoObjective;
            java.lang.Object hpoResourceConfig;

            /**
             * Sets the value of {@link HpoConfigProperty#getAlgorithmHyperParameterRanges}
             * @param algorithmHyperParameterRanges The hyperparameters and their allowable ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmHyperParameterRanges(software.amazon.awscdk.IResolvable algorithmHyperParameterRanges) {
                this.algorithmHyperParameterRanges = algorithmHyperParameterRanges;
                return this;
            }

            /**
             * Sets the value of {@link HpoConfigProperty#getAlgorithmHyperParameterRanges}
             * @param algorithmHyperParameterRanges The hyperparameters and their allowable ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmHyperParameterRanges(software.amazon.awscdk.services.personalize.CfnSolution.AlgorithmHyperParameterRangesProperty algorithmHyperParameterRanges) {
                this.algorithmHyperParameterRanges = algorithmHyperParameterRanges;
                return this;
            }

            /**
             * Sets the value of {@link HpoConfigProperty#getHpoObjective}
             * @param hpoObjective The metric to optimize during HPO.
             *                     <blockquote>
             *                     <p>
             *                     Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hpoObjective(software.amazon.awscdk.IResolvable hpoObjective) {
                this.hpoObjective = hpoObjective;
                return this;
            }

            /**
             * Sets the value of {@link HpoConfigProperty#getHpoObjective}
             * @param hpoObjective The metric to optimize during HPO.
             *                     <blockquote>
             *                     <p>
             *                     Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hpoObjective(software.amazon.awscdk.services.personalize.CfnSolution.HpoObjectiveProperty hpoObjective) {
                this.hpoObjective = hpoObjective;
                return this;
            }

            /**
             * Sets the value of {@link HpoConfigProperty#getHpoResourceConfig}
             * @param hpoResourceConfig Describes the resource configuration for HPO.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hpoResourceConfig(software.amazon.awscdk.IResolvable hpoResourceConfig) {
                this.hpoResourceConfig = hpoResourceConfig;
                return this;
            }

            /**
             * Sets the value of {@link HpoConfigProperty#getHpoResourceConfig}
             * @param hpoResourceConfig Describes the resource configuration for HPO.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hpoResourceConfig(software.amazon.awscdk.services.personalize.CfnSolution.HpoResourceConfigProperty hpoResourceConfig) {
                this.hpoResourceConfig = hpoResourceConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HpoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HpoConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HpoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HpoConfigProperty {
            private final java.lang.Object algorithmHyperParameterRanges;
            private final java.lang.Object hpoObjective;
            private final java.lang.Object hpoResourceConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithmHyperParameterRanges = software.amazon.jsii.Kernel.get(this, "algorithmHyperParameterRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hpoObjective = software.amazon.jsii.Kernel.get(this, "hpoObjective", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hpoResourceConfig = software.amazon.jsii.Kernel.get(this, "hpoResourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithmHyperParameterRanges = builder.algorithmHyperParameterRanges;
                this.hpoObjective = builder.hpoObjective;
                this.hpoResourceConfig = builder.hpoResourceConfig;
            }

            @Override
            public final java.lang.Object getAlgorithmHyperParameterRanges() {
                return this.algorithmHyperParameterRanges;
            }

            @Override
            public final java.lang.Object getHpoObjective() {
                return this.hpoObjective;
            }

            @Override
            public final java.lang.Object getHpoResourceConfig() {
                return this.hpoResourceConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlgorithmHyperParameterRanges() != null) {
                    data.set("algorithmHyperParameterRanges", om.valueToTree(this.getAlgorithmHyperParameterRanges()));
                }
                if (this.getHpoObjective() != null) {
                    data.set("hpoObjective", om.valueToTree(this.getHpoObjective()));
                }
                if (this.getHpoResourceConfig() != null) {
                    data.set("hpoResourceConfig", om.valueToTree(this.getHpoResourceConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.HpoConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HpoConfigProperty.Jsii$Proxy that = (HpoConfigProperty.Jsii$Proxy) o;

                if (this.algorithmHyperParameterRanges != null ? !this.algorithmHyperParameterRanges.equals(that.algorithmHyperParameterRanges) : that.algorithmHyperParameterRanges != null) return false;
                if (this.hpoObjective != null ? !this.hpoObjective.equals(that.hpoObjective) : that.hpoObjective != null) return false;
                return this.hpoResourceConfig != null ? this.hpoResourceConfig.equals(that.hpoResourceConfig) : that.hpoResourceConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithmHyperParameterRanges != null ? this.algorithmHyperParameterRanges.hashCode() : 0;
                result = 31 * result + (this.hpoObjective != null ? this.hpoObjective.hashCode() : 0);
                result = 31 * result + (this.hpoResourceConfig != null ? this.hpoResourceConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The metric to optimize during hyperparameter optimization (HPO).
     * <p>
     * <blockquote>
     * <p>
     * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * HpoObjectiveProperty hpoObjectiveProperty = HpoObjectiveProperty.builder()
     *         .metricName("metricName")
     *         .metricRegex("metricRegex")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.HpoObjectiveProperty")
    @software.amazon.jsii.Jsii.Proxy(HpoObjectiveProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HpoObjectiveProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html#cfn-personalize-solution-hpoobjective-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html#cfn-personalize-solution-hpoobjective-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * A regular expression for finding the metric in the training job logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html#cfn-personalize-solution-hpoobjective-metricregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html#cfn-personalize-solution-hpoobjective-metricregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricRegex() {
            return null;
        }

        /**
         * The type of the metric.
         * <p>
         * Valid values are <code>Maximize</code> and <code>Minimize</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html#cfn-personalize-solution-hpoobjective-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hpoobjective.html#cfn-personalize-solution-hpoobjective-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HpoObjectiveProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HpoObjectiveProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HpoObjectiveProperty> {
            java.lang.String metricName;
            java.lang.String metricRegex;
            java.lang.String type;

            /**
             * Sets the value of {@link HpoObjectiveProperty#getMetricName}
             * @param metricName The name of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link HpoObjectiveProperty#getMetricRegex}
             * @param metricRegex A regular expression for finding the metric in the training job logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricRegex(java.lang.String metricRegex) {
                this.metricRegex = metricRegex;
                return this;
            }

            /**
             * Sets the value of {@link HpoObjectiveProperty#getType}
             * @param type The type of the metric.
             *             Valid values are <code>Maximize</code> and <code>Minimize</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HpoObjectiveProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HpoObjectiveProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HpoObjectiveProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HpoObjectiveProperty {
            private final java.lang.String metricName;
            private final java.lang.String metricRegex;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricRegex = software.amazon.jsii.Kernel.get(this, "metricRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = builder.metricName;
                this.metricRegex = builder.metricRegex;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getMetricRegex() {
                return this.metricRegex;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getMetricRegex() != null) {
                    data.set("metricRegex", om.valueToTree(this.getMetricRegex()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.HpoObjectiveProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HpoObjectiveProperty.Jsii$Proxy that = (HpoObjectiveProperty.Jsii$Proxy) o;

                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                if (this.metricRegex != null ? !this.metricRegex.equals(that.metricRegex) : that.metricRegex != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName != null ? this.metricName.hashCode() : 0;
                result = 31 * result + (this.metricRegex != null ? this.metricRegex.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the resource configuration for hyperparameter optimization (HPO).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * HpoResourceConfigProperty hpoResourceConfigProperty = HpoResourceConfigProperty.builder()
     *         .maxNumberOfTrainingJobs("maxNumberOfTrainingJobs")
     *         .maxParallelTrainingJobs("maxParallelTrainingJobs")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hporesourceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hporesourceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.HpoResourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HpoResourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HpoResourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of training jobs when you create a solution version.
         * <p>
         * The maximum value for <code>maxNumberOfTrainingJobs</code> is <code>40</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hporesourceconfig.html#cfn-personalize-solution-hporesourceconfig-maxnumberoftrainingjobs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hporesourceconfig.html#cfn-personalize-solution-hporesourceconfig-maxnumberoftrainingjobs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxNumberOfTrainingJobs() {
            return null;
        }

        /**
         * The maximum number of parallel training jobs when you create a solution version.
         * <p>
         * The maximum value for <code>maxParallelTrainingJobs</code> is <code>10</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hporesourceconfig.html#cfn-personalize-solution-hporesourceconfig-maxparalleltrainingjobs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-hporesourceconfig.html#cfn-personalize-solution-hporesourceconfig-maxparalleltrainingjobs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxParallelTrainingJobs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HpoResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HpoResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HpoResourceConfigProperty> {
            java.lang.String maxNumberOfTrainingJobs;
            java.lang.String maxParallelTrainingJobs;

            /**
             * Sets the value of {@link HpoResourceConfigProperty#getMaxNumberOfTrainingJobs}
             * @param maxNumberOfTrainingJobs The maximum number of training jobs when you create a solution version.
             *                                The maximum value for <code>maxNumberOfTrainingJobs</code> is <code>40</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxNumberOfTrainingJobs(java.lang.String maxNumberOfTrainingJobs) {
                this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
                return this;
            }

            /**
             * Sets the value of {@link HpoResourceConfigProperty#getMaxParallelTrainingJobs}
             * @param maxParallelTrainingJobs The maximum number of parallel training jobs when you create a solution version.
             *                                The maximum value for <code>maxParallelTrainingJobs</code> is <code>10</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxParallelTrainingJobs(java.lang.String maxParallelTrainingJobs) {
                this.maxParallelTrainingJobs = maxParallelTrainingJobs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HpoResourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HpoResourceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HpoResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HpoResourceConfigProperty {
            private final java.lang.String maxNumberOfTrainingJobs;
            private final java.lang.String maxParallelTrainingJobs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxNumberOfTrainingJobs = software.amazon.jsii.Kernel.get(this, "maxNumberOfTrainingJobs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxParallelTrainingJobs = software.amazon.jsii.Kernel.get(this, "maxParallelTrainingJobs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxNumberOfTrainingJobs = builder.maxNumberOfTrainingJobs;
                this.maxParallelTrainingJobs = builder.maxParallelTrainingJobs;
            }

            @Override
            public final java.lang.String getMaxNumberOfTrainingJobs() {
                return this.maxNumberOfTrainingJobs;
            }

            @Override
            public final java.lang.String getMaxParallelTrainingJobs() {
                return this.maxParallelTrainingJobs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxNumberOfTrainingJobs() != null) {
                    data.set("maxNumberOfTrainingJobs", om.valueToTree(this.getMaxNumberOfTrainingJobs()));
                }
                if (this.getMaxParallelTrainingJobs() != null) {
                    data.set("maxParallelTrainingJobs", om.valueToTree(this.getMaxParallelTrainingJobs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.HpoResourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HpoResourceConfigProperty.Jsii$Proxy that = (HpoResourceConfigProperty.Jsii$Proxy) o;

                if (this.maxNumberOfTrainingJobs != null ? !this.maxNumberOfTrainingJobs.equals(that.maxNumberOfTrainingJobs) : that.maxNumberOfTrainingJobs != null) return false;
                return this.maxParallelTrainingJobs != null ? this.maxParallelTrainingJobs.equals(that.maxParallelTrainingJobs) : that.maxParallelTrainingJobs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxNumberOfTrainingJobs != null ? this.maxNumberOfTrainingJobs.hashCode() : 0;
                result = 31 * result + (this.maxParallelTrainingJobs != null ? this.maxParallelTrainingJobs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the name and range of an integer-valued hyperparameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * IntegerHyperParameterRangeProperty integerHyperParameterRangeProperty = IntegerHyperParameterRangeProperty.builder()
     *         .maxValue(123)
     *         .minValue(123)
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.IntegerHyperParameterRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegerHyperParameterRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegerHyperParameterRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum allowable value for the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html#cfn-personalize-solution-integerhyperparameterrange-maxvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html#cfn-personalize-solution-integerhyperparameterrange-maxvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxValue() {
            return null;
        }

        /**
         * The minimum allowable value for the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html#cfn-personalize-solution-integerhyperparameterrange-minvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html#cfn-personalize-solution-integerhyperparameterrange-minvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinValue() {
            return null;
        }

        /**
         * The name of the hyperparameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html#cfn-personalize-solution-integerhyperparameterrange-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-integerhyperparameterrange.html#cfn-personalize-solution-integerhyperparameterrange-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegerHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegerHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegerHyperParameterRangeProperty> {
            java.lang.Number maxValue;
            java.lang.Number minValue;
            java.lang.String name;

            /**
             * Sets the value of {@link IntegerHyperParameterRangeProperty#getMaxValue}
             * @param maxValue The maximum allowable value for the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.Number maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link IntegerHyperParameterRangeProperty#getMinValue}
             * @param minValue The minimum allowable value for the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.Number minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Sets the value of {@link IntegerHyperParameterRangeProperty#getName}
             * @param name The name of the hyperparameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegerHyperParameterRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegerHyperParameterRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegerHyperParameterRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegerHyperParameterRangeProperty {
            private final java.lang.Number maxValue;
            private final java.lang.Number minValue;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxValue = builder.maxValue;
                this.minValue = builder.minValue;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Number getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.Number getMinValue() {
                return this.minValue;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxValue() != null) {
                    data.set("maxValue", om.valueToTree(this.getMaxValue()));
                }
                if (this.getMinValue() != null) {
                    data.set("minValue", om.valueToTree(this.getMinValue()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.IntegerHyperParameterRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegerHyperParameterRangeProperty.Jsii$Proxy that = (IntegerHyperParameterRangeProperty.Jsii$Proxy) o;

                if (this.maxValue != null ? !this.maxValue.equals(that.maxValue) : that.maxValue != null) return false;
                if (this.minValue != null ? !this.minValue.equals(that.minValue) : that.minValue != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxValue != null ? this.maxValue.hashCode() : 0;
                result = 31 * result + (this.minValue != null ? this.minValue.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration properties for the solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * Object autoMlConfig;
     * Object hpoConfig;
     * SolutionConfigProperty solutionConfigProperty = SolutionConfigProperty.builder()
     *         .algorithmHyperParameters(Map.of(
     *                 "algorithmHyperParametersKey", "algorithmHyperParameters"))
     *         .autoMlConfig(autoMlConfig)
     *         .eventValueThreshold("eventValueThreshold")
     *         .featureTransformationParameters(Map.of(
     *                 "featureTransformationParametersKey", "featureTransformationParameters"))
     *         .hpoConfig(hpoConfig)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnSolution.SolutionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SolutionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SolutionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Lists the algorithm hyperparameters and their values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-algorithmhyperparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-algorithmhyperparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlgorithmHyperParameters() {
            return null;
        }

        /**
         * The <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html">AutoMLConfig</a> object containing a list of recipes to search when AutoML is performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-automlconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-automlconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMlConfig() {
            return null;
        }

        /**
         * Only events with a value greater than or equal to this threshold are used for training a model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-eventvaluethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-eventvaluethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventValueThreshold() {
            return null;
        }

        /**
         * Lists the feature transformation parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-featuretransformationparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-featuretransformationparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFeatureTransformationParameters() {
            return null;
        }

        /**
         * Describes the properties for hyperparameter optimization (HPO).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-hpoconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-solution-solutionconfig.html#cfn-personalize-solution-solutionconfig-hpoconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHpoConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SolutionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SolutionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SolutionConfigProperty> {
            java.lang.Object algorithmHyperParameters;
            java.lang.Object autoMlConfig;
            java.lang.String eventValueThreshold;
            java.lang.Object featureTransformationParameters;
            java.lang.Object hpoConfig;

            /**
             * Sets the value of {@link SolutionConfigProperty#getAlgorithmHyperParameters}
             * @param algorithmHyperParameters Lists the algorithm hyperparameters and their values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmHyperParameters(software.amazon.awscdk.IResolvable algorithmHyperParameters) {
                this.algorithmHyperParameters = algorithmHyperParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getAlgorithmHyperParameters}
             * @param algorithmHyperParameters Lists the algorithm hyperparameters and their values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmHyperParameters(java.util.Map<java.lang.String, java.lang.String> algorithmHyperParameters) {
                this.algorithmHyperParameters = algorithmHyperParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getAutoMlConfig}
             * @param autoMlConfig The <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html">AutoMLConfig</a> object containing a list of recipes to search when AutoML is performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoMlConfig(java.lang.Object autoMlConfig) {
                this.autoMlConfig = autoMlConfig;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getEventValueThreshold}
             * @param eventValueThreshold Only events with a value greater than or equal to this threshold are used for training a model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventValueThreshold(java.lang.String eventValueThreshold) {
                this.eventValueThreshold = eventValueThreshold;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getFeatureTransformationParameters}
             * @param featureTransformationParameters Lists the feature transformation parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureTransformationParameters(software.amazon.awscdk.IResolvable featureTransformationParameters) {
                this.featureTransformationParameters = featureTransformationParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getFeatureTransformationParameters}
             * @param featureTransformationParameters Lists the feature transformation parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureTransformationParameters(java.util.Map<java.lang.String, java.lang.String> featureTransformationParameters) {
                this.featureTransformationParameters = featureTransformationParameters;
                return this;
            }

            /**
             * Sets the value of {@link SolutionConfigProperty#getHpoConfig}
             * @param hpoConfig Describes the properties for hyperparameter optimization (HPO).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hpoConfig(java.lang.Object hpoConfig) {
                this.hpoConfig = hpoConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SolutionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SolutionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SolutionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SolutionConfigProperty {
            private final java.lang.Object algorithmHyperParameters;
            private final java.lang.Object autoMlConfig;
            private final java.lang.String eventValueThreshold;
            private final java.lang.Object featureTransformationParameters;
            private final java.lang.Object hpoConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithmHyperParameters = software.amazon.jsii.Kernel.get(this, "algorithmHyperParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoMlConfig = software.amazon.jsii.Kernel.get(this, "autoMlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventValueThreshold = software.amazon.jsii.Kernel.get(this, "eventValueThreshold", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureTransformationParameters = software.amazon.jsii.Kernel.get(this, "featureTransformationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hpoConfig = software.amazon.jsii.Kernel.get(this, "hpoConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithmHyperParameters = builder.algorithmHyperParameters;
                this.autoMlConfig = builder.autoMlConfig;
                this.eventValueThreshold = builder.eventValueThreshold;
                this.featureTransformationParameters = builder.featureTransformationParameters;
                this.hpoConfig = builder.hpoConfig;
            }

            @Override
            public final java.lang.Object getAlgorithmHyperParameters() {
                return this.algorithmHyperParameters;
            }

            @Override
            public final java.lang.Object getAutoMlConfig() {
                return this.autoMlConfig;
            }

            @Override
            public final java.lang.String getEventValueThreshold() {
                return this.eventValueThreshold;
            }

            @Override
            public final java.lang.Object getFeatureTransformationParameters() {
                return this.featureTransformationParameters;
            }

            @Override
            public final java.lang.Object getHpoConfig() {
                return this.hpoConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlgorithmHyperParameters() != null) {
                    data.set("algorithmHyperParameters", om.valueToTree(this.getAlgorithmHyperParameters()));
                }
                if (this.getAutoMlConfig() != null) {
                    data.set("autoMlConfig", om.valueToTree(this.getAutoMlConfig()));
                }
                if (this.getEventValueThreshold() != null) {
                    data.set("eventValueThreshold", om.valueToTree(this.getEventValueThreshold()));
                }
                if (this.getFeatureTransformationParameters() != null) {
                    data.set("featureTransformationParameters", om.valueToTree(this.getFeatureTransformationParameters()));
                }
                if (this.getHpoConfig() != null) {
                    data.set("hpoConfig", om.valueToTree(this.getHpoConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnSolution.SolutionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SolutionConfigProperty.Jsii$Proxy that = (SolutionConfigProperty.Jsii$Proxy) o;

                if (this.algorithmHyperParameters != null ? !this.algorithmHyperParameters.equals(that.algorithmHyperParameters) : that.algorithmHyperParameters != null) return false;
                if (this.autoMlConfig != null ? !this.autoMlConfig.equals(that.autoMlConfig) : that.autoMlConfig != null) return false;
                if (this.eventValueThreshold != null ? !this.eventValueThreshold.equals(that.eventValueThreshold) : that.eventValueThreshold != null) return false;
                if (this.featureTransformationParameters != null ? !this.featureTransformationParameters.equals(that.featureTransformationParameters) : that.featureTransformationParameters != null) return false;
                return this.hpoConfig != null ? this.hpoConfig.equals(that.hpoConfig) : that.hpoConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithmHyperParameters != null ? this.algorithmHyperParameters.hashCode() : 0;
                result = 31 * result + (this.autoMlConfig != null ? this.autoMlConfig.hashCode() : 0);
                result = 31 * result + (this.eventValueThreshold != null ? this.eventValueThreshold.hashCode() : 0);
                result = 31 * result + (this.featureTransformationParameters != null ? this.featureTransformationParameters.hashCode() : 0);
                result = 31 * result + (this.hpoConfig != null ? this.hpoConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.personalize.CfnSolution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.personalize.CfnSolution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.personalize.CfnSolutionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.personalize.CfnSolutionProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the dataset group that provides the training data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-datasetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-datasetgrouparn</a>
         * @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group that provides the training data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetGroupArn(final java.lang.String datasetGroupArn) {
            this.props.datasetGroupArn(datasetGroupArn);
            return this;
        }

        /**
         * The name of the solution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-name</a>
         * @param name The name of the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The event type (for example, 'click' or 'like') that is used for training the model.
         * <p>
         * If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-eventtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-eventtype</a>
         * @param eventType The event type (for example, 'click' or 'like') that is used for training the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(final java.lang.String eventType) {
            this.props.eventType(eventType);
            return this;
        }

        /**
         * <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
         * <p>
         * Instead, match your use case to the available Amazon Personalize recipes. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use case.</a>
         * <p>
         * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( <code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performautoml">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performautoml</a>
         * @param performAutoMl <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performAutoMl(final java.lang.Boolean performAutoMl) {
            this.props.performAutoMl(performAutoMl);
            return this;
        }
        /**
         * <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote>
         * <p>
         * Instead, match your use case to the available Amazon Personalize recipes. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use case.</a>
         * <p>
         * When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration ( <code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performautoml">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performautoml</a>
         * @param performAutoMl <blockquote><p>We don't recommend enabling automated machine learning.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performAutoMl(final software.amazon.awscdk.IResolvable performAutoMl) {
            this.props.performAutoMl(performAutoMl);
            return this;
        }

        /**
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performhpo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performhpo</a>
         * @param performHpo Whether to perform hyperparameter optimization (HPO) on the chosen recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performHpo(final java.lang.Boolean performHpo) {
            this.props.performHpo(performHpo);
            return this;
        }
        /**
         * Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performhpo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-performhpo</a>
         * @param performHpo Whether to perform hyperparameter optimization (HPO) on the chosen recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performHpo(final software.amazon.awscdk.IResolvable performHpo) {
            this.props.performHpo(performHpo);
            return this;
        }

        /**
         * The ARN of the recipe used to create the solution.
         * <p>
         * This is required when <code>performAutoML</code> is false.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-recipearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-recipearn</a>
         * @param recipeArn The ARN of the recipe used to create the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipeArn(final java.lang.String recipeArn) {
            this.props.recipeArn(recipeArn);
            return this;
        }

        /**
         * Describes the configuration properties for the solution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-solutionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-solutionconfig</a>
         * @param solutionConfig Describes the configuration properties for the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionConfig(final software.amazon.awscdk.IResolvable solutionConfig) {
            this.props.solutionConfig(solutionConfig);
            return this;
        }
        /**
         * Describes the configuration properties for the solution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-solutionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-personalize-solution.html#cfn-personalize-solution-solutionconfig</a>
         * @param solutionConfig Describes the configuration properties for the solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionConfig(final software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty solutionConfig) {
            this.props.solutionConfig(solutionConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.personalize.CfnSolution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.personalize.CfnSolution build() {
            return new software.amazon.awscdk.services.personalize.CfnSolution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
