package software.amazon.awscdk.services.qbusiness;

/**
 * Properties for defining a <code>CfnDataSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * Object configuration;
 * CfnDataSourceProps cfnDataSourceProps = CfnDataSourceProps.builder()
 *         .applicationId("applicationId")
 *         .configuration(configuration)
 *         .displayName("displayName")
 *         .indexId("indexId")
 *         // the properties below are optional
 *         .description("description")
 *         .documentEnrichmentConfiguration(DocumentEnrichmentConfigurationProperty.builder()
 *                 .inlineConfigurations(List.of(InlineDocumentEnrichmentConfigurationProperty.builder()
 *                         .condition(DocumentAttributeConditionProperty.builder()
 *                                 .key("key")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .documentContentOperator("documentContentOperator")
 *                         .target(DocumentAttributeTargetProperty.builder()
 *                                 .key("key")
 *                                 // the properties below are optional
 *                                 .attributeValueOperator("attributeValueOperator")
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .postExtractionHookConfiguration(HookConfigurationProperty.builder()
 *                         .invocationCondition(DocumentAttributeConditionProperty.builder()
 *                                 .key("key")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .lambdaArn("lambdaArn")
 *                         .roleArn("roleArn")
 *                         .s3BucketName("s3BucketName")
 *                         .build())
 *                 .preExtractionHookConfiguration(HookConfigurationProperty.builder()
 *                         .invocationCondition(DocumentAttributeConditionProperty.builder()
 *                                 .key("key")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .value(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .lambdaArn("lambdaArn")
 *                         .roleArn("roleArn")
 *                         .s3BucketName("s3BucketName")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         .syncSchedule("syncSchedule")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:35.839Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon Q Business application the data source will be attached to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * Use this property to specify a JSON or YAML schema with configuration information specific to your data source connector to connect your data source repository to Amazon Q Business .
     * <p>
     * You must use the JSON or YAML schema provided by Amazon Q .
     * <p>
     * You can find configuration templates for your specific data source using the following steps:
     * <p>
     * <ul>
     * <li>Navigate to the <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html">Supported connectors</a> page in the Amazon Q Business User Guide, and select the data source connector of your choice.</li>
     * <li>Then, from that specific data source connector's page, select <em>Using AWS CloudFormation</em> to find the schemas for your data source connector, including parameter descriptions and examples.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * The name of the Amazon Q Business data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The identifier of the index the data source is attached to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-indexid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-indexid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexId();

    /**
     * A description for the data source connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Provides the configuration information for altering document metadata and content during the document ingestion process.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-documentenrichmentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-documentenrichmentconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentEnrichmentConfiguration() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index.
     * <p>
     * If you don't set a schedule, Amazon Q Business won't periodically update the index.
     * <p>
     * Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> . If you do, you receive a <code>ValidationException</code> exception.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-syncschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-syncschedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSyncSchedule() {
        return null;
    }

    /**
     * A list of key-value pairs that identify or categorize the data source connector.
     * <p>
     * You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with Amazon Q Business connectors</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-datasource.html#cfn-qbusiness-datasource-vpcconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataSourceProps> {
        java.lang.String applicationId;
        java.lang.Object configuration;
        java.lang.String displayName;
        java.lang.String indexId;
        java.lang.String description;
        java.lang.Object documentEnrichmentConfiguration;
        java.lang.String roleArn;
        java.lang.String syncSchedule;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vpcConfiguration;

        /**
         * Sets the value of {@link CfnDataSourceProps#getApplicationId}
         * @param applicationId The identifier of the Amazon Q Business application the data source will be attached to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getConfiguration}
         * @param configuration Use this property to specify a JSON or YAML schema with configuration information specific to your data source connector to connect your data source repository to Amazon Q Business . This parameter is required.
         *                      You must use the JSON or YAML schema provided by Amazon Q .
         *                      <p>
         *                      You can find configuration templates for your specific data source using the following steps:
         *                      <p>
         *                      <ul>
         *                      <li>Navigate to the <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html">Supported connectors</a> page in the Amazon Q Business User Guide, and select the data source connector of your choice.</li>
         *                      <li>Then, from that specific data source connector's page, select <em>Using AWS CloudFormation</em> to find the schemas for your data source connector, including parameter descriptions and examples.</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(java.lang.Object configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDisplayName}
         * @param displayName The name of the Amazon Q Business data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getIndexId}
         * @param indexId The identifier of the index the data source is attached to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexId(java.lang.String indexId) {
            this.indexId = indexId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDescription}
         * @param description A description for the data source connector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDocumentEnrichmentConfiguration}
         * @param documentEnrichmentConfiguration Provides the configuration information for altering document metadata and content during the document ingestion process.
         *                                        For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentEnrichmentConfiguration(software.amazon.awscdk.IResolvable documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDocumentEnrichmentConfiguration}
         * @param documentEnrichmentConfiguration Provides the configuration information for altering document metadata and content during the document ingestion process.
         *                                        For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document enrichment</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentEnrichmentConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataSource.DocumentEnrichmentConfigurationProperty documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getSyncSchedule}
         * @param syncSchedule Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index.
         *                     If you don't set a schedule, Amazon Q Business won't periodically update the index.
         *                     <p>
         *                     Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> . If you do, you receive a <code>ValidationException</code> exception.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncSchedule(java.lang.String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getTags}
         * @param tags A list of key-value pairs that identify or categorize the data source connector.
         *             You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getVpcConfiguration}
         * @param vpcConfiguration Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         *                         For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with Amazon Q Business connectors</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getVpcConfiguration}
         * @param vpcConfiguration Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         *                         For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with Amazon Q Business connectors</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.services.qbusiness.CfnDataSource.DataSourceVpcConfigurationProperty vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataSourceProps {
        private final java.lang.String applicationId;
        private final java.lang.Object configuration;
        private final java.lang.String displayName;
        private final java.lang.String indexId;
        private final java.lang.String description;
        private final java.lang.Object documentEnrichmentConfiguration;
        private final java.lang.String roleArn;
        private final java.lang.String syncSchedule;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vpcConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.indexId = software.amazon.jsii.Kernel.get(this, "indexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentEnrichmentConfiguration = software.amazon.jsii.Kernel.get(this, "documentEnrichmentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.syncSchedule = software.amazon.jsii.Kernel.get(this, "syncSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.indexId = java.util.Objects.requireNonNull(builder.indexId, "indexId is required");
            this.description = builder.description;
            this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
            this.roleArn = builder.roleArn;
            this.syncSchedule = builder.syncSchedule;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcConfiguration = builder.vpcConfiguration;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getIndexId() {
            return this.indexId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDocumentEnrichmentConfiguration() {
            return this.documentEnrichmentConfiguration;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getSyncSchedule() {
            return this.syncSchedule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpcConfiguration() {
            return this.vpcConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("indexId", om.valueToTree(this.getIndexId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDocumentEnrichmentConfiguration() != null) {
                data.set("documentEnrichmentConfiguration", om.valueToTree(this.getDocumentEnrichmentConfiguration()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getSyncSchedule() != null) {
                data.set("syncSchedule", om.valueToTree(this.getSyncSchedule()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcConfiguration() != null) {
                data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataSourceProps.Jsii$Proxy that = (CfnDataSourceProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!configuration.equals(that.configuration)) return false;
            if (!displayName.equals(that.displayName)) return false;
            if (!indexId.equals(that.indexId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.documentEnrichmentConfiguration != null ? !this.documentEnrichmentConfiguration.equals(that.documentEnrichmentConfiguration) : that.documentEnrichmentConfiguration != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.syncSchedule != null ? !this.syncSchedule.equals(that.syncSchedule) : that.syncSchedule != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.configuration.hashCode());
            result = 31 * result + (this.displayName.hashCode());
            result = 31 * result + (this.indexId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.documentEnrichmentConfiguration != null ? this.documentEnrichmentConfiguration.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.syncSchedule != null ? this.syncSchedule.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
            return result;
        }
    }
}
