package software.amazon.awscdk.services.s3;

/**
 * The date source for the partitioned prefix.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket accessLogsBucket = new Bucket(this, "AccessLogsBucket");
 * Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .serverAccessLogsPrefix("logs")
 *         .targetObjectKeyFormat(TargetObjectKeyFormat.partitionedPrefix(PartitionDateSource.EVENT_TIME))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:39.403Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.PartitionDateSource")
public enum PartitionDateSource {
    /**
     * The year, month, and day will be based on the timestamp of the S3 event in the file that's been delivered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENT_TIME,
    /**
     * The year, month, and day will be based on the time when the log file was delivered to S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELIVERY_TIME,
}
