package software.amazon.awscdk.services.s3.deployment;

/**
 * <code>BucketDeployment</code> populates an S3 bucket with the contents of .zip files from other S3 buckets or from local disk.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket destinationBucket;
 * BucketDeployment deployment = BucketDeployment.Builder.create(this, "DeployFiles")
 *         .sources(List.of(Source.asset(join(__dirname, "source-files"))))
 *         .destinationBucket(destinationBucket)
 *         .build();
 * deployment.handlerRole.addToPolicy(
 * PolicyStatement.Builder.create()
 *         .actions(List.of("kms:Decrypt", "kms:DescribeKey"))
 *         .effect(Effect.ALLOW)
 *         .resources(List.of("&lt;encryption key ARN&gt;"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:39.429Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.BucketDeployment")
public class BucketDeployment extends software.constructs.Construct {

    protected BucketDeployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BucketDeployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BucketDeployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add an additional source to the bucket deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IBucket websiteBucket;
     * BucketDeployment deployment = BucketDeployment.Builder.create(this, "Deployment")
     *         .sources(List.of(Source.asset("./website-dist")))
     *         .destinationBucket(websiteBucket)
     *         .build();
     * deployment.addSource(Source.asset("./another-asset"));
     * </pre></blockquote>
     * <p>
     * @param source This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource source) {
        software.amazon.jsii.Kernel.call(this, "addSource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(source, "source is required") });
    }

    /**
     * The bucket after the deployment.
     * <p>
     * If you want to reference the destination bucket in another construct and make sure the
     * bucket deployment has happened before the next operation is started, pass the other construct
     * a reference to <code>deployment.deployedBucket</code>.
     * <p>
     * Note that this only returns an immutable reference to the destination bucket.
     * If sequenced access to the original destination bucket is required, you may add a dependency
     * on the bucket deployment instead: <code>otherResource.node.addDependency(deployment)</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getDeployedBucket() {
        return software.amazon.jsii.Kernel.get(this, "deployedBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * Execution role of the Lambda function behind the custom CloudFormation resource of type <code>Custom::CDKBucketDeployment</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getHandlerRole() {
        return software.amazon.jsii.Kernel.get(this, "handlerRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The object keys for the sources deployed to the S3 bucket.
     * <p>
     * This returns a list of tokenized object keys for source files that are deployed to the bucket.
     * <p>
     * This can be useful when using <code>BucketDeployment</code> with <code>extract</code> set to <code>false</code> and you need to reference
     * the object key that resides in the bucket for that zip source file somewhere else in your CDK
     * application, such as in a CFN output.
     * <p>
     * For example, use <code>Fn.select(0, myBucketDeployment.objectKeys)</code> to reference the object key of the
     * first source file in your bucket deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getObjectKeys() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "objectKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.deployment.BucketDeployment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.deployment.BucketDeployment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps.Builder();
        }

        /**
         * The S3 bucket to sync the contents of the zip file to.
         * <p>
         * @return {@code this}
         * @param destinationBucket The S3 bucket to sync the contents of the zip file to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationBucket(final software.amazon.awscdk.services.s3.IBucket destinationBucket) {
            this.props.destinationBucket(destinationBucket);
            return this;
        }

        /**
         * The sources from which to deploy the contents of this bucket.
         * <p>
         * @return {@code this}
         * @param sources The sources from which to deploy the contents of this bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(final java.util.List<? extends software.amazon.awscdk.services.s3.deployment.ISource> sources) {
            this.props.sources(sources);
            return this;
        }

        /**
         * System-defined x-amz-acl metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl</a>
         * @param accessControl System-defined x-amz-acl metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(final software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.props.accessControl(accessControl);
            return this;
        }

        /**
         * System-defined cache-control metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param cacheControl System-defined cache-control metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheControl(final java.util.List<? extends software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl) {
            this.props.cacheControl(cacheControl);
            return this;
        }

        /**
         * System-defined cache-disposition metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param contentDisposition System-defined cache-disposition metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentDisposition(final java.lang.String contentDisposition) {
            this.props.contentDisposition(contentDisposition);
            return this;
        }

        /**
         * System-defined content-encoding metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param contentEncoding System-defined content-encoding metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentEncoding(final java.lang.String contentEncoding) {
            this.props.contentEncoding(contentEncoding);
            return this;
        }

        /**
         * System-defined content-language metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param contentLanguage System-defined content-language metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentLanguage(final java.lang.String contentLanguage) {
            this.props.contentLanguage(contentLanguage);
            return this;
        }

        /**
         * System-defined content-type metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param contentType System-defined content-type metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(final java.lang.String contentType) {
            this.props.contentType(contentType);
            return this;
        }

        /**
         * Key prefix in the destination bucket.
         * <p>
         * Must be &lt;=104 characters
         * <p>
         * Default: "/" (unzip to root of the destination bucket)
         * <p>
         * @return {@code this}
         * @param destinationKeyPrefix Key prefix in the destination bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationKeyPrefix(final java.lang.String destinationKeyPrefix) {
            this.props.destinationKeyPrefix(destinationKeyPrefix);
            return this;
        }

        /**
         * The CloudFront distribution using the destination bucket as an origin.
         * <p>
         * Files in the distribution's edge caches will be invalidated after
         * files are uploaded to the destination bucket.
         * <p>
         * Default: - No invalidation occurs
         * <p>
         * @return {@code this}
         * @param distribution The CloudFront distribution using the destination bucket as an origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distribution(final software.amazon.awscdk.services.cloudfront.IDistribution distribution) {
            this.props.distribution(distribution);
            return this;
        }

        /**
         * The file paths to invalidate in the CloudFront distribution.
         * <p>
         * Default: - All files under the destination bucket key prefix will be invalidated.
         * <p>
         * @return {@code this}
         * @param distributionPaths The file paths to invalidate in the CloudFront distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionPaths(final java.util.List<java.lang.String> distributionPaths) {
            this.props.distributionPaths(distributionPaths);
            return this;
        }

        /**
         * The size of the AWS Lambda function’s /tmp directory in MiB.
         * <p>
         * Default: 512 MiB
         * <p>
         * @return {@code this}
         * @param ephemeralStorageSize The size of the AWS Lambda function’s /tmp directory in MiB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageSize(final software.amazon.awscdk.Size ephemeralStorageSize) {
            this.props.ephemeralStorageSize(ephemeralStorageSize);
            return this;
        }

        /**
         * If this is set, matching files or objects will be excluded from the deployment's sync command.
         * <p>
         * This can be used to exclude a file from being pruned in the destination bucket.
         * <p>
         * If you want to just exclude files from the deployment package (which excludes these files
         * evaluated when invalidating the asset), you should leverage the <code>exclude</code> property of
         * <code>AssetOptions</code> when defining your source.
         * <p>
         * Default: - No exclude filters are used
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters">https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters</a>
         * @param exclude If this is set, matching files or objects will be excluded from the deployment's sync command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        /**
         * System-defined expires metadata to be set on all objects in the deployment.
         * <p>
         * Default: - The objects in the distribution will not expire.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param expires System-defined expires metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expires(final software.amazon.awscdk.Expiration expires) {
            this.props.expires(expires);
            return this;
        }

        /**
         * If this is set, the zip file will be synced to the destination S3 bucket and extracted.
         * <p>
         * If false, the file will remain zipped in the destination bucket.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param extract If this is set, the zip file will be synced to the destination S3 bucket and extracted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extract(final java.lang.Boolean extract) {
            this.props.extract(extract);
            return this;
        }

        /**
         * If this is set, matching files or objects will be included with the deployment's sync command.
         * <p>
         * Since all files from the deployment package are included by default, this property
         * is usually leveraged alongside an <code>exclude</code> filter.
         * <p>
         * Default: - No include filters are used and all files are included with the sync command
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters">https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters</a>
         * @param include If this is set, matching files or objects will be included with the deployment's sync command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder include(final java.util.List<java.lang.String> include) {
            this.props.include(include);
            return this;
        }

        /**
         * The Log Group used for logging of events emitted by the custom resource's lambda function.
         * <p>
         * Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
         * If you are deploying to another type of region, please check regional availability first.
         * <p>
         * Default: - a default log group created by AWS Lambda
         * <p>
         * @return {@code this}
         * @param logGroup The Log Group used for logging of events emitted by the custom resource's lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * The number of days that the lambda function's log events are kept in CloudWatch Logs.
         * <p>
         * This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
         * <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @param logRetention The number of days that the lambda function's log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
         * <p>
         * If you are deploying large files, you will need to increase this number
         * accordingly.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param memoryLimit The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimit(final java.lang.Number memoryLimit) {
            this.props.memoryLimit(memoryLimit);
            return this;
        }

        /**
         * User-defined object metadata to be set on all objects in the deployment.
         * <p>
         * Default: - No user metadata is set
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata</a>
         * @param metadata User-defined object metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final java.util.Map<java.lang.String, java.lang.String> metadata) {
            this.props.metadata(metadata);
            return this;
        }

        /**
         * If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html">https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html</a>
         * @param prune If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(final java.lang.Boolean prune) {
            this.props.prune(prune);
            return this;
        }

        /**
         * If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
         * <p>
         * NOTICE: Configuring this to "false" might have operational implications. Please
         * visit to the package documentation referred below to make sure you fully understand those implications.
         * <p>
         * Default: true - when resource is deleted/updated, files are retained
         * <p>
         * @return {@code this}
         * @see <a href="https://github.com/aws/aws-cdk/tree/main/packages/aws-cdk-lib/aws-s3-deployment#retain-on-delete">https://github.com/aws/aws-cdk/tree/main/packages/aws-cdk-lib/aws-s3-deployment#retain-on-delete</a>
         * @param retainOnDelete If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainOnDelete(final java.lang.Boolean retainOnDelete) {
            this.props.retainOnDelete(retainOnDelete);
            return this;
        }

        /**
         * Execution role associated with this function.
         * <p>
         * Default: - A role is automatically created
         * <p>
         * @return {@code this}
         * @param role Execution role associated with this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Server side encryption is not used.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param serverSideEncryption System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryption(final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption) {
            this.props.serverSideEncryption(serverSideEncryption);
            return this;
        }

        /**
         * System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param serverSideEncryptionAwsKmsKeyId System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionAwsKmsKeyId(final java.lang.String serverSideEncryptionAwsKmsKeyId) {
            this.props.serverSideEncryptionAwsKmsKeyId(serverSideEncryptionAwsKmsKeyId);
            return this;
        }

        /**
         * System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
         * <p>
         * Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
         * <p>
         * Default: - Not set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro">https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro</a>
         * @param serverSideEncryptionCustomerAlgorithm System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionCustomerAlgorithm(final java.lang.String serverSideEncryptionCustomerAlgorithm) {
            this.props.serverSideEncryptionCustomerAlgorithm(serverSideEncryptionCustomerAlgorithm);
            return this;
        }

        /**
         * If set to true, uploads will precompute the value of <code>x-amz-content-sha256</code> and include it in the signed S3 request headers.
         * <p>
         * Default: - `x-amz-content-sha256` will not be computed
         * <p>
         * @return {@code this}
         * @param signContent If set to true, uploads will precompute the value of <code>x-amz-content-sha256</code> and include it in the signed S3 request headers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signContent(final java.lang.Boolean signContent) {
            this.props.signContent(signContent);
            return this;
        }

        /**
         * System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
         * <p>
         * Default: - Default storage-class for the bucket is used.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param storageClass System-defined x-amz-storage-class metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClass(final software.amazon.awscdk.services.s3.deployment.StorageClass storageClass) {
            this.props.storageClass(storageClass);
            return this;
        }

        /**
         * Mount an EFS file system.
         * <p>
         * Enable this if your assets are large and you encounter disk space errors.
         * Enabling this option will require a VPC to be specified.
         * <p>
         * Default: - No EFS. Lambda has access only to 512MB of disk space.
         * <p>
         * @return {@code this}
         * @param useEfs Mount an EFS file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useEfs(final java.lang.Boolean useEfs) {
            this.props.useEfs(useEfs);
            return this;
        }

        /**
         * The VPC network to place the deployment lambda handler in.
         * <p>
         * This is required if <code>useEfs</code> is set.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param vpc The VPC network to place the deployment lambda handler in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where in the VPC to place the deployment lambda handler.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where in the VPC to place the deployment lambda handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
         * <p>
         * Default: - No website redirection.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
         * @param websiteRedirectLocation System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRedirectLocation(final java.lang.String websiteRedirectLocation) {
            this.props.websiteRedirectLocation(websiteRedirectLocation);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3.deployment.BucketDeployment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.deployment.BucketDeployment build() {
            return new software.amazon.awscdk.services.s3.deployment.BucketDeployment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
