package software.amazon.awscdk.services.sagemaker;

/**
 * Creates a SageMaker HyperPod cluster.
 * <p>
 * SageMaker HyperPod is a capability of SageMaker for creating and managing persistent clusters for developing large machine learning models, such as large language models (LLMs) and diffusion models. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in the <em>Amazon SageMaker Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .instanceGroups(List.of(ClusterInstanceGroupProperty.builder()
 *                 .executionRole("executionRole")
 *                 .instanceCount(123)
 *                 .instanceGroupName("instanceGroupName")
 *                 .instanceType("instanceType")
 *                 .lifeCycleConfig(ClusterLifeCycleConfigProperty.builder()
 *                         .onCreate("onCreate")
 *                         .sourceS3Uri("sourceS3Uri")
 *                         .build())
 *                 // the properties below are optional
 *                 .currentCount(123)
 *                 .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
 *                         .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
 *                                 .volumeSizeInGb(123)
 *                                 .build())
 *                         .build()))
 *                 .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
 *                 .threadsPerCore(123)
 *                 .build()))
 *         // the properties below are optional
 *         .clusterName("clusterName")
 *         .nodeRecovery("nodeRecovery")
 *         .orchestrator(OrchestratorProperty.builder()
 *                 .eks(ClusterOrchestratorEksConfigProperty.builder()
 *                         .clusterArn("clusterArn")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:39.478Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "attrClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClusterStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrClusterStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time when the SageMaker HyperPod cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The failure message of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFailureMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrFailureMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInstanceGroups() {
        return software.amazon.jsii.Kernel.get(this, "instanceGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceGroups", java.util.Objects.requireNonNull(value, "instanceGroups is required"));
    }

    /**
     * The instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceGroups(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterInstanceGroupProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterInstanceGroupProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "instanceGroups", java.util.Objects.requireNonNull(value, "instanceGroups is required"));
    }

    /**
     * The name of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", value);
    }

    /**
     * Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNodeRecovery() {
        return software.amazon.jsii.Kernel.get(this, "nodeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeRecovery(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "nodeRecovery", value);
    }

    /**
     * The orchestrator type for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrchestrator() {
        return software.amazon.jsii.Kernel.get(this, "orchestrator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The orchestrator type for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrchestrator(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "orchestrator", value);
    }

    /**
     * The orchestrator type for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrchestrator(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnCluster.OrchestratorProperty value) {
        software.amazon.jsii.Kernel.set(this, "orchestrator", value);
    }

    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * Defines the configuration for attaching an additional Amazon Elastic Block Store (EBS) volume to each instance of the SageMaker HyperPod cluster instance group.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620">SageMaker HyperPod release notes: June 20, 2024</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterEbsVolumeConfigProperty clusterEbsVolumeConfigProperty = ClusterEbsVolumeConfigProperty.builder()
     *         .volumeSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterEbsVolumeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterEbsVolumeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod cluster instance group.
         * <p>
         * The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html#cfn-sagemaker-cluster-clusterebsvolumeconfig-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html#cfn-sagemaker-cluster-clusterebsvolumeconfig-volumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSizeInGb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterEbsVolumeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterEbsVolumeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterEbsVolumeConfigProperty> {
            java.lang.Number volumeSizeInGb;

            /**
             * Sets the value of {@link ClusterEbsVolumeConfigProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod cluster instance group.
             *                       The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterEbsVolumeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterEbsVolumeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterEbsVolumeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterEbsVolumeConfigProperty {
            private final java.lang.Number volumeSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSizeInGb = builder.volumeSizeInGb;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVolumeSizeInGb() != null) {
                    data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterEbsVolumeConfigProperty.Jsii$Proxy that = (ClusterEbsVolumeConfigProperty.Jsii$Proxy) o;

                return this.volumeSizeInGb != null ? this.volumeSizeInGb.equals(that.volumeSizeInGb) : that.volumeSizeInGb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.volumeSizeInGb != null ? this.volumeSizeInGb.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration information of the instance group within the HyperPod cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterInstanceGroupProperty clusterInstanceGroupProperty = ClusterInstanceGroupProperty.builder()
     *         .executionRole("executionRole")
     *         .instanceCount(123)
     *         .instanceGroupName("instanceGroupName")
     *         .instanceType("instanceType")
     *         .lifeCycleConfig(ClusterLifeCycleConfigProperty.builder()
     *                 .onCreate("onCreate")
     *                 .sourceS3Uri("sourceS3Uri")
     *                 .build())
     *         // the properties below are optional
     *         .currentCount(123)
     *         .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
     *                 .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
     *                         .volumeSizeInGb(123)
     *                         .build())
     *                 .build()))
     *         .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
     *         .threadsPerCore(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterInstanceGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterInstanceGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The execution role for the instance group to assume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

        /**
         * The number of instances in an instance group of the SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The name of the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancegroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceGroupName();

        /**
         * The instance type of the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The lifecycle configuration for a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-lifecycleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-lifecycleconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLifeCycleConfig();

        /**
         * The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-currentcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-currentcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCurrentCount() {
            return null;
        }

        /**
         * The configurations of additional storage specified to the instance group where the instance (node) is launched.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancestorageconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancestorageconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceStorageConfigs() {
            return null;
        }

        /**
         * A flag indicating whether deep health checks should be performed when the HyperPod cluster instance group is created or updated.
         * <p>
         * Deep health checks are comprehensive, invasive tests that validate the health of the underlying hardware and infrastructure components.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-onstartdeephealthchecks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-onstartdeephealthchecks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOnStartDeepHealthChecks() {
            return null;
        }

        /**
         * The number of threads per CPU core you specified under <code>CreateCluster</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-threadspercore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-threadspercore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreadsPerCore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterInstanceGroupProperty> {
            java.lang.String executionRole;
            java.lang.Number instanceCount;
            java.lang.String instanceGroupName;
            java.lang.String instanceType;
            java.lang.Object lifeCycleConfig;
            java.lang.Number currentCount;
            java.lang.Object instanceStorageConfigs;
            java.util.List<java.lang.String> onStartDeepHealthChecks;
            java.lang.Number threadsPerCore;

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getExecutionRole}
             * @param executionRole The execution role for the instance group to assume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceCount}
             * @param instanceCount The number of instances in an instance group of the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceGroupName}
             * @param instanceGroupName The name of the instance group of a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGroupName(java.lang.String instanceGroupName) {
                this.instanceGroupName = instanceGroupName;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceType}
             * @param instanceType The instance type of the instance group of a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getLifeCycleConfig}
             * @param lifeCycleConfig The lifecycle configuration for a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifeCycleConfig(software.amazon.awscdk.IResolvable lifeCycleConfig) {
                this.lifeCycleConfig = lifeCycleConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getLifeCycleConfig}
             * @param lifeCycleConfig The lifecycle configuration for a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifeCycleConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterLifeCycleConfigProperty lifeCycleConfig) {
                this.lifeCycleConfig = lifeCycleConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getCurrentCount}
             * @param currentCount The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentCount(java.lang.Number currentCount) {
                this.currentCount = currentCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceStorageConfigs}
             * @param instanceStorageConfigs The configurations of additional storage specified to the instance group where the instance (node) is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceStorageConfigs(software.amazon.awscdk.IResolvable instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceStorageConfigs}
             * @param instanceStorageConfigs The configurations of additional storage specified to the instance group where the instance (node) is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceStorageConfigs(java.util.List<? extends java.lang.Object> instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getOnStartDeepHealthChecks}
             * @param onStartDeepHealthChecks A flag indicating whether deep health checks should be performed when the HyperPod cluster instance group is created or updated.
             *                                Deep health checks are comprehensive, invasive tests that validate the health of the underlying hardware and infrastructure components.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onStartDeepHealthChecks(java.util.List<java.lang.String> onStartDeepHealthChecks) {
                this.onStartDeepHealthChecks = onStartDeepHealthChecks;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getThreadsPerCore}
             * @param threadsPerCore The number of threads per CPU core you specified under <code>CreateCluster</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterInstanceGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterInstanceGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterInstanceGroupProperty {
            private final java.lang.String executionRole;
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceGroupName;
            private final java.lang.String instanceType;
            private final java.lang.Object lifeCycleConfig;
            private final java.lang.Number currentCount;
            private final java.lang.Object instanceStorageConfigs;
            private final java.util.List<java.lang.String> onStartDeepHealthChecks;
            private final java.lang.Number threadsPerCore;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceGroupName = software.amazon.jsii.Kernel.get(this, "instanceGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lifeCycleConfig = software.amazon.jsii.Kernel.get(this, "lifeCycleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.currentCount = software.amazon.jsii.Kernel.get(this, "currentCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceStorageConfigs = software.amazon.jsii.Kernel.get(this, "instanceStorageConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onStartDeepHealthChecks = software.amazon.jsii.Kernel.get(this, "onStartDeepHealthChecks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.threadsPerCore = software.amazon.jsii.Kernel.get(this, "threadsPerCore", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceGroupName = java.util.Objects.requireNonNull(builder.instanceGroupName, "instanceGroupName is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.lifeCycleConfig = java.util.Objects.requireNonNull(builder.lifeCycleConfig, "lifeCycleConfig is required");
                this.currentCount = builder.currentCount;
                this.instanceStorageConfigs = builder.instanceStorageConfigs;
                this.onStartDeepHealthChecks = builder.onStartDeepHealthChecks;
                this.threadsPerCore = builder.threadsPerCore;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceGroupName() {
                return this.instanceGroupName;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Object getLifeCycleConfig() {
                return this.lifeCycleConfig;
            }

            @Override
            public final java.lang.Number getCurrentCount() {
                return this.currentCount;
            }

            @Override
            public final java.lang.Object getInstanceStorageConfigs() {
                return this.instanceStorageConfigs;
            }

            @Override
            public final java.util.List<java.lang.String> getOnStartDeepHealthChecks() {
                return this.onStartDeepHealthChecks;
            }

            @Override
            public final java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceGroupName", om.valueToTree(this.getInstanceGroupName()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("lifeCycleConfig", om.valueToTree(this.getLifeCycleConfig()));
                if (this.getCurrentCount() != null) {
                    data.set("currentCount", om.valueToTree(this.getCurrentCount()));
                }
                if (this.getInstanceStorageConfigs() != null) {
                    data.set("instanceStorageConfigs", om.valueToTree(this.getInstanceStorageConfigs()));
                }
                if (this.getOnStartDeepHealthChecks() != null) {
                    data.set("onStartDeepHealthChecks", om.valueToTree(this.getOnStartDeepHealthChecks()));
                }
                if (this.getThreadsPerCore() != null) {
                    data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterInstanceGroupProperty.Jsii$Proxy that = (ClusterInstanceGroupProperty.Jsii$Proxy) o;

                if (!executionRole.equals(that.executionRole)) return false;
                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceGroupName.equals(that.instanceGroupName)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!lifeCycleConfig.equals(that.lifeCycleConfig)) return false;
                if (this.currentCount != null ? !this.currentCount.equals(that.currentCount) : that.currentCount != null) return false;
                if (this.instanceStorageConfigs != null ? !this.instanceStorageConfigs.equals(that.instanceStorageConfigs) : that.instanceStorageConfigs != null) return false;
                if (this.onStartDeepHealthChecks != null ? !this.onStartDeepHealthChecks.equals(that.onStartDeepHealthChecks) : that.onStartDeepHealthChecks != null) return false;
                return this.threadsPerCore != null ? this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executionRole.hashCode();
                result = 31 * result + (this.instanceCount.hashCode());
                result = 31 * result + (this.instanceGroupName.hashCode());
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.lifeCycleConfig.hashCode());
                result = 31 * result + (this.currentCount != null ? this.currentCount.hashCode() : 0);
                result = 31 * result + (this.instanceStorageConfigs != null ? this.instanceStorageConfigs.hashCode() : 0);
                result = 31 * result + (this.onStartDeepHealthChecks != null ? this.onStartDeepHealthChecks.hashCode() : 0);
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the configuration for attaching additional storage to the instances in the SageMaker HyperPod cluster instance group.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620">SageMaker HyperPod release notes: June 20, 2024</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterInstanceStorageConfigProperty clusterInstanceStorageConfigProperty = ClusterInstanceStorageConfigProperty.builder()
     *         .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
     *                 .volumeSizeInGb(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterInstanceStorageConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterInstanceStorageConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group.
         * <p>
         * The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html#cfn-sagemaker-cluster-clusterinstancestorageconfig-ebsvolumeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html#cfn-sagemaker-cluster-clusterinstancestorageconfig-ebsvolumeconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsVolumeConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterInstanceStorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterInstanceStorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterInstanceStorageConfigProperty> {
            java.lang.Object ebsVolumeConfig;

            /**
             * Sets the value of {@link ClusterInstanceStorageConfigProperty#getEbsVolumeConfig}
             * @param ebsVolumeConfig Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group.
             *                        The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsVolumeConfig(software.amazon.awscdk.IResolvable ebsVolumeConfig) {
                this.ebsVolumeConfig = ebsVolumeConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceStorageConfigProperty#getEbsVolumeConfig}
             * @param ebsVolumeConfig Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group.
             *                        The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsVolumeConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty ebsVolumeConfig) {
                this.ebsVolumeConfig = ebsVolumeConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterInstanceStorageConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterInstanceStorageConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterInstanceStorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterInstanceStorageConfigProperty {
            private final java.lang.Object ebsVolumeConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsVolumeConfig = software.amazon.jsii.Kernel.get(this, "ebsVolumeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsVolumeConfig = builder.ebsVolumeConfig;
            }

            @Override
            public final java.lang.Object getEbsVolumeConfig() {
                return this.ebsVolumeConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsVolumeConfig() != null) {
                    data.set("ebsVolumeConfig", om.valueToTree(this.getEbsVolumeConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterInstanceStorageConfigProperty.Jsii$Proxy that = (ClusterInstanceStorageConfigProperty.Jsii$Proxy) o;

                return this.ebsVolumeConfig != null ? this.ebsVolumeConfig.equals(that.ebsVolumeConfig) : that.ebsVolumeConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsVolumeConfig != null ? this.ebsVolumeConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The lifecycle configuration for a SageMaker HyperPod cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterLifeCycleConfigProperty clusterLifeCycleConfigProperty = ClusterLifeCycleConfigProperty.builder()
     *         .onCreate("onCreate")
     *         .sourceS3Uri("sourceS3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterLifeCycleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterLifeCycleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterLifeCycleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code> .
         * <p>
         * This entrypoint script runs during cluster creation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-oncreate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-oncreate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOnCreate();

        /**
         * An Amazon S3 bucket path where your lifecycle scripts are stored.
         * <p>
         * <blockquote>
         * <p>
         * Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code> . The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod">IAM role for SageMaker HyperPod</a> has the managed <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html"><code>AmazonSageMakerClusterInstanceRolePolicy</code></a> attached, which allows access to S3 buckets with the specific prefix <code>sagemaker-</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-sources3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-sources3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceS3Uri();

        /**
         * @return a {@link Builder} of {@link ClusterLifeCycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterLifeCycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterLifeCycleConfigProperty> {
            java.lang.String onCreate;
            java.lang.String sourceS3Uri;

            /**
             * Sets the value of {@link ClusterLifeCycleConfigProperty#getOnCreate}
             * @param onCreate The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code> . This parameter is required.
             *                 This entrypoint script runs during cluster creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onCreate(java.lang.String onCreate) {
                this.onCreate = onCreate;
                return this;
            }

            /**
             * Sets the value of {@link ClusterLifeCycleConfigProperty#getSourceS3Uri}
             * @param sourceS3Uri An Amazon S3 bucket path where your lifecycle scripts are stored. This parameter is required.
             *                    <blockquote>
             *                    <p>
             *                    Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code> . The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod">IAM role for SageMaker HyperPod</a> has the managed <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html"><code>AmazonSageMakerClusterInstanceRolePolicy</code></a> attached, which allows access to S3 buckets with the specific prefix <code>sagemaker-</code> .
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceS3Uri(java.lang.String sourceS3Uri) {
                this.sourceS3Uri = sourceS3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterLifeCycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterLifeCycleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterLifeCycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterLifeCycleConfigProperty {
            private final java.lang.String onCreate;
            private final java.lang.String sourceS3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onCreate = software.amazon.jsii.Kernel.get(this, "onCreate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceS3Uri = software.amazon.jsii.Kernel.get(this, "sourceS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onCreate = java.util.Objects.requireNonNull(builder.onCreate, "onCreate is required");
                this.sourceS3Uri = java.util.Objects.requireNonNull(builder.sourceS3Uri, "sourceS3Uri is required");
            }

            @Override
            public final java.lang.String getOnCreate() {
                return this.onCreate;
            }

            @Override
            public final java.lang.String getSourceS3Uri() {
                return this.sourceS3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("onCreate", om.valueToTree(this.getOnCreate()));
                data.set("sourceS3Uri", om.valueToTree(this.getSourceS3Uri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterLifeCycleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterLifeCycleConfigProperty.Jsii$Proxy that = (ClusterLifeCycleConfigProperty.Jsii$Proxy) o;

                if (!onCreate.equals(that.onCreate)) return false;
                return this.sourceS3Uri.equals(that.sourceS3Uri);
            }

            @Override
            public final int hashCode() {
                int result = this.onCreate.hashCode();
                result = 31 * result + (this.sourceS3Uri.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration for the Amazon EKS cluster that is used as the orchestrator for the SageMaker HyperPod cluster.
     * <p>
     * This includes the Amazon Resource Name (ARN) of the EKS cluster
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterOrchestratorEksConfigProperty clusterOrchestratorEksConfigProperty = ClusterOrchestratorEksConfigProperty.builder()
     *         .clusterArn("clusterArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterOrchestratorEksConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterOrchestratorEksConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html#cfn-sagemaker-cluster-clusterorchestratoreksconfig-clusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html#cfn-sagemaker-cluster-clusterorchestratoreksconfig-clusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterArn();

        /**
         * @return a {@link Builder} of {@link ClusterOrchestratorEksConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterOrchestratorEksConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterOrchestratorEksConfigProperty> {
            java.lang.String clusterArn;

            /**
             * Sets the value of {@link ClusterOrchestratorEksConfigProperty#getClusterArn}
             * @param clusterArn The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterArn(java.lang.String clusterArn) {
                this.clusterArn = clusterArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterOrchestratorEksConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterOrchestratorEksConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterOrchestratorEksConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterOrchestratorEksConfigProperty {
            private final java.lang.String clusterArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterArn = java.util.Objects.requireNonNull(builder.clusterArn, "clusterArn is required");
            }

            @Override
            public final java.lang.String getClusterArn() {
                return this.clusterArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterArn", om.valueToTree(this.getClusterArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterOrchestratorEksConfigProperty.Jsii$Proxy that = (ClusterOrchestratorEksConfigProperty.Jsii$Proxy) o;

                return this.clusterArn.equals(that.clusterArn);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterArn.hashCode();
                return result;
            }
        }
    }
    /**
     * The orchestrator for a SageMaker HyperPod cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * OrchestratorProperty orchestratorProperty = OrchestratorProperty.builder()
     *         .eks(ClusterOrchestratorEksConfigProperty.builder()
     *                 .clusterArn("clusterArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.OrchestratorProperty")
    @software.amazon.jsii.Jsii.Proxy(OrchestratorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrchestratorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html#cfn-sagemaker-cluster-orchestrator-eks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html#cfn-sagemaker-cluster-orchestrator-eks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEks();

        /**
         * @return a {@link Builder} of {@link OrchestratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrchestratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrchestratorProperty> {
            java.lang.Object eks;

            /**
             * Sets the value of {@link OrchestratorProperty#getEks}
             * @param eks The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eks(software.amazon.awscdk.IResolvable eks) {
                this.eks = eks;
                return this;
            }

            /**
             * Sets the value of {@link OrchestratorProperty#getEks}
             * @param eks The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eks(software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty eks) {
                this.eks = eks;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrchestratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrchestratorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrchestratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrchestratorProperty {
            private final java.lang.Object eks;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eks = software.amazon.jsii.Kernel.get(this, "eks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eks = java.util.Objects.requireNonNull(builder.eks, "eks is required");
            }

            @Override
            public final java.lang.Object getEks() {
                return this.eks;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eks", om.valueToTree(this.getEks()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.OrchestratorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrchestratorProperty.Jsii$Proxy that = (OrchestratorProperty.Jsii$Proxy) o;

                return this.eks.equals(that.eks);
            }

            @Override
            public final int hashCode() {
                int result = this.eks.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     * <p>
     * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> .
         * <p>
         * Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The ID of the subnets in the VPC to which you want to connect your training job or model.
         * <p>
         * For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> . This parameter is required.
             *                         Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets The ID of the subnets in the VPC to which you want to connect your training job or model. This parameter is required.
             *                For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnClusterProps.Builder();
        }

        /**
         * The instance groups of the SageMaker HyperPod cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups</a>
         * @param instanceGroups The instance groups of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroups(final software.amazon.awscdk.IResolvable instanceGroups) {
            this.props.instanceGroups(instanceGroups);
            return this;
        }
        /**
         * The instance groups of the SageMaker HyperPod cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups</a>
         * @param instanceGroups The instance groups of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroups(final java.util.List<? extends java.lang.Object> instanceGroups) {
            this.props.instanceGroups(instanceGroups);
            return this;
        }

        /**
         * The name of the SageMaker HyperPod cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clustername</a>
         * @param clusterName The name of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
         * <p>
         * Available values are <code>Automatic</code> for enabling and <code>None</code> for disabling.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-noderecovery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-noderecovery</a>
         * @param nodeRecovery Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeRecovery(final java.lang.String nodeRecovery) {
            this.props.nodeRecovery(nodeRecovery);
            return this;
        }

        /**
         * The orchestrator type for the SageMaker HyperPod cluster.
         * <p>
         * Currently, <code>'eks'</code> is the only available option.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator</a>
         * @param orchestrator The orchestrator type for the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orchestrator(final software.amazon.awscdk.IResolvable orchestrator) {
            this.props.orchestrator(orchestrator);
            return this;
        }
        /**
         * The orchestrator type for the SageMaker HyperPod cluster.
         * <p>
         * Currently, <code>'eks'</code> is the only available option.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator</a>
         * @param orchestrator The orchestrator type for the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orchestrator(final software.amazon.awscdk.services.sagemaker.CfnCluster.OrchestratorProperty orchestrator) {
            this.props.orchestrator(orchestrator);
            return this;
        }

        /**
         * A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
         * <p>
         * You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html">AddTags</a> .
         * <p>
         * For more information on adding metadata to your AWS resources with tagging, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> . For advice on best practices for managing AWS resources with tagging, see <a href="https://docs.aws.amazon.com/https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tags</a>
         * @param tags A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         * <p>
         * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig</a>
         * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         * <p>
         * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig</a>
         * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnCluster build() {
            return new software.amazon.awscdk.services.sagemaker.CfnCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
