package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnEmailIdentity</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnEmailIdentityProps cfnEmailIdentityProps = CfnEmailIdentityProps.builder()
 *         .emailIdentity("emailIdentity")
 *         // the properties below are optional
 *         .configurationSetAttributes(ConfigurationSetAttributesProperty.builder()
 *                 .configurationSetName("configurationSetName")
 *                 .build())
 *         .dkimAttributes(DkimAttributesProperty.builder()
 *                 .signingEnabled(false)
 *                 .build())
 *         .dkimSigningAttributes(DkimSigningAttributesProperty.builder()
 *                 .domainSigningPrivateKey("domainSigningPrivateKey")
 *                 .domainSigningSelector("domainSigningSelector")
 *                 .nextSigningKeyLength("nextSigningKeyLength")
 *                 .build())
 *         .feedbackAttributes(FeedbackAttributesProperty.builder()
 *                 .emailForwardingEnabled(false)
 *                 .build())
 *         .mailFromAttributes(MailFromAttributesProperty.builder()
 *                 .behaviorOnMxFailure("behaviorOnMxFailure")
 *                 .mailFromDomain("mailFromDomain")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:40.234Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentityProps")
@software.amazon.jsii.Jsii.Proxy(CfnEmailIdentityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEmailIdentityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The email address or domain to verify.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-emailidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-emailidentity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEmailIdentity();

    /**
     * Used to associate a configuration set with an email identity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-configurationsetattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-configurationsetattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationSetAttributes() {
        return null;
    }

    /**
     * An object that contains information about the DKIM attributes for the identity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDkimAttributes() {
        return null;
    }

    /**
     * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
     * <p>
     * You can only specify this object if the email identity is a domain, as opposed to an address.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimsigningattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-dkimsigningattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDkimSigningAttributes() {
        return null;
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-feedbackattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-feedbackattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFeedbackAttributes() {
        return null;
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-mailfromattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-emailidentity.html#cfn-ses-emailidentity-mailfromattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMailFromAttributes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEmailIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEmailIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEmailIdentityProps> {
        java.lang.String emailIdentity;
        java.lang.Object configurationSetAttributes;
        java.lang.Object dkimAttributes;
        java.lang.Object dkimSigningAttributes;
        java.lang.Object feedbackAttributes;
        java.lang.Object mailFromAttributes;

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getEmailIdentity}
         * @param emailIdentity The email address or domain to verify. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailIdentity(java.lang.String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getConfigurationSetAttributes}
         * @param configurationSetAttributes Used to associate a configuration set with an email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetAttributes(software.amazon.awscdk.IResolvable configurationSetAttributes) {
            this.configurationSetAttributes = configurationSetAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getConfigurationSetAttributes}
         * @param configurationSetAttributes Used to associate a configuration set with an email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetAttributes(software.amazon.awscdk.services.ses.CfnEmailIdentity.ConfigurationSetAttributesProperty configurationSetAttributes) {
            this.configurationSetAttributes = configurationSetAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getDkimAttributes}
         * @param dkimAttributes An object that contains information about the DKIM attributes for the identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimAttributes(software.amazon.awscdk.IResolvable dkimAttributes) {
            this.dkimAttributes = dkimAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getDkimAttributes}
         * @param dkimAttributes An object that contains information about the DKIM attributes for the identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimAttributes(software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimAttributesProperty dkimAttributes) {
            this.dkimAttributes = dkimAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getDkimSigningAttributes}
         * @param dkimSigningAttributes If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
         *                              You can only specify this object if the email identity is a domain, as opposed to an address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningAttributes(software.amazon.awscdk.IResolvable dkimSigningAttributes) {
            this.dkimSigningAttributes = dkimSigningAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getDkimSigningAttributes}
         * @param dkimSigningAttributes If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> .
         *                              You can only specify this object if the email identity is a domain, as opposed to an address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningAttributes(software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimSigningAttributesProperty dkimSigningAttributes) {
            this.dkimSigningAttributes = dkimSigningAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getFeedbackAttributes}
         * @param feedbackAttributes Used to enable or disable feedback forwarding for an identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackAttributes(software.amazon.awscdk.IResolvable feedbackAttributes) {
            this.feedbackAttributes = feedbackAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getFeedbackAttributes}
         * @param feedbackAttributes Used to enable or disable feedback forwarding for an identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackAttributes(software.amazon.awscdk.services.ses.CfnEmailIdentity.FeedbackAttributesProperty feedbackAttributes) {
            this.feedbackAttributes = feedbackAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getMailFromAttributes}
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(software.amazon.awscdk.IResolvable mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEmailIdentityProps#getMailFromAttributes}
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(software.amazon.awscdk.services.ses.CfnEmailIdentity.MailFromAttributesProperty mailFromAttributes) {
            this.mailFromAttributes = mailFromAttributes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEmailIdentityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEmailIdentityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEmailIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEmailIdentityProps {
        private final java.lang.String emailIdentity;
        private final java.lang.Object configurationSetAttributes;
        private final java.lang.Object dkimAttributes;
        private final java.lang.Object dkimSigningAttributes;
        private final java.lang.Object feedbackAttributes;
        private final java.lang.Object mailFromAttributes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emailIdentity = software.amazon.jsii.Kernel.get(this, "emailIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationSetAttributes = software.amazon.jsii.Kernel.get(this, "configurationSetAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dkimAttributes = software.amazon.jsii.Kernel.get(this, "dkimAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dkimSigningAttributes = software.amazon.jsii.Kernel.get(this, "dkimSigningAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.feedbackAttributes = software.amazon.jsii.Kernel.get(this, "feedbackAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mailFromAttributes = software.amazon.jsii.Kernel.get(this, "mailFromAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emailIdentity = java.util.Objects.requireNonNull(builder.emailIdentity, "emailIdentity is required");
            this.configurationSetAttributes = builder.configurationSetAttributes;
            this.dkimAttributes = builder.dkimAttributes;
            this.dkimSigningAttributes = builder.dkimSigningAttributes;
            this.feedbackAttributes = builder.feedbackAttributes;
            this.mailFromAttributes = builder.mailFromAttributes;
        }

        @Override
        public final java.lang.String getEmailIdentity() {
            return this.emailIdentity;
        }

        @Override
        public final java.lang.Object getConfigurationSetAttributes() {
            return this.configurationSetAttributes;
        }

        @Override
        public final java.lang.Object getDkimAttributes() {
            return this.dkimAttributes;
        }

        @Override
        public final java.lang.Object getDkimSigningAttributes() {
            return this.dkimSigningAttributes;
        }

        @Override
        public final java.lang.Object getFeedbackAttributes() {
            return this.feedbackAttributes;
        }

        @Override
        public final java.lang.Object getMailFromAttributes() {
            return this.mailFromAttributes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("emailIdentity", om.valueToTree(this.getEmailIdentity()));
            if (this.getConfigurationSetAttributes() != null) {
                data.set("configurationSetAttributes", om.valueToTree(this.getConfigurationSetAttributes()));
            }
            if (this.getDkimAttributes() != null) {
                data.set("dkimAttributes", om.valueToTree(this.getDkimAttributes()));
            }
            if (this.getDkimSigningAttributes() != null) {
                data.set("dkimSigningAttributes", om.valueToTree(this.getDkimSigningAttributes()));
            }
            if (this.getFeedbackAttributes() != null) {
                data.set("feedbackAttributes", om.valueToTree(this.getFeedbackAttributes()));
            }
            if (this.getMailFromAttributes() != null) {
                data.set("mailFromAttributes", om.valueToTree(this.getMailFromAttributes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEmailIdentityProps.Jsii$Proxy that = (CfnEmailIdentityProps.Jsii$Proxy) o;

            if (!emailIdentity.equals(that.emailIdentity)) return false;
            if (this.configurationSetAttributes != null ? !this.configurationSetAttributes.equals(that.configurationSetAttributes) : that.configurationSetAttributes != null) return false;
            if (this.dkimAttributes != null ? !this.dkimAttributes.equals(that.dkimAttributes) : that.dkimAttributes != null) return false;
            if (this.dkimSigningAttributes != null ? !this.dkimSigningAttributes.equals(that.dkimSigningAttributes) : that.dkimSigningAttributes != null) return false;
            if (this.feedbackAttributes != null ? !this.feedbackAttributes.equals(that.feedbackAttributes) : that.feedbackAttributes != null) return false;
            return this.mailFromAttributes != null ? this.mailFromAttributes.equals(that.mailFromAttributes) : that.mailFromAttributes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.emailIdentity.hashCode();
            result = 31 * result + (this.configurationSetAttributes != null ? this.configurationSetAttributes.hashCode() : 0);
            result = 31 * result + (this.dkimAttributes != null ? this.dkimAttributes.hashCode() : 0);
            result = 31 * result + (this.dkimSigningAttributes != null ? this.dkimSigningAttributes.hashCode() : 0);
            result = 31 * result + (this.feedbackAttributes != null ? this.feedbackAttributes.hashCode() : 0);
            result = 31 * result + (this.mailFromAttributes != null ? this.mailFromAttributes.hashCode() : 0);
            return result;
        }
    }
}
