package software.amazon.awscdk.services.sns;

/**
 * The tracing mode of an Amazon SNS topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = Topic.Builder.create(this, "MyTopic")
 *         .tracingConfig(TracingConfig.ACTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:40.400Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.TracingConfig")
public enum TracingConfig {
    /**
     * The mode that topic passes trace headers received from the Amazon SNS publisher to its subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PASS_THROUGH,
    /**
     * The mode that Amazon SNS vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTIVE,
}
