package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a <code>CfnActivity</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * CfnActivityProps cfnActivityProps = CfnActivityProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .kmsDataKeyReusePeriodSeconds(123)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .tags(List.of(TagsEntryProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:40.609Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CfnActivityProps")
@software.amazon.jsii.Jsii.Proxy(CfnActivityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnActivityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the activity.
     * <p>
     * A name must <em>not</em> contain:
     * <p>
     * <ul>
     * <li>white space</li>
     * <li>brackets <code>&lt; &gt; { } [ ]</code></li>
     * <li>wildcard characters <code>? *</code></li>
     * <li>special characters <code>" # % \ ^ | ~ </code> $ &amp; , ; : /`</li>
     * <li>control characters ( <code>U+0000-001F</code> , <code>U+007F-009F</code> )</li>
     * </ul>
     * <p>
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Encryption configuration for the activity.
     * <p>
     * Activity configuration is immutable, and resource names must be unique. To set customer managed keys for encryption, you must create a <em>new Activity</em> . If you attempt to change the configuration in your CFN template for an existing activity, you will receive an <code>ActivityAlreadyExists</code> exception.
     * <p>
     * To update your activity to include customer managed keys, set a new activity name within your AWS CloudFormation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-encryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return null;
    }

    /**
     * The list of tags to add to a resource.
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + -
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnActivityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnActivityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnActivityProps> {
        java.lang.String name;
        java.lang.Object encryptionConfiguration;
        java.util.List<software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty> tags;

        /**
         * Sets the value of {@link CfnActivityProps#getName}
         * @param name The name of the activity. This parameter is required.
         *             A name must <em>not</em> contain:
         *             <p>
         *             <ul>
         *             <li>white space</li>
         *             <li>brackets <code>&lt; &gt; { } [ ]</code></li>
         *             <li>wildcard characters <code>? *</code></li>
         *             <li>special characters <code>" # % \ ^ | ~ </code> $ &amp; , ; : /`</li>
         *             <li>control characters ( <code>U+0000-001F</code> , <code>U+007F-009F</code> )</li>
         *             </ul>
         *             <p>
         *             To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnActivityProps#getEncryptionConfiguration}
         * @param encryptionConfiguration Encryption configuration for the activity.
         *                                Activity configuration is immutable, and resource names must be unique. To set customer managed keys for encryption, you must create a <em>new Activity</em> . If you attempt to change the configuration in your CFN template for an existing activity, you will receive an <code>ActivityAlreadyExists</code> exception.
         *                                <p>
         *                                To update your activity to include customer managed keys, set a new activity name within your AWS CloudFormation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnActivityProps#getEncryptionConfiguration}
         * @param encryptionConfiguration Encryption configuration for the activity.
         *                                Activity configuration is immutable, and resource names must be unique. To set customer managed keys for encryption, you must create a <em>new Activity</em> . If you attempt to change the configuration in your CFN template for an existing activity, you will receive an <code>ActivityAlreadyExists</code> exception.
         *                                <p>
         *                                To update your activity to include customer managed keys, set a new activity name within your AWS CloudFormation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.stepfunctions.CfnActivity.EncryptionConfigurationProperty encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnActivityProps#getTags}
         * @param tags The list of tags to add to a resource.
         *             Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + -
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnActivityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnActivityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnActivityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnActivityProps {
        private final java.lang.String name;
        private final java.lang.Object encryptionConfiguration;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.CfnActivity.TagsEntryProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CfnActivityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnActivityProps.Jsii$Proxy that = (CfnActivityProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
