package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Options for binding a launch target to an ECS run job task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * LaunchTargetBindOptions launchTargetBindOptions = LaunchTargetBindOptions.builder()
 *         .taskDefinition(taskDefinition)
 *         // the properties below are optional
 *         .cluster(cluster)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:40.897Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.LaunchTargetBindOptions")
@software.amazon.jsii.Jsii.Proxy(LaunchTargetBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchTargetBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Task definition to run Docker containers in Amazon ECS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinition getTaskDefinition();

    /**
     * A regional grouping of one or more container instances on which you can run tasks and services.
     * <p>
     * Default: - No cluster
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LaunchTargetBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchTargetBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchTargetBindOptions> {
        software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition;
        software.amazon.awscdk.services.ecs.ICluster cluster;

        /**
         * Sets the value of {@link LaunchTargetBindOptions#getTaskDefinition}
         * @param taskDefinition Task definition to run Docker containers in Amazon ECS. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTargetBindOptions#getCluster}
         * @param cluster A regional grouping of one or more container instances on which you can run tasks and services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchTargetBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchTargetBindOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchTargetBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTargetBindOptions {
        private final software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ITaskDefinition.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.taskDefinition = java.util.Objects.requireNonNull(builder.taskDefinition, "taskDefinition is required");
            this.cluster = builder.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ITaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.LaunchTargetBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchTargetBindOptions.Jsii$Proxy that = (LaunchTargetBindOptions.Jsii$Proxy) o;

            if (!taskDefinition.equals(that.taskDefinition)) return false;
            return this.cluster != null ? this.cluster.equals(that.cluster) : that.cluster == null;
        }

        @Override
        public final int hashCode() {
            int result = this.taskDefinition.hashCode();
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            return result;
        }
    }
}
