package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for the worker configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GlueStartJobRun.Builder.create(this, "Task")
 *         .glueJobName("my-glue-job")
 *         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                 .workerType(WorkerType.G_1X) // Worker type
 *                 .numberOfWorkers(2)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:40.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.WorkerConfigurationProperty")
@software.amazon.jsii.Jsii.Proxy(WorkerConfigurationProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WorkerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of workers of a defined <code>WorkerType</code> that are allocated when a job runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getNumberOfWorkers();

    /**
     * The type of predefined worker that is allocated when a job runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.WorkerType getWorkerType();

    /**
     * @return a {@link Builder} of {@link WorkerConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WorkerConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WorkerConfigurationProperty> {
        java.lang.Number numberOfWorkers;
        software.amazon.awscdk.services.stepfunctions.tasks.WorkerType workerType;

        /**
         * Sets the value of {@link WorkerConfigurationProperty#getNumberOfWorkers}
         * @param numberOfWorkers The number of workers of a defined <code>WorkerType</code> that are allocated when a job runs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfWorkers(java.lang.Number numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        /**
         * Sets the value of {@link WorkerConfigurationProperty#getWorkerType}
         * @param workerType The type of predefined worker that is allocated when a job runs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerType(software.amazon.awscdk.services.stepfunctions.tasks.WorkerType workerType) {
            this.workerType = workerType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WorkerConfigurationProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WorkerConfigurationProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WorkerConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkerConfigurationProperty {
        private final java.lang.Number numberOfWorkers;
        private final software.amazon.awscdk.services.stepfunctions.tasks.WorkerType workerType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.numberOfWorkers = software.amazon.jsii.Kernel.get(this, "numberOfWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.workerType = software.amazon.jsii.Kernel.get(this, "workerType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.numberOfWorkers = java.util.Objects.requireNonNull(builder.numberOfWorkers, "numberOfWorkers is required");
            this.workerType = java.util.Objects.requireNonNull(builder.workerType, "workerType is required");
        }

        @Override
        public final java.lang.Number getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.WorkerType getWorkerType() {
            return this.workerType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("numberOfWorkers", om.valueToTree(this.getNumberOfWorkers()));
            data.set("workerType", om.valueToTree(this.getWorkerType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.WorkerConfigurationProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WorkerConfigurationProperty.Jsii$Proxy that = (WorkerConfigurationProperty.Jsii$Proxy) o;

            if (!numberOfWorkers.equals(that.numberOfWorkers)) return false;
            return this.workerType.equals(that.workerType);
        }

        @Override
        public final int hashCode() {
            int result = this.numberOfWorkers.hashCode();
            result = 31 * result + (this.workerType.hashCode());
            return result;
        }
    }
}
