package software.amazon.awscdk.services.workspacesweb;

/**
 * This resource specifies an identity provider that is then associated with a web portal.
 * <p>
 * This resource is not required if your portal's <code>AuthenticationType</code> is IAM Identity Center.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesweb.*;
 * CfnIdentityProvider cfnIdentityProvider = CfnIdentityProvider.Builder.create(this, "MyCfnIdentityProvider")
 *         .identityProviderDetails(Map.of(
 *                 "identityProviderDetailsKey", "identityProviderDetails"))
 *         .identityProviderName("identityProviderName")
 *         .identityProviderType("identityProviderType")
 *         // the properties below are optional
 *         .portalArn("portalArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:41.441Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnIdentityProvider")
public class CfnIdentityProvider extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIdentityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.workspacesweb.CfnIdentityProvider.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.workspacesweb.CfnIdentityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityProviderArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The identity provider details.
     * <p>
     * The following list describes the provider detail keys for each identity provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getIdentityProviderDetails() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The identity provider details.
     * <p>
     * The following list describes the provider detail keys for each identity provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", java.util.Objects.requireNonNull(value, "identityProviderDetails is required"));
    }

    /**
     * The identity provider details.
     * <p>
     * The following list describes the provider detail keys for each identity provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", java.util.Objects.requireNonNull(value, "identityProviderDetails is required"));
    }

    /**
     * The identity provider name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderName() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identity provider name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderName", java.util.Objects.requireNonNull(value, "identityProviderName is required"));
    }

    /**
     * The identity provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderType() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identity provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderType", java.util.Objects.requireNonNull(value, "identityProviderType is required"));
    }

    /**
     * The ARN of the identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPortalArn() {
        return software.amazon.jsii.Kernel.get(this, "portalArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPortalArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "portalArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.workspacesweb.CfnIdentityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.workspacesweb.CfnIdentityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.workspacesweb.CfnIdentityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.workspacesweb.CfnIdentityProviderProps.Builder();
        }

        /**
         * The identity provider details. The following list describes the provider detail keys for each identity provider type.
         * <p>
         * <ul>
         * <li>For Google and Login with Amazon:</li>
         * <li><code>client_id</code></li>
         * <li><code>client_secret</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li>For Facebook:</li>
         * <li><code>client_id</code></li>
         * <li><code>client_secret</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li><code>api_version</code></li>
         * <li>For Sign in with Apple:</li>
         * <li><code>client_id</code></li>
         * <li><code>team_id</code></li>
         * <li><code>key_id</code></li>
         * <li><code>private_key</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li>For OIDC providers:</li>
         * <li><code>client_id</code></li>
         * <li><code>client_secret</code></li>
         * <li><code>attributes_request_method</code></li>
         * <li><code>oidc_issuer</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li><code>authorize_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li><code>token_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li><code>attributes_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li><code>jwks_uri</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li>For SAML providers:</li>
         * <li><code>MetadataFile</code> OR <code>MetadataURL</code></li>
         * <li><code>IDPSignout</code> (boolean) <em>optional</em></li>
         * <li><code>IDPInit</code> (boolean) <em>optional</em></li>
         * <li><code>RequestSigningAlgorithm</code> (string) <em>optional</em> - Only accepts <code>rsa-sha256</code></li>
         * <li><code>EncryptedResponses</code> (boolean) <em>optional</em></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityproviderdetails</a>
         * @param identityProviderDetails The identity provider details. The following list describes the provider detail keys for each identity provider type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final software.amazon.awscdk.IResolvable identityProviderDetails) {
            this.props.identityProviderDetails(identityProviderDetails);
            return this;
        }
        /**
         * The identity provider details. The following list describes the provider detail keys for each identity provider type.
         * <p>
         * <ul>
         * <li>For Google and Login with Amazon:</li>
         * <li><code>client_id</code></li>
         * <li><code>client_secret</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li>For Facebook:</li>
         * <li><code>client_id</code></li>
         * <li><code>client_secret</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li><code>api_version</code></li>
         * <li>For Sign in with Apple:</li>
         * <li><code>client_id</code></li>
         * <li><code>team_id</code></li>
         * <li><code>key_id</code></li>
         * <li><code>private_key</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li>For OIDC providers:</li>
         * <li><code>client_id</code></li>
         * <li><code>client_secret</code></li>
         * <li><code>attributes_request_method</code></li>
         * <li><code>oidc_issuer</code></li>
         * <li><code>authorize_scopes</code></li>
         * <li><code>authorize_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li><code>token_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li><code>attributes_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li><code>jwks_uri</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li>For SAML providers:</li>
         * <li><code>MetadataFile</code> OR <code>MetadataURL</code></li>
         * <li><code>IDPSignout</code> (boolean) <em>optional</em></li>
         * <li><code>IDPInit</code> (boolean) <em>optional</em></li>
         * <li><code>RequestSigningAlgorithm</code> (string) <em>optional</em> - Only accepts <code>rsa-sha256</code></li>
         * <li><code>EncryptedResponses</code> (boolean) <em>optional</em></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityproviderdetails</a>
         * @param identityProviderDetails The identity provider details. The following list describes the provider detail keys for each identity provider type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final java.util.Map<java.lang.String, java.lang.String> identityProviderDetails) {
            this.props.identityProviderDetails(identityProviderDetails);
            return this;
        }

        /**
         * The identity provider name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidername</a>
         * @param identityProviderName The identity provider name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderName(final java.lang.String identityProviderName) {
            this.props.identityProviderName(identityProviderName);
            return this;
        }

        /**
         * The identity provider type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidertype</a>
         * @param identityProviderType The identity provider type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderType(final java.lang.String identityProviderType) {
            this.props.identityProviderType(identityProviderType);
            return this;
        }

        /**
         * The ARN of the identity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-portalarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-portalarn</a>
         * @param portalArn The ARN of the identity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalArn(final java.lang.String portalArn) {
            this.props.portalArn(portalArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.workspacesweb.CfnIdentityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.workspacesweb.CfnIdentityProvider build() {
            return new software.amazon.awscdk.services.workspacesweb.CfnIdentityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
