package software.amazon.awscdk.services.workspacesweb;

/**
 * Properties for defining a <code>CfnIdentityProvider</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesweb.*;
 * CfnIdentityProviderProps cfnIdentityProviderProps = CfnIdentityProviderProps.builder()
 *         .identityProviderDetails(Map.of(
 *                 "identityProviderDetailsKey", "identityProviderDetails"))
 *         .identityProviderName("identityProviderName")
 *         .identityProviderType("identityProviderType")
 *         // the properties below are optional
 *         .portalArn("portalArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:41.443Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnIdentityProviderProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentityProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identity provider details. The following list describes the provider detail keys for each identity provider type.
     * <p>
     * <ul>
     * <li>For Google and Login with Amazon:</li>
     * <li><code>client_id</code></li>
     * <li><code>client_secret</code></li>
     * <li><code>authorize_scopes</code></li>
     * <li>For Facebook:</li>
     * <li><code>client_id</code></li>
     * <li><code>client_secret</code></li>
     * <li><code>authorize_scopes</code></li>
     * <li><code>api_version</code></li>
     * <li>For Sign in with Apple:</li>
     * <li><code>client_id</code></li>
     * <li><code>team_id</code></li>
     * <li><code>key_id</code></li>
     * <li><code>private_key</code></li>
     * <li><code>authorize_scopes</code></li>
     * <li>For OIDC providers:</li>
     * <li><code>client_id</code></li>
     * <li><code>client_secret</code></li>
     * <li><code>attributes_request_method</code></li>
     * <li><code>oidc_issuer</code></li>
     * <li><code>authorize_scopes</code></li>
     * <li><code>authorize_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li><code>token_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li><code>attributes_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li><code>jwks_uri</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>For SAML providers:</li>
     * <li><code>MetadataFile</code> OR <code>MetadataURL</code></li>
     * <li><code>IDPSignout</code> (boolean) <em>optional</em></li>
     * <li><code>IDPInit</code> (boolean) <em>optional</em></li>
     * <li><code>RequestSigningAlgorithm</code> (string) <em>optional</em> - Only accepts <code>rsa-sha256</code></li>
     * <li><code>EncryptedResponses</code> (boolean) <em>optional</em></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityproviderdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIdentityProviderDetails();

    /**
     * The identity provider name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderName();

    /**
     * The identity provider type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-identityprovidertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderType();

    /**
     * The ARN of the identity provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-portalarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-identityprovider.html#cfn-workspacesweb-identityprovider-portalarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPortalArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentityProviderProps> {
        java.lang.Object identityProviderDetails;
        java.lang.String identityProviderName;
        java.lang.String identityProviderType;
        java.lang.String portalArn;

        /**
         * Sets the value of {@link CfnIdentityProviderProps#getIdentityProviderDetails}
         * @param identityProviderDetails The identity provider details. The following list describes the provider detail keys for each identity provider type. This parameter is required.
         *                                <ul>
         *                                <li>For Google and Login with Amazon:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>client_secret</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li>For Facebook:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>client_secret</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li><code>api_version</code></li>
         *                                <li>For Sign in with Apple:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>team_id</code></li>
         *                                <li><code>key_id</code></li>
         *                                <li><code>private_key</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li>For OIDC providers:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>client_secret</code></li>
         *                                <li><code>attributes_request_method</code></li>
         *                                <li><code>oidc_issuer</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li><code>authorize_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li><code>token_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li><code>attributes_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li><code>jwks_uri</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li>For SAML providers:</li>
         *                                <li><code>MetadataFile</code> OR <code>MetadataURL</code></li>
         *                                <li><code>IDPSignout</code> (boolean) <em>optional</em></li>
         *                                <li><code>IDPInit</code> (boolean) <em>optional</em></li>
         *                                <li><code>RequestSigningAlgorithm</code> (string) <em>optional</em> - Only accepts <code>rsa-sha256</code></li>
         *                                <li><code>EncryptedResponses</code> (boolean) <em>optional</em></li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(software.amazon.awscdk.IResolvable identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProviderProps#getIdentityProviderDetails}
         * @param identityProviderDetails The identity provider details. The following list describes the provider detail keys for each identity provider type. This parameter is required.
         *                                <ul>
         *                                <li>For Google and Login with Amazon:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>client_secret</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li>For Facebook:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>client_secret</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li><code>api_version</code></li>
         *                                <li>For Sign in with Apple:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>team_id</code></li>
         *                                <li><code>key_id</code></li>
         *                                <li><code>private_key</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li>For OIDC providers:</li>
         *                                <li><code>client_id</code></li>
         *                                <li><code>client_secret</code></li>
         *                                <li><code>attributes_request_method</code></li>
         *                                <li><code>oidc_issuer</code></li>
         *                                <li><code>authorize_scopes</code></li>
         *                                <li><code>authorize_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li><code>token_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li><code>attributes_url</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li><code>jwks_uri</code> <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         *                                <li>For SAML providers:</li>
         *                                <li><code>MetadataFile</code> OR <code>MetadataURL</code></li>
         *                                <li><code>IDPSignout</code> (boolean) <em>optional</em></li>
         *                                <li><code>IDPInit</code> (boolean) <em>optional</em></li>
         *                                <li><code>RequestSigningAlgorithm</code> (string) <em>optional</em> - Only accepts <code>rsa-sha256</code></li>
         *                                <li><code>EncryptedResponses</code> (boolean) <em>optional</em></li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(java.util.Map<java.lang.String, java.lang.String> identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProviderProps#getIdentityProviderName}
         * @param identityProviderName The identity provider name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderName(java.lang.String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProviderProps#getIdentityProviderType}
         * @param identityProviderType The identity provider type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderType(java.lang.String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityProviderProps#getPortalArn}
         * @param portalArn The ARN of the identity provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalArn(java.lang.String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentityProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentityProviderProps {
        private final java.lang.Object identityProviderDetails;
        private final java.lang.String identityProviderName;
        private final java.lang.String identityProviderType;
        private final java.lang.String portalArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityProviderDetails = software.amazon.jsii.Kernel.get(this, "identityProviderDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.identityProviderName = software.amazon.jsii.Kernel.get(this, "identityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityProviderType = software.amazon.jsii.Kernel.get(this, "identityProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portalArn = software.amazon.jsii.Kernel.get(this, "portalArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityProviderDetails = java.util.Objects.requireNonNull(builder.identityProviderDetails, "identityProviderDetails is required");
            this.identityProviderName = java.util.Objects.requireNonNull(builder.identityProviderName, "identityProviderName is required");
            this.identityProviderType = java.util.Objects.requireNonNull(builder.identityProviderType, "identityProviderType is required");
            this.portalArn = builder.portalArn;
        }

        @Override
        public final java.lang.Object getIdentityProviderDetails() {
            return this.identityProviderDetails;
        }

        @Override
        public final java.lang.String getIdentityProviderName() {
            return this.identityProviderName;
        }

        @Override
        public final java.lang.String getIdentityProviderType() {
            return this.identityProviderType;
        }

        @Override
        public final java.lang.String getPortalArn() {
            return this.portalArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityProviderDetails", om.valueToTree(this.getIdentityProviderDetails()));
            data.set("identityProviderName", om.valueToTree(this.getIdentityProviderName()));
            data.set("identityProviderType", om.valueToTree(this.getIdentityProviderType()));
            if (this.getPortalArn() != null) {
                data.set("portalArn", om.valueToTree(this.getPortalArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.CfnIdentityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentityProviderProps.Jsii$Proxy that = (CfnIdentityProviderProps.Jsii$Proxy) o;

            if (!identityProviderDetails.equals(that.identityProviderDetails)) return false;
            if (!identityProviderName.equals(that.identityProviderName)) return false;
            if (!identityProviderType.equals(that.identityProviderType)) return false;
            return this.portalArn != null ? this.portalArn.equals(that.portalArn) : that.portalArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identityProviderDetails.hashCode();
            result = 31 * result + (this.identityProviderName.hashCode());
            result = 31 * result + (this.identityProviderType.hashCode());
            result = 31 * result + (this.portalArn != null ? this.portalArn.hashCode() : 0);
            return result;
        }
    }
}
