/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.ArnComponents;
import software.amazon.awscdk.ArnFormat;
import software.amazon.awscdk.CfnElement;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Environment;
import software.amazon.awscdk.ExportValueOptions;
import software.amazon.awscdk.IStackSynthesizer;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.ITemplateOptions;
import software.amazon.awscdk.PermissionsBoundary;
import software.amazon.awscdk.StackProps;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.cloud_assembly_schema.MissingContext;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IConstruct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.Stack")
public class Stack
extends Construct
implements ITaggable {
    protected Stack(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stack(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Stack(@Nullable Construct scope, @Nullable String id, @Nullable StackProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope, id, props});
    }

    public Stack(@Nullable Construct scope, @Nullable String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope, id});
    }

    public Stack(@Nullable Construct scope) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{scope});
    }

    public Stack() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static Boolean isStack(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Stack.class, (String)"isStack", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{x});
    }

    @NotNull
    public static Stack of(@NotNull IConstruct construct) {
        return (Stack)JsiiObject.jsiiStaticCall(Stack.class, (String)"of", (NativeType)NativeType.forClass(Stack.class), (Object[])new Object[]{Objects.requireNonNull(construct, "construct is required")});
    }

    public void addDependency(@NotNull Stack target, @Nullable String reason) {
        Kernel.call((Object)this, (String)"addDependency", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(target, "target is required"), reason});
    }

    public void addDependency(@NotNull Stack target) {
        Kernel.call((Object)this, (String)"addDependency", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public void addMetadata(@NotNull String key, @NotNull Object value) {
        Kernel.call((Object)this, (String)"addMetadata", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void addTransform(@NotNull String transform) {
        Kernel.call((Object)this, (String)"addTransform", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(transform, "transform is required")});
    }

    @NotNull
    protected String allocateLogicalId(@NotNull CfnElement cfnElement) {
        return (String)Kernel.call((Object)this, (String)"allocateLogicalId", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(cfnElement, "cfnElement is required")});
    }

    @NotNull
    public List<String> exportStringListValue(@NotNull Object exportedValue, @Nullable ExportValueOptions options) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"exportStringListValue", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[]{exportedValue, options}));
    }

    @NotNull
    public List<String> exportStringListValue(@NotNull Object exportedValue) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"exportStringListValue", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[]{exportedValue}));
    }

    @NotNull
    public String exportValue(@NotNull Object exportedValue, @Nullable ExportValueOptions options) {
        return (String)Kernel.call((Object)this, (String)"exportValue", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{exportedValue, options});
    }

    @NotNull
    public String exportValue(@NotNull Object exportedValue) {
        return (String)Kernel.call((Object)this, (String)"exportValue", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{exportedValue});
    }

    @NotNull
    public String formatArn(@NotNull ArnComponents components) {
        return (String)Kernel.call((Object)this, (String)"formatArn", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(components, "components is required")});
    }

    @NotNull
    public String getLogicalId(@NotNull CfnElement element) {
        return (String)Kernel.call((Object)this, (String)"getLogicalId", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(element, "element is required")});
    }

    @NotNull
    public String regionalFact(@NotNull String factName, @Nullable String defaultValue) {
        return (String)Kernel.call((Object)this, (String)"regionalFact", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(factName, "factName is required"), defaultValue});
    }

    @NotNull
    public String regionalFact(@NotNull String factName) {
        return (String)Kernel.call((Object)this, (String)"regionalFact", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(factName, "factName is required")});
    }

    public void renameLogicalId(@NotNull String oldId, @NotNull String newId) {
        Kernel.call((Object)this, (String)"renameLogicalId", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(oldId, "oldId is required"), Objects.requireNonNull(newId, "newId is required")});
    }

    public void reportMissingContextKey(@NotNull MissingContext report) {
        Kernel.call((Object)this, (String)"reportMissingContextKey", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(report, "report is required")});
    }

    @NotNull
    public Object resolve(@NotNull Object obj) {
        return Kernel.call((Object)this, (String)"resolve", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[]{obj});
    }

    @NotNull
    public ArnComponents splitArn(@NotNull String arn, @NotNull ArnFormat arnFormat) {
        return (ArnComponents)Kernel.call((Object)this, (String)"splitArn", (NativeType)NativeType.forClass(ArnComponents.class), (Object[])new Object[]{Objects.requireNonNull(arn, "arn is required"), Objects.requireNonNull(arnFormat, "arnFormat is required")});
    }

    @NotNull
    public String toJsonString(@NotNull Object obj, @Nullable Number space) {
        return (String)Kernel.call((Object)this, (String)"toJsonString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{obj, space});
    }

    @NotNull
    public String toJsonString(@NotNull Object obj) {
        return (String)Kernel.call((Object)this, (String)"toJsonString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{obj});
    }

    @NotNull
    public String toYamlString(@NotNull Object obj) {
        return (String)Kernel.call((Object)this, (String)"toYamlString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{obj});
    }

    @NotNull
    public String getAccount() {
        return (String)Kernel.get((Object)this, (String)"account", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getArtifactId() {
        return (String)Kernel.get((Object)this, (String)"artifactId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAvailabilityZones() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"availabilityZones", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Boolean getBundlingRequired() {
        return (Boolean)Kernel.get((Object)this, (String)"bundlingRequired", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<Stack> getDependencies() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"dependencies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Stack.class))));
    }

    @NotNull
    public String getEnvironment() {
        return (String)Kernel.get((Object)this, (String)"environment", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Boolean getNested() {
        return (Boolean)Kernel.get((Object)this, (String)"nested", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<String> getNotificationArns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"notificationArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getPartition() {
        return (String)Kernel.get((Object)this, (String)"partition", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getRegion() {
        return (String)Kernel.get((Object)this, (String)"region", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getStackId() {
        return (String)Kernel.get((Object)this, (String)"stackId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getStackName() {
        return (String)Kernel.get((Object)this, (String)"stackName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IStackSynthesizer getSynthesizer() {
        return (IStackSynthesizer)Kernel.get((Object)this, (String)"synthesizer", (NativeType)NativeType.forClass(IStackSynthesizer.class));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getTemplateFile() {
        return (String)Kernel.get((Object)this, (String)"templateFile", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ITemplateOptions getTemplateOptions() {
        return (ITemplateOptions)Kernel.get((Object)this, (String)"templateOptions", (NativeType)NativeType.forClass(ITemplateOptions.class));
    }

    @NotNull
    public String getUrlSuffix() {
        return (String)Kernel.get((Object)this, (String)"urlSuffix", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Stack getNestedStackParent() {
        return (Stack)Kernel.get((Object)this, (String)"nestedStackParent", (NativeType)NativeType.forClass(Stack.class));
    }

    @Nullable
    public CfnResource getNestedStackResource() {
        return (CfnResource)((Object)Kernel.get((Object)this, (String)"nestedStackResource", (NativeType)NativeType.forClass(CfnResource.class)));
    }

    @NotNull
    public Boolean getTerminationProtection() {
        return (Boolean)Kernel.get((Object)this, (String)"terminationProtection", (NativeType)NativeType.forClass(Boolean.class));
    }

    public void setTerminationProtection(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"terminationProtection", (Object)Objects.requireNonNull(value, "terminationProtection is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Stack> {
        private final Construct scope;
        private final String id;
        private StackProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        public static Builder create(Construct scope) {
            return new Builder(scope, null);
        }

        public static Builder create() {
            return new Builder(null, null);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder analyticsReporting(Boolean analyticsReporting) {
            this.props().analyticsReporting(analyticsReporting);
            return this;
        }

        public Builder crossRegionReferences(Boolean crossRegionReferences) {
            this.props().crossRegionReferences(crossRegionReferences);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder env(Environment env) {
            this.props().env(env);
            return this;
        }

        public Builder notificationArns(List<String> notificationArns) {
            this.props().notificationArns(notificationArns);
            return this;
        }

        public Builder permissionsBoundary(PermissionsBoundary permissionsBoundary) {
            this.props().permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder stackName(String stackName) {
            this.props().stackName(stackName);
            return this;
        }

        public Builder suppressTemplateIndentation(Boolean suppressTemplateIndentation) {
            this.props().suppressTemplateIndentation(suppressTemplateIndentation);
            return this;
        }

        public Builder synthesizer(IStackSynthesizer synthesizer) {
            this.props().synthesizer(synthesizer);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder terminationProtection(Boolean terminationProtection) {
            this.props().terminationProtection(terminationProtection);
            return this;
        }

        public Stack build() {
            return new Stack(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private StackProps.Builder props() {
            if (this.props == null) {
                this.props = new StackProps.Builder();
            }
            return this.props;
        }
    }
}

