/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.AssetHashType;
import software.amazon.awscdk.BundlingOptions;
import software.amazon.awscdk.IgnoreMode;
import software.amazon.awscdk.SymlinkFollowMode;
import software.amazon.awscdk.services.cloudfront.ImportSource;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.s3.assets.AssetOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudfront.AssetImportSource")
public class AssetImportSource
extends ImportSource {
    protected AssetImportSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetImportSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AssetImportSource(@NotNull String path, @Nullable AssetOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required"), options});
    }

    public AssetImportSource(@NotNull String path) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @NotNull
    public String getPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"path", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AssetImportSource> {
        private final String path;
        private AssetOptions.Builder options;

        public static Builder create(String path) {
            return new Builder(path);
        }

        private Builder(String path) {
            this.path = path;
        }

        public Builder assetHash(String assetHash) {
            this.options().assetHash(assetHash);
            return this;
        }

        public Builder assetHashType(AssetHashType assetHashType) {
            this.options().assetHashType(assetHashType);
            return this;
        }

        public Builder bundling(BundlingOptions bundling) {
            this.options().bundling(bundling);
            return this;
        }

        public Builder exclude(List<String> exclude) {
            this.options().exclude(exclude);
            return this;
        }

        public Builder followSymlinks(SymlinkFollowMode followSymlinks) {
            this.options().followSymlinks(followSymlinks);
            return this;
        }

        public Builder ignoreMode(IgnoreMode ignoreMode) {
            this.options().ignoreMode(ignoreMode);
            return this;
        }

        public Builder deployTime(Boolean deployTime) {
            this.options().deployTime(deployTime);
            return this;
        }

        public Builder readers(List<? extends IGrantable> readers) {
            this.options().readers(readers);
            return this;
        }

        public AssetImportSource build() {
            return new AssetImportSource(this.path, this.options != null ? this.options.build() : null);
        }

        private AssetOptions.Builder options() {
            if (this.options == null) {
                this.options = new AssetOptions.Builder();
            }
            return this.options;
        }
    }
}

