/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.events.Archive;
import software.amazon.awscdk.services.events.BaseArchiveProps;
import software.amazon.awscdk.services.events.EventBusAttributes;
import software.amazon.awscdk.services.events.EventBusProps;
import software.amazon.awscdk.services.events.IEventBus;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_events.EventBus")
public class EventBus
extends Resource
implements IEventBus {
    protected EventBus(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventBus(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EventBus(@NotNull Construct scope, @NotNull String id, @Nullable EventBusProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public EventBus(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IEventBus fromEventBusArn(@NotNull Construct scope, @NotNull String id, @NotNull String eventBusArn) {
        return (IEventBus)JsiiObject.jsiiStaticCall(EventBus.class, (String)"fromEventBusArn", (NativeType)NativeType.forClass(IEventBus.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(eventBusArn, "eventBusArn is required")});
    }

    @NotNull
    public static IEventBus fromEventBusAttributes(@NotNull Construct scope, @NotNull String id, @NotNull EventBusAttributes attrs) {
        return (IEventBus)JsiiObject.jsiiStaticCall(EventBus.class, (String)"fromEventBusAttributes", (NativeType)NativeType.forClass(IEventBus.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IEventBus fromEventBusName(@NotNull Construct scope, @NotNull String id, @NotNull String eventBusName) {
        return (IEventBus)JsiiObject.jsiiStaticCall(EventBus.class, (String)"fromEventBusName", (NativeType)NativeType.forClass(IEventBus.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(eventBusName, "eventBusName is required")});
    }

    @NotNull
    public static Grant grantAllPutEvents(@NotNull IGrantable grantee) {
        return (Grant)((Object)JsiiObject.jsiiStaticCall(EventBus.class, (String)"grantAllPutEvents", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Archive archive(@NotNull String id, @NotNull BaseArchiveProps props) {
        return (Archive)Kernel.call((Object)this, (String)"archive", (NativeType)NativeType.forClass(Archive.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public Grant grantPutEventsTo(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPutEventsTo", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public String getEventBusArn() {
        return (String)Kernel.get((Object)this, (String)"eventBusArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getEventBusName() {
        return (String)Kernel.get((Object)this, (String)"eventBusName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getEventBusPolicy() {
        return (String)Kernel.get((Object)this, (String)"eventBusPolicy", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getEventSourceName() {
        return (String)Kernel.get((Object)this, (String)"eventSourceName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EventBus> {
        private final Construct scope;
        private final String id;
        private EventBusProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder eventBusName(String eventBusName) {
            this.props().eventBusName(eventBusName);
            return this;
        }

        public Builder eventSourceName(String eventSourceName) {
            this.props().eventSourceName(eventSourceName);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props().kmsKey(kmsKey);
            return this;
        }

        public EventBus build() {
            return new EventBus(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private EventBusProps.Builder props() {
            if (this.props == null) {
                this.props = new EventBusProps.Builder();
            }
            return this.props;
        }
    }
}

