/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.medialive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.medialive.CfnCluster;
import software.amazon.awscdk.services.medialive.CfnClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_medialive.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @Nullable CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrChannelIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrChannelIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrState() {
        return (String)Kernel.get((Object)this, (String)"attrState", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public String getClusterType() {
        return (String)Kernel.get((Object)this, (String)"clusterType", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterType(@Nullable String value) {
        Kernel.set((Object)this, (String)"clusterType", (Object)value);
    }

    @Nullable
    public String getInstanceRoleArn() {
        return (String)Kernel.get((Object)this, (String)"instanceRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"instanceRoleArn", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getNetworkSettings() {
        return Kernel.get((Object)this, (String)"networkSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworkSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"networkSettings", (Object)value);
    }

    public void setNetworkSettings(@Nullable ClusterNetworkSettingsProperty value) {
        Kernel.set((Object)this, (String)"networkSettings", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder clusterType(String clusterType) {
            this.props().clusterType(clusterType);
            return this;
        }

        public Builder instanceRoleArn(String instanceRoleArn) {
            this.props().instanceRoleArn(instanceRoleArn);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder networkSettings(IResolvable networkSettings) {
            this.props().networkSettings(networkSettings);
            return this;
        }

        public Builder networkSettings(ClusterNetworkSettingsProperty networkSettings) {
            this.props().networkSettings(networkSettings);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnClusterProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_medialive.CfnCluster.InterfaceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InterfaceMappingProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLogicalInterfaceName() {
            return null;
        }

        @Nullable
        default public String getNetworkId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InterfaceMappingProperty> {
            String logicalInterfaceName;
            String networkId;

            public Builder logicalInterfaceName(String logicalInterfaceName) {
                this.logicalInterfaceName = logicalInterfaceName;
                return this;
            }

            public Builder networkId(String networkId) {
                this.networkId = networkId;
                return this;
            }

            public InterfaceMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_medialive.CfnCluster.ClusterNetworkSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterNetworkSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDefaultRoute() {
            return null;
        }

        @Nullable
        default public Object getInterfaceMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterNetworkSettingsProperty> {
            String defaultRoute;
            Object interfaceMappings;

            public Builder defaultRoute(String defaultRoute) {
                this.defaultRoute = defaultRoute;
                return this;
            }

            public Builder interfaceMappings(IResolvable interfaceMappings) {
                this.interfaceMappings = interfaceMappings;
                return this;
            }

            public Builder interfaceMappings(List<? extends Object> interfaceMappings) {
                this.interfaceMappings = interfaceMappings;
                return this;
            }

            public ClusterNetworkSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

