/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.connect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.connect.CfnQueue;
import software.amazon.awscdk.services.connect.CfnQueueProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_connect.CfnQueue")
public class CfnQueue
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnQueue.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnQueue(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnQueue(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnQueue(@NotNull Construct scope, @NotNull String id, @NotNull CfnQueueProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrQueueArn() {
        return (String)Kernel.get((Object)this, (String)"attrQueueArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrType() {
        return (String)Kernel.get((Object)this, (String)"attrType", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getHoursOfOperationArn() {
        return (String)Kernel.get((Object)this, (String)"hoursOfOperationArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setHoursOfOperationArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"hoursOfOperationArn", (Object)Objects.requireNonNull(value, "hoursOfOperationArn is required"));
    }

    @NotNull
    public String getInstanceArn() {
        return (String)Kernel.get((Object)this, (String)"instanceArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceArn", (Object)Objects.requireNonNull(value, "instanceArn is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Number getMaxContacts() {
        return (Number)Kernel.get((Object)this, (String)"maxContacts", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxContacts(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxContacts", (Object)value);
    }

    @Nullable
    public Object getOutboundCallerConfig() {
        return Kernel.get((Object)this, (String)"outboundCallerConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOutboundCallerConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"outboundCallerConfig", (Object)value);
    }

    public void setOutboundCallerConfig(@Nullable OutboundCallerConfigProperty value) {
        Kernel.set((Object)this, (String)"outboundCallerConfig", (Object)value);
    }

    @Nullable
    public List<String> getQuickConnectArns() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"quickConnectArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setQuickConnectArns(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"quickConnectArns", value);
    }

    @Nullable
    public String getStatus() {
        return (String)Kernel.get((Object)this, (String)"status", (NativeType)NativeType.forClass(String.class));
    }

    public void setStatus(@Nullable String value) {
        Kernel.set((Object)this, (String)"status", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnQueue> {
        private final Construct scope;
        private final String id;
        private final CfnQueueProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnQueueProps.Builder();
        }

        public Builder hoursOfOperationArn(String hoursOfOperationArn) {
            this.props.hoursOfOperationArn(hoursOfOperationArn);
            return this;
        }

        public Builder instanceArn(String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder maxContacts(Number maxContacts) {
            this.props.maxContacts(maxContacts);
            return this;
        }

        public Builder outboundCallerConfig(IResolvable outboundCallerConfig) {
            this.props.outboundCallerConfig(outboundCallerConfig);
            return this;
        }

        public Builder outboundCallerConfig(OutboundCallerConfigProperty outboundCallerConfig) {
            this.props.outboundCallerConfig(outboundCallerConfig);
            return this;
        }

        public Builder quickConnectArns(List<String> quickConnectArns) {
            this.props.quickConnectArns(quickConnectArns);
            return this;
        }

        public Builder status(String status) {
            this.props.status(status);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnQueue build() {
            return new CfnQueue(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_connect.CfnQueue.OutboundCallerConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutboundCallerConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOutboundCallerIdName() {
            return null;
        }

        @Nullable
        default public String getOutboundCallerIdNumberArn() {
            return null;
        }

        @Nullable
        default public String getOutboundFlowArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutboundCallerConfigProperty> {
            String outboundCallerIdName;
            String outboundCallerIdNumberArn;
            String outboundFlowArn;

            public Builder outboundCallerIdName(String outboundCallerIdName) {
                this.outboundCallerIdName = outboundCallerIdName;
                return this;
            }

            public Builder outboundCallerIdNumberArn(String outboundCallerIdNumberArn) {
                this.outboundCallerIdNumberArn = outboundCallerIdNumberArn;
                return this;
            }

            public Builder outboundFlowArn(String outboundFlowArn) {
                this.outboundFlowArn = outboundFlowArn;
                return this;
            }

            public OutboundCallerConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

