/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.dms.CfnReplicationInstanceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dms.CfnReplicationInstance")
public class CfnReplicationInstance
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnReplicationInstance.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnReplicationInstance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReplicationInstance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnReplicationInstance(@NotNull Construct scope, @NotNull String id, @NotNull CfnReplicationInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrReplicationInstancePrivateIpAddresses() {
        return (String)Kernel.get((Object)this, (String)"attrReplicationInstancePrivateIpAddresses", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrReplicationInstancePublicIpAddresses() {
        return (String)Kernel.get((Object)this, (String)"attrReplicationInstancePublicIpAddresses", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getReplicationInstanceClass() {
        return (String)Kernel.get((Object)this, (String)"replicationInstanceClass", (NativeType)NativeType.forClass(String.class));
    }

    public void setReplicationInstanceClass(@NotNull String value) {
        Kernel.set((Object)this, (String)"replicationInstanceClass", (Object)Objects.requireNonNull(value, "replicationInstanceClass is required"));
    }

    @Nullable
    public Number getAllocatedStorage() {
        return (Number)Kernel.get((Object)this, (String)"allocatedStorage", (NativeType)NativeType.forClass(Number.class));
    }

    public void setAllocatedStorage(@Nullable Number value) {
        Kernel.set((Object)this, (String)"allocatedStorage", (Object)value);
    }

    @Nullable
    public Object getAllowMajorVersionUpgrade() {
        return Kernel.get((Object)this, (String)"allowMajorVersionUpgrade", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAllowMajorVersionUpgrade(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"allowMajorVersionUpgrade", (Object)value);
    }

    public void setAllowMajorVersionUpgrade(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"allowMajorVersionUpgrade", (Object)value);
    }

    @Nullable
    public Object getAutoMinorVersionUpgrade() {
        return Kernel.get((Object)this, (String)"autoMinorVersionUpgrade", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoMinorVersionUpgrade(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    public void setAutoMinorVersionUpgrade(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    @Nullable
    public String getAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"availabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZone(@Nullable String value) {
        Kernel.set((Object)this, (String)"availabilityZone", (Object)value);
    }

    @Nullable
    public String getEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"engineVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineVersion", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public Object getMultiAz() {
        return Kernel.get((Object)this, (String)"multiAz", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMultiAz(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"multiAz", (Object)value);
    }

    public void setMultiAz(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"multiAz", (Object)value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public Object getPubliclyAccessible() {
        return Kernel.get((Object)this, (String)"publiclyAccessible", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPubliclyAccessible(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    public void setPubliclyAccessible(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    @Nullable
    public String getReplicationInstanceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"replicationInstanceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setReplicationInstanceIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"replicationInstanceIdentifier", (Object)value);
    }

    @Nullable
    public String getReplicationSubnetGroupIdentifier() {
        return (String)Kernel.get((Object)this, (String)"replicationSubnetGroupIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setReplicationSubnetGroupIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"replicationSubnetGroupIdentifier", (Object)value);
    }

    @Nullable
    public String getResourceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"resourceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"resourceIdentifier", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public List<String> getVpcSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcSecurityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcSecurityGroupIds", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnReplicationInstance> {
        private final Construct scope;
        private final String id;
        private final CfnReplicationInstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnReplicationInstanceProps.Builder();
        }

        public Builder replicationInstanceClass(String replicationInstanceClass) {
            this.props.replicationInstanceClass(replicationInstanceClass);
            return this;
        }

        public Builder allocatedStorage(Number allocatedStorage) {
            this.props.allocatedStorage(allocatedStorage);
            return this;
        }

        public Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.props.allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }

        public Builder allowMajorVersionUpgrade(IResolvable allowMajorVersionUpgrade) {
            this.props.allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder autoMinorVersionUpgrade(IResolvable autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder multiAz(Boolean multiAz) {
            this.props.multiAz(multiAz);
            return this;
        }

        public Builder multiAz(IResolvable multiAz) {
            this.props.multiAz(multiAz);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder publiclyAccessible(IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.props.replicationInstanceIdentifier(replicationInstanceIdentifier);
            return this;
        }

        public Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.props.replicationSubnetGroupIdentifier(replicationSubnetGroupIdentifier);
            return this;
        }

        public Builder resourceIdentifier(String resourceIdentifier) {
            this.props.resourceIdentifier(resourceIdentifier);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        public CfnReplicationInstance build() {
            return new CfnReplicationInstance(this.scope, this.id, this.props.build());
        }
    }
}

