package software.amazon.awscdk;

/**
 * The destination for a docker image asset, when it is given to the AssetManifestBuilder.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Object assumeRoleAdditionalOptions;
 * AssetManifestDockerImageDestination assetManifestDockerImageDestination = AssetManifestDockerImageDestination.builder()
 *         .repositoryName("repositoryName")
 *         // the properties below are optional
 *         .dockerTagPrefix("dockerTagPrefix")
 *         .role(RoleOptions.builder()
 *                 .assumeRoleArn("assumeRoleArn")
 *                 // the properties below are optional
 *                 .assumeRoleAdditionalOptions(Map.of(
 *                         "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.042Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.AssetManifestDockerImageDestination")
@software.amazon.jsii.Jsii.Proxy(AssetManifestDockerImageDestination.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetManifestDockerImageDestination extends software.amazon.jsii.JsiiSerializable {

    /**
     * Repository name where the docker image asset should be written.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * Prefix to add to the asset hash to make the Docker image tag.
     * <p>
     * Default: ''
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerTagPrefix() {
        return null;
    }

    /**
     * Role to use to perform the upload.
     * <p>
     * Default: - No role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RoleOptions getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssetManifestDockerImageDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetManifestDockerImageDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetManifestDockerImageDestination> {
        java.lang.String repositoryName;
        java.lang.String dockerTagPrefix;
        software.amazon.awscdk.RoleOptions role;

        /**
         * Sets the value of {@link AssetManifestDockerImageDestination#getRepositoryName}
         * @param repositoryName Repository name where the docker image asset should be written. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link AssetManifestDockerImageDestination#getDockerTagPrefix}
         * @param dockerTagPrefix Prefix to add to the asset hash to make the Docker image tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerTagPrefix(java.lang.String dockerTagPrefix) {
            this.dockerTagPrefix = dockerTagPrefix;
            return this;
        }

        /**
         * Sets the value of {@link AssetManifestDockerImageDestination#getRole}
         * @param role Role to use to perform the upload.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.RoleOptions role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetManifestDockerImageDestination}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetManifestDockerImageDestination build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetManifestDockerImageDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetManifestDockerImageDestination {
        private final java.lang.String repositoryName;
        private final java.lang.String dockerTagPrefix;
        private final software.amazon.awscdk.RoleOptions role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerTagPrefix = software.amazon.jsii.Kernel.get(this, "dockerTagPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RoleOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
            this.dockerTagPrefix = builder.dockerTagPrefix;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.String getDockerTagPrefix() {
            return this.dockerTagPrefix;
        }

        @Override
        public final software.amazon.awscdk.RoleOptions getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            if (this.getDockerTagPrefix() != null) {
                data.set("dockerTagPrefix", om.valueToTree(this.getDockerTagPrefix()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.AssetManifestDockerImageDestination"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetManifestDockerImageDestination.Jsii$Proxy that = (AssetManifestDockerImageDestination.Jsii$Proxy) o;

            if (!repositoryName.equals(that.repositoryName)) return false;
            if (this.dockerTagPrefix != null ? !this.dockerTagPrefix.equals(that.dockerTagPrefix) : that.dockerTagPrefix != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repositoryName.hashCode();
            result = 31 * result + (this.dockerTagPrefix != null ? this.dockerTagPrefix.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
