package software.amazon.awscdk;

/**
 * This is a CloudFormation resource for the first-party AWS::Hooks::LambdaHook.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnLambdaHook cfnLambdaHook = CfnLambdaHook.Builder.create(this, "MyCfnLambdaHook")
 *         .alias("alias")
 *         .executionRole("executionRole")
 *         .failureMode("failureMode")
 *         .hookStatus("hookStatus")
 *         .lambdaFunction("lambdaFunction")
 *         .targetOperations(List.of("targetOperations"))
 *         // the properties below are optional
 *         .stackFilters(StackFiltersProperty.builder()
 *                 .filteringCriteria("filteringCriteria")
 *                 // the properties below are optional
 *                 .stackNames(StackNamesProperty.builder()
 *                         .exclude(List.of("exclude"))
 *                         .include(List.of("include"))
 *                         .build())
 *                 .stackRoles(StackRolesProperty.builder()
 *                         .exclude(List.of("exclude"))
 *                         .include(List.of("include"))
 *                         .build())
 *                 .build())
 *         .targetFilters(TargetFiltersProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .invocationPoints(List.of("invocationPoints"))
 *                 .targetNames(List.of("targetNames"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.084Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnLambdaHook")
public class CfnLambdaHook extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLambdaHook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLambdaHook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.CfnLambdaHook.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLambdaHook(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnLambdaHookProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the activated hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrHookArn() {
        return software.amazon.jsii.Kernel.get(this, "attrHookArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The typename alias for the hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlias() {
        return software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The typename alias for the hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlias(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alias", java.util.Objects.requireNonNull(value, "alias is required"));
    }

    /**
     * IAM Role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * IAM Role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRole", java.util.Objects.requireNonNull(value, "executionRole is required"));
    }

    /**
     * Attribute to specify CloudFormation behavior on hook failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFailureMode() {
        return software.amazon.jsii.Kernel.get(this, "failureMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Attribute to specify CloudFormation behavior on hook failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailureMode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "failureMode", java.util.Objects.requireNonNull(value, "failureMode is required"));
    }

    /**
     * Attribute to specify which stacks this hook applies to or should get invoked for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHookStatus() {
        return software.amazon.jsii.Kernel.get(this, "hookStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Attribute to specify which stacks this hook applies to or should get invoked for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHookStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hookStatus", java.util.Objects.requireNonNull(value, "hookStatus is required"));
    }

    /**
     * Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLambdaFunction() {
        return software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaFunction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "lambdaFunction", java.util.Objects.requireNonNull(value, "lambdaFunction is required"));
    }

    /**
     * Which operations should this Hook run against?
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetOperations() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "targetOperations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Which operations should this Hook run against?
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetOperations(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "targetOperations", java.util.Objects.requireNonNull(value, "targetOperations is required"));
    }

    /**
     * Filters to allow hooks to target specific stack attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStackFilters() {
        return software.amazon.jsii.Kernel.get(this, "stackFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Filters to allow hooks to target specific stack attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStackFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stackFilters", value);
    }

    /**
     * Filters to allow hooks to target specific stack attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStackFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnLambdaHook.StackFiltersProperty value) {
        software.amazon.jsii.Kernel.set(this, "stackFilters", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetFilters() {
        return software.amazon.jsii.Kernel.get(this, "targetFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetFilters", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetFilters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnLambdaHook.TargetFiltersProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetFilters", value);
    }
    /**
     * Filters to allow hooks to target specific stack attributes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * StackFiltersProperty stackFiltersProperty = StackFiltersProperty.builder()
     *         .filteringCriteria("filteringCriteria")
     *         // the properties below are optional
     *         .stackNames(StackNamesProperty.builder()
     *                 .exclude(List.of("exclude"))
     *                 .include(List.of("include"))
     *                 .build())
     *         .stackRoles(StackRolesProperty.builder()
     *                 .exclude(List.of("exclude"))
     *                 .include(List.of("include"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnLambdaHook.StackFiltersProperty")
    @software.amazon.jsii.Jsii.Proxy(StackFiltersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StackFiltersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Attribute to specify the filtering behavior.
         * <p>
         * ANY will make the Hook pass if one filter matches. ALL will make the Hook pass if all filters match
         * <p>
         * Default: - "ALL"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html#cfn-cloudformation-lambdahook-stackfilters-filteringcriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html#cfn-cloudformation-lambdahook-stackfilters-filteringcriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilteringCriteria();

        /**
         * List of stack names as filters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html#cfn-cloudformation-lambdahook-stackfilters-stacknames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html#cfn-cloudformation-lambdahook-stackfilters-stacknames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStackNames() {
            return null;
        }

        /**
         * List of stack roles that are performing the stack operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html#cfn-cloudformation-lambdahook-stackfilters-stackroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackfilters.html#cfn-cloudformation-lambdahook-stackfilters-stackroles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStackRoles() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StackFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StackFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StackFiltersProperty> {
            java.lang.String filteringCriteria;
            java.lang.Object stackNames;
            java.lang.Object stackRoles;

            /**
             * Sets the value of {@link StackFiltersProperty#getFilteringCriteria}
             * @param filteringCriteria Attribute to specify the filtering behavior. This parameter is required.
             *                          ANY will make the Hook pass if one filter matches. ALL will make the Hook pass if all filters match
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filteringCriteria(java.lang.String filteringCriteria) {
                this.filteringCriteria = filteringCriteria;
                return this;
            }

            /**
             * Sets the value of {@link StackFiltersProperty#getStackNames}
             * @param stackNames List of stack names as filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackNames(software.amazon.awscdk.IResolvable stackNames) {
                this.stackNames = stackNames;
                return this;
            }

            /**
             * Sets the value of {@link StackFiltersProperty#getStackNames}
             * @param stackNames List of stack names as filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackNames(software.amazon.awscdk.CfnLambdaHook.StackNamesProperty stackNames) {
                this.stackNames = stackNames;
                return this;
            }

            /**
             * Sets the value of {@link StackFiltersProperty#getStackRoles}
             * @param stackRoles List of stack roles that are performing the stack operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackRoles(software.amazon.awscdk.IResolvable stackRoles) {
                this.stackRoles = stackRoles;
                return this;
            }

            /**
             * Sets the value of {@link StackFiltersProperty#getStackRoles}
             * @param stackRoles List of stack roles that are performing the stack operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackRoles(software.amazon.awscdk.CfnLambdaHook.StackRolesProperty stackRoles) {
                this.stackRoles = stackRoles;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StackFiltersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StackFiltersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StackFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackFiltersProperty {
            private final java.lang.String filteringCriteria;
            private final java.lang.Object stackNames;
            private final java.lang.Object stackRoles;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filteringCriteria = software.amazon.jsii.Kernel.get(this, "filteringCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stackNames = software.amazon.jsii.Kernel.get(this, "stackNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stackRoles = software.amazon.jsii.Kernel.get(this, "stackRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filteringCriteria = java.util.Objects.requireNonNull(builder.filteringCriteria, "filteringCriteria is required");
                this.stackNames = builder.stackNames;
                this.stackRoles = builder.stackRoles;
            }

            @Override
            public final java.lang.String getFilteringCriteria() {
                return this.filteringCriteria;
            }

            @Override
            public final java.lang.Object getStackNames() {
                return this.stackNames;
            }

            @Override
            public final java.lang.Object getStackRoles() {
                return this.stackRoles;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filteringCriteria", om.valueToTree(this.getFilteringCriteria()));
                if (this.getStackNames() != null) {
                    data.set("stackNames", om.valueToTree(this.getStackNames()));
                }
                if (this.getStackRoles() != null) {
                    data.set("stackRoles", om.valueToTree(this.getStackRoles()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnLambdaHook.StackFiltersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StackFiltersProperty.Jsii$Proxy that = (StackFiltersProperty.Jsii$Proxy) o;

                if (!filteringCriteria.equals(that.filteringCriteria)) return false;
                if (this.stackNames != null ? !this.stackNames.equals(that.stackNames) : that.stackNames != null) return false;
                return this.stackRoles != null ? this.stackRoles.equals(that.stackRoles) : that.stackRoles == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filteringCriteria.hashCode();
                result = 31 * result + (this.stackNames != null ? this.stackNames.hashCode() : 0);
                result = 31 * result + (this.stackRoles != null ? this.stackRoles.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * List of stack names as filters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * StackNamesProperty stackNamesProperty = StackNamesProperty.builder()
     *         .exclude(List.of("exclude"))
     *         .include(List.of("include"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stacknames.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stacknames.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnLambdaHook.StackNamesProperty")
    @software.amazon.jsii.Jsii.Proxy(StackNamesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StackNamesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of stack names that the hook is going to be excluded from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stacknames.html#cfn-cloudformation-lambdahook-stacknames-exclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stacknames.html#cfn-cloudformation-lambdahook-stacknames-exclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
            return null;
        }

        /**
         * List of stack names that the hook is going to target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stacknames.html#cfn-cloudformation-lambdahook-stacknames-include">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stacknames.html#cfn-cloudformation-lambdahook-stacknames-include</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StackNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StackNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StackNamesProperty> {
            java.util.List<java.lang.String> exclude;
            java.util.List<java.lang.String> include;

            /**
             * Sets the value of {@link StackNamesProperty#getExclude}
             * @param exclude List of stack names that the hook is going to be excluded from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclude(java.util.List<java.lang.String> exclude) {
                this.exclude = exclude;
                return this;
            }

            /**
             * Sets the value of {@link StackNamesProperty#getInclude}
             * @param include List of stack names that the hook is going to target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(java.util.List<java.lang.String> include) {
                this.include = include;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StackNamesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StackNamesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StackNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackNamesProperty {
            private final java.util.List<java.lang.String> exclude;
            private final java.util.List<java.lang.String> include;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exclude = builder.exclude;
                this.include = builder.include;
            }

            @Override
            public final java.util.List<java.lang.String> getExclude() {
                return this.exclude;
            }

            @Override
            public final java.util.List<java.lang.String> getInclude() {
                return this.include;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExclude() != null) {
                    data.set("exclude", om.valueToTree(this.getExclude()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnLambdaHook.StackNamesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StackNamesProperty.Jsii$Proxy that = (StackNamesProperty.Jsii$Proxy) o;

                if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
                return this.include != null ? this.include.equals(that.include) : that.include == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exclude != null ? this.exclude.hashCode() : 0;
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * List of stack roles that are performing the stack operations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * StackRolesProperty stackRolesProperty = StackRolesProperty.builder()
     *         .exclude(List.of("exclude"))
     *         .include(List.of("include"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackroles.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackroles.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnLambdaHook.StackRolesProperty")
    @software.amazon.jsii.Jsii.Proxy(StackRolesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StackRolesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of stack roles that the hook is going to be excluded from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackroles.html#cfn-cloudformation-lambdahook-stackroles-exclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackroles.html#cfn-cloudformation-lambdahook-stackroles-exclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
            return null;
        }

        /**
         * List of stack roles that the hook is going to target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackroles.html#cfn-cloudformation-lambdahook-stackroles-include">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-stackroles.html#cfn-cloudformation-lambdahook-stackroles-include</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StackRolesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StackRolesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StackRolesProperty> {
            java.util.List<java.lang.String> exclude;
            java.util.List<java.lang.String> include;

            /**
             * Sets the value of {@link StackRolesProperty#getExclude}
             * @param exclude List of stack roles that the hook is going to be excluded from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclude(java.util.List<java.lang.String> exclude) {
                this.exclude = exclude;
                return this;
            }

            /**
             * Sets the value of {@link StackRolesProperty#getInclude}
             * @param include List of stack roles that the hook is going to target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(java.util.List<java.lang.String> include) {
                this.include = include;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StackRolesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StackRolesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StackRolesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackRolesProperty {
            private final java.util.List<java.lang.String> exclude;
            private final java.util.List<java.lang.String> include;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exclude = builder.exclude;
                this.include = builder.include;
            }

            @Override
            public final java.util.List<java.lang.String> getExclude() {
                return this.exclude;
            }

            @Override
            public final java.util.List<java.lang.String> getInclude() {
                return this.include;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExclude() != null) {
                    data.set("exclude", om.valueToTree(this.getExclude()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnLambdaHook.StackRolesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StackRolesProperty.Jsii$Proxy that = (StackRolesProperty.Jsii$Proxy) o;

                if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
                return this.include != null ? this.include.equals(that.include) : that.include == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exclude != null ? this.exclude.hashCode() : 0;
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.*;
     * TargetFiltersProperty targetFiltersProperty = TargetFiltersProperty.builder()
     *         .actions(List.of("actions"))
     *         .invocationPoints(List.of("invocationPoints"))
     *         .targetNames(List.of("targetNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnLambdaHook.TargetFiltersProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetFiltersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetFiltersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of actions that the hook is going to target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html#cfn-cloudformation-lambdahook-targetfilters-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html#cfn-cloudformation-lambdahook-targetfilters-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getActions() {
            return null;
        }

        /**
         * List of invocation points that the hook is going to target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html#cfn-cloudformation-lambdahook-targetfilters-invocationpoints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html#cfn-cloudformation-lambdahook-targetfilters-invocationpoints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInvocationPoints() {
            return null;
        }

        /**
         * List of type names that the hook is going to target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html#cfn-cloudformation-lambdahook-targetfilters-targetnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-lambdahook-targetfilters.html#cfn-cloudformation-lambdahook-targetfilters-targetnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetFiltersProperty> {
            java.util.List<java.lang.String> actions;
            java.util.List<java.lang.String> invocationPoints;
            java.util.List<java.lang.String> targetNames;

            /**
             * Sets the value of {@link TargetFiltersProperty#getActions}
             * @param actions List of actions that the hook is going to target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link TargetFiltersProperty#getInvocationPoints}
             * @param invocationPoints List of invocation points that the hook is going to target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationPoints(java.util.List<java.lang.String> invocationPoints) {
                this.invocationPoints = invocationPoints;
                return this;
            }

            /**
             * Sets the value of {@link TargetFiltersProperty#getTargetNames}
             * @param targetNames List of type names that the hook is going to target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetNames(java.util.List<java.lang.String> targetNames) {
                this.targetNames = targetNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetFiltersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetFiltersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetFiltersProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.util.List<java.lang.String> invocationPoints;
            private final java.util.List<java.lang.String> targetNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.invocationPoints = software.amazon.jsii.Kernel.get(this, "invocationPoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.targetNames = software.amazon.jsii.Kernel.get(this, "targetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = builder.actions;
                this.invocationPoints = builder.invocationPoints;
                this.targetNames = builder.targetNames;
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.util.List<java.lang.String> getInvocationPoints() {
                return this.invocationPoints;
            }

            @Override
            public final java.util.List<java.lang.String> getTargetNames() {
                return this.targetNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }
                if (this.getInvocationPoints() != null) {
                    data.set("invocationPoints", om.valueToTree(this.getInvocationPoints()));
                }
                if (this.getTargetNames() != null) {
                    data.set("targetNames", om.valueToTree(this.getTargetNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnLambdaHook.TargetFiltersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetFiltersProperty.Jsii$Proxy that = (TargetFiltersProperty.Jsii$Proxy) o;

                if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
                if (this.invocationPoints != null ? !this.invocationPoints.equals(that.invocationPoints) : that.invocationPoints != null) return false;
                return this.targetNames != null ? this.targetNames.equals(that.targetNames) : that.targetNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions != null ? this.actions.hashCode() : 0;
                result = 31 * result + (this.invocationPoints != null ? this.invocationPoints.hashCode() : 0);
                result = 31 * result + (this.targetNames != null ? this.targetNames.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.CfnLambdaHook}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.CfnLambdaHook> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.CfnLambdaHookProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.CfnLambdaHookProps.Builder();
        }

        /**
         * The typename alias for the hook.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-alias</a>
         * @param alias The typename alias for the hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(final java.lang.String alias) {
            this.props.alias(alias);
            return this;
        }

        /**
         * IAM Role ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-executionrole</a>
         * @param executionRole IAM Role ARN. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final java.lang.String executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * Attribute to specify CloudFormation behavior on hook failure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-failuremode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-failuremode</a>
         * @param failureMode Attribute to specify CloudFormation behavior on hook failure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureMode(final java.lang.String failureMode) {
            this.props.failureMode(failureMode);
            return this;
        }

        /**
         * Attribute to specify which stacks this hook applies to or should get invoked for.
         * <p>
         * Default: - "ENABLED"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-hookstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-hookstatus</a>
         * @param hookStatus Attribute to specify which stacks this hook applies to or should get invoked for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hookStatus(final java.lang.String hookStatus) {
            this.props.hookStatus(hookStatus);
            return this;
        }

        /**
         * Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-lambdafunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-lambdafunction</a>
         * @param lambdaFunction Amazon Resource Name (ARN), Partial ARN, name, version, or alias of the Lambda function to invoke with this hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(final java.lang.String lambdaFunction) {
            this.props.lambdaFunction(lambdaFunction);
            return this;
        }

        /**
         * Which operations should this Hook run against?
         * <p>
         * Resource changes, stacks or change sets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetoperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetoperations</a>
         * @param targetOperations Which operations should this Hook run against?. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetOperations(final java.util.List<java.lang.String> targetOperations) {
            this.props.targetOperations(targetOperations);
            return this;
        }

        /**
         * Filters to allow hooks to target specific stack attributes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-stackfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-stackfilters</a>
         * @param stackFilters Filters to allow hooks to target specific stack attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackFilters(final software.amazon.awscdk.IResolvable stackFilters) {
            this.props.stackFilters(stackFilters);
            return this;
        }
        /**
         * Filters to allow hooks to target specific stack attributes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-stackfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-stackfilters</a>
         * @param stackFilters Filters to allow hooks to target specific stack attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackFilters(final software.amazon.awscdk.CfnLambdaHook.StackFiltersProperty stackFilters) {
            this.props.stackFilters(stackFilters);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetfilters</a>
         * @param targetFilters This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFilters(final software.amazon.awscdk.IResolvable targetFilters) {
            this.props.targetFilters(targetFilters);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetfilters</a>
         * @param targetFilters This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFilters(final software.amazon.awscdk.CfnLambdaHook.TargetFiltersProperty targetFilters) {
            this.props.targetFilters(targetFilters);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.CfnLambdaHook}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.CfnLambdaHook build() {
            return new software.amazon.awscdk.CfnLambdaHook(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
