package software.amazon.awscdk.services.apigatewayv2;

/**
 * The <code>AWS::ApiGatewayV2::Stage</code> resource specifies a stage for an API.
 * <p>
 * Each stage is a named reference to a deployment of the API and is made available for client applications to call. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-stages.html">Working with stages for HTTP APIs</a> and <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-set-up-websocket-deployment.html">Deploy a WebSocket API in API Gateway</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object routeSettings;
 * Object stageVariables;
 * Object tags;
 * CfnStage cfnStage = CfnStage.Builder.create(this, "MyCfnStage")
 *         .apiId("apiId")
 *         .stageName("stageName")
 *         // the properties below are optional
 *         .accessLogSettings(AccessLogSettingsProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .format("format")
 *                 .build())
 *         .accessPolicyId("accessPolicyId")
 *         .autoDeploy(false)
 *         .clientCertificateId("clientCertificateId")
 *         .defaultRouteSettings(RouteSettingsProperty.builder()
 *                 .dataTraceEnabled(false)
 *                 .detailedMetricsEnabled(false)
 *                 .loggingLevel("loggingLevel")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build())
 *         .deploymentId("deploymentId")
 *         .description("description")
 *         .routeSettings(routeSettings)
 *         .stageVariables(stageVariables)
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.766Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnStage")
public class CfnStage extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnStage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.CfnStage.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.CfnStageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * The stage name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stage name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stageName", java.util.Objects.requireNonNull(value, "stageName is required"));
    }

    /**
     * Settings for logging access in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSettings() {
        return software.amazon.jsii.Kernel.get(this, "accessLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings for logging access in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLogSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessLogSettings", value);
    }

    /**
     * Settings for logging access in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLogSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CfnStage.AccessLogSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "accessLogSettings", value);
    }

    /**
     * This parameter is not currently supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccessPolicyId() {
        return software.amazon.jsii.Kernel.get(this, "accessPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This parameter is not currently supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessPolicyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessPolicyId", value);
    }

    /**
     * Specifies whether updates to an API automatically trigger a new deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoDeploy() {
        return software.amazon.jsii.Kernel.get(this, "autoDeploy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether updates to an API automatically trigger a new deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoDeploy(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoDeploy", value);
    }

    /**
     * Specifies whether updates to an API automatically trigger a new deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoDeploy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoDeploy", value);
    }

    /**
     * The identifier of a client certificate for a <code>Stage</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateId() {
        return software.amazon.jsii.Kernel.get(this, "clientCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of a client certificate for a <code>Stage</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientCertificateId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientCertificateId", value);
    }

    /**
     * The default route settings for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRouteSettings() {
        return software.amazon.jsii.Kernel.get(this, "defaultRouteSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default route settings for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRouteSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultRouteSettings", value);
    }

    /**
     * The default route settings for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRouteSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CfnStage.RouteSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultRouteSettings", value);
    }

    /**
     * The deployment identifier for the API stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeploymentId() {
        return software.amazon.jsii.Kernel.get(this, "deploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The deployment identifier for the API stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deploymentId", value);
    }

    /**
     * The description for the API stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description for the API stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Route settings for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRouteSettings() {
        return software.amazon.jsii.Kernel.get(this, "routeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Route settings for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteSettings(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "routeSettings", value);
    }

    /**
     * A map that defines the stage variables for a <code>Stage</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStageVariables() {
        return software.amazon.jsii.Kernel.get(this, "stageVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map that defines the stage variables for a <code>Stage</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageVariables(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "stageVariables", value);
    }

    /**
     * The collection of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The collection of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Settings for logging access in a stage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * AccessLogSettingsProperty accessLogSettingsProperty = AccessLogSettingsProperty.builder()
     *         .destinationArn("destinationArn")
     *         .format("format")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnStage.AccessLogSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessLogSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the CloudWatch Logs log group to receive access logs.
         * <p>
         * This parameter is required to enable access logging.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-destinationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-destinationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * A single line format of the access logs of data, as specified by selected $context variables.
         * <p>
         * The format must include at least $context.requestId. This parameter is required to enable access logging.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessLogSettingsProperty> {
            java.lang.String destinationArn;
            java.lang.String format;

            /**
             * Sets the value of {@link AccessLogSettingsProperty#getDestinationArn}
             * @param destinationArn The ARN of the CloudWatch Logs log group to receive access logs.
             *                       This parameter is required to enable access logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link AccessLogSettingsProperty#getFormat}
             * @param format A single line format of the access logs of data, as specified by selected $context variables.
             *               The format must include at least $context.requestId. This parameter is required to enable access logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessLogSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingsProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = builder.destinationArn;
                this.format = builder.format;
            }

            @Override
            public final java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnStage.AccessLogSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingsProperty.Jsii$Proxy that = (AccessLogSettingsProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a collection of route settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * RouteSettingsProperty routeSettingsProperty = RouteSettingsProperty.builder()
     *         .dataTraceEnabled(false)
     *         .detailedMetricsEnabled(false)
     *         .loggingLevel("loggingLevel")
     *         .throttlingBurstLimit(123)
     *         .throttlingRateLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnStage.RouteSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RouteSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouteSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether ( <code>true</code> ) or not ( <code>false</code> ) data trace logging is enabled for this route.
         * <p>
         * This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-datatraceenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-datatraceenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * Specifies whether detailed metrics are enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-detailedmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-detailedmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDetailedMetricsEnabled() {
            return null;
        }

        /**
         * Specifies the logging level for this route: <code>INFO</code> , <code>ERROR</code> , or <code>OFF</code> .
         * <p>
         * This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-logginglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-logginglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * Specifies the throttling burst limit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingburstlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingburstlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * Specifies the throttling rate limit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingratelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingratelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouteSettingsProperty> {
            java.lang.Object dataTraceEnabled;
            java.lang.Object detailedMetricsEnabled;
            java.lang.String loggingLevel;
            java.lang.Number throttlingBurstLimit;
            java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of {@link RouteSettingsProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Specifies whether ( <code>true</code> ) or not ( <code>false</code> ) data trace logging is enabled for this route.
             *                         This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Specifies whether ( <code>true</code> ) or not ( <code>false</code> ) data trace logging is enabled for this route.
             *                         This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDetailedMetricsEnabled}
             * @param detailedMetricsEnabled Specifies whether detailed metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedMetricsEnabled(java.lang.Boolean detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDetailedMetricsEnabled}
             * @param detailedMetricsEnabled Specifies whether detailed metrics are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedMetricsEnabled(software.amazon.awscdk.IResolvable detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getLoggingLevel}
             * @param loggingLevel Specifies the logging level for this route: <code>INFO</code> , <code>ERROR</code> , or <code>OFF</code> .
             *                     This property affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit Specifies the throttling burst limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit Specifies the throttling rate limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouteSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouteSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteSettingsProperty {
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.Object detailedMetricsEnabled;
            private final java.lang.String loggingLevel;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.detailedMetricsEnabled = software.amazon.jsii.Kernel.get(this, "detailedMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataTraceEnabled = builder.dataTraceEnabled;
                this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
                this.loggingLevel = builder.loggingLevel;
                this.throttlingBurstLimit = builder.throttlingBurstLimit;
                this.throttlingRateLimit = builder.throttlingRateLimit;
            }

            @Override
            public final java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public final java.lang.Object getDetailedMetricsEnabled() {
                return this.detailedMetricsEnabled;
            }

            @Override
            public final java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public final java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public final java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getDetailedMetricsEnabled() != null) {
                    data.set("detailedMetricsEnabled", om.valueToTree(this.getDetailedMetricsEnabled()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnStage.RouteSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouteSettingsProperty.Jsii$Proxy that = (RouteSettingsProperty.Jsii$Proxy) o;

                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.detailedMetricsEnabled != null ? !this.detailedMetricsEnabled.equals(that.detailedMetricsEnabled) : that.detailedMetricsEnabled != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0;
                result = 31 * result + (this.detailedMetricsEnabled != null ? this.detailedMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.CfnStage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.CfnStage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.CfnStageProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.CfnStageProps.Builder();
        }

        /**
         * The API identifier.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid</a>
         * @param apiId The API identifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * The stage name.
         * <p>
         * Stage names can contain only alphanumeric characters, hyphens, and underscores, or be <code>$default</code> . Maximum length is 128 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename</a>
         * @param stageName The stage name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * Settings for logging access in this stage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings</a>
         * @param accessLogSettings Settings for logging access in this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSettings(final software.amazon.awscdk.IResolvable accessLogSettings) {
            this.props.accessLogSettings(accessLogSettings);
            return this;
        }
        /**
         * Settings for logging access in this stage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings</a>
         * @param accessLogSettings Settings for logging access in this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSettings(final software.amazon.awscdk.services.apigatewayv2.CfnStage.AccessLogSettingsProperty accessLogSettings) {
            this.props.accessLogSettings(accessLogSettings);
            return this;
        }

        /**
         * This parameter is not currently supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesspolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesspolicyid</a>
         * @param accessPolicyId This parameter is not currently supported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicyId(final java.lang.String accessPolicyId) {
            this.props.accessPolicyId(accessPolicyId);
            return this;
        }

        /**
         * Specifies whether updates to an API automatically trigger a new deployment.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy</a>
         * @param autoDeploy Specifies whether updates to an API automatically trigger a new deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeploy(final java.lang.Boolean autoDeploy) {
            this.props.autoDeploy(autoDeploy);
            return this;
        }
        /**
         * Specifies whether updates to an API automatically trigger a new deployment.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-autodeploy</a>
         * @param autoDeploy Specifies whether updates to an API automatically trigger a new deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeploy(final software.amazon.awscdk.IResolvable autoDeploy) {
            this.props.autoDeploy(autoDeploy);
            return this;
        }

        /**
         * The identifier of a client certificate for a <code>Stage</code> .
         * <p>
         * Supported only for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid</a>
         * @param clientCertificateId The identifier of a client certificate for a <code>Stage</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateId(final java.lang.String clientCertificateId) {
            this.props.clientCertificateId(clientCertificateId);
            return this;
        }

        /**
         * The default route settings for the stage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings</a>
         * @param defaultRouteSettings The default route settings for the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(final software.amazon.awscdk.IResolvable defaultRouteSettings) {
            this.props.defaultRouteSettings(defaultRouteSettings);
            return this;
        }
        /**
         * The default route settings for the stage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings</a>
         * @param defaultRouteSettings The default route settings for the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(final software.amazon.awscdk.services.apigatewayv2.CfnStage.RouteSettingsProperty defaultRouteSettings) {
            this.props.defaultRouteSettings(defaultRouteSettings);
            return this;
        }

        /**
         * The deployment identifier for the API stage.
         * <p>
         * Can't be updated if <code>autoDeploy</code> is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid</a>
         * @param deploymentId The deployment identifier for the API stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentId(final java.lang.String deploymentId) {
            this.props.deploymentId(deploymentId);
            return this;
        }

        /**
         * The description for the API stage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description</a>
         * @param description The description for the API stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Route settings for the stage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings</a>
         * @param routeSettings Route settings for the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSettings(final java.lang.Object routeSettings) {
            this.props.routeSettings(routeSettings);
            return this;
        }

        /**
         * A map that defines the stage variables for a <code>Stage</code> .
         * <p>
         * Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables</a>
         * @param stageVariables A map that defines the stage variables for a <code>Stage</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageVariables(final java.lang.Object stageVariables) {
            this.props.stageVariables(stageVariables);
            return this;
        }

        /**
         * The collection of tags.
         * <p>
         * Each tag element is associated with a given resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags</a>
         * @param tags The collection of tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.CfnStage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.CfnStage build() {
            return new software.amazon.awscdk.services.apigatewayv2.CfnStage(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
