package software.amazon.awscdk.services.apigatewayv2;

/**
 * Options for DomainMapping.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpLambdaIntegration;
 * Function handler;
 * DomainName dn;
 * HttpApi apiDemo = HttpApi.Builder.create(this, "DemoApi")
 *         .defaultIntegration(new HttpLambdaIntegration("DefaultIntegration", handler))
 *         // https://${dn.domainName}/demo goes to apiDemo $default stage
 *         .defaultDomainMapping(DomainMappingOptions.builder()
 *                 .domainName(dn)
 *                 .mappingKey("demo")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:02.771Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.DomainMappingOptions")
@software.amazon.jsii.Jsii.Proxy(DomainMappingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainMappingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name for the mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IDomainName getDomainName();

    /**
     * The API mapping key.
     * <p>
     * Leave it undefined for the root path mapping.
     * <p>
     * Default: - empty key for the root path mapping
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMappingKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainMappingOptions> {
        software.amazon.awscdk.services.apigatewayv2.IDomainName domainName;
        java.lang.String mappingKey;

        /**
         * Sets the value of {@link DomainMappingOptions#getDomainName}
         * @param domainName The domain name for the mapping. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.apigatewayv2.IDomainName domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainMappingOptions#getMappingKey}
         * @param mappingKey The API mapping key.
         *                   Leave it undefined for the root path mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappingKey(java.lang.String mappingKey) {
            this.mappingKey = mappingKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainMappingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainMappingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainMappingOptions {
        private final software.amazon.awscdk.services.apigatewayv2.IDomainName domainName;
        private final java.lang.String mappingKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IDomainName.class));
            this.mappingKey = software.amazon.jsii.Kernel.get(this, "mappingKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.mappingKey = builder.mappingKey;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IDomainName getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getMappingKey() {
            return this.mappingKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getMappingKey() != null) {
                data.set("mappingKey", om.valueToTree(this.getMappingKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.DomainMappingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainMappingOptions.Jsii$Proxy that = (DomainMappingOptions.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            return this.mappingKey != null ? this.mappingKey.equals(that.mappingKey) : that.mappingKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.mappingKey != null ? this.mappingKey.hashCode() : 0);
            return result;
        }
    }
}
