package software.amazon.awscdk.services.applicationinsights;

/**
 * The <code>AWS::ApplicationInsights::Application</code> resource adds an application that is created from a resource group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationinsights.*;
 * CfnApplication cfnApplication = CfnApplication.Builder.create(this, "MyCfnApplication")
 *         .resourceGroupName("resourceGroupName")
 *         // the properties below are optional
 *         .attachMissingPermission(false)
 *         .autoConfigurationEnabled(false)
 *         .componentMonitoringSettings(List.of(ComponentMonitoringSettingProperty.builder()
 *                 .componentConfigurationMode("componentConfigurationMode")
 *                 .tier("tier")
 *                 // the properties below are optional
 *                 .componentArn("componentArn")
 *                 .componentName("componentName")
 *                 .customComponentConfiguration(ComponentConfigurationProperty.builder()
 *                         .configurationDetails(ConfigurationDetailsProperty.builder()
 *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                         .alarmMetricName("alarmMetricName")
 *                                         .build()))
 *                                 .alarms(List.of(AlarmProperty.builder()
 *                                         .alarmName("alarmName")
 *                                         // the properties below are optional
 *                                         .severity("severity")
 *                                         .build()))
 *                                 .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
 *                                         .agreeToInstallHanadbClient(false)
 *                                         .hanaPort("hanaPort")
 *                                         .hanaSecretName("hanaSecretName")
 *                                         .hanasid("hanasid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
 *                                         .hostPort("hostPort")
 *                                         .jmxurl("jmxurl")
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .logs(List.of(LogProperty.builder()
 *                                         .logType("logType")
 *                                         // the properties below are optional
 *                                         .encoding("encoding")
 *                                         .logGroupName("logGroupName")
 *                                         .logPath("logPath")
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
 *                                         .instanceNumbers(List.of("instanceNumbers"))
 *                                         .sapsid("sapsid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .processes(List.of(ProcessProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .processName("processName")
 *                                         .build()))
 *                                 .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .sqlSecretName("sqlSecretName")
 *                                         .build())
 *                                 .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                         .eventLevels(List.of("eventLevels"))
 *                                         .eventName("eventName")
 *                                         .logGroupName("logGroupName")
 *                                         // the properties below are optional
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .build())
 *                         .subComponentTypeConfigurations(List.of(SubComponentTypeConfigurationProperty.builder()
 *                                 .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .logs(List.of(LogProperty.builder()
 *                                                 .logType("logType")
 *                                                 // the properties below are optional
 *                                                 .encoding("encoding")
 *                                                 .logGroupName("logGroupName")
 *                                                 .logPath("logPath")
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .processes(List.of(ProcessProperty.builder()
 *                                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                         .alarmMetricName("alarmMetricName")
 *                                                         .build()))
 *                                                 .processName("processName")
 *                                                 .build()))
 *                                         .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                                 .eventLevels(List.of("eventLevels"))
 *                                                 .eventName("eventName")
 *                                                 .logGroupName("logGroupName")
 *                                                 // the properties below are optional
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .build())
 *                                 .subComponentType("subComponentType")
 *                                 .build()))
 *                         .build())
 *                 .defaultOverwriteComponentConfiguration(ComponentConfigurationProperty.builder()
 *                         .configurationDetails(ConfigurationDetailsProperty.builder()
 *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                         .alarmMetricName("alarmMetricName")
 *                                         .build()))
 *                                 .alarms(List.of(AlarmProperty.builder()
 *                                         .alarmName("alarmName")
 *                                         // the properties below are optional
 *                                         .severity("severity")
 *                                         .build()))
 *                                 .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
 *                                         .agreeToInstallHanadbClient(false)
 *                                         .hanaPort("hanaPort")
 *                                         .hanaSecretName("hanaSecretName")
 *                                         .hanasid("hanasid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
 *                                         .hostPort("hostPort")
 *                                         .jmxurl("jmxurl")
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .logs(List.of(LogProperty.builder()
 *                                         .logType("logType")
 *                                         // the properties below are optional
 *                                         .encoding("encoding")
 *                                         .logGroupName("logGroupName")
 *                                         .logPath("logPath")
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
 *                                         .instanceNumbers(List.of("instanceNumbers"))
 *                                         .sapsid("sapsid")
 *                                         // the properties below are optional
 *                                         .prometheusPort("prometheusPort")
 *                                         .build())
 *                                 .processes(List.of(ProcessProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .processName("processName")
 *                                         .build()))
 *                                 .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
 *                                         .prometheusPort("prometheusPort")
 *                                         .sqlSecretName("sqlSecretName")
 *                                         .build())
 *                                 .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                         .eventLevels(List.of("eventLevels"))
 *                                         .eventName("eventName")
 *                                         .logGroupName("logGroupName")
 *                                         // the properties below are optional
 *                                         .patternSet("patternSet")
 *                                         .build()))
 *                                 .build())
 *                         .subComponentTypeConfigurations(List.of(SubComponentTypeConfigurationProperty.builder()
 *                                 .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
 *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                 .alarmMetricName("alarmMetricName")
 *                                                 .build()))
 *                                         .logs(List.of(LogProperty.builder()
 *                                                 .logType("logType")
 *                                                 // the properties below are optional
 *                                                 .encoding("encoding")
 *                                                 .logGroupName("logGroupName")
 *                                                 .logPath("logPath")
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .processes(List.of(ProcessProperty.builder()
 *                                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
 *                                                         .alarmMetricName("alarmMetricName")
 *                                                         .build()))
 *                                                 .processName("processName")
 *                                                 .build()))
 *                                         .windowsEvents(List.of(WindowsEventProperty.builder()
 *                                                 .eventLevels(List.of("eventLevels"))
 *                                                 .eventName("eventName")
 *                                                 .logGroupName("logGroupName")
 *                                                 // the properties below are optional
 *                                                 .patternSet("patternSet")
 *                                                 .build()))
 *                                         .build())
 *                                 .subComponentType("subComponentType")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .customComponents(List.of(CustomComponentProperty.builder()
 *                 .componentName("componentName")
 *                 .resourceList(List.of("resourceList"))
 *                 .build()))
 *         .cweMonitorEnabled(false)
 *         .groupingType("groupingType")
 *         .logPatternSets(List.of(LogPatternSetProperty.builder()
 *                 .logPatterns(List.of(LogPatternProperty.builder()
 *                         .pattern("pattern")
 *                         .patternName("patternName")
 *                         .rank(123)
 *                         .build()))
 *                 .patternSetName("patternSetName")
 *                 .build()))
 *         .opsCenterEnabled(false)
 *         .opsItemSnsTopicArn("opsItemSnsTopicArn")
 *         .snsNotificationArn("snsNotificationArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:03.136Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.applicationinsights.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationinsights.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the application, such as <code>arn:aws:applicationinsights:us-east-1:123456789012:application/resource-group/my_resource_group</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the resource group used for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceGroupName() {
        return software.amazon.jsii.Kernel.get(this, "resourceGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the resource group used for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceGroupName", java.util.Objects.requireNonNull(value, "resourceGroupName is required"));
    }

    /**
     * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttachMissingPermission() {
        return software.amazon.jsii.Kernel.get(this, "attachMissingPermission", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttachMissingPermission(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "attachMissingPermission", value);
    }

    /**
     * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttachMissingPermission(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attachMissingPermission", value);
    }

    /**
     * If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoConfigurationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "autoConfigurationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoConfigurationEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoConfigurationEnabled", value);
    }

    /**
     * If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoConfigurationEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoConfigurationEnabled", value);
    }

    /**
     * The monitoring settings of the components.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getComponentMonitoringSettings() {
        return software.amazon.jsii.Kernel.get(this, "componentMonitoringSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The monitoring settings of the components.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponentMonitoringSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "componentMonitoringSettings", value);
    }

    /**
     * The monitoring settings of the components.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponentMonitoringSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.applicationinsights.CfnApplication.ComponentMonitoringSettingProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.applicationinsights.CfnApplication.ComponentMonitoringSettingProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "componentMonitoringSettings", value);
    }

    /**
     * Describes a custom component by grouping similar standalone instances to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomComponents() {
        return software.amazon.jsii.Kernel.get(this, "customComponents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes a custom component by grouping similar standalone instances to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomComponents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customComponents", value);
    }

    /**
     * Describes a custom component by grouping similar standalone instances to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomComponents(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.applicationinsights.CfnApplication.CustomComponentProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.applicationinsights.CfnApplication.CustomComponentProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "customComponents", value);
    }

    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCweMonitorEnabled() {
        return software.amazon.jsii.Kernel.get(this, "cweMonitorEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCweMonitorEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "cweMonitorEnabled", value);
    }

    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCweMonitorEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cweMonitorEnabled", value);
    }

    /**
     * Application Insights can create applications based on a resource group or on an account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGroupingType() {
        return software.amazon.jsii.Kernel.get(this, "groupingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Application Insights can create applications based on a resource group or on an account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupingType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupingType", value);
    }

    /**
     * The log pattern sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogPatternSets() {
        return software.amazon.jsii.Kernel.get(this, "logPatternSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The log pattern sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPatternSets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logPatternSets", value);
    }

    /**
     * The log pattern sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPatternSets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.applicationinsights.CfnApplication.LogPatternSetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.applicationinsights.CfnApplication.LogPatternSetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "logPatternSets", value);
    }

    /**
     * Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpsCenterEnabled() {
        return software.amazon.jsii.Kernel.get(this, "opsCenterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpsCenterEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "opsCenterEnabled", value);
    }

    /**
     * Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpsCenterEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "opsCenterEnabled", value);
    }

    /**
     * The SNS topic provided to Application Insights that is associated with the created OpsItems to receive SNS notifications for opsItem updates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOpsItemSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "opsItemSnsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The SNS topic provided to Application Insights that is associated with the created OpsItems to receive SNS notifications for opsItem updates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpsItemSnsTopicArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "opsItemSnsTopicArn", value);
    }

    /**
     * The SNS topic ARN that is associated with SNS notifications for updates or issues.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnsNotificationArn() {
        return software.amazon.jsii.Kernel.get(this, "snsNotificationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The SNS topic ARN that is associated with SNS notifications for updates or issues.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnsNotificationArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snsNotificationArn", value);
    }

    /**
     * An array of <code>Tags</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of <code>Tags</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The <code>AWS::ApplicationInsights::Application AlarmMetric</code> property type defines a metric to monitor for the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * AlarmMetricProperty alarmMetricProperty = AlarmMetricProperty.builder()
     *         .alarmMetricName("alarmMetricName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.AlarmMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric to be monitored for the component.
         * <p>
         * For metrics supported by Application Insights, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/appinsights-logs-and-metrics.html">Logs and metrics supported by Amazon CloudWatch Application Insights</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html#cfn-applicationinsights-application-alarmmetric-alarmmetricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html#cfn-applicationinsights-application-alarmmetric-alarmmetricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmMetricName();

        /**
         * @return a {@link Builder} of {@link AlarmMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmMetricProperty> {
            java.lang.String alarmMetricName;

            /**
             * Sets the value of {@link AlarmMetricProperty#getAlarmMetricName}
             * @param alarmMetricName The name of the metric to be monitored for the component. This parameter is required.
             *                        For metrics supported by Application Insights, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/appinsights-logs-and-metrics.html">Logs and metrics supported by Amazon CloudWatch Application Insights</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmMetricName(java.lang.String alarmMetricName) {
                this.alarmMetricName = alarmMetricName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmMetricProperty {
            private final java.lang.String alarmMetricName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmMetricName = software.amazon.jsii.Kernel.get(this, "alarmMetricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmMetricName = java.util.Objects.requireNonNull(builder.alarmMetricName, "alarmMetricName is required");
            }

            @Override
            public final java.lang.String getAlarmMetricName() {
                return this.alarmMetricName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmMetricName", om.valueToTree(this.getAlarmMetricName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.AlarmMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmMetricProperty.Jsii$Proxy that = (AlarmMetricProperty.Jsii$Proxy) o;

                return this.alarmMetricName.equals(that.alarmMetricName);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmMetricName.hashCode();
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application Alarm</code> property type defines a CloudWatch alarm to be monitored for the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * AlarmProperty alarmProperty = AlarmProperty.builder()
     *         .alarmName("alarmName")
     *         // the properties below are optional
     *         .severity("severity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.AlarmProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch alarm to be monitored for the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-alarmname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

        /**
         * Indicates the degree of outage when the alarm goes off.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-severity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-severity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSeverity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmProperty> {
            java.lang.String alarmName;
            java.lang.String severity;

            /**
             * Sets the value of {@link AlarmProperty#getAlarmName}
             * @param alarmName The name of the CloudWatch alarm to be monitored for the component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmName(java.lang.String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            /**
             * Sets the value of {@link AlarmProperty#getSeverity}
             * @param severity Indicates the degree of outage when the alarm goes off.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severity(java.lang.String severity) {
                this.severity = severity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmProperty {
            private final java.lang.String alarmName;
            private final java.lang.String severity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.severity = software.amazon.jsii.Kernel.get(this, "severity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
                this.severity = builder.severity;
            }

            @Override
            public final java.lang.String getAlarmName() {
                return this.alarmName;
            }

            @Override
            public final java.lang.String getSeverity() {
                return this.severity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmName", om.valueToTree(this.getAlarmName()));
                if (this.getSeverity() != null) {
                    data.set("severity", om.valueToTree(this.getSeverity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.AlarmProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmProperty.Jsii$Proxy that = (AlarmProperty.Jsii$Proxy) o;

                if (!alarmName.equals(that.alarmName)) return false;
                return this.severity != null ? this.severity.equals(that.severity) : that.severity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarmName.hashCode();
                result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application ComponentConfiguration</code> property type defines the configuration settings of the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * ComponentConfigurationProperty componentConfigurationProperty = ComponentConfigurationProperty.builder()
     *         .configurationDetails(ConfigurationDetailsProperty.builder()
     *                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                         .alarmMetricName("alarmMetricName")
     *                         .build()))
     *                 .alarms(List.of(AlarmProperty.builder()
     *                         .alarmName("alarmName")
     *                         // the properties below are optional
     *                         .severity("severity")
     *                         .build()))
     *                 .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
     *                         .prometheusPort("prometheusPort")
     *                         .build())
     *                 .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
     *                         .agreeToInstallHanadbClient(false)
     *                         .hanaPort("hanaPort")
     *                         .hanaSecretName("hanaSecretName")
     *                         .hanasid("hanasid")
     *                         // the properties below are optional
     *                         .prometheusPort("prometheusPort")
     *                         .build())
     *                 .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
     *                         .hostPort("hostPort")
     *                         .jmxurl("jmxurl")
     *                         .prometheusPort("prometheusPort")
     *                         .build())
     *                 .logs(List.of(LogProperty.builder()
     *                         .logType("logType")
     *                         // the properties below are optional
     *                         .encoding("encoding")
     *                         .logGroupName("logGroupName")
     *                         .logPath("logPath")
     *                         .patternSet("patternSet")
     *                         .build()))
     *                 .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
     *                         .instanceNumbers(List.of("instanceNumbers"))
     *                         .sapsid("sapsid")
     *                         // the properties below are optional
     *                         .prometheusPort("prometheusPort")
     *                         .build())
     *                 .processes(List.of(ProcessProperty.builder()
     *                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                 .alarmMetricName("alarmMetricName")
     *                                 .build()))
     *                         .processName("processName")
     *                         .build()))
     *                 .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
     *                         .prometheusPort("prometheusPort")
     *                         .sqlSecretName("sqlSecretName")
     *                         .build())
     *                 .windowsEvents(List.of(WindowsEventProperty.builder()
     *                         .eventLevels(List.of("eventLevels"))
     *                         .eventName("eventName")
     *                         .logGroupName("logGroupName")
     *                         // the properties below are optional
     *                         .patternSet("patternSet")
     *                         .build()))
     *                 .build())
     *         .subComponentTypeConfigurations(List.of(SubComponentTypeConfigurationProperty.builder()
     *                 .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
     *                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                 .alarmMetricName("alarmMetricName")
     *                                 .build()))
     *                         .logs(List.of(LogProperty.builder()
     *                                 .logType("logType")
     *                                 // the properties below are optional
     *                                 .encoding("encoding")
     *                                 .logGroupName("logGroupName")
     *                                 .logPath("logPath")
     *                                 .patternSet("patternSet")
     *                                 .build()))
     *                         .processes(List.of(ProcessProperty.builder()
     *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                         .alarmMetricName("alarmMetricName")
     *                                         .build()))
     *                                 .processName("processName")
     *                                 .build()))
     *                         .windowsEvents(List.of(WindowsEventProperty.builder()
     *                                 .eventLevels(List.of("eventLevels"))
     *                                 .eventName("eventName")
     *                                 .logGroupName("logGroupName")
     *                                 // the properties below are optional
     *                                 .patternSet("patternSet")
     *                                 .build()))
     *                         .build())
     *                 .subComponentType("subComponentType")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.ComponentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-configurationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-configurationdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationDetails() {
            return null;
        }

        /**
         * Sub-component configurations of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-subcomponenttypeconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-subcomponenttypeconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubComponentTypeConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentConfigurationProperty> {
            java.lang.Object configurationDetails;
            java.lang.Object subComponentTypeConfigurations;

            /**
             * Sets the value of {@link ComponentConfigurationProperty#getConfigurationDetails}
             * @param configurationDetails The configuration settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationDetails(software.amazon.awscdk.IResolvable configurationDetails) {
                this.configurationDetails = configurationDetails;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConfigurationProperty#getConfigurationDetails}
             * @param configurationDetails The configuration settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationDetails(software.amazon.awscdk.services.applicationinsights.CfnApplication.ConfigurationDetailsProperty configurationDetails) {
                this.configurationDetails = configurationDetails;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConfigurationProperty#getSubComponentTypeConfigurations}
             * @param subComponentTypeConfigurations Sub-component configurations of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subComponentTypeConfigurations(software.amazon.awscdk.IResolvable subComponentTypeConfigurations) {
                this.subComponentTypeConfigurations = subComponentTypeConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConfigurationProperty#getSubComponentTypeConfigurations}
             * @param subComponentTypeConfigurations Sub-component configurations of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subComponentTypeConfigurations(java.util.List<? extends java.lang.Object> subComponentTypeConfigurations) {
                this.subComponentTypeConfigurations = subComponentTypeConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentConfigurationProperty {
            private final java.lang.Object configurationDetails;
            private final java.lang.Object subComponentTypeConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationDetails = software.amazon.jsii.Kernel.get(this, "configurationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subComponentTypeConfigurations = software.amazon.jsii.Kernel.get(this, "subComponentTypeConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationDetails = builder.configurationDetails;
                this.subComponentTypeConfigurations = builder.subComponentTypeConfigurations;
            }

            @Override
            public final java.lang.Object getConfigurationDetails() {
                return this.configurationDetails;
            }

            @Override
            public final java.lang.Object getSubComponentTypeConfigurations() {
                return this.subComponentTypeConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigurationDetails() != null) {
                    data.set("configurationDetails", om.valueToTree(this.getConfigurationDetails()));
                }
                if (this.getSubComponentTypeConfigurations() != null) {
                    data.set("subComponentTypeConfigurations", om.valueToTree(this.getSubComponentTypeConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.ComponentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentConfigurationProperty.Jsii$Proxy that = (ComponentConfigurationProperty.Jsii$Proxy) o;

                if (this.configurationDetails != null ? !this.configurationDetails.equals(that.configurationDetails) : that.configurationDetails != null) return false;
                return this.subComponentTypeConfigurations != null ? this.subComponentTypeConfigurations.equals(that.subComponentTypeConfigurations) : that.subComponentTypeConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationDetails != null ? this.configurationDetails.hashCode() : 0;
                result = 31 * result + (this.subComponentTypeConfigurations != null ? this.subComponentTypeConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application ComponentMonitoringSetting</code> property type defines the monitoring setting of the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * ComponentMonitoringSettingProperty componentMonitoringSettingProperty = ComponentMonitoringSettingProperty.builder()
     *         .componentConfigurationMode("componentConfigurationMode")
     *         .tier("tier")
     *         // the properties below are optional
     *         .componentArn("componentArn")
     *         .componentName("componentName")
     *         .customComponentConfiguration(ComponentConfigurationProperty.builder()
     *                 .configurationDetails(ConfigurationDetailsProperty.builder()
     *                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                 .alarmMetricName("alarmMetricName")
     *                                 .build()))
     *                         .alarms(List.of(AlarmProperty.builder()
     *                                 .alarmName("alarmName")
     *                                 // the properties below are optional
     *                                 .severity("severity")
     *                                 .build()))
     *                         .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
     *                                 .agreeToInstallHanadbClient(false)
     *                                 .hanaPort("hanaPort")
     *                                 .hanaSecretName("hanaSecretName")
     *                                 .hanasid("hanasid")
     *                                 // the properties below are optional
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
     *                                 .hostPort("hostPort")
     *                                 .jmxurl("jmxurl")
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .logs(List.of(LogProperty.builder()
     *                                 .logType("logType")
     *                                 // the properties below are optional
     *                                 .encoding("encoding")
     *                                 .logGroupName("logGroupName")
     *                                 .logPath("logPath")
     *                                 .patternSet("patternSet")
     *                                 .build()))
     *                         .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
     *                                 .instanceNumbers(List.of("instanceNumbers"))
     *                                 .sapsid("sapsid")
     *                                 // the properties below are optional
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .processes(List.of(ProcessProperty.builder()
     *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                         .alarmMetricName("alarmMetricName")
     *                                         .build()))
     *                                 .processName("processName")
     *                                 .build()))
     *                         .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
     *                                 .prometheusPort("prometheusPort")
     *                                 .sqlSecretName("sqlSecretName")
     *                                 .build())
     *                         .windowsEvents(List.of(WindowsEventProperty.builder()
     *                                 .eventLevels(List.of("eventLevels"))
     *                                 .eventName("eventName")
     *                                 .logGroupName("logGroupName")
     *                                 // the properties below are optional
     *                                 .patternSet("patternSet")
     *                                 .build()))
     *                         .build())
     *                 .subComponentTypeConfigurations(List.of(SubComponentTypeConfigurationProperty.builder()
     *                         .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
     *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                         .alarmMetricName("alarmMetricName")
     *                                         .build()))
     *                                 .logs(List.of(LogProperty.builder()
     *                                         .logType("logType")
     *                                         // the properties below are optional
     *                                         .encoding("encoding")
     *                                         .logGroupName("logGroupName")
     *                                         .logPath("logPath")
     *                                         .patternSet("patternSet")
     *                                         .build()))
     *                                 .processes(List.of(ProcessProperty.builder()
     *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                                 .alarmMetricName("alarmMetricName")
     *                                                 .build()))
     *                                         .processName("processName")
     *                                         .build()))
     *                                 .windowsEvents(List.of(WindowsEventProperty.builder()
     *                                         .eventLevels(List.of("eventLevels"))
     *                                         .eventName("eventName")
     *                                         .logGroupName("logGroupName")
     *                                         // the properties below are optional
     *                                         .patternSet("patternSet")
     *                                         .build()))
     *                                 .build())
     *                         .subComponentType("subComponentType")
     *                         .build()))
     *                 .build())
     *         .defaultOverwriteComponentConfiguration(ComponentConfigurationProperty.builder()
     *                 .configurationDetails(ConfigurationDetailsProperty.builder()
     *                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                 .alarmMetricName("alarmMetricName")
     *                                 .build()))
     *                         .alarms(List.of(AlarmProperty.builder()
     *                                 .alarmName("alarmName")
     *                                 // the properties below are optional
     *                                 .severity("severity")
     *                                 .build()))
     *                         .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
     *                                 .agreeToInstallHanadbClient(false)
     *                                 .hanaPort("hanaPort")
     *                                 .hanaSecretName("hanaSecretName")
     *                                 .hanasid("hanasid")
     *                                 // the properties below are optional
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
     *                                 .hostPort("hostPort")
     *                                 .jmxurl("jmxurl")
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .logs(List.of(LogProperty.builder()
     *                                 .logType("logType")
     *                                 // the properties below are optional
     *                                 .encoding("encoding")
     *                                 .logGroupName("logGroupName")
     *                                 .logPath("logPath")
     *                                 .patternSet("patternSet")
     *                                 .build()))
     *                         .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
     *                                 .instanceNumbers(List.of("instanceNumbers"))
     *                                 .sapsid("sapsid")
     *                                 // the properties below are optional
     *                                 .prometheusPort("prometheusPort")
     *                                 .build())
     *                         .processes(List.of(ProcessProperty.builder()
     *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                         .alarmMetricName("alarmMetricName")
     *                                         .build()))
     *                                 .processName("processName")
     *                                 .build()))
     *                         .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
     *                                 .prometheusPort("prometheusPort")
     *                                 .sqlSecretName("sqlSecretName")
     *                                 .build())
     *                         .windowsEvents(List.of(WindowsEventProperty.builder()
     *                                 .eventLevels(List.of("eventLevels"))
     *                                 .eventName("eventName")
     *                                 .logGroupName("logGroupName")
     *                                 // the properties below are optional
     *                                 .patternSet("patternSet")
     *                                 .build()))
     *                         .build())
     *                 .subComponentTypeConfigurations(List.of(SubComponentTypeConfigurationProperty.builder()
     *                         .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
     *                                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                         .alarmMetricName("alarmMetricName")
     *                                         .build()))
     *                                 .logs(List.of(LogProperty.builder()
     *                                         .logType("logType")
     *                                         // the properties below are optional
     *                                         .encoding("encoding")
     *                                         .logGroupName("logGroupName")
     *                                         .logPath("logPath")
     *                                         .patternSet("patternSet")
     *                                         .build()))
     *                                 .processes(List.of(ProcessProperty.builder()
     *                                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                                 .alarmMetricName("alarmMetricName")
     *                                                 .build()))
     *                                         .processName("processName")
     *                                         .build()))
     *                                 .windowsEvents(List.of(WindowsEventProperty.builder()
     *                                         .eventLevels(List.of("eventLevels"))
     *                                         .eventName("eventName")
     *                                         .logGroupName("logGroupName")
     *                                         // the properties below are optional
     *                                         .patternSet("patternSet")
     *                                         .build()))
     *                                 .build())
     *                         .subComponentType("subComponentType")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.ComponentMonitoringSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentMonitoringSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentMonitoringSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Component monitoring can be configured in one of the following three modes:.
         * <p>
         * <ul>
         * <li><code>DEFAULT</code> : The component will be configured with the recommended default monitoring settings of the selected <code>Tier</code> .</li>
         * <li><code>CUSTOM</code> : The component will be configured with the customized monitoring settings that are specified in <code>CustomComponentConfiguration</code> . If used, <code>CustomComponentConfiguration</code> must be provided.</li>
         * <li><code>DEFAULT_WITH_OVERWRITE</code> : The component will be configured with the recommended default monitoring settings of the selected <code>Tier</code> , and merged with customized overwrite settings that are specified in <code>DefaultOverwriteComponentConfiguration</code> . If used, <code>DefaultOverwriteComponentConfiguration</code> must be provided.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentconfigurationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentconfigurationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComponentConfigurationMode();

        /**
         * The tier of the application component.
         * <p>
         * Supported tiers include <code>DOT_NET_CORE</code> , <code>DOT_NET_WORKER</code> , <code>DOT_NET_WEB</code> , <code>SQL_SERVER</code> , <code>SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP</code> , <code>SQL_SERVER_FAILOVER_CLUSTER_INSTANCE</code> , <code>MYSQL</code> , <code>POSTGRESQL</code> , <code>JAVA_JMX</code> , <code>ORACLE</code> , <code>SAP_HANA_MULTI_NODE</code> , <code>SAP_HANA_SINGLE_NODE</code> , <code>SAP_HANA_HIGH_AVAILABILITY</code> , <code>SHAREPOINT</code> . <code>ACTIVE_DIRECTORY</code> , and <code>DEFAULT</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-tier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTier();

        /**
         * The ARN of the component.
         * <p>
         * Either the component ARN or the component name is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentArn() {
            return null;
        }

        /**
         * The name of the component.
         * <p>
         * Either the component ARN or the component name is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentName() {
            return null;
        }

        /**
         * Customized monitoring settings.
         * <p>
         * Required if CUSTOM mode is configured in <code>ComponentConfigurationMode</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-customcomponentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-customcomponentconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomComponentConfiguration() {
            return null;
        }

        /**
         * Customized overwrite monitoring settings.
         * <p>
         * Required if CUSTOM mode is configured in <code>ComponentConfigurationMode</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-defaultoverwritecomponentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-defaultoverwritecomponentconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultOverwriteComponentConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentMonitoringSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentMonitoringSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentMonitoringSettingProperty> {
            java.lang.String componentConfigurationMode;
            java.lang.String tier;
            java.lang.String componentArn;
            java.lang.String componentName;
            java.lang.Object customComponentConfiguration;
            java.lang.Object defaultOverwriteComponentConfiguration;

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getComponentConfigurationMode}
             * @param componentConfigurationMode Component monitoring can be configured in one of the following three modes:. This parameter is required.
             *                                   <ul>
             *                                   <li><code>DEFAULT</code> : The component will be configured with the recommended default monitoring settings of the selected <code>Tier</code> .</li>
             *                                   <li><code>CUSTOM</code> : The component will be configured with the customized monitoring settings that are specified in <code>CustomComponentConfiguration</code> . If used, <code>CustomComponentConfiguration</code> must be provided.</li>
             *                                   <li><code>DEFAULT_WITH_OVERWRITE</code> : The component will be configured with the recommended default monitoring settings of the selected <code>Tier</code> , and merged with customized overwrite settings that are specified in <code>DefaultOverwriteComponentConfiguration</code> . If used, <code>DefaultOverwriteComponentConfiguration</code> must be provided.</li>
             *                                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentConfigurationMode(java.lang.String componentConfigurationMode) {
                this.componentConfigurationMode = componentConfigurationMode;
                return this;
            }

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getTier}
             * @param tier The tier of the application component. This parameter is required.
             *             Supported tiers include <code>DOT_NET_CORE</code> , <code>DOT_NET_WORKER</code> , <code>DOT_NET_WEB</code> , <code>SQL_SERVER</code> , <code>SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP</code> , <code>SQL_SERVER_FAILOVER_CLUSTER_INSTANCE</code> , <code>MYSQL</code> , <code>POSTGRESQL</code> , <code>JAVA_JMX</code> , <code>ORACLE</code> , <code>SAP_HANA_MULTI_NODE</code> , <code>SAP_HANA_SINGLE_NODE</code> , <code>SAP_HANA_HIGH_AVAILABILITY</code> , <code>SHAREPOINT</code> . <code>ACTIVE_DIRECTORY</code> , and <code>DEFAULT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tier(java.lang.String tier) {
                this.tier = tier;
                return this;
            }

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getComponentArn}
             * @param componentArn The ARN of the component.
             *                     Either the component ARN or the component name is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentArn(java.lang.String componentArn) {
                this.componentArn = componentArn;
                return this;
            }

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getComponentName}
             * @param componentName The name of the component.
             *                      Either the component ARN or the component name is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentName(java.lang.String componentName) {
                this.componentName = componentName;
                return this;
            }

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getCustomComponentConfiguration}
             * @param customComponentConfiguration Customized monitoring settings.
             *                                     Required if CUSTOM mode is configured in <code>ComponentConfigurationMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customComponentConfiguration(software.amazon.awscdk.IResolvable customComponentConfiguration) {
                this.customComponentConfiguration = customComponentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getCustomComponentConfiguration}
             * @param customComponentConfiguration Customized monitoring settings.
             *                                     Required if CUSTOM mode is configured in <code>ComponentConfigurationMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customComponentConfiguration(software.amazon.awscdk.services.applicationinsights.CfnApplication.ComponentConfigurationProperty customComponentConfiguration) {
                this.customComponentConfiguration = customComponentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getDefaultOverwriteComponentConfiguration}
             * @param defaultOverwriteComponentConfiguration Customized overwrite monitoring settings.
             *                                               Required if CUSTOM mode is configured in <code>ComponentConfigurationMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOverwriteComponentConfiguration(software.amazon.awscdk.IResolvable defaultOverwriteComponentConfiguration) {
                this.defaultOverwriteComponentConfiguration = defaultOverwriteComponentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ComponentMonitoringSettingProperty#getDefaultOverwriteComponentConfiguration}
             * @param defaultOverwriteComponentConfiguration Customized overwrite monitoring settings.
             *                                               Required if CUSTOM mode is configured in <code>ComponentConfigurationMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOverwriteComponentConfiguration(software.amazon.awscdk.services.applicationinsights.CfnApplication.ComponentConfigurationProperty defaultOverwriteComponentConfiguration) {
                this.defaultOverwriteComponentConfiguration = defaultOverwriteComponentConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentMonitoringSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentMonitoringSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentMonitoringSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentMonitoringSettingProperty {
            private final java.lang.String componentConfigurationMode;
            private final java.lang.String tier;
            private final java.lang.String componentArn;
            private final java.lang.String componentName;
            private final java.lang.Object customComponentConfiguration;
            private final java.lang.Object defaultOverwriteComponentConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentConfigurationMode = software.amazon.jsii.Kernel.get(this, "componentConfigurationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentArn = software.amazon.jsii.Kernel.get(this, "componentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentName = software.amazon.jsii.Kernel.get(this, "componentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customComponentConfiguration = software.amazon.jsii.Kernel.get(this, "customComponentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultOverwriteComponentConfiguration = software.amazon.jsii.Kernel.get(this, "defaultOverwriteComponentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentConfigurationMode = java.util.Objects.requireNonNull(builder.componentConfigurationMode, "componentConfigurationMode is required");
                this.tier = java.util.Objects.requireNonNull(builder.tier, "tier is required");
                this.componentArn = builder.componentArn;
                this.componentName = builder.componentName;
                this.customComponentConfiguration = builder.customComponentConfiguration;
                this.defaultOverwriteComponentConfiguration = builder.defaultOverwriteComponentConfiguration;
            }

            @Override
            public final java.lang.String getComponentConfigurationMode() {
                return this.componentConfigurationMode;
            }

            @Override
            public final java.lang.String getTier() {
                return this.tier;
            }

            @Override
            public final java.lang.String getComponentArn() {
                return this.componentArn;
            }

            @Override
            public final java.lang.String getComponentName() {
                return this.componentName;
            }

            @Override
            public final java.lang.Object getCustomComponentConfiguration() {
                return this.customComponentConfiguration;
            }

            @Override
            public final java.lang.Object getDefaultOverwriteComponentConfiguration() {
                return this.defaultOverwriteComponentConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("componentConfigurationMode", om.valueToTree(this.getComponentConfigurationMode()));
                data.set("tier", om.valueToTree(this.getTier()));
                if (this.getComponentArn() != null) {
                    data.set("componentArn", om.valueToTree(this.getComponentArn()));
                }
                if (this.getComponentName() != null) {
                    data.set("componentName", om.valueToTree(this.getComponentName()));
                }
                if (this.getCustomComponentConfiguration() != null) {
                    data.set("customComponentConfiguration", om.valueToTree(this.getCustomComponentConfiguration()));
                }
                if (this.getDefaultOverwriteComponentConfiguration() != null) {
                    data.set("defaultOverwriteComponentConfiguration", om.valueToTree(this.getDefaultOverwriteComponentConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.ComponentMonitoringSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentMonitoringSettingProperty.Jsii$Proxy that = (ComponentMonitoringSettingProperty.Jsii$Proxy) o;

                if (!componentConfigurationMode.equals(that.componentConfigurationMode)) return false;
                if (!tier.equals(that.tier)) return false;
                if (this.componentArn != null ? !this.componentArn.equals(that.componentArn) : that.componentArn != null) return false;
                if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) return false;
                if (this.customComponentConfiguration != null ? !this.customComponentConfiguration.equals(that.customComponentConfiguration) : that.customComponentConfiguration != null) return false;
                return this.defaultOverwriteComponentConfiguration != null ? this.defaultOverwriteComponentConfiguration.equals(that.defaultOverwriteComponentConfiguration) : that.defaultOverwriteComponentConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentConfigurationMode.hashCode();
                result = 31 * result + (this.tier.hashCode());
                result = 31 * result + (this.componentArn != null ? this.componentArn.hashCode() : 0);
                result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
                result = 31 * result + (this.customComponentConfiguration != null ? this.customComponentConfiguration.hashCode() : 0);
                result = 31 * result + (this.defaultOverwriteComponentConfiguration != null ? this.defaultOverwriteComponentConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application ConfigurationDetails</code> property type specifies the configuration settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * ConfigurationDetailsProperty configurationDetailsProperty = ConfigurationDetailsProperty.builder()
     *         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                 .alarmMetricName("alarmMetricName")
     *                 .build()))
     *         .alarms(List.of(AlarmProperty.builder()
     *                 .alarmName("alarmName")
     *                 // the properties below are optional
     *                 .severity("severity")
     *                 .build()))
     *         .haClusterPrometheusExporter(HAClusterPrometheusExporterProperty.builder()
     *                 .prometheusPort("prometheusPort")
     *                 .build())
     *         .hanaPrometheusExporter(HANAPrometheusExporterProperty.builder()
     *                 .agreeToInstallHanadbClient(false)
     *                 .hanaPort("hanaPort")
     *                 .hanaSecretName("hanaSecretName")
     *                 .hanasid("hanasid")
     *                 // the properties below are optional
     *                 .prometheusPort("prometheusPort")
     *                 .build())
     *         .jmxPrometheusExporter(JMXPrometheusExporterProperty.builder()
     *                 .hostPort("hostPort")
     *                 .jmxurl("jmxurl")
     *                 .prometheusPort("prometheusPort")
     *                 .build())
     *         .logs(List.of(LogProperty.builder()
     *                 .logType("logType")
     *                 // the properties below are optional
     *                 .encoding("encoding")
     *                 .logGroupName("logGroupName")
     *                 .logPath("logPath")
     *                 .patternSet("patternSet")
     *                 .build()))
     *         .netWeaverPrometheusExporter(NetWeaverPrometheusExporterProperty.builder()
     *                 .instanceNumbers(List.of("instanceNumbers"))
     *                 .sapsid("sapsid")
     *                 // the properties below are optional
     *                 .prometheusPort("prometheusPort")
     *                 .build())
     *         .processes(List.of(ProcessProperty.builder()
     *                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                         .alarmMetricName("alarmMetricName")
     *                         .build()))
     *                 .processName("processName")
     *                 .build()))
     *         .sqlServerPrometheusExporter(SQLServerPrometheusExporterProperty.builder()
     *                 .prometheusPort("prometheusPort")
     *                 .sqlSecretName("sqlSecretName")
     *                 .build())
     *         .windowsEvents(List.of(WindowsEventProperty.builder()
     *                 .eventLevels(List.of("eventLevels"))
     *                 .eventName("eventName")
     *                 .logGroupName("logGroupName")
     *                 // the properties below are optional
     *                 .patternSet("patternSet")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.ConfigurationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of metrics to monitor for the component.
         * <p>
         * All component types can use <code>AlarmMetrics</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarmmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarmmetrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlarmMetrics() {
            return null;
        }

        /**
         * A list of alarms to monitor for the component.
         * <p>
         * All component types can use <code>Alarm</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlarms() {
            return null;
        }

        /**
         * The HA cluster Prometheus Exporter settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-haclusterprometheusexporter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-haclusterprometheusexporter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHaClusterPrometheusExporter() {
            return null;
        }

        /**
         * The HANA DB Prometheus Exporter settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-hanaprometheusexporter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-hanaprometheusexporter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHanaPrometheusExporter() {
            return null;
        }

        /**
         * A list of Java metrics to monitor for the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-jmxprometheusexporter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-jmxprometheusexporter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJmxPrometheusExporter() {
            return null;
        }

        /**
         * A list of logs to monitor for the component.
         * <p>
         * Only Amazon EC2 instances can use <code>Logs</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-logs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-logs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogs() {
            return null;
        }

        /**
         * The NetWeaver Prometheus Exporter Settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-netweaverprometheusexporter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-netweaverprometheusexporter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetWeaverPrometheusExporter() {
            return null;
        }

        /**
         * A list of processes to monitor for the component.
         * <p>
         * Only Windows EC2 instances can have a processes section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-processes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-processes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcesses() {
            return null;
        }

        /**
         * The SQL prometheus exporter settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-sqlserverprometheusexporter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-sqlserverprometheusexporter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqlServerPrometheusExporter() {
            return null;
        }

        /**
         * A list of Windows Events to monitor for the component.
         * <p>
         * Only Amazon EC2 instances running on Windows can use <code>WindowsEvents</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-windowsevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-windowsevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWindowsEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationDetailsProperty> {
            java.lang.Object alarmMetrics;
            java.lang.Object alarms;
            java.lang.Object haClusterPrometheusExporter;
            java.lang.Object hanaPrometheusExporter;
            java.lang.Object jmxPrometheusExporter;
            java.lang.Object logs;
            java.lang.Object netWeaverPrometheusExporter;
            java.lang.Object processes;
            java.lang.Object sqlServerPrometheusExporter;
            java.lang.Object windowsEvents;

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getAlarmMetrics}
             * @param alarmMetrics A list of metrics to monitor for the component.
             *                     All component types can use <code>AlarmMetrics</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmMetrics(software.amazon.awscdk.IResolvable alarmMetrics) {
                this.alarmMetrics = alarmMetrics;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getAlarmMetrics}
             * @param alarmMetrics A list of metrics to monitor for the component.
             *                     All component types can use <code>AlarmMetrics</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmMetrics(java.util.List<? extends java.lang.Object> alarmMetrics) {
                this.alarmMetrics = alarmMetrics;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getAlarms}
             * @param alarms A list of alarms to monitor for the component.
             *               All component types can use <code>Alarm</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(software.amazon.awscdk.IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getAlarms}
             * @param alarms A list of alarms to monitor for the component.
             *               All component types can use <code>Alarm</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(java.util.List<? extends java.lang.Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getHaClusterPrometheusExporter}
             * @param haClusterPrometheusExporter The HA cluster Prometheus Exporter settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder haClusterPrometheusExporter(software.amazon.awscdk.IResolvable haClusterPrometheusExporter) {
                this.haClusterPrometheusExporter = haClusterPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getHaClusterPrometheusExporter}
             * @param haClusterPrometheusExporter The HA cluster Prometheus Exporter settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder haClusterPrometheusExporter(software.amazon.awscdk.services.applicationinsights.CfnApplication.HAClusterPrometheusExporterProperty haClusterPrometheusExporter) {
                this.haClusterPrometheusExporter = haClusterPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getHanaPrometheusExporter}
             * @param hanaPrometheusExporter The HANA DB Prometheus Exporter settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hanaPrometheusExporter(software.amazon.awscdk.IResolvable hanaPrometheusExporter) {
                this.hanaPrometheusExporter = hanaPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getHanaPrometheusExporter}
             * @param hanaPrometheusExporter The HANA DB Prometheus Exporter settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hanaPrometheusExporter(software.amazon.awscdk.services.applicationinsights.CfnApplication.HANAPrometheusExporterProperty hanaPrometheusExporter) {
                this.hanaPrometheusExporter = hanaPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getJmxPrometheusExporter}
             * @param jmxPrometheusExporter A list of Java metrics to monitor for the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jmxPrometheusExporter(software.amazon.awscdk.IResolvable jmxPrometheusExporter) {
                this.jmxPrometheusExporter = jmxPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getJmxPrometheusExporter}
             * @param jmxPrometheusExporter A list of Java metrics to monitor for the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jmxPrometheusExporter(software.amazon.awscdk.services.applicationinsights.CfnApplication.JMXPrometheusExporterProperty jmxPrometheusExporter) {
                this.jmxPrometheusExporter = jmxPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getLogs}
             * @param logs A list of logs to monitor for the component.
             *             Only Amazon EC2 instances can use <code>Logs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logs(software.amazon.awscdk.IResolvable logs) {
                this.logs = logs;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getLogs}
             * @param logs A list of logs to monitor for the component.
             *             Only Amazon EC2 instances can use <code>Logs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logs(java.util.List<? extends java.lang.Object> logs) {
                this.logs = logs;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getNetWeaverPrometheusExporter}
             * @param netWeaverPrometheusExporter The NetWeaver Prometheus Exporter Settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder netWeaverPrometheusExporter(software.amazon.awscdk.IResolvable netWeaverPrometheusExporter) {
                this.netWeaverPrometheusExporter = netWeaverPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getNetWeaverPrometheusExporter}
             * @param netWeaverPrometheusExporter The NetWeaver Prometheus Exporter Settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder netWeaverPrometheusExporter(software.amazon.awscdk.services.applicationinsights.CfnApplication.NetWeaverPrometheusExporterProperty netWeaverPrometheusExporter) {
                this.netWeaverPrometheusExporter = netWeaverPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getProcesses}
             * @param processes A list of processes to monitor for the component.
             *                  Only Windows EC2 instances can have a processes section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processes(software.amazon.awscdk.IResolvable processes) {
                this.processes = processes;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getProcesses}
             * @param processes A list of processes to monitor for the component.
             *                  Only Windows EC2 instances can have a processes section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processes(java.util.List<? extends java.lang.Object> processes) {
                this.processes = processes;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getSqlServerPrometheusExporter}
             * @param sqlServerPrometheusExporter The SQL prometheus exporter settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlServerPrometheusExporter(software.amazon.awscdk.IResolvable sqlServerPrometheusExporter) {
                this.sqlServerPrometheusExporter = sqlServerPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getSqlServerPrometheusExporter}
             * @param sqlServerPrometheusExporter The SQL prometheus exporter settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlServerPrometheusExporter(software.amazon.awscdk.services.applicationinsights.CfnApplication.SQLServerPrometheusExporterProperty sqlServerPrometheusExporter) {
                this.sqlServerPrometheusExporter = sqlServerPrometheusExporter;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getWindowsEvents}
             * @param windowsEvents A list of Windows Events to monitor for the component.
             *                      Only Amazon EC2 instances running on Windows can use <code>WindowsEvents</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windowsEvents(software.amazon.awscdk.IResolvable windowsEvents) {
                this.windowsEvents = windowsEvents;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDetailsProperty#getWindowsEvents}
             * @param windowsEvents A list of Windows Events to monitor for the component.
             *                      Only Amazon EC2 instances running on Windows can use <code>WindowsEvents</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windowsEvents(java.util.List<? extends java.lang.Object> windowsEvents) {
                this.windowsEvents = windowsEvents;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationDetailsProperty {
            private final java.lang.Object alarmMetrics;
            private final java.lang.Object alarms;
            private final java.lang.Object haClusterPrometheusExporter;
            private final java.lang.Object hanaPrometheusExporter;
            private final java.lang.Object jmxPrometheusExporter;
            private final java.lang.Object logs;
            private final java.lang.Object netWeaverPrometheusExporter;
            private final java.lang.Object processes;
            private final java.lang.Object sqlServerPrometheusExporter;
            private final java.lang.Object windowsEvents;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmMetrics = software.amazon.jsii.Kernel.get(this, "alarmMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.haClusterPrometheusExporter = software.amazon.jsii.Kernel.get(this, "haClusterPrometheusExporter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hanaPrometheusExporter = software.amazon.jsii.Kernel.get(this, "hanaPrometheusExporter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jmxPrometheusExporter = software.amazon.jsii.Kernel.get(this, "jmxPrometheusExporter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logs = software.amazon.jsii.Kernel.get(this, "logs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.netWeaverPrometheusExporter = software.amazon.jsii.Kernel.get(this, "netWeaverPrometheusExporter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processes = software.amazon.jsii.Kernel.get(this, "processes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqlServerPrometheusExporter = software.amazon.jsii.Kernel.get(this, "sqlServerPrometheusExporter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.windowsEvents = software.amazon.jsii.Kernel.get(this, "windowsEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmMetrics = builder.alarmMetrics;
                this.alarms = builder.alarms;
                this.haClusterPrometheusExporter = builder.haClusterPrometheusExporter;
                this.hanaPrometheusExporter = builder.hanaPrometheusExporter;
                this.jmxPrometheusExporter = builder.jmxPrometheusExporter;
                this.logs = builder.logs;
                this.netWeaverPrometheusExporter = builder.netWeaverPrometheusExporter;
                this.processes = builder.processes;
                this.sqlServerPrometheusExporter = builder.sqlServerPrometheusExporter;
                this.windowsEvents = builder.windowsEvents;
            }

            @Override
            public final java.lang.Object getAlarmMetrics() {
                return this.alarmMetrics;
            }

            @Override
            public final java.lang.Object getAlarms() {
                return this.alarms;
            }

            @Override
            public final java.lang.Object getHaClusterPrometheusExporter() {
                return this.haClusterPrometheusExporter;
            }

            @Override
            public final java.lang.Object getHanaPrometheusExporter() {
                return this.hanaPrometheusExporter;
            }

            @Override
            public final java.lang.Object getJmxPrometheusExporter() {
                return this.jmxPrometheusExporter;
            }

            @Override
            public final java.lang.Object getLogs() {
                return this.logs;
            }

            @Override
            public final java.lang.Object getNetWeaverPrometheusExporter() {
                return this.netWeaverPrometheusExporter;
            }

            @Override
            public final java.lang.Object getProcesses() {
                return this.processes;
            }

            @Override
            public final java.lang.Object getSqlServerPrometheusExporter() {
                return this.sqlServerPrometheusExporter;
            }

            @Override
            public final java.lang.Object getWindowsEvents() {
                return this.windowsEvents;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlarmMetrics() != null) {
                    data.set("alarmMetrics", om.valueToTree(this.getAlarmMetrics()));
                }
                if (this.getAlarms() != null) {
                    data.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getHaClusterPrometheusExporter() != null) {
                    data.set("haClusterPrometheusExporter", om.valueToTree(this.getHaClusterPrometheusExporter()));
                }
                if (this.getHanaPrometheusExporter() != null) {
                    data.set("hanaPrometheusExporter", om.valueToTree(this.getHanaPrometheusExporter()));
                }
                if (this.getJmxPrometheusExporter() != null) {
                    data.set("jmxPrometheusExporter", om.valueToTree(this.getJmxPrometheusExporter()));
                }
                if (this.getLogs() != null) {
                    data.set("logs", om.valueToTree(this.getLogs()));
                }
                if (this.getNetWeaverPrometheusExporter() != null) {
                    data.set("netWeaverPrometheusExporter", om.valueToTree(this.getNetWeaverPrometheusExporter()));
                }
                if (this.getProcesses() != null) {
                    data.set("processes", om.valueToTree(this.getProcesses()));
                }
                if (this.getSqlServerPrometheusExporter() != null) {
                    data.set("sqlServerPrometheusExporter", om.valueToTree(this.getSqlServerPrometheusExporter()));
                }
                if (this.getWindowsEvents() != null) {
                    data.set("windowsEvents", om.valueToTree(this.getWindowsEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.ConfigurationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationDetailsProperty.Jsii$Proxy that = (ConfigurationDetailsProperty.Jsii$Proxy) o;

                if (this.alarmMetrics != null ? !this.alarmMetrics.equals(that.alarmMetrics) : that.alarmMetrics != null) return false;
                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                if (this.haClusterPrometheusExporter != null ? !this.haClusterPrometheusExporter.equals(that.haClusterPrometheusExporter) : that.haClusterPrometheusExporter != null) return false;
                if (this.hanaPrometheusExporter != null ? !this.hanaPrometheusExporter.equals(that.hanaPrometheusExporter) : that.hanaPrometheusExporter != null) return false;
                if (this.jmxPrometheusExporter != null ? !this.jmxPrometheusExporter.equals(that.jmxPrometheusExporter) : that.jmxPrometheusExporter != null) return false;
                if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) return false;
                if (this.netWeaverPrometheusExporter != null ? !this.netWeaverPrometheusExporter.equals(that.netWeaverPrometheusExporter) : that.netWeaverPrometheusExporter != null) return false;
                if (this.processes != null ? !this.processes.equals(that.processes) : that.processes != null) return false;
                if (this.sqlServerPrometheusExporter != null ? !this.sqlServerPrometheusExporter.equals(that.sqlServerPrometheusExporter) : that.sqlServerPrometheusExporter != null) return false;
                return this.windowsEvents != null ? this.windowsEvents.equals(that.windowsEvents) : that.windowsEvents == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarmMetrics != null ? this.alarmMetrics.hashCode() : 0;
                result = 31 * result + (this.alarms != null ? this.alarms.hashCode() : 0);
                result = 31 * result + (this.haClusterPrometheusExporter != null ? this.haClusterPrometheusExporter.hashCode() : 0);
                result = 31 * result + (this.hanaPrometheusExporter != null ? this.hanaPrometheusExporter.hashCode() : 0);
                result = 31 * result + (this.jmxPrometheusExporter != null ? this.jmxPrometheusExporter.hashCode() : 0);
                result = 31 * result + (this.logs != null ? this.logs.hashCode() : 0);
                result = 31 * result + (this.netWeaverPrometheusExporter != null ? this.netWeaverPrometheusExporter.hashCode() : 0);
                result = 31 * result + (this.processes != null ? this.processes.hashCode() : 0);
                result = 31 * result + (this.sqlServerPrometheusExporter != null ? this.sqlServerPrometheusExporter.hashCode() : 0);
                result = 31 * result + (this.windowsEvents != null ? this.windowsEvents.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application CustomComponent</code> property type describes a custom component by grouping similar standalone instances to monitor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * CustomComponentProperty customComponentProperty = CustomComponentProperty.builder()
     *         .componentName("componentName")
     *         .resourceList(List.of("resourceList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.CustomComponentProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomComponentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomComponentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-componentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-componentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComponentName();

        /**
         * The list of resource ARNs that belong to the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-resourcelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-resourcelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceList();

        /**
         * @return a {@link Builder} of {@link CustomComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomComponentProperty> {
            java.lang.String componentName;
            java.util.List<java.lang.String> resourceList;

            /**
             * Sets the value of {@link CustomComponentProperty#getComponentName}
             * @param componentName The name of the component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentName(java.lang.String componentName) {
                this.componentName = componentName;
                return this;
            }

            /**
             * Sets the value of {@link CustomComponentProperty#getResourceList}
             * @param resourceList The list of resource ARNs that belong to the component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceList(java.util.List<java.lang.String> resourceList) {
                this.resourceList = resourceList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomComponentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomComponentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomComponentProperty {
            private final java.lang.String componentName;
            private final java.util.List<java.lang.String> resourceList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentName = software.amazon.jsii.Kernel.get(this, "componentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceList = software.amazon.jsii.Kernel.get(this, "resourceList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentName = java.util.Objects.requireNonNull(builder.componentName, "componentName is required");
                this.resourceList = java.util.Objects.requireNonNull(builder.resourceList, "resourceList is required");
            }

            @Override
            public final java.lang.String getComponentName() {
                return this.componentName;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceList() {
                return this.resourceList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("componentName", om.valueToTree(this.getComponentName()));
                data.set("resourceList", om.valueToTree(this.getResourceList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.CustomComponentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomComponentProperty.Jsii$Proxy that = (CustomComponentProperty.Jsii$Proxy) o;

                if (!componentName.equals(that.componentName)) return false;
                return this.resourceList.equals(that.resourceList);
            }

            @Override
            public final int hashCode() {
                int result = this.componentName.hashCode();
                result = 31 * result + (this.resourceList.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application HAClusterPrometheusExporter</code> property type defines the HA cluster Prometheus Exporter settings.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config-sections.html#component-configuration-prometheus">component configuration</a> in the CloudWatch Application Insights documentation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * HAClusterPrometheusExporterProperty hAClusterPrometheusExporterProperty = HAClusterPrometheusExporterProperty.builder()
     *         .prometheusPort("prometheusPort")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-haclusterprometheusexporter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-haclusterprometheusexporter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.HAClusterPrometheusExporterProperty")
    @software.amazon.jsii.Jsii.Proxy(HAClusterPrometheusExporterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HAClusterPrometheusExporterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target port to which Prometheus sends metrics.
         * <p>
         * If not specified, the default port 9668 is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-haclusterprometheusexporter.html#cfn-applicationinsights-application-haclusterprometheusexporter-prometheusport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-haclusterprometheusexporter.html#cfn-applicationinsights-application-haclusterprometheusexporter-prometheusport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrometheusPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HAClusterPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HAClusterPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HAClusterPrometheusExporterProperty> {
            java.lang.String prometheusPort;

            /**
             * Sets the value of {@link HAClusterPrometheusExporterProperty#getPrometheusPort}
             * @param prometheusPort The target port to which Prometheus sends metrics.
             *                       If not specified, the default port 9668 is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheusPort(java.lang.String prometheusPort) {
                this.prometheusPort = prometheusPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HAClusterPrometheusExporterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HAClusterPrometheusExporterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HAClusterPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HAClusterPrometheusExporterProperty {
            private final java.lang.String prometheusPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prometheusPort = software.amazon.jsii.Kernel.get(this, "prometheusPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prometheusPort = builder.prometheusPort;
            }

            @Override
            public final java.lang.String getPrometheusPort() {
                return this.prometheusPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrometheusPort() != null) {
                    data.set("prometheusPort", om.valueToTree(this.getPrometheusPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.HAClusterPrometheusExporterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HAClusterPrometheusExporterProperty.Jsii$Proxy that = (HAClusterPrometheusExporterProperty.Jsii$Proxy) o;

                return this.prometheusPort != null ? this.prometheusPort.equals(that.prometheusPort) : that.prometheusPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prometheusPort != null ? this.prometheusPort.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application HANAPrometheusExporter</code> property type defines the HANA DB Prometheus Exporter settings.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config-sections.html#component-configuration-prometheus">component configuration</a> in the CloudWatch Application Insights documentation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * HANAPrometheusExporterProperty hANAPrometheusExporterProperty = HANAPrometheusExporterProperty.builder()
     *         .agreeToInstallHanadbClient(false)
     *         .hanaPort("hanaPort")
     *         .hanaSecretName("hanaSecretName")
     *         .hanasid("hanasid")
     *         // the properties below are optional
     *         .prometheusPort("prometheusPort")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.HANAPrometheusExporterProperty")
    @software.amazon.jsii.Jsii.Proxy(HANAPrometheusExporterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HANAPrometheusExporterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Designates whether you agree to install the HANA DB client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-agreetoinstallhanadbclient">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-agreetoinstallhanadbclient</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAgreeToInstallHanadbClient();

        /**
         * The HANA database port by which the exporter will query HANA metrics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-hanaport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-hanaport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHanaPort();

        /**
         * The AWS Secrets Manager secret that stores HANA monitoring user credentials.
         * <p>
         * The HANA Prometheus exporter uses these credentials to connect to the database and query HANA metrics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-hanasecretname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-hanasecretname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHanaSecretName();

        /**
         * The three-character SAP system ID (SID) of the SAP HANA system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-hanasid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-hanasid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHanasid();

        /**
         * The target port to which Prometheus sends metrics.
         * <p>
         * If not specified, the default port 9668 is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-prometheusport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-hanaprometheusexporter.html#cfn-applicationinsights-application-hanaprometheusexporter-prometheusport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrometheusPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HANAPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HANAPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HANAPrometheusExporterProperty> {
            java.lang.Object agreeToInstallHanadbClient;
            java.lang.String hanaPort;
            java.lang.String hanaSecretName;
            java.lang.String hanasid;
            java.lang.String prometheusPort;

            /**
             * Sets the value of {@link HANAPrometheusExporterProperty#getAgreeToInstallHanadbClient}
             * @param agreeToInstallHanadbClient Designates whether you agree to install the HANA DB client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agreeToInstallHanadbClient(java.lang.Boolean agreeToInstallHanadbClient) {
                this.agreeToInstallHanadbClient = agreeToInstallHanadbClient;
                return this;
            }

            /**
             * Sets the value of {@link HANAPrometheusExporterProperty#getAgreeToInstallHanadbClient}
             * @param agreeToInstallHanadbClient Designates whether you agree to install the HANA DB client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agreeToInstallHanadbClient(software.amazon.awscdk.IResolvable agreeToInstallHanadbClient) {
                this.agreeToInstallHanadbClient = agreeToInstallHanadbClient;
                return this;
            }

            /**
             * Sets the value of {@link HANAPrometheusExporterProperty#getHanaPort}
             * @param hanaPort The HANA database port by which the exporter will query HANA metrics. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hanaPort(java.lang.String hanaPort) {
                this.hanaPort = hanaPort;
                return this;
            }

            /**
             * Sets the value of {@link HANAPrometheusExporterProperty#getHanaSecretName}
             * @param hanaSecretName The AWS Secrets Manager secret that stores HANA monitoring user credentials. This parameter is required.
             *                       The HANA Prometheus exporter uses these credentials to connect to the database and query HANA metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hanaSecretName(java.lang.String hanaSecretName) {
                this.hanaSecretName = hanaSecretName;
                return this;
            }

            /**
             * Sets the value of {@link HANAPrometheusExporterProperty#getHanasid}
             * @param hanasid The three-character SAP system ID (SID) of the SAP HANA system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hanasid(java.lang.String hanasid) {
                this.hanasid = hanasid;
                return this;
            }

            /**
             * Sets the value of {@link HANAPrometheusExporterProperty#getPrometheusPort}
             * @param prometheusPort The target port to which Prometheus sends metrics.
             *                       If not specified, the default port 9668 is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheusPort(java.lang.String prometheusPort) {
                this.prometheusPort = prometheusPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HANAPrometheusExporterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HANAPrometheusExporterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HANAPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HANAPrometheusExporterProperty {
            private final java.lang.Object agreeToInstallHanadbClient;
            private final java.lang.String hanaPort;
            private final java.lang.String hanaSecretName;
            private final java.lang.String hanasid;
            private final java.lang.String prometheusPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agreeToInstallHanadbClient = software.amazon.jsii.Kernel.get(this, "agreeToInstallHanadbClient", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hanaPort = software.amazon.jsii.Kernel.get(this, "hanaPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hanaSecretName = software.amazon.jsii.Kernel.get(this, "hanaSecretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hanasid = software.amazon.jsii.Kernel.get(this, "hanasid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prometheusPort = software.amazon.jsii.Kernel.get(this, "prometheusPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agreeToInstallHanadbClient = java.util.Objects.requireNonNull(builder.agreeToInstallHanadbClient, "agreeToInstallHanadbClient is required");
                this.hanaPort = java.util.Objects.requireNonNull(builder.hanaPort, "hanaPort is required");
                this.hanaSecretName = java.util.Objects.requireNonNull(builder.hanaSecretName, "hanaSecretName is required");
                this.hanasid = java.util.Objects.requireNonNull(builder.hanasid, "hanasid is required");
                this.prometheusPort = builder.prometheusPort;
            }

            @Override
            public final java.lang.Object getAgreeToInstallHanadbClient() {
                return this.agreeToInstallHanadbClient;
            }

            @Override
            public final java.lang.String getHanaPort() {
                return this.hanaPort;
            }

            @Override
            public final java.lang.String getHanaSecretName() {
                return this.hanaSecretName;
            }

            @Override
            public final java.lang.String getHanasid() {
                return this.hanasid;
            }

            @Override
            public final java.lang.String getPrometheusPort() {
                return this.prometheusPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("agreeToInstallHanadbClient", om.valueToTree(this.getAgreeToInstallHanadbClient()));
                data.set("hanaPort", om.valueToTree(this.getHanaPort()));
                data.set("hanaSecretName", om.valueToTree(this.getHanaSecretName()));
                data.set("hanasid", om.valueToTree(this.getHanasid()));
                if (this.getPrometheusPort() != null) {
                    data.set("prometheusPort", om.valueToTree(this.getPrometheusPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.HANAPrometheusExporterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HANAPrometheusExporterProperty.Jsii$Proxy that = (HANAPrometheusExporterProperty.Jsii$Proxy) o;

                if (!agreeToInstallHanadbClient.equals(that.agreeToInstallHanadbClient)) return false;
                if (!hanaPort.equals(that.hanaPort)) return false;
                if (!hanaSecretName.equals(that.hanaSecretName)) return false;
                if (!hanasid.equals(that.hanasid)) return false;
                return this.prometheusPort != null ? this.prometheusPort.equals(that.prometheusPort) : that.prometheusPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agreeToInstallHanadbClient.hashCode();
                result = 31 * result + (this.hanaPort.hashCode());
                result = 31 * result + (this.hanaSecretName.hashCode());
                result = 31 * result + (this.hanasid.hashCode());
                result = 31 * result + (this.prometheusPort != null ? this.prometheusPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application JMXPrometheusExporter</code> property type defines the JMXPrometheus Exporter configuration.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config-sections.html#component-configuration-prometheus">component configuration</a> in the CloudWatch Application Insights documentation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * JMXPrometheusExporterProperty jMXPrometheusExporterProperty = JMXPrometheusExporterProperty.builder()
     *         .hostPort("hostPort")
     *         .jmxurl("jmxurl")
     *         .prometheusPort("prometheusPort")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.JMXPrometheusExporterProperty")
    @software.amazon.jsii.Jsii.Proxy(JMXPrometheusExporterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JMXPrometheusExporterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host and port to connect to through remote JMX.
         * <p>
         * Only one of <code>jmxURL</code> and <code>hostPort</code> can be specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-hostport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-hostport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostPort() {
            return null;
        }

        /**
         * The complete JMX URL to connect to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-jmxurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-jmxurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJmxurl() {
            return null;
        }

        /**
         * The target port to send Prometheus metrics to.
         * <p>
         * If not specified, the default port <code>9404</code> is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-prometheusport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-jmxprometheusexporter.html#cfn-applicationinsights-application-jmxprometheusexporter-prometheusport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrometheusPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JMXPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JMXPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JMXPrometheusExporterProperty> {
            java.lang.String hostPort;
            java.lang.String jmxurl;
            java.lang.String prometheusPort;

            /**
             * Sets the value of {@link JMXPrometheusExporterProperty#getHostPort}
             * @param hostPort The host and port to connect to through remote JMX.
             *                 Only one of <code>jmxURL</code> and <code>hostPort</code> can be specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPort(java.lang.String hostPort) {
                this.hostPort = hostPort;
                return this;
            }

            /**
             * Sets the value of {@link JMXPrometheusExporterProperty#getJmxurl}
             * @param jmxurl The complete JMX URL to connect to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jmxurl(java.lang.String jmxurl) {
                this.jmxurl = jmxurl;
                return this;
            }

            /**
             * Sets the value of {@link JMXPrometheusExporterProperty#getPrometheusPort}
             * @param prometheusPort The target port to send Prometheus metrics to.
             *                       If not specified, the default port <code>9404</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheusPort(java.lang.String prometheusPort) {
                this.prometheusPort = prometheusPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JMXPrometheusExporterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JMXPrometheusExporterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JMXPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JMXPrometheusExporterProperty {
            private final java.lang.String hostPort;
            private final java.lang.String jmxurl;
            private final java.lang.String prometheusPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostPort = software.amazon.jsii.Kernel.get(this, "hostPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jmxurl = software.amazon.jsii.Kernel.get(this, "jmxurl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prometheusPort = software.amazon.jsii.Kernel.get(this, "prometheusPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostPort = builder.hostPort;
                this.jmxurl = builder.jmxurl;
                this.prometheusPort = builder.prometheusPort;
            }

            @Override
            public final java.lang.String getHostPort() {
                return this.hostPort;
            }

            @Override
            public final java.lang.String getJmxurl() {
                return this.jmxurl;
            }

            @Override
            public final java.lang.String getPrometheusPort() {
                return this.prometheusPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHostPort() != null) {
                    data.set("hostPort", om.valueToTree(this.getHostPort()));
                }
                if (this.getJmxurl() != null) {
                    data.set("jmxurl", om.valueToTree(this.getJmxurl()));
                }
                if (this.getPrometheusPort() != null) {
                    data.set("prometheusPort", om.valueToTree(this.getPrometheusPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.JMXPrometheusExporterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JMXPrometheusExporterProperty.Jsii$Proxy that = (JMXPrometheusExporterProperty.Jsii$Proxy) o;

                if (this.hostPort != null ? !this.hostPort.equals(that.hostPort) : that.hostPort != null) return false;
                if (this.jmxurl != null ? !this.jmxurl.equals(that.jmxurl) : that.jmxurl != null) return false;
                return this.prometheusPort != null ? this.prometheusPort.equals(that.prometheusPort) : that.prometheusPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostPort != null ? this.hostPort.hashCode() : 0;
                result = 31 * result + (this.jmxurl != null ? this.jmxurl.hashCode() : 0);
                result = 31 * result + (this.prometheusPort != null ? this.prometheusPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application LogPattern</code> property type specifies an object that defines the log patterns that belong to a <code>LogPatternSet</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * LogPatternProperty logPatternProperty = LogPatternProperty.builder()
     *         .pattern("pattern")
     *         .patternName("patternName")
     *         .rank(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.LogPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(LogPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A regular expression that defines the log pattern.
         * <p>
         * A log pattern can contain up to 50 characters, and it cannot be empty.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-pattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPattern();

        /**
         * The name of the log pattern.
         * <p>
         * A log pattern name can contain up to 50 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-patternname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-patternname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPatternName();

        /**
         * The rank of the log pattern.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-rank">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-rank</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRank();

        /**
         * @return a {@link Builder} of {@link LogPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogPatternProperty> {
            java.lang.String pattern;
            java.lang.String patternName;
            java.lang.Number rank;

            /**
             * Sets the value of {@link LogPatternProperty#getPattern}
             * @param pattern A regular expression that defines the log pattern. This parameter is required.
             *                A log pattern can contain up to 50 characters, and it cannot be empty.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link LogPatternProperty#getPatternName}
             * @param patternName The name of the log pattern. This parameter is required.
             *                    A log pattern name can contain up to 50 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternName(java.lang.String patternName) {
                this.patternName = patternName;
                return this;
            }

            /**
             * Sets the value of {@link LogPatternProperty#getRank}
             * @param rank The rank of the log pattern. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rank(java.lang.Number rank) {
                this.rank = rank;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogPatternProperty {
            private final java.lang.String pattern;
            private final java.lang.String patternName;
            private final java.lang.Number rank;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternName = software.amazon.jsii.Kernel.get(this, "patternName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rank = software.amazon.jsii.Kernel.get(this, "rank", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.patternName = java.util.Objects.requireNonNull(builder.patternName, "patternName is required");
                this.rank = java.util.Objects.requireNonNull(builder.rank, "rank is required");
            }

            @Override
            public final java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getPatternName() {
                return this.patternName;
            }

            @Override
            public final java.lang.Number getRank() {
                return this.rank;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                data.set("patternName", om.valueToTree(this.getPatternName()));
                data.set("rank", om.valueToTree(this.getRank()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.LogPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogPatternProperty.Jsii$Proxy that = (LogPatternProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (!patternName.equals(that.patternName)) return false;
                return this.rank.equals(that.rank);
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.patternName.hashCode());
                result = 31 * result + (this.rank.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application LogPatternSet</code> property type specifies the log pattern set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * LogPatternSetProperty logPatternSetProperty = LogPatternSetProperty.builder()
     *         .logPatterns(List.of(LogPatternProperty.builder()
     *                 .pattern("pattern")
     *                 .patternName("patternName")
     *                 .rank(123)
     *                 .build()))
     *         .patternSetName("patternSetName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.LogPatternSetProperty")
    @software.amazon.jsii.Jsii.Proxy(LogPatternSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogPatternSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of objects that define the log patterns that belong to <code>LogPatternSet</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-logpatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-logpatterns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLogPatterns();

        /**
         * The name of the log pattern.
         * <p>
         * A log pattern name can contain up to 30 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-patternsetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-patternsetname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPatternSetName();

        /**
         * @return a {@link Builder} of {@link LogPatternSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogPatternSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogPatternSetProperty> {
            java.lang.Object logPatterns;
            java.lang.String patternSetName;

            /**
             * Sets the value of {@link LogPatternSetProperty#getLogPatterns}
             * @param logPatterns A list of objects that define the log patterns that belong to <code>LogPatternSet</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPatterns(software.amazon.awscdk.IResolvable logPatterns) {
                this.logPatterns = logPatterns;
                return this;
            }

            /**
             * Sets the value of {@link LogPatternSetProperty#getLogPatterns}
             * @param logPatterns A list of objects that define the log patterns that belong to <code>LogPatternSet</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPatterns(java.util.List<? extends java.lang.Object> logPatterns) {
                this.logPatterns = logPatterns;
                return this;
            }

            /**
             * Sets the value of {@link LogPatternSetProperty#getPatternSetName}
             * @param patternSetName The name of the log pattern. This parameter is required.
             *                       A log pattern name can contain up to 30 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternSetName(java.lang.String patternSetName) {
                this.patternSetName = patternSetName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogPatternSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogPatternSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogPatternSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogPatternSetProperty {
            private final java.lang.Object logPatterns;
            private final java.lang.String patternSetName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logPatterns = software.amazon.jsii.Kernel.get(this, "logPatterns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.patternSetName = software.amazon.jsii.Kernel.get(this, "patternSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logPatterns = java.util.Objects.requireNonNull(builder.logPatterns, "logPatterns is required");
                this.patternSetName = java.util.Objects.requireNonNull(builder.patternSetName, "patternSetName is required");
            }

            @Override
            public final java.lang.Object getLogPatterns() {
                return this.logPatterns;
            }

            @Override
            public final java.lang.String getPatternSetName() {
                return this.patternSetName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logPatterns", om.valueToTree(this.getLogPatterns()));
                data.set("patternSetName", om.valueToTree(this.getPatternSetName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.LogPatternSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogPatternSetProperty.Jsii$Proxy that = (LogPatternSetProperty.Jsii$Proxy) o;

                if (!logPatterns.equals(that.logPatterns)) return false;
                return this.patternSetName.equals(that.patternSetName);
            }

            @Override
            public final int hashCode() {
                int result = this.logPatterns.hashCode();
                result = 31 * result + (this.patternSetName.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application Log</code> property type specifies a log to monitor for the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * LogProperty logProperty = LogProperty.builder()
     *         .logType("logType")
     *         // the properties below are optional
     *         .encoding("encoding")
     *         .logGroupName("logGroupName")
     *         .logPath("logPath")
     *         .patternSet("patternSet")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.LogProperty")
    @software.amazon.jsii.Jsii.Proxy(LogProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The log type decides the log patterns against which Application Insights analyzes the log.
         * <p>
         * The log type is selected from the following: <code>SQL_SERVER</code> , <code>MYSQL</code> , <code>MYSQL_SLOW_QUERY</code> , <code>POSTGRESQL</code> , <code>ORACLE_ALERT</code> , <code>ORACLE_LISTENER</code> , <code>IIS</code> , <code>APPLICATION</code> , <code>WINDOWS_EVENTS</code> , <code>WINDOWS_EVENTS_ACTIVE_DIRECTORY</code> , <code>WINDOWS_EVENTS_DNS</code> , <code>WINDOWS_EVENTS_IIS</code> , <code>WINDOWS_EVENTS_SHAREPOINT</code> , <code>SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP</code> , <code>SQL_SERVER_FAILOVER_CLUSTER_INSTANCE</code> , <code>STEP_FUNCTION</code> , <code>API_GATEWAY_ACCESS</code> , <code>API_GATEWAY_EXECUTION</code> , <code>SAP_HANA_LOGS</code> , <code>SAP_HANA_TRACE</code> , <code>SAP_HANA_HIGH_AVAILABILITY</code> , and <code>DEFAULT</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogType();

        /**
         * The type of encoding of the logs to be monitored.
         * <p>
         * The specified encoding should be included in the list of CloudWatch agent supported encodings. If not provided, CloudWatch Application Insights uses the default encoding type for the log type:
         * <p>
         * <ul>
         * <li><code>APPLICATION/DEFAULT</code> : utf-8 encoding</li>
         * <li><code>SQL_SERVER</code> : utf-16 encoding</li>
         * <li><code>IIS</code> : ascii encoding</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-encoding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-encoding</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncoding() {
            return null;
        }

        /**
         * The CloudWatch log group name to be associated with the monitored log.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-loggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
            return null;
        }

        /**
         * The path of the logs to be monitored.
         * <p>
         * The log path must be an absolute Windows or Linux system file path. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Agent-Configuration-File-Details.html#CloudWatch-Agent-Configuration-File-Logssection">CloudWatch Agent Configuration File: Logs Section</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogPath() {
            return null;
        }

        /**
         * The log pattern set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-patternset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-patternset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPatternSet() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogProperty> {
            java.lang.String logType;
            java.lang.String encoding;
            java.lang.String logGroupName;
            java.lang.String logPath;
            java.lang.String patternSet;

            /**
             * Sets the value of {@link LogProperty#getLogType}
             * @param logType The log type decides the log patterns against which Application Insights analyzes the log. This parameter is required.
             *                The log type is selected from the following: <code>SQL_SERVER</code> , <code>MYSQL</code> , <code>MYSQL_SLOW_QUERY</code> , <code>POSTGRESQL</code> , <code>ORACLE_ALERT</code> , <code>ORACLE_LISTENER</code> , <code>IIS</code> , <code>APPLICATION</code> , <code>WINDOWS_EVENTS</code> , <code>WINDOWS_EVENTS_ACTIVE_DIRECTORY</code> , <code>WINDOWS_EVENTS_DNS</code> , <code>WINDOWS_EVENTS_IIS</code> , <code>WINDOWS_EVENTS_SHAREPOINT</code> , <code>SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP</code> , <code>SQL_SERVER_FAILOVER_CLUSTER_INSTANCE</code> , <code>STEP_FUNCTION</code> , <code>API_GATEWAY_ACCESS</code> , <code>API_GATEWAY_EXECUTION</code> , <code>SAP_HANA_LOGS</code> , <code>SAP_HANA_TRACE</code> , <code>SAP_HANA_HIGH_AVAILABILITY</code> , and <code>DEFAULT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logType(java.lang.String logType) {
                this.logType = logType;
                return this;
            }

            /**
             * Sets the value of {@link LogProperty#getEncoding}
             * @param encoding The type of encoding of the logs to be monitored.
             *                 The specified encoding should be included in the list of CloudWatch agent supported encodings. If not provided, CloudWatch Application Insights uses the default encoding type for the log type:
             *                 <p>
             *                 <ul>
             *                 <li><code>APPLICATION/DEFAULT</code> : utf-8 encoding</li>
             *                 <li><code>SQL_SERVER</code> : utf-16 encoding</li>
             *                 <li><code>IIS</code> : ascii encoding</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encoding(java.lang.String encoding) {
                this.encoding = encoding;
                return this;
            }

            /**
             * Sets the value of {@link LogProperty#getLogGroupName}
             * @param logGroupName The CloudWatch log group name to be associated with the monitored log.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Sets the value of {@link LogProperty#getLogPath}
             * @param logPath The path of the logs to be monitored.
             *                The log path must be an absolute Windows or Linux system file path. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Agent-Configuration-File-Details.html#CloudWatch-Agent-Configuration-File-Logssection">CloudWatch Agent Configuration File: Logs Section</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPath(java.lang.String logPath) {
                this.logPath = logPath;
                return this;
            }

            /**
             * Sets the value of {@link LogProperty#getPatternSet}
             * @param patternSet The log pattern set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternSet(java.lang.String patternSet) {
                this.patternSet = patternSet;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogProperty {
            private final java.lang.String logType;
            private final java.lang.String encoding;
            private final java.lang.String logGroupName;
            private final java.lang.String logPath;
            private final java.lang.String patternSet;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logType = software.amazon.jsii.Kernel.get(this, "logType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encoding = software.amazon.jsii.Kernel.get(this, "encoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logPath = software.amazon.jsii.Kernel.get(this, "logPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternSet = software.amazon.jsii.Kernel.get(this, "patternSet", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logType = java.util.Objects.requireNonNull(builder.logType, "logType is required");
                this.encoding = builder.encoding;
                this.logGroupName = builder.logGroupName;
                this.logPath = builder.logPath;
                this.patternSet = builder.patternSet;
            }

            @Override
            public final java.lang.String getLogType() {
                return this.logType;
            }

            @Override
            public final java.lang.String getEncoding() {
                return this.encoding;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            public final java.lang.String getLogPath() {
                return this.logPath;
            }

            @Override
            public final java.lang.String getPatternSet() {
                return this.patternSet;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logType", om.valueToTree(this.getLogType()));
                if (this.getEncoding() != null) {
                    data.set("encoding", om.valueToTree(this.getEncoding()));
                }
                if (this.getLogGroupName() != null) {
                    data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                }
                if (this.getLogPath() != null) {
                    data.set("logPath", om.valueToTree(this.getLogPath()));
                }
                if (this.getPatternSet() != null) {
                    data.set("patternSet", om.valueToTree(this.getPatternSet()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.LogProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogProperty.Jsii$Proxy that = (LogProperty.Jsii$Proxy) o;

                if (!logType.equals(that.logType)) return false;
                if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) return false;
                if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
                if (this.logPath != null ? !this.logPath.equals(that.logPath) : that.logPath != null) return false;
                return this.patternSet != null ? this.patternSet.equals(that.patternSet) : that.patternSet == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logType.hashCode();
                result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
                result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
                result = 31 * result + (this.logPath != null ? this.logPath.hashCode() : 0);
                result = 31 * result + (this.patternSet != null ? this.patternSet.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The NetWeaver Prometheus Exporter Settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * NetWeaverPrometheusExporterProperty netWeaverPrometheusExporterProperty = NetWeaverPrometheusExporterProperty.builder()
     *         .instanceNumbers(List.of("instanceNumbers"))
     *         .sapsid("sapsid")
     *         // the properties below are optional
     *         .prometheusPort("prometheusPort")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.NetWeaverPrometheusExporterProperty")
    @software.amazon.jsii.Jsii.Proxy(NetWeaverPrometheusExporterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetWeaverPrometheusExporterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * SAP instance numbers for ASCS, ERS, and App Servers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html#cfn-applicationinsights-application-netweaverprometheusexporter-instancenumbers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html#cfn-applicationinsights-application-netweaverprometheusexporter-instancenumbers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceNumbers();

        /**
         * SAP NetWeaver SID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html#cfn-applicationinsights-application-netweaverprometheusexporter-sapsid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html#cfn-applicationinsights-application-netweaverprometheusexporter-sapsid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSapsid();

        /**
         * Prometheus exporter port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html#cfn-applicationinsights-application-netweaverprometheusexporter-prometheusport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-netweaverprometheusexporter.html#cfn-applicationinsights-application-netweaverprometheusexporter-prometheusport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrometheusPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetWeaverPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetWeaverPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetWeaverPrometheusExporterProperty> {
            java.util.List<java.lang.String> instanceNumbers;
            java.lang.String sapsid;
            java.lang.String prometheusPort;

            /**
             * Sets the value of {@link NetWeaverPrometheusExporterProperty#getInstanceNumbers}
             * @param instanceNumbers SAP instance numbers for ASCS, ERS, and App Servers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceNumbers(java.util.List<java.lang.String> instanceNumbers) {
                this.instanceNumbers = instanceNumbers;
                return this;
            }

            /**
             * Sets the value of {@link NetWeaverPrometheusExporterProperty#getSapsid}
             * @param sapsid SAP NetWeaver SID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapsid(java.lang.String sapsid) {
                this.sapsid = sapsid;
                return this;
            }

            /**
             * Sets the value of {@link NetWeaverPrometheusExporterProperty#getPrometheusPort}
             * @param prometheusPort Prometheus exporter port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheusPort(java.lang.String prometheusPort) {
                this.prometheusPort = prometheusPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetWeaverPrometheusExporterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetWeaverPrometheusExporterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetWeaverPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetWeaverPrometheusExporterProperty {
            private final java.util.List<java.lang.String> instanceNumbers;
            private final java.lang.String sapsid;
            private final java.lang.String prometheusPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceNumbers = software.amazon.jsii.Kernel.get(this, "instanceNumbers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sapsid = software.amazon.jsii.Kernel.get(this, "sapsid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prometheusPort = software.amazon.jsii.Kernel.get(this, "prometheusPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceNumbers = java.util.Objects.requireNonNull(builder.instanceNumbers, "instanceNumbers is required");
                this.sapsid = java.util.Objects.requireNonNull(builder.sapsid, "sapsid is required");
                this.prometheusPort = builder.prometheusPort;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceNumbers() {
                return this.instanceNumbers;
            }

            @Override
            public final java.lang.String getSapsid() {
                return this.sapsid;
            }

            @Override
            public final java.lang.String getPrometheusPort() {
                return this.prometheusPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceNumbers", om.valueToTree(this.getInstanceNumbers()));
                data.set("sapsid", om.valueToTree(this.getSapsid()));
                if (this.getPrometheusPort() != null) {
                    data.set("prometheusPort", om.valueToTree(this.getPrometheusPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.NetWeaverPrometheusExporterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetWeaverPrometheusExporterProperty.Jsii$Proxy that = (NetWeaverPrometheusExporterProperty.Jsii$Proxy) o;

                if (!instanceNumbers.equals(that.instanceNumbers)) return false;
                if (!sapsid.equals(that.sapsid)) return false;
                return this.prometheusPort != null ? this.prometheusPort.equals(that.prometheusPort) : that.prometheusPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceNumbers.hashCode();
                result = 31 * result + (this.sapsid.hashCode());
                result = 31 * result + (this.prometheusPort != null ? this.prometheusPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A process to be monitored for the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * ProcessProperty processProperty = ProcessProperty.builder()
     *         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                 .alarmMetricName("alarmMetricName")
     *                 .build()))
     *         .processName("processName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-process.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-process.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.ProcessProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of metrics to monitor for the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-process.html#cfn-applicationinsights-application-process-alarmmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-process.html#cfn-applicationinsights-application-process-alarmmetrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAlarmMetrics();

        /**
         * The name of the process to be monitored for the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-process.html#cfn-applicationinsights-application-process-processname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-process.html#cfn-applicationinsights-application-process-processname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProcessName();

        /**
         * @return a {@link Builder} of {@link ProcessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessProperty> {
            java.lang.Object alarmMetrics;
            java.lang.String processName;

            /**
             * Sets the value of {@link ProcessProperty#getAlarmMetrics}
             * @param alarmMetrics A list of metrics to monitor for the component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmMetrics(software.amazon.awscdk.IResolvable alarmMetrics) {
                this.alarmMetrics = alarmMetrics;
                return this;
            }

            /**
             * Sets the value of {@link ProcessProperty#getAlarmMetrics}
             * @param alarmMetrics A list of metrics to monitor for the component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmMetrics(java.util.List<? extends java.lang.Object> alarmMetrics) {
                this.alarmMetrics = alarmMetrics;
                return this;
            }

            /**
             * Sets the value of {@link ProcessProperty#getProcessName}
             * @param processName The name of the process to be monitored for the component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processName(java.lang.String processName) {
                this.processName = processName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessProperty {
            private final java.lang.Object alarmMetrics;
            private final java.lang.String processName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmMetrics = software.amazon.jsii.Kernel.get(this, "alarmMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processName = software.amazon.jsii.Kernel.get(this, "processName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmMetrics = java.util.Objects.requireNonNull(builder.alarmMetrics, "alarmMetrics is required");
                this.processName = java.util.Objects.requireNonNull(builder.processName, "processName is required");
            }

            @Override
            public final java.lang.Object getAlarmMetrics() {
                return this.alarmMetrics;
            }

            @Override
            public final java.lang.String getProcessName() {
                return this.processName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmMetrics", om.valueToTree(this.getAlarmMetrics()));
                data.set("processName", om.valueToTree(this.getProcessName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.ProcessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessProperty.Jsii$Proxy that = (ProcessProperty.Jsii$Proxy) o;

                if (!alarmMetrics.equals(that.alarmMetrics)) return false;
                return this.processName.equals(that.processName);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmMetrics.hashCode();
                result = 31 * result + (this.processName.hashCode());
                return result;
            }
        }
    }
    /**
     * The SQL prometheus exporter settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * SQLServerPrometheusExporterProperty sQLServerPrometheusExporterProperty = SQLServerPrometheusExporterProperty.builder()
     *         .prometheusPort("prometheusPort")
     *         .sqlSecretName("sqlSecretName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-sqlserverprometheusexporter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-sqlserverprometheusexporter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.SQLServerPrometheusExporterProperty")
    @software.amazon.jsii.Jsii.Proxy(SQLServerPrometheusExporterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SQLServerPrometheusExporterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Prometheus exporter port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-sqlserverprometheusexporter.html#cfn-applicationinsights-application-sqlserverprometheusexporter-prometheusport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-sqlserverprometheusexporter.html#cfn-applicationinsights-application-sqlserverprometheusexporter-prometheusport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrometheusPort();

        /**
         * Secret name which managers SQL exporter connection.
         * <p>
         * e.g. {"data_source_name": "sqlserver://<USERNAME>:<PASSWORD>&#64;localhost:1433"}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-sqlserverprometheusexporter.html#cfn-applicationinsights-application-sqlserverprometheusexporter-sqlsecretname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-sqlserverprometheusexporter.html#cfn-applicationinsights-application-sqlserverprometheusexporter-sqlsecretname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlSecretName();

        /**
         * @return a {@link Builder} of {@link SQLServerPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SQLServerPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SQLServerPrometheusExporterProperty> {
            java.lang.String prometheusPort;
            java.lang.String sqlSecretName;

            /**
             * Sets the value of {@link SQLServerPrometheusExporterProperty#getPrometheusPort}
             * @param prometheusPort Prometheus exporter port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheusPort(java.lang.String prometheusPort) {
                this.prometheusPort = prometheusPort;
                return this;
            }

            /**
             * Sets the value of {@link SQLServerPrometheusExporterProperty#getSqlSecretName}
             * @param sqlSecretName Secret name which managers SQL exporter connection. This parameter is required.
             *                      e.g. {"data_source_name": "sqlserver://<USERNAME>:<PASSWORD>&#64;localhost:1433"}
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlSecretName(java.lang.String sqlSecretName) {
                this.sqlSecretName = sqlSecretName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SQLServerPrometheusExporterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SQLServerPrometheusExporterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SQLServerPrometheusExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SQLServerPrometheusExporterProperty {
            private final java.lang.String prometheusPort;
            private final java.lang.String sqlSecretName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prometheusPort = software.amazon.jsii.Kernel.get(this, "prometheusPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqlSecretName = software.amazon.jsii.Kernel.get(this, "sqlSecretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prometheusPort = java.util.Objects.requireNonNull(builder.prometheusPort, "prometheusPort is required");
                this.sqlSecretName = java.util.Objects.requireNonNull(builder.sqlSecretName, "sqlSecretName is required");
            }

            @Override
            public final java.lang.String getPrometheusPort() {
                return this.prometheusPort;
            }

            @Override
            public final java.lang.String getSqlSecretName() {
                return this.sqlSecretName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("prometheusPort", om.valueToTree(this.getPrometheusPort()));
                data.set("sqlSecretName", om.valueToTree(this.getSqlSecretName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.SQLServerPrometheusExporterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SQLServerPrometheusExporterProperty.Jsii$Proxy that = (SQLServerPrometheusExporterProperty.Jsii$Proxy) o;

                if (!prometheusPort.equals(that.prometheusPort)) return false;
                return this.sqlSecretName.equals(that.sqlSecretName);
            }

            @Override
            public final int hashCode() {
                int result = this.prometheusPort.hashCode();
                result = 31 * result + (this.sqlSecretName.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application SubComponentConfigurationDetails</code> property type specifies the configuration settings of the sub-components.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * SubComponentConfigurationDetailsProperty subComponentConfigurationDetailsProperty = SubComponentConfigurationDetailsProperty.builder()
     *         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                 .alarmMetricName("alarmMetricName")
     *                 .build()))
     *         .logs(List.of(LogProperty.builder()
     *                 .logType("logType")
     *                 // the properties below are optional
     *                 .encoding("encoding")
     *                 .logGroupName("logGroupName")
     *                 .logPath("logPath")
     *                 .patternSet("patternSet")
     *                 .build()))
     *         .processes(List.of(ProcessProperty.builder()
     *                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                         .alarmMetricName("alarmMetricName")
     *                         .build()))
     *                 .processName("processName")
     *                 .build()))
     *         .windowsEvents(List.of(WindowsEventProperty.builder()
     *                 .eventLevels(List.of("eventLevels"))
     *                 .eventName("eventName")
     *                 .logGroupName("logGroupName")
     *                 // the properties below are optional
     *                 .patternSet("patternSet")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.SubComponentConfigurationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(SubComponentConfigurationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubComponentConfigurationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of metrics to monitor for the component.
         * <p>
         * All component types can use <code>AlarmMetrics</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-alarmmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-alarmmetrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlarmMetrics() {
            return null;
        }

        /**
         * A list of logs to monitor for the component.
         * <p>
         * Only Amazon EC2 instances can use <code>Logs</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-logs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-logs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogs() {
            return null;
        }

        /**
         * A list of processes to monitor for the component.
         * <p>
         * Only Windows EC2 instances can have a processes section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-processes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-processes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcesses() {
            return null;
        }

        /**
         * A list of Windows Events to monitor for the component.
         * <p>
         * Only Amazon EC2 instances running on Windows can use <code>WindowsEvents</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-windowsevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-windowsevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWindowsEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubComponentConfigurationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubComponentConfigurationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubComponentConfigurationDetailsProperty> {
            java.lang.Object alarmMetrics;
            java.lang.Object logs;
            java.lang.Object processes;
            java.lang.Object windowsEvents;

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getAlarmMetrics}
             * @param alarmMetrics A list of metrics to monitor for the component.
             *                     All component types can use <code>AlarmMetrics</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmMetrics(software.amazon.awscdk.IResolvable alarmMetrics) {
                this.alarmMetrics = alarmMetrics;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getAlarmMetrics}
             * @param alarmMetrics A list of metrics to monitor for the component.
             *                     All component types can use <code>AlarmMetrics</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmMetrics(java.util.List<? extends java.lang.Object> alarmMetrics) {
                this.alarmMetrics = alarmMetrics;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getLogs}
             * @param logs A list of logs to monitor for the component.
             *             Only Amazon EC2 instances can use <code>Logs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logs(software.amazon.awscdk.IResolvable logs) {
                this.logs = logs;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getLogs}
             * @param logs A list of logs to monitor for the component.
             *             Only Amazon EC2 instances can use <code>Logs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logs(java.util.List<? extends java.lang.Object> logs) {
                this.logs = logs;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getProcesses}
             * @param processes A list of processes to monitor for the component.
             *                  Only Windows EC2 instances can have a processes section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processes(software.amazon.awscdk.IResolvable processes) {
                this.processes = processes;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getProcesses}
             * @param processes A list of processes to monitor for the component.
             *                  Only Windows EC2 instances can have a processes section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processes(java.util.List<? extends java.lang.Object> processes) {
                this.processes = processes;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getWindowsEvents}
             * @param windowsEvents A list of Windows Events to monitor for the component.
             *                      Only Amazon EC2 instances running on Windows can use <code>WindowsEvents</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windowsEvents(software.amazon.awscdk.IResolvable windowsEvents) {
                this.windowsEvents = windowsEvents;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentConfigurationDetailsProperty#getWindowsEvents}
             * @param windowsEvents A list of Windows Events to monitor for the component.
             *                      Only Amazon EC2 instances running on Windows can use <code>WindowsEvents</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windowsEvents(java.util.List<? extends java.lang.Object> windowsEvents) {
                this.windowsEvents = windowsEvents;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubComponentConfigurationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubComponentConfigurationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubComponentConfigurationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubComponentConfigurationDetailsProperty {
            private final java.lang.Object alarmMetrics;
            private final java.lang.Object logs;
            private final java.lang.Object processes;
            private final java.lang.Object windowsEvents;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmMetrics = software.amazon.jsii.Kernel.get(this, "alarmMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logs = software.amazon.jsii.Kernel.get(this, "logs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processes = software.amazon.jsii.Kernel.get(this, "processes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.windowsEvents = software.amazon.jsii.Kernel.get(this, "windowsEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmMetrics = builder.alarmMetrics;
                this.logs = builder.logs;
                this.processes = builder.processes;
                this.windowsEvents = builder.windowsEvents;
            }

            @Override
            public final java.lang.Object getAlarmMetrics() {
                return this.alarmMetrics;
            }

            @Override
            public final java.lang.Object getLogs() {
                return this.logs;
            }

            @Override
            public final java.lang.Object getProcesses() {
                return this.processes;
            }

            @Override
            public final java.lang.Object getWindowsEvents() {
                return this.windowsEvents;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlarmMetrics() != null) {
                    data.set("alarmMetrics", om.valueToTree(this.getAlarmMetrics()));
                }
                if (this.getLogs() != null) {
                    data.set("logs", om.valueToTree(this.getLogs()));
                }
                if (this.getProcesses() != null) {
                    data.set("processes", om.valueToTree(this.getProcesses()));
                }
                if (this.getWindowsEvents() != null) {
                    data.set("windowsEvents", om.valueToTree(this.getWindowsEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.SubComponentConfigurationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubComponentConfigurationDetailsProperty.Jsii$Proxy that = (SubComponentConfigurationDetailsProperty.Jsii$Proxy) o;

                if (this.alarmMetrics != null ? !this.alarmMetrics.equals(that.alarmMetrics) : that.alarmMetrics != null) return false;
                if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) return false;
                if (this.processes != null ? !this.processes.equals(that.processes) : that.processes != null) return false;
                return this.windowsEvents != null ? this.windowsEvents.equals(that.windowsEvents) : that.windowsEvents == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarmMetrics != null ? this.alarmMetrics.hashCode() : 0;
                result = 31 * result + (this.logs != null ? this.logs.hashCode() : 0);
                result = 31 * result + (this.processes != null ? this.processes.hashCode() : 0);
                result = 31 * result + (this.windowsEvents != null ? this.windowsEvents.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application SubComponentTypeConfiguration</code> property type specifies the sub-component configurations for a component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * SubComponentTypeConfigurationProperty subComponentTypeConfigurationProperty = SubComponentTypeConfigurationProperty.builder()
     *         .subComponentConfigurationDetails(SubComponentConfigurationDetailsProperty.builder()
     *                 .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                         .alarmMetricName("alarmMetricName")
     *                         .build()))
     *                 .logs(List.of(LogProperty.builder()
     *                         .logType("logType")
     *                         // the properties below are optional
     *                         .encoding("encoding")
     *                         .logGroupName("logGroupName")
     *                         .logPath("logPath")
     *                         .patternSet("patternSet")
     *                         .build()))
     *                 .processes(List.of(ProcessProperty.builder()
     *                         .alarmMetrics(List.of(AlarmMetricProperty.builder()
     *                                 .alarmMetricName("alarmMetricName")
     *                                 .build()))
     *                         .processName("processName")
     *                         .build()))
     *                 .windowsEvents(List.of(WindowsEventProperty.builder()
     *                         .eventLevels(List.of("eventLevels"))
     *                         .eventName("eventName")
     *                         .logGroupName("logGroupName")
     *                         // the properties below are optional
     *                         .patternSet("patternSet")
     *                         .build()))
     *                 .build())
     *         .subComponentType("subComponentType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.SubComponentTypeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SubComponentTypeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubComponentTypeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings of the sub-components.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponentconfigurationdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponentconfigurationdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSubComponentConfigurationDetails();

        /**
         * The sub-component type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubComponentType();

        /**
         * @return a {@link Builder} of {@link SubComponentTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubComponentTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubComponentTypeConfigurationProperty> {
            java.lang.Object subComponentConfigurationDetails;
            java.lang.String subComponentType;

            /**
             * Sets the value of {@link SubComponentTypeConfigurationProperty#getSubComponentConfigurationDetails}
             * @param subComponentConfigurationDetails The configuration settings of the sub-components. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subComponentConfigurationDetails(software.amazon.awscdk.IResolvable subComponentConfigurationDetails) {
                this.subComponentConfigurationDetails = subComponentConfigurationDetails;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentTypeConfigurationProperty#getSubComponentConfigurationDetails}
             * @param subComponentConfigurationDetails The configuration settings of the sub-components. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subComponentConfigurationDetails(software.amazon.awscdk.services.applicationinsights.CfnApplication.SubComponentConfigurationDetailsProperty subComponentConfigurationDetails) {
                this.subComponentConfigurationDetails = subComponentConfigurationDetails;
                return this;
            }

            /**
             * Sets the value of {@link SubComponentTypeConfigurationProperty#getSubComponentType}
             * @param subComponentType The sub-component type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subComponentType(java.lang.String subComponentType) {
                this.subComponentType = subComponentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubComponentTypeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubComponentTypeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubComponentTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubComponentTypeConfigurationProperty {
            private final java.lang.Object subComponentConfigurationDetails;
            private final java.lang.String subComponentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subComponentConfigurationDetails = software.amazon.jsii.Kernel.get(this, "subComponentConfigurationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subComponentType = software.amazon.jsii.Kernel.get(this, "subComponentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subComponentConfigurationDetails = java.util.Objects.requireNonNull(builder.subComponentConfigurationDetails, "subComponentConfigurationDetails is required");
                this.subComponentType = java.util.Objects.requireNonNull(builder.subComponentType, "subComponentType is required");
            }

            @Override
            public final java.lang.Object getSubComponentConfigurationDetails() {
                return this.subComponentConfigurationDetails;
            }

            @Override
            public final java.lang.String getSubComponentType() {
                return this.subComponentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subComponentConfigurationDetails", om.valueToTree(this.getSubComponentConfigurationDetails()));
                data.set("subComponentType", om.valueToTree(this.getSubComponentType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.SubComponentTypeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubComponentTypeConfigurationProperty.Jsii$Proxy that = (SubComponentTypeConfigurationProperty.Jsii$Proxy) o;

                if (!subComponentConfigurationDetails.equals(that.subComponentConfigurationDetails)) return false;
                return this.subComponentType.equals(that.subComponentType);
            }

            @Override
            public final int hashCode() {
                int result = this.subComponentConfigurationDetails.hashCode();
                result = 31 * result + (this.subComponentType.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>AWS::ApplicationInsights::Application WindowsEvent</code> property type specifies a Windows Event to monitor for the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationinsights.*;
     * WindowsEventProperty windowsEventProperty = WindowsEventProperty.builder()
     *         .eventLevels(List.of("eventLevels"))
     *         .eventName("eventName")
     *         .logGroupName("logGroupName")
     *         // the properties below are optional
     *         .patternSet("patternSet")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationinsights.CfnApplication.WindowsEventProperty")
    @software.amazon.jsii.Jsii.Proxy(WindowsEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WindowsEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The levels of event to log.
         * <p>
         * You must specify each level to log. Possible values include <code>INFORMATION</code> , <code>WARNING</code> , <code>ERROR</code> , <code>CRITICAL</code> , and <code>VERBOSE</code> . This field is required for each type of Windows Event to log.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventlevels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventlevels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEventLevels();

        /**
         * The type of Windows Events to log, equivalent to the Windows Event log channel name.
         * <p>
         * For example, System, Security, CustomEventName, and so on. This field is required for each type of Windows event to log.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventName();

        /**
         * The CloudWatch log group name to be associated with the monitored log.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-loggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

        /**
         * The log pattern set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-patternset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-patternset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPatternSet() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WindowsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WindowsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WindowsEventProperty> {
            java.util.List<java.lang.String> eventLevels;
            java.lang.String eventName;
            java.lang.String logGroupName;
            java.lang.String patternSet;

            /**
             * Sets the value of {@link WindowsEventProperty#getEventLevels}
             * @param eventLevels The levels of event to log. This parameter is required.
             *                    You must specify each level to log. Possible values include <code>INFORMATION</code> , <code>WARNING</code> , <code>ERROR</code> , <code>CRITICAL</code> , and <code>VERBOSE</code> . This field is required for each type of Windows Event to log.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventLevels(java.util.List<java.lang.String> eventLevels) {
                this.eventLevels = eventLevels;
                return this;
            }

            /**
             * Sets the value of {@link WindowsEventProperty#getEventName}
             * @param eventName The type of Windows Events to log, equivalent to the Windows Event log channel name. This parameter is required.
             *                  For example, System, Security, CustomEventName, and so on. This field is required for each type of Windows event to log.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventName(java.lang.String eventName) {
                this.eventName = eventName;
                return this;
            }

            /**
             * Sets the value of {@link WindowsEventProperty#getLogGroupName}
             * @param logGroupName The CloudWatch log group name to be associated with the monitored log. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Sets the value of {@link WindowsEventProperty#getPatternSet}
             * @param patternSet The log pattern set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternSet(java.lang.String patternSet) {
                this.patternSet = patternSet;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WindowsEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WindowsEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WindowsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowsEventProperty {
            private final java.util.List<java.lang.String> eventLevels;
            private final java.lang.String eventName;
            private final java.lang.String logGroupName;
            private final java.lang.String patternSet;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventLevels = software.amazon.jsii.Kernel.get(this, "eventLevels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.eventName = software.amazon.jsii.Kernel.get(this, "eventName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternSet = software.amazon.jsii.Kernel.get(this, "patternSet", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventLevels = java.util.Objects.requireNonNull(builder.eventLevels, "eventLevels is required");
                this.eventName = java.util.Objects.requireNonNull(builder.eventName, "eventName is required");
                this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
                this.patternSet = builder.patternSet;
            }

            @Override
            public final java.util.List<java.lang.String> getEventLevels() {
                return this.eventLevels;
            }

            @Override
            public final java.lang.String getEventName() {
                return this.eventName;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            public final java.lang.String getPatternSet() {
                return this.patternSet;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventLevels", om.valueToTree(this.getEventLevels()));
                data.set("eventName", om.valueToTree(this.getEventName()));
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                if (this.getPatternSet() != null) {
                    data.set("patternSet", om.valueToTree(this.getPatternSet()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationinsights.CfnApplication.WindowsEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WindowsEventProperty.Jsii$Proxy that = (WindowsEventProperty.Jsii$Proxy) o;

                if (!eventLevels.equals(that.eventLevels)) return false;
                if (!eventName.equals(that.eventName)) return false;
                if (!logGroupName.equals(that.logGroupName)) return false;
                return this.patternSet != null ? this.patternSet.equals(that.patternSet) : that.patternSet == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventLevels.hashCode();
                result = 31 * result + (this.eventName.hashCode());
                result = 31 * result + (this.logGroupName.hashCode());
                result = 31 * result + (this.patternSet != null ? this.patternSet.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationinsights.CfnApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationinsights.CfnApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationinsights.CfnApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationinsights.CfnApplicationProps.Builder();
        }

        /**
         * The name of the resource group used for the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname</a>
         * @param resourceGroupName The name of the resource group used for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceGroupName(final java.lang.String resourceGroupName) {
            this.props.resourceGroupName(resourceGroupName);
            return this;
        }

        /**
         * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-attachmissingpermission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-attachmissingpermission</a>
         * @param attachMissingPermission If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachMissingPermission(final java.lang.Boolean attachMissingPermission) {
            this.props.attachMissingPermission(attachMissingPermission);
            return this;
        }
        /**
         * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-attachmissingpermission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-attachmissingpermission</a>
         * @param attachMissingPermission If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachMissingPermission(final software.amazon.awscdk.IResolvable attachMissingPermission) {
            this.props.attachMissingPermission(attachMissingPermission);
            return this;
        }

        /**
         * If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled</a>
         * @param autoConfigurationEnabled If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoConfigurationEnabled(final java.lang.Boolean autoConfigurationEnabled) {
            this.props.autoConfigurationEnabled(autoConfigurationEnabled);
            return this;
        }
        /**
         * If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled</a>
         * @param autoConfigurationEnabled If set to <code>true</code> , the application components will be configured with the monitoring configuration recommended by Application Insights. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoConfigurationEnabled(final software.amazon.awscdk.IResolvable autoConfigurationEnabled) {
            this.props.autoConfigurationEnabled(autoConfigurationEnabled);
            return this;
        }

        /**
         * The monitoring settings of the components.
         * <p>
         * Not required to set up default monitoring for all components. To set up default monitoring for all components, set <code>AutoConfigurationEnabled</code> to <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings</a>
         * @param componentMonitoringSettings The monitoring settings of the components. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentMonitoringSettings(final software.amazon.awscdk.IResolvable componentMonitoringSettings) {
            this.props.componentMonitoringSettings(componentMonitoringSettings);
            return this;
        }
        /**
         * The monitoring settings of the components.
         * <p>
         * Not required to set up default monitoring for all components. To set up default monitoring for all components, set <code>AutoConfigurationEnabled</code> to <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings</a>
         * @param componentMonitoringSettings The monitoring settings of the components. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentMonitoringSettings(final java.util.List<? extends java.lang.Object> componentMonitoringSettings) {
            this.props.componentMonitoringSettings(componentMonitoringSettings);
            return this;
        }

        /**
         * Describes a custom component by grouping similar standalone instances to monitor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents</a>
         * @param customComponents Describes a custom component by grouping similar standalone instances to monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customComponents(final software.amazon.awscdk.IResolvable customComponents) {
            this.props.customComponents(customComponents);
            return this;
        }
        /**
         * Describes a custom component by grouping similar standalone instances to monitor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents</a>
         * @param customComponents Describes a custom component by grouping similar standalone instances to monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customComponents(final java.util.List<? extends java.lang.Object> customComponents) {
            this.props.customComponents(customComponents);
            return this;
        }

        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled</a>
         * @param cweMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cweMonitorEnabled(final java.lang.Boolean cweMonitorEnabled) {
            this.props.cweMonitorEnabled(cweMonitorEnabled);
            return this;
        }
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled</a>
         * @param cweMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code> , <code>failed deployment</code> , and others. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cweMonitorEnabled(final software.amazon.awscdk.IResolvable cweMonitorEnabled) {
            this.props.cweMonitorEnabled(cweMonitorEnabled);
            return this;
        }

        /**
         * Application Insights can create applications based on a resource group or on an account.
         * <p>
         * To create an account-based application using all of the resources in the account, set this parameter to <code>ACCOUNT_BASED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-groupingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-groupingtype</a>
         * @param groupingType Application Insights can create applications based on a resource group or on an account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingType(final java.lang.String groupingType) {
            this.props.groupingType(groupingType);
            return this;
        }

        /**
         * The log pattern sets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets</a>
         * @param logPatternSets The log pattern sets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPatternSets(final software.amazon.awscdk.IResolvable logPatternSets) {
            this.props.logPatternSets(logPatternSets);
            return this;
        }
        /**
         * The log pattern sets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets</a>
         * @param logPatternSets The log pattern sets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPatternSets(final java.util.List<? extends java.lang.Object> logPatternSets) {
            this.props.logPatternSets(logPatternSets);
            return this;
        }

        /**
         * Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled</a>
         * @param opsCenterEnabled Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder opsCenterEnabled(final java.lang.Boolean opsCenterEnabled) {
            this.props.opsCenterEnabled(opsCenterEnabled);
            return this;
        }
        /**
         * Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled</a>
         * @param opsCenterEnabled Indicates whether Application Insights will create OpsItems for any problem that is detected by Application Insights for an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder opsCenterEnabled(final software.amazon.awscdk.IResolvable opsCenterEnabled) {
            this.props.opsCenterEnabled(opsCenterEnabled);
            return this;
        }

        /**
         * The SNS topic provided to Application Insights that is associated with the created OpsItems to receive SNS notifications for opsItem updates.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn</a>
         * @param opsItemSnsTopicArn The SNS topic provided to Application Insights that is associated with the created OpsItems to receive SNS notifications for opsItem updates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder opsItemSnsTopicArn(final java.lang.String opsItemSnsTopicArn) {
            this.props.opsItemSnsTopicArn(opsItemSnsTopicArn);
            return this;
        }

        /**
         * The SNS topic ARN that is associated with SNS notifications for updates or issues.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-snsnotificationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-snsnotificationarn</a>
         * @param snsNotificationArn The SNS topic ARN that is associated with SNS notifications for updates or issues. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsNotificationArn(final java.lang.String snsNotificationArn) {
            this.props.snsNotificationArn(snsNotificationArn);
            return this;
        }

        /**
         * An array of <code>Tags</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags</a>
         * @param tags An array of <code>Tags</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.applicationinsights.CfnApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationinsights.CfnApplication build() {
            return new software.amazon.awscdk.services.applicationinsights.CfnApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
