package software.amazon.awscdk.services.appmesh;

/**
 * Properties for defining a <code>CfnRoute</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnRouteProps cfnRouteProps = CfnRouteProps.builder()
 *         .meshName("meshName")
 *         .spec(RouteSpecProperty.builder()
 *                 .grpcRoute(GrpcRouteProperty.builder()
 *                         .action(GrpcRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .match(GrpcRouteMatchProperty.builder()
 *                                 .metadata(List.of(GrpcRouteMetadataProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(GrpcRouteMetadataMatchMethodProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(MatchRangeProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .methodName("methodName")
 *                                 .port(123)
 *                                 .serviceName("serviceName")
 *                                 .build())
 *                         // the properties below are optional
 *                         .retryPolicy(GrpcRetryPolicyProperty.builder()
 *                                 .maxRetries(123)
 *                                 .perRetryTimeout(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .grpcRetryEvents(List.of("grpcRetryEvents"))
 *                                 .httpRetryEvents(List.of("httpRetryEvents"))
 *                                 .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                                 .build())
 *                         .timeout(GrpcTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .http2Route(HttpRouteProperty.builder()
 *                         .action(HttpRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .match(HttpRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HeaderMatchMethodProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(MatchRangeProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .scheme("scheme")
 *                                 .build())
 *                         // the properties below are optional
 *                         .retryPolicy(HttpRetryPolicyProperty.builder()
 *                                 .maxRetries(123)
 *                                 .perRetryTimeout(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .httpRetryEvents(List.of("httpRetryEvents"))
 *                                 .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                                 .build())
 *                         .timeout(HttpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .httpRoute(HttpRouteProperty.builder()
 *                         .action(HttpRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .match(HttpRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HeaderMatchMethodProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(MatchRangeProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .scheme("scheme")
 *                                 .build())
 *                         // the properties below are optional
 *                         .retryPolicy(HttpRetryPolicyProperty.builder()
 *                                 .maxRetries(123)
 *                                 .perRetryTimeout(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .httpRetryEvents(List.of("httpRetryEvents"))
 *                                 .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                                 .build())
 *                         .timeout(HttpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .priority(123)
 *                 .tcpRoute(TcpRouteProperty.builder()
 *                         .action(TcpRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .match(TcpRouteMatchProperty.builder()
 *                                 .port(123)
 *                                 .build())
 *                         .timeout(TcpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .virtualRouterName("virtualRouterName")
 *         // the properties below are optional
 *         .meshOwner("meshOwner")
 *         .routeName("routeName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:03.243Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRouteProps")
@software.amazon.jsii.Jsii.Proxy(CfnRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the service mesh to create the route in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMeshName();

    /**
     * The route specification to apply.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSpec();

    /**
     * The name of the virtual router in which to create the route.
     * <p>
     * If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualRouterName();

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return null;
    }

    /**
     * The name to use for the route.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRouteName() {
        return null;
    }

    /**
     * Optional metadata that you can apply to the route to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRouteProps> {
        java.lang.String meshName;
        java.lang.Object spec;
        java.lang.String virtualRouterName;
        java.lang.String meshOwner;
        java.lang.String routeName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRouteProps#getMeshName}
         * @param meshName The name of the service mesh to create the route in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(java.lang.String meshName) {
            this.meshName = meshName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getSpec}
         * @param spec The route specification to apply. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.IResolvable spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getSpec}
         * @param spec The route specification to apply. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.services.appmesh.CfnRoute.RouteSpecProperty spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getVirtualRouterName}
         * @param virtualRouterName The name of the virtual router in which to create the route. This parameter is required.
         *                          If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterName(java.lang.String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getMeshOwner}
         * @param meshOwner The AWS IAM account ID of the service mesh owner.
         *                  If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(java.lang.String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getRouteName}
         * @param routeName The name to use for the route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeName(java.lang.String routeName) {
            this.routeName = routeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getTags}
         * @param tags Optional metadata that you can apply to the route to assist with categorization and organization.
         *             Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRouteProps {
        private final java.lang.String meshName;
        private final java.lang.Object spec;
        private final java.lang.String virtualRouterName;
        private final java.lang.String meshOwner;
        private final java.lang.String routeName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.meshName = software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.spec = software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.virtualRouterName = software.amazon.jsii.Kernel.get(this, "virtualRouterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.meshOwner = software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeName = software.amazon.jsii.Kernel.get(this, "routeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.meshName = java.util.Objects.requireNonNull(builder.meshName, "meshName is required");
            this.spec = java.util.Objects.requireNonNull(builder.spec, "spec is required");
            this.virtualRouterName = java.util.Objects.requireNonNull(builder.virtualRouterName, "virtualRouterName is required");
            this.meshOwner = builder.meshOwner;
            this.routeName = builder.routeName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getMeshName() {
            return this.meshName;
        }

        @Override
        public final java.lang.Object getSpec() {
            return this.spec;
        }

        @Override
        public final java.lang.String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        @Override
        public final java.lang.String getMeshOwner() {
            return this.meshOwner;
        }

        @Override
        public final java.lang.String getRouteName() {
            return this.routeName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("meshName", om.valueToTree(this.getMeshName()));
            data.set("spec", om.valueToTree(this.getSpec()));
            data.set("virtualRouterName", om.valueToTree(this.getVirtualRouterName()));
            if (this.getMeshOwner() != null) {
                data.set("meshOwner", om.valueToTree(this.getMeshOwner()));
            }
            if (this.getRouteName() != null) {
                data.set("routeName", om.valueToTree(this.getRouteName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRouteProps.Jsii$Proxy that = (CfnRouteProps.Jsii$Proxy) o;

            if (!meshName.equals(that.meshName)) return false;
            if (!spec.equals(that.spec)) return false;
            if (!virtualRouterName.equals(that.virtualRouterName)) return false;
            if (this.meshOwner != null ? !this.meshOwner.equals(that.meshOwner) : that.meshOwner != null) return false;
            if (this.routeName != null ? !this.routeName.equals(that.routeName) : that.routeName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.meshName.hashCode();
            result = 31 * result + (this.spec.hashCode());
            result = 31 * result + (this.virtualRouterName.hashCode());
            result = 31 * result + (this.meshOwner != null ? this.meshOwner.hashCode() : 0);
            result = 31 * result + (this.routeName != null ? this.routeName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
