package software.amazon.awscdk.services.apprunner;

/**
 * Properties for defining a <code>CfnService</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * CfnServiceProps cfnServiceProps = CfnServiceProps.builder()
 *         .sourceConfiguration(SourceConfigurationProperty.builder()
 *                 .authenticationConfiguration(AuthenticationConfigurationProperty.builder()
 *                         .accessRoleArn("accessRoleArn")
 *                         .connectionArn("connectionArn")
 *                         .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .codeRepository(CodeRepositoryProperty.builder()
 *                         .repositoryUrl("repositoryUrl")
 *                         .sourceCodeVersion(SourceCodeVersionProperty.builder()
 *                                 .type("type")
 *                                 .value("value")
 *                                 .build())
 *                         // the properties below are optional
 *                         .codeConfiguration(CodeConfigurationProperty.builder()
 *                                 .configurationSource("configurationSource")
 *                                 // the properties below are optional
 *                                 .codeConfigurationValues(CodeConfigurationValuesProperty.builder()
 *                                         .runtime("runtime")
 *                                         // the properties below are optional
 *                                         .buildCommand("buildCommand")
 *                                         .port("port")
 *                                         .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .startCommand("startCommand")
 *                                         .build())
 *                                 .build())
 *                         .sourceDirectory("sourceDirectory")
 *                         .build())
 *                 .imageRepository(ImageRepositoryProperty.builder()
 *                         .imageIdentifier("imageIdentifier")
 *                         .imageRepositoryType("imageRepositoryType")
 *                         // the properties below are optional
 *                         .imageConfiguration(ImageConfigurationProperty.builder()
 *                                 .port("port")
 *                                 .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .startCommand("startCommand")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .autoScalingConfigurationArn("autoScalingConfigurationArn")
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .kmsKey("kmsKey")
 *                 .build())
 *         .healthCheckConfiguration(HealthCheckConfigurationProperty.builder()
 *                 .healthyThreshold(123)
 *                 .interval(123)
 *                 .path("path")
 *                 .protocol("protocol")
 *                 .timeout(123)
 *                 .unhealthyThreshold(123)
 *                 .build())
 *         .instanceConfiguration(InstanceConfigurationProperty.builder()
 *                 .cpu("cpu")
 *                 .instanceRoleArn("instanceRoleArn")
 *                 .memory("memory")
 *                 .build())
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .egressConfiguration(EgressConfigurationProperty.builder()
 *                         .egressType("egressType")
 *                         // the properties below are optional
 *                         .vpcConnectorArn("vpcConnectorArn")
 *                         .build())
 *                 .ingressConfiguration(IngressConfigurationProperty.builder()
 *                         .isPubliclyAccessible(false)
 *                         .build())
 *                 .ipAddressType("ipAddressType")
 *                 .build())
 *         .observabilityConfiguration(ServiceObservabilityConfigurationProperty.builder()
 *                 .observabilityEnabled(false)
 *                 // the properties below are optional
 *                 .observabilityConfigurationArn("observabilityConfigurationArn")
 *                 .build())
 *         .serviceName("serviceName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:03.427Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnServiceProps")
@software.amazon.jsii.Jsii.Proxy(CfnServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source to deploy to the App Runner service.
     * <p>
     * It can be a code or an image repository.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration();

    /**
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.
     * <p>
     * If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     * <p>
     * Specify an ARN with a name and a revision number to associate that revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3</code>
     * <p>
     * Specify just the name to associate the latest revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingConfigurationArn() {
        return null;
    }

    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
     * <p>
     * By default, App Runner uses an AWS managed key .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return null;
    }

    /**
     * The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckConfiguration() {
        return null;
    }

    /**
     * The runtime configuration of instances (scaling units) of your service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceConfiguration() {
        return null;
    }

    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-networkconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return null;
    }

    /**
     * The observability configuration of your service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-observabilityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-observabilityconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getObservabilityConfiguration() {
        return null;
    }

    /**
     * A name for the App Runner service.
     * <p>
     * It must be unique across all the running App Runner services in your AWS account in the AWS Region .
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a name for your service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * An optional list of metadata items that you can associate with the App Runner service resource.
     * <p>
     * A tag is a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServiceProps> {
        java.lang.Object sourceConfiguration;
        java.lang.String autoScalingConfigurationArn;
        java.lang.Object encryptionConfiguration;
        java.lang.Object healthCheckConfiguration;
        java.lang.Object instanceConfiguration;
        java.lang.Object networkConfiguration;
        java.lang.Object observabilityConfiguration;
        java.lang.String serviceName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnServiceProps#getSourceConfiguration}
         * @param sourceConfiguration The source to deploy to the App Runner service. This parameter is required.
         *                            It can be a code or an image repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getSourceConfiguration}
         * @param sourceConfiguration The source to deploy to the App Runner service. This parameter is required.
         *                            It can be a code or an image repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getAutoScalingConfigurationArn}
         * @param autoScalingConfigurationArn The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.
         *                                    If not provided, App Runner associates the latest revision of a default auto scaling configuration.
         *                                    <p>
         *                                    Specify an ARN with a name and a revision number to associate that revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3</code>
         *                                    <p>
         *                                    Specify just the name to associate the latest revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingConfigurationArn(java.lang.String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getEncryptionConfiguration}
         * @param encryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
         *                                By default, App Runner uses an AWS managed key .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getEncryptionConfiguration}
         * @param encryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
         *                                By default, App Runner uses an AWS managed key .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.apprunner.CfnService.EncryptionConfigurationProperty encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getHealthCheckConfiguration}
         * @param healthCheckConfiguration The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfiguration(software.amazon.awscdk.IResolvable healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getHealthCheckConfiguration}
         * @param healthCheckConfiguration The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfiguration(software.amazon.awscdk.services.apprunner.CfnService.HealthCheckConfigurationProperty healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getInstanceConfiguration}
         * @param instanceConfiguration The runtime configuration of instances (scaling units) of your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(software.amazon.awscdk.IResolvable instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getInstanceConfiguration}
         * @param instanceConfiguration The runtime configuration of instances (scaling units) of your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(software.amazon.awscdk.services.apprunner.CfnService.InstanceConfigurationProperty instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getNetworkConfiguration}
         * @param networkConfiguration Configuration settings related to network traffic of the web application that the App Runner service runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getNetworkConfiguration}
         * @param networkConfiguration Configuration settings related to network traffic of the web application that the App Runner service runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.services.apprunner.CfnService.NetworkConfigurationProperty networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getObservabilityConfiguration}
         * @param observabilityConfiguration The observability configuration of your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder observabilityConfiguration(software.amazon.awscdk.IResolvable observabilityConfiguration) {
            this.observabilityConfiguration = observabilityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getObservabilityConfiguration}
         * @param observabilityConfiguration The observability configuration of your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder observabilityConfiguration(software.amazon.awscdk.services.apprunner.CfnService.ServiceObservabilityConfigurationProperty observabilityConfiguration) {
            this.observabilityConfiguration = observabilityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getServiceName}
         * @param serviceName A name for the App Runner service.
         *                    It must be unique across all the running App Runner services in your AWS account in the AWS Region .
         *                    <p>
         *                    If you don't specify a name, AWS CloudFormation generates a name for your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceProps#getTags}
         * @param tags An optional list of metadata items that you can associate with the App Runner service resource.
         *             A tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServiceProps {
        private final java.lang.Object sourceConfiguration;
        private final java.lang.String autoScalingConfigurationArn;
        private final java.lang.Object encryptionConfiguration;
        private final java.lang.Object healthCheckConfiguration;
        private final java.lang.Object instanceConfiguration;
        private final java.lang.Object networkConfiguration;
        private final java.lang.Object observabilityConfiguration;
        private final java.lang.String serviceName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoScalingConfigurationArn = software.amazon.jsii.Kernel.get(this, "autoScalingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.healthCheckConfiguration = software.amazon.jsii.Kernel.get(this, "healthCheckConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceConfiguration = software.amazon.jsii.Kernel.get(this, "instanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.observabilityConfiguration = software.amazon.jsii.Kernel.get(this, "observabilityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceConfiguration = java.util.Objects.requireNonNull(builder.sourceConfiguration, "sourceConfiguration is required");
            this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.healthCheckConfiguration = builder.healthCheckConfiguration;
            this.instanceConfiguration = builder.instanceConfiguration;
            this.networkConfiguration = builder.networkConfiguration;
            this.observabilityConfiguration = builder.observabilityConfiguration;
            this.serviceName = builder.serviceName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getSourceConfiguration() {
            return this.sourceConfiguration;
        }

        @Override
        public final java.lang.String getAutoScalingConfigurationArn() {
            return this.autoScalingConfigurationArn;
        }

        @Override
        public final java.lang.Object getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final java.lang.Object getHealthCheckConfiguration() {
            return this.healthCheckConfiguration;
        }

        @Override
        public final java.lang.Object getInstanceConfiguration() {
            return this.instanceConfiguration;
        }

        @Override
        public final java.lang.Object getNetworkConfiguration() {
            return this.networkConfiguration;
        }

        @Override
        public final java.lang.Object getObservabilityConfiguration() {
            return this.observabilityConfiguration;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
            if (this.getAutoScalingConfigurationArn() != null) {
                data.set("autoScalingConfigurationArn", om.valueToTree(this.getAutoScalingConfigurationArn()));
            }
            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getHealthCheckConfiguration() != null) {
                data.set("healthCheckConfiguration", om.valueToTree(this.getHealthCheckConfiguration()));
            }
            if (this.getInstanceConfiguration() != null) {
                data.set("instanceConfiguration", om.valueToTree(this.getInstanceConfiguration()));
            }
            if (this.getNetworkConfiguration() != null) {
                data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
            }
            if (this.getObservabilityConfiguration() != null) {
                data.set("observabilityConfiguration", om.valueToTree(this.getObservabilityConfiguration()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServiceProps.Jsii$Proxy that = (CfnServiceProps.Jsii$Proxy) o;

            if (!sourceConfiguration.equals(that.sourceConfiguration)) return false;
            if (this.autoScalingConfigurationArn != null ? !this.autoScalingConfigurationArn.equals(that.autoScalingConfigurationArn) : that.autoScalingConfigurationArn != null) return false;
            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            if (this.healthCheckConfiguration != null ? !this.healthCheckConfiguration.equals(that.healthCheckConfiguration) : that.healthCheckConfiguration != null) return false;
            if (this.instanceConfiguration != null ? !this.instanceConfiguration.equals(that.instanceConfiguration) : that.instanceConfiguration != null) return false;
            if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
            if (this.observabilityConfiguration != null ? !this.observabilityConfiguration.equals(that.observabilityConfiguration) : that.observabilityConfiguration != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceConfiguration.hashCode();
            result = 31 * result + (this.autoScalingConfigurationArn != null ? this.autoScalingConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.healthCheckConfiguration != null ? this.healthCheckConfiguration.hashCode() : 0);
            result = 31 * result + (this.instanceConfiguration != null ? this.instanceConfiguration.hashCode() : 0);
            result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
            result = 31 * result + (this.observabilityConfiguration != null ? this.observabilityConfiguration.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
