package software.amazon.awscdk.services.autoscaling;

/**
 * MixedInstancesPolicy allows you to configure a group that diversifies across On-Demand Instances and Spot Instances of multiple instance types.
 * <p>
 * For more information, see Auto Scaling groups with
 * multiple instance types and purchase options in the Amazon EC2 Auto Scaling User Guide:
 * <p>
 * https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LaunchTemplate launchTemplate1;
 * LaunchTemplate launchTemplate2;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .mixedInstancesPolicy(MixedInstancesPolicy.builder()
 *                 .instancesDistribution(InstancesDistribution.builder()
 *                         .onDemandPercentageAboveBaseCapacity(50)
 *                         .build())
 *                 .launchTemplate(launchTemplate1)
 *                 .launchTemplateOverrides(List.of(LaunchTemplateOverrides.builder().instanceType(new InstanceType("t3.micro")).build(), LaunchTemplateOverrides.builder().instanceType(new InstanceType("t3a.micro")).build(), LaunchTemplateOverrides.builder().instanceType(new InstanceType("t4g.micro")).launchTemplate(launchTemplate2).build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:03.856Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.MixedInstancesPolicy")
@software.amazon.jsii.Jsii.Proxy(MixedInstancesPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MixedInstancesPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Launch template to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ILaunchTemplate getLaunchTemplate();

    /**
     * InstancesDistribution to use.
     * <p>
     * Default: - The value for each property in it uses a default value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.InstancesDistribution getInstancesDistribution() {
        return null;
    }

    /**
     * Launch template overrides.
     * <p>
     * The maximum number of instance types that can be associated with an Auto Scaling group is 40.
     * <p>
     * The maximum number of distinct launch templates you can define for an Auto Scaling group is 20.
     * <p>
     * Default: - Do not provide any overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides> getLaunchTemplateOverrides() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MixedInstancesPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MixedInstancesPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MixedInstancesPolicy> {
        software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate;
        software.amazon.awscdk.services.autoscaling.InstancesDistribution instancesDistribution;
        java.util.List<software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides> launchTemplateOverrides;

        /**
         * Sets the value of {@link MixedInstancesPolicy#getLaunchTemplate}
         * @param launchTemplate Launch template to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link MixedInstancesPolicy#getInstancesDistribution}
         * @param instancesDistribution InstancesDistribution to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instancesDistribution(software.amazon.awscdk.services.autoscaling.InstancesDistribution instancesDistribution) {
            this.instancesDistribution = instancesDistribution;
            return this;
        }

        /**
         * Sets the value of {@link MixedInstancesPolicy#getLaunchTemplateOverrides}
         * @param launchTemplateOverrides Launch template overrides.
         *                                The maximum number of instance types that can be associated with an Auto Scaling group is 40.
         *                                <p>
         *                                The maximum number of distinct launch templates you can define for an Auto Scaling group is 20.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder launchTemplateOverrides(java.util.List<? extends software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides> launchTemplateOverrides) {
            this.launchTemplateOverrides = (java.util.List<software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides>)launchTemplateOverrides;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MixedInstancesPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MixedInstancesPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MixedInstancesPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MixedInstancesPolicy {
        private final software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate;
        private final software.amazon.awscdk.services.autoscaling.InstancesDistribution instancesDistribution;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides> launchTemplateOverrides;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ILaunchTemplate.class));
            this.instancesDistribution = software.amazon.jsii.Kernel.get(this, "instancesDistribution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.InstancesDistribution.class));
            this.launchTemplateOverrides = software.amazon.jsii.Kernel.get(this, "launchTemplateOverrides", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.launchTemplate = java.util.Objects.requireNonNull(builder.launchTemplate, "launchTemplate is required");
            this.instancesDistribution = builder.instancesDistribution;
            this.launchTemplateOverrides = (java.util.List<software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides>)builder.launchTemplateOverrides;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ILaunchTemplate getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.InstancesDistribution getInstancesDistribution() {
            return this.instancesDistribution;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides> getLaunchTemplateOverrides() {
            return this.launchTemplateOverrides;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            if (this.getInstancesDistribution() != null) {
                data.set("instancesDistribution", om.valueToTree(this.getInstancesDistribution()));
            }
            if (this.getLaunchTemplateOverrides() != null) {
                data.set("launchTemplateOverrides", om.valueToTree(this.getLaunchTemplateOverrides()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.MixedInstancesPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MixedInstancesPolicy.Jsii$Proxy that = (MixedInstancesPolicy.Jsii$Proxy) o;

            if (!launchTemplate.equals(that.launchTemplate)) return false;
            if (this.instancesDistribution != null ? !this.instancesDistribution.equals(that.instancesDistribution) : that.instancesDistribution != null) return false;
            return this.launchTemplateOverrides != null ? this.launchTemplateOverrides.equals(that.launchTemplateOverrides) : that.launchTemplateOverrides == null;
        }

        @Override
        public final int hashCode() {
            int result = this.launchTemplate.hashCode();
            result = 31 * result + (this.instancesDistribution != null ? this.instancesDistribution.hashCode() : 0);
            result = 31 * result + (this.launchTemplateOverrides != null ? this.launchTemplateOverrides.hashCode() : 0);
            return result;
        }
    }
}
