package software.amazon.awscdk.services.batch;

/**
 * Props common to all JobDefinitions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.batch.*;
 * Object parameters;
 * RetryStrategy retryStrategy;
 * JobDefinitionProps jobDefinitionProps = JobDefinitionProps.builder()
 *         .jobDefinitionName("jobDefinitionName")
 *         .parameters(Map.of(
 *                 "parametersKey", parameters))
 *         .retryAttempts(123)
 *         .retryStrategies(List.of(retryStrategy))
 *         .schedulingPriority(123)
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:04.151Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.JobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(JobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of this job definition.
     * <p>
     * Default: - generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters">https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return null;
    }

    /**
     * The number of times to retry a job.
     * <p>
     * The job is retried on failure the same number of attempts as the value.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return null;
    }

    /**
     * Defines the retry behavior for this job.
     * <p>
     * Default: - no `RetryStrategy`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
        return null;
    }

    /**
     * The priority of this Job.
     * <p>
     * Only used in Fairshare Scheduling
     * to decide which job to run first when there are multiple jobs
     * with the same share identifier.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
        return null;
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes,
     * Batch terminates your jobs if they aren't finished.
     * <p>
     * Default: - no timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JobDefinitionProps> {
        java.lang.String jobDefinitionName;
        java.util.Map<java.lang.String, java.lang.Object> parameters;
        java.lang.Number retryAttempts;
        java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies;
        java.lang.Number schedulingPriority;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link JobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name of this job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getParameters}
         * @param parameters The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getRetryAttempts}
         * @param retryAttempts The number of times to retry a job.
         *                      The job is retried on failure the same number of attempts as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getRetryStrategies}
         * @param retryStrategies Defines the retry behavior for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder retryStrategies(java.util.List<? extends software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies) {
            this.retryStrategies = (java.util.List<software.amazon.awscdk.services.batch.RetryStrategy>)retryStrategies;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getSchedulingPriority}
         * @param schedulingPriority The priority of this Job.
         *                           Only used in Fairshare Scheduling
         *                           to decide which job to run first when there are multiple jobs
         *                           with the same share identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(java.lang.Number schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getTimeout}
         * @param timeout The timeout time for jobs that are submitted with this job definition.
         *                After the amount of time you specify passes,
         *                Batch terminates your jobs if they aren't finished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobDefinitionProps {
        private final java.lang.String jobDefinitionName;
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.Number retryAttempts;
        private final java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies;
        private final java.lang.Number schedulingPriority;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.retryStrategies = software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class)));
            this.schedulingPriority = software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobDefinitionName = builder.jobDefinitionName;
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.parameters;
            this.retryAttempts = builder.retryAttempts;
            this.retryStrategies = (java.util.List<software.amazon.awscdk.services.batch.RetryStrategy>)builder.retryStrategies;
            this.schedulingPriority = builder.schedulingPriority;
            this.timeout = builder.timeout;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
            return this.retryStrategies;
        }

        @Override
        public final java.lang.Number getSchedulingPriority() {
            return this.schedulingPriority;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getRetryStrategies() != null) {
                data.set("retryStrategies", om.valueToTree(this.getRetryStrategies()));
            }
            if (this.getSchedulingPriority() != null) {
                data.set("schedulingPriority", om.valueToTree(this.getSchedulingPriority()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.JobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobDefinitionProps.Jsii$Proxy that = (JobDefinitionProps.Jsii$Proxy) o;

            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            if (this.retryStrategies != null ? !this.retryStrategies.equals(that.retryStrategies) : that.retryStrategies != null) return false;
            if (this.schedulingPriority != null ? !this.schedulingPriority.equals(that.schedulingPriority) : that.schedulingPriority != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0;
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.retryStrategies != null ? this.retryStrategies.hashCode() : 0);
            result = 31 * result + (this.schedulingPriority != null ? this.schedulingPriority.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
