package software.amazon.awscdk.services.bedrock;

/**
 * Specifies a knowledge base as a resource in a top-level template. Minimally, you must specify the following properties:.
 * <p>
 * <ul>
 * <li>Name – Specify a name for the knowledge base.</li>
 * <li>RoleArn – Specify the Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-permissions.html">Create a service role for Knowledge base for Amazon Bedrock</a> .</li>
 * <li>KnowledgeBaseConfiguration – Specify the embeddings configuration of the knowledge base. The following sub-properties are required:</li>
 * <li>Type – Specify the value <code>VECTOR</code> .</li>
 * <li>StorageConfiguration – Specify information about the vector store in which the data source is stored. The following sub-properties are required:</li>
 * <li>Type – Specify the vector store service that you are using.</li>
 * </ul>
 * <p>
 * <blockquote>
 * <p>
 * Redis Enterprise Cloud vector stores are currently unsupported in AWS CloudFormation .
 * <p>
 * </blockquote>
 * <p>
 * For more information about using knowledge bases in Amazon Bedrock , see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Knowledge base for Amazon Bedrock</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnKnowledgeBase cfnKnowledgeBase = CfnKnowledgeBase.Builder.create(this, "MyCfnKnowledgeBase")
 *         .knowledgeBaseConfiguration(KnowledgeBaseConfigurationProperty.builder()
 *                 .type("type")
 *                 .vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfigurationProperty.builder()
 *                         .embeddingModelArn("embeddingModelArn")
 *                         // the properties below are optional
 *                         .embeddingModelConfiguration(EmbeddingModelConfigurationProperty.builder()
 *                                 .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
 *                                         .dimensions(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .roleArn("roleArn")
 *         .storageConfiguration(StorageConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .opensearchServerlessConfiguration(OpenSearchServerlessConfigurationProperty.builder()
 *                         .collectionArn("collectionArn")
 *                         .fieldMapping(OpenSearchServerlessFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .vectorIndexName("vectorIndexName")
 *                         .build())
 *                 .pineconeConfiguration(PineconeConfigurationProperty.builder()
 *                         .connectionString("connectionString")
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .fieldMapping(PineconeFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .textField("textField")
 *                                 .build())
 *                         // the properties below are optional
 *                         .namespace("namespace")
 *                         .build())
 *                 .rdsConfiguration(RdsConfigurationProperty.builder()
 *                         .credentialsSecretArn("credentialsSecretArn")
 *                         .databaseName("databaseName")
 *                         .fieldMapping(RdsFieldMappingProperty.builder()
 *                                 .metadataField("metadataField")
 *                                 .primaryKeyField("primaryKeyField")
 *                                 .textField("textField")
 *                                 .vectorField("vectorField")
 *                                 .build())
 *                         .resourceArn("resourceArn")
 *                         .tableName("tableName")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:04.312Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase")
public class CfnKnowledgeBase extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKnowledgeBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnKnowledgeBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time the knowledge base was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A list of reasons that the API operation on the knowledge base failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrFailureReasons() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrFailureReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseArn() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseId() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the knowledge base was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains details about the embeddings configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKnowledgeBaseConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the embeddings configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseConfiguration", java.util.Objects.requireNonNull(value, "knowledgeBaseConfiguration is required"));
    }

    /**
     * Contains details about the embeddings configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseConfiguration", java.util.Objects.requireNonNull(value, "knowledgeBaseConfiguration is required"));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Contains details about the storage configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStorageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "storageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the storage configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageConfiguration", java.util.Objects.requireNonNull(value, "storageConfiguration is required"));
    }

    /**
     * Contains details about the storage configuration of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.StorageConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "storageConfiguration", java.util.Objects.requireNonNull(value, "storageConfiguration is required"));
    }

    /**
     * The description of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The vector configuration details for the Bedrock embeddings model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * BedrockEmbeddingModelConfigurationProperty bedrockEmbeddingModelConfigurationProperty = BedrockEmbeddingModelConfigurationProperty.builder()
     *         .dimensions(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.BedrockEmbeddingModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BedrockEmbeddingModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BedrockEmbeddingModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-bedrockembeddingmodelconfiguration-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-bedrockembeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-bedrockembeddingmodelconfiguration-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDimensions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BedrockEmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BedrockEmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BedrockEmbeddingModelConfigurationProperty> {
            java.lang.Number dimensions;

            /**
             * Sets the value of {@link BedrockEmbeddingModelConfigurationProperty#getDimensions}
             * @param dimensions The dimensions details for the vector configuration used on the Bedrock embeddings model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.lang.Number dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BedrockEmbeddingModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BedrockEmbeddingModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BedrockEmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockEmbeddingModelConfigurationProperty {
            private final java.lang.Number dimensions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
            }

            @Override
            public final java.lang.Number getDimensions() {
                return this.dimensions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.BedrockEmbeddingModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BedrockEmbeddingModelConfigurationProperty.Jsii$Proxy that = (BedrockEmbeddingModelConfigurationProperty.Jsii$Proxy) o;

                return this.dimensions != null ? this.dimensions.equals(that.dimensions) : that.dimensions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration details for the embeddings model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * EmbeddingModelConfigurationProperty embeddingModelConfigurationProperty = EmbeddingModelConfigurationProperty.builder()
     *         .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
     *                 .dimensions(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.EmbeddingModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddingModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddingModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The vector configuration details on the Bedrock embeddings model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-embeddingmodelconfiguration-bedrockembeddingmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-embeddingmodelconfiguration.html#cfn-bedrock-knowledgebase-embeddingmodelconfiguration-bedrockembeddingmodelconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBedrockEmbeddingModelConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmbeddingModelConfigurationProperty> {
            java.lang.Object bedrockEmbeddingModelConfiguration;

            /**
             * Sets the value of {@link EmbeddingModelConfigurationProperty#getBedrockEmbeddingModelConfiguration}
             * @param bedrockEmbeddingModelConfiguration The vector configuration details on the Bedrock embeddings model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockEmbeddingModelConfiguration(software.amazon.awscdk.IResolvable bedrockEmbeddingModelConfiguration) {
                this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EmbeddingModelConfigurationProperty#getBedrockEmbeddingModelConfiguration}
             * @param bedrockEmbeddingModelConfiguration The vector configuration details on the Bedrock embeddings model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockEmbeddingModelConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.BedrockEmbeddingModelConfigurationProperty bedrockEmbeddingModelConfiguration) {
                this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmbeddingModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmbeddingModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmbeddingModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmbeddingModelConfigurationProperty {
            private final java.lang.Object bedrockEmbeddingModelConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bedrockEmbeddingModelConfiguration = software.amazon.jsii.Kernel.get(this, "bedrockEmbeddingModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bedrockEmbeddingModelConfiguration = builder.bedrockEmbeddingModelConfiguration;
            }

            @Override
            public final java.lang.Object getBedrockEmbeddingModelConfiguration() {
                return this.bedrockEmbeddingModelConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBedrockEmbeddingModelConfiguration() != null) {
                    data.set("bedrockEmbeddingModelConfiguration", om.valueToTree(this.getBedrockEmbeddingModelConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.EmbeddingModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmbeddingModelConfigurationProperty.Jsii$Proxy that = (EmbeddingModelConfigurationProperty.Jsii$Proxy) o;

                return this.bedrockEmbeddingModelConfiguration != null ? this.bedrockEmbeddingModelConfiguration.equals(that.bedrockEmbeddingModelConfiguration) : that.bedrockEmbeddingModelConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bedrockEmbeddingModelConfiguration != null ? this.bedrockEmbeddingModelConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configurations to apply to a knowledge base attached to the agent during query.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html#session-state-kb">Knowledge base retrieval configurations</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * KnowledgeBaseConfigurationProperty knowledgeBaseConfigurationProperty = KnowledgeBaseConfigurationProperty.builder()
     *         .type("type")
     *         .vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfigurationProperty.builder()
     *                 .embeddingModelArn("embeddingModelArn")
     *                 // the properties below are optional
     *                 .embeddingModelConfiguration(EmbeddingModelConfigurationProperty.builder()
     *                         .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
     *                                 .dimensions(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KnowledgeBaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KnowledgeBaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of data that the data source is converted into for the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Contains details about the model that's used to convert the data source into vector embeddings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-vectorknowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-knowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration-vectorknowledgebaseconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVectorKnowledgeBaseConfiguration();

        /**
         * @return a {@link Builder} of {@link KnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBaseConfigurationProperty> {
            java.lang.String type;
            java.lang.Object vectorKnowledgeBaseConfiguration;

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getType}
             * @param type The type of data that the data source is converted into for the knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getVectorKnowledgeBaseConfiguration}
             * @param vectorKnowledgeBaseConfiguration Contains details about the model that's used to convert the data source into vector embeddings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorKnowledgeBaseConfiguration(software.amazon.awscdk.IResolvable vectorKnowledgeBaseConfiguration) {
                this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseConfigurationProperty#getVectorKnowledgeBaseConfiguration}
             * @param vectorKnowledgeBaseConfiguration Contains details about the model that's used to convert the data source into vector embeddings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorKnowledgeBaseConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.VectorKnowledgeBaseConfigurationProperty vectorKnowledgeBaseConfiguration) {
                this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KnowledgeBaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KnowledgeBaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBaseConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object vectorKnowledgeBaseConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vectorKnowledgeBaseConfiguration = software.amazon.jsii.Kernel.get(this, "vectorKnowledgeBaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.vectorKnowledgeBaseConfiguration = java.util.Objects.requireNonNull(builder.vectorKnowledgeBaseConfiguration, "vectorKnowledgeBaseConfiguration is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getVectorKnowledgeBaseConfiguration() {
                return this.vectorKnowledgeBaseConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("vectorKnowledgeBaseConfiguration", om.valueToTree(this.getVectorKnowledgeBaseConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KnowledgeBaseConfigurationProperty.Jsii$Proxy that = (KnowledgeBaseConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.vectorKnowledgeBaseConfiguration.equals(that.vectorKnowledgeBaseConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.vectorKnowledgeBaseConfiguration.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in Amazon OpenSearch Service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html">Create a vector index in Amazon OpenSearch Service</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * OpenSearchServerlessConfigurationProperty openSearchServerlessConfigurationProperty = OpenSearchServerlessConfigurationProperty.builder()
     *         .collectionArn("collectionArn")
     *         .fieldMapping(OpenSearchServerlessFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .textField("textField")
     *                 .vectorField("vectorField")
     *                 .build())
     *         .vectorIndexName("vectorIndexName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchServerlessConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchServerlessConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-collectionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-collectionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCollectionArn();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The name of the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-vectorindexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessconfiguration.html#cfn-bedrock-knowledgebase-opensearchserverlessconfiguration-vectorindexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorIndexName();

        /**
         * @return a {@link Builder} of {@link OpenSearchServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchServerlessConfigurationProperty> {
            java.lang.String collectionArn;
            java.lang.Object fieldMapping;
            java.lang.String vectorIndexName;

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getCollectionArn}
             * @param collectionArn The Amazon Resource Name (ARN) of the OpenSearch Service vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionArn(java.lang.String collectionArn) {
                this.collectionArn = collectionArn;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.OpenSearchServerlessFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessConfigurationProperty#getVectorIndexName}
             * @param vectorIndexName The name of the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorIndexName(java.lang.String vectorIndexName) {
                this.vectorIndexName = vectorIndexName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchServerlessConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchServerlessConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchServerlessConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchServerlessConfigurationProperty {
            private final java.lang.String collectionArn;
            private final java.lang.Object fieldMapping;
            private final java.lang.String vectorIndexName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectionArn = software.amazon.jsii.Kernel.get(this, "collectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vectorIndexName = software.amazon.jsii.Kernel.get(this, "vectorIndexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionArn = java.util.Objects.requireNonNull(builder.collectionArn, "collectionArn is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.vectorIndexName = java.util.Objects.requireNonNull(builder.vectorIndexName, "vectorIndexName is required");
            }

            @Override
            public final java.lang.String getCollectionArn() {
                return this.collectionArn;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getVectorIndexName() {
                return this.vectorIndexName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("collectionArn", om.valueToTree(this.getCollectionArn()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                data.set("vectorIndexName", om.valueToTree(this.getVectorIndexName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchServerlessConfigurationProperty.Jsii$Proxy that = (OpenSearchServerlessConfigurationProperty.Jsii$Proxy) o;

                if (!collectionArn.equals(that.collectionArn)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                return this.vectorIndexName.equals(that.vectorIndexName);
            }

            @Override
            public final int hashCode() {
                int result = this.collectionArn.hashCode();
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.vectorIndexName.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * OpenSearchServerlessFieldMappingProperty openSearchServerlessFieldMappingProperty = OpenSearchServerlessFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .textField("textField")
     *         .vectorField("vectorField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchServerlessFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchServerlessFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-vectorfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-opensearchserverlessfieldmapping.html#cfn-bedrock-knowledgebase-opensearchserverlessfieldmapping-vectorfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorField();

        /**
         * @return a {@link Builder} of {@link OpenSearchServerlessFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchServerlessFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchServerlessFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String textField;
            java.lang.String vectorField;

            /**
             * Sets the value of {@link OpenSearchServerlessFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServerlessFieldMappingProperty#getVectorField}
             * @param vectorField The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorField(java.lang.String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchServerlessFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchServerlessFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchServerlessFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchServerlessFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String textField;
            private final java.lang.String vectorField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vectorField = software.amazon.jsii.Kernel.get(this, "vectorField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
                this.vectorField = java.util.Objects.requireNonNull(builder.vectorField, "vectorField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            public final java.lang.String getVectorField() {
                return this.vectorField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("textField", om.valueToTree(this.getTextField()));
                data.set("vectorField", om.valueToTree(this.getVectorField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchServerlessFieldMappingProperty.Jsii$Proxy that = (OpenSearchServerlessFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                if (!textField.equals(that.textField)) return false;
                return this.vectorField.equals(that.vectorField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.textField.hashCode());
                result = 31 * result + (this.vectorField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in Pinecone.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html">Create a vector index in Pinecone</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PineconeConfigurationProperty pineconeConfigurationProperty = PineconeConfigurationProperty.builder()
     *         .connectionString("connectionString")
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .fieldMapping(PineconeFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .textField("textField")
     *                 .build())
     *         // the properties below are optional
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PineconeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PineconeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint URL for your index management page.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-connectionstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-connectionstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectionString();

        /**
         * The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The namespace to be used to write new data to your database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconeconfiguration.html#cfn-bedrock-knowledgebase-pineconeconfiguration-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PineconeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PineconeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PineconeConfigurationProperty> {
            java.lang.String connectionString;
            java.lang.String credentialsSecretArn;
            java.lang.Object fieldMapping;
            java.lang.String namespace;

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getConnectionString}
             * @param connectionString The endpoint URL for your index management page. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionString(java.lang.String connectionString) {
                this.connectionString = connectionString;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.PineconeFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link PineconeConfigurationProperty#getNamespace}
             * @param namespace The namespace to be used to write new data to your database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PineconeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PineconeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PineconeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PineconeConfigurationProperty {
            private final java.lang.String connectionString;
            private final java.lang.String credentialsSecretArn;
            private final java.lang.Object fieldMapping;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionString = software.amazon.jsii.Kernel.get(this, "connectionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionString = java.util.Objects.requireNonNull(builder.connectionString, "connectionString is required");
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.String getConnectionString() {
                return this.connectionString;
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectionString", om.valueToTree(this.getConnectionString()));
                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PineconeConfigurationProperty.Jsii$Proxy that = (PineconeConfigurationProperty.Jsii$Proxy) o;

                if (!connectionString.equals(that.connectionString)) return false;
                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionString.hashCode();
                result = 31 * result + (this.credentialsSecretArn.hashCode());
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PineconeFieldMappingProperty pineconeFieldMappingProperty = PineconeFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .textField("textField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(PineconeFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PineconeFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-pineconefieldmapping.html#cfn-bedrock-knowledgebase-pineconefieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * @return a {@link Builder} of {@link PineconeFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PineconeFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PineconeFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String textField;

            /**
             * Sets the value of {@link PineconeFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link PineconeFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PineconeFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PineconeFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PineconeFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PineconeFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String textField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("textField", om.valueToTree(this.getTextField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PineconeFieldMappingProperty.Jsii$Proxy that = (PineconeFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                return this.textField.equals(that.textField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.textField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains details about the storage configuration of the knowledge base in Amazon RDS.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RdsConfigurationProperty rdsConfigurationProperty = RdsConfigurationProperty.builder()
     *         .credentialsSecretArn("credentialsSecretArn")
     *         .databaseName("databaseName")
     *         .fieldMapping(RdsFieldMappingProperty.builder()
     *                 .metadataField("metadataField")
     *                 .primaryKeyField("primaryKeyField")
     *                 .textField("textField")
     *                 .vectorField("vectorField")
     *                 .build())
     *         .resourceArn("resourceArn")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-credentialssecretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-credentialssecretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsSecretArn();

        /**
         * The name of your Amazon RDS database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * Contains the names of the fields to which to map information about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-fieldmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-fieldmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldMapping();

        /**
         * The Amazon Resource Name (ARN) of the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-resourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * The name of the table in the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsconfiguration.html#cfn-bedrock-knowledgebase-rdsconfiguration-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link RdsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsConfigurationProperty> {
            java.lang.String credentialsSecretArn;
            java.lang.String databaseName;
            java.lang.Object fieldMapping;
            java.lang.String resourceArn;
            java.lang.String tableName;

            /**
             * Sets the value of {@link RdsConfigurationProperty#getCredentialsSecretArn}
             * @param credentialsSecretArn The Amazon Resource Name (ARN) of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsSecretArn(java.lang.String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getDatabaseName}
             * @param databaseName The name of your Amazon RDS database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getFieldMapping}
             * @param fieldMapping Contains the names of the fields to which to map information about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMapping(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RdsFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getResourceArn}
             * @param resourceArn The Amazon Resource Name (ARN) of the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link RdsConfigurationProperty#getTableName}
             * @param tableName The name of the table in the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RdsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsConfigurationProperty {
            private final java.lang.String credentialsSecretArn;
            private final java.lang.String databaseName;
            private final java.lang.Object fieldMapping;
            private final java.lang.String resourceArn;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentialsSecretArn = software.amazon.jsii.Kernel.get(this, "credentialsSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMapping = software.amazon.jsii.Kernel.get(this, "fieldMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentialsSecretArn = java.util.Objects.requireNonNull(builder.credentialsSecretArn, "credentialsSecretArn is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.fieldMapping = java.util.Objects.requireNonNull(builder.fieldMapping, "fieldMapping is required");
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getCredentialsSecretArn() {
                return this.credentialsSecretArn;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Object getFieldMapping() {
                return this.fieldMapping;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentialsSecretArn", om.valueToTree(this.getCredentialsSecretArn()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("fieldMapping", om.valueToTree(this.getFieldMapping()));
                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsConfigurationProperty.Jsii$Proxy that = (RdsConfigurationProperty.Jsii$Proxy) o;

                if (!credentialsSecretArn.equals(that.credentialsSecretArn)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (!fieldMapping.equals(that.fieldMapping)) return false;
                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.credentialsSecretArn.hashCode();
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.fieldMapping.hashCode());
                result = 31 * result + (this.resourceArn.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the names of the fields to which to map information about the vector store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RdsFieldMappingProperty rdsFieldMappingProperty = RdsFieldMappingProperty.builder()
     *         .metadataField("metadataField")
     *         .primaryKeyField("primaryKeyField")
     *         .textField("textField")
     *         .vectorField("vectorField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-metadatafield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-metadatafield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataField();

        /**
         * The name of the field in which Amazon Bedrock stores the ID for each entry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-primarykeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-primarykeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrimaryKeyField();

        /**
         * The name of the field in which Amazon Bedrock stores the raw text from your data.
         * <p>
         * The text is split according to the chunking strategy you choose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-textfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-textfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextField();

        /**
         * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-vectorfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-rdsfieldmapping.html#cfn-bedrock-knowledgebase-rdsfieldmapping-vectorfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVectorField();

        /**
         * @return a {@link Builder} of {@link RdsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsFieldMappingProperty> {
            java.lang.String metadataField;
            java.lang.String primaryKeyField;
            java.lang.String textField;
            java.lang.String vectorField;

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getMetadataField}
             * @param metadataField The name of the field in which Amazon Bedrock stores metadata about the vector store. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataField(java.lang.String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getPrimaryKeyField}
             * @param primaryKeyField The name of the field in which Amazon Bedrock stores the ID for each entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryKeyField(java.lang.String primaryKeyField) {
                this.primaryKeyField = primaryKeyField;
                return this;
            }

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getTextField}
             * @param textField The name of the field in which Amazon Bedrock stores the raw text from your data. This parameter is required.
             *                  The text is split according to the chunking strategy you choose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textField(java.lang.String textField) {
                this.textField = textField;
                return this;
            }

            /**
             * Sets the value of {@link RdsFieldMappingProperty#getVectorField}
             * @param vectorField The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vectorField(java.lang.String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RdsFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsFieldMappingProperty {
            private final java.lang.String metadataField;
            private final java.lang.String primaryKeyField;
            private final java.lang.String textField;
            private final java.lang.String vectorField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataField = software.amazon.jsii.Kernel.get(this, "metadataField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryKeyField = software.amazon.jsii.Kernel.get(this, "primaryKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textField = software.amazon.jsii.Kernel.get(this, "textField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vectorField = software.amazon.jsii.Kernel.get(this, "vectorField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataField = java.util.Objects.requireNonNull(builder.metadataField, "metadataField is required");
                this.primaryKeyField = java.util.Objects.requireNonNull(builder.primaryKeyField, "primaryKeyField is required");
                this.textField = java.util.Objects.requireNonNull(builder.textField, "textField is required");
                this.vectorField = java.util.Objects.requireNonNull(builder.vectorField, "vectorField is required");
            }

            @Override
            public final java.lang.String getMetadataField() {
                return this.metadataField;
            }

            @Override
            public final java.lang.String getPrimaryKeyField() {
                return this.primaryKeyField;
            }

            @Override
            public final java.lang.String getTextField() {
                return this.textField;
            }

            @Override
            public final java.lang.String getVectorField() {
                return this.vectorField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metadataField", om.valueToTree(this.getMetadataField()));
                data.set("primaryKeyField", om.valueToTree(this.getPrimaryKeyField()));
                data.set("textField", om.valueToTree(this.getTextField()));
                data.set("vectorField", om.valueToTree(this.getVectorField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsFieldMappingProperty.Jsii$Proxy that = (RdsFieldMappingProperty.Jsii$Proxy) o;

                if (!metadataField.equals(that.metadataField)) return false;
                if (!primaryKeyField.equals(that.primaryKeyField)) return false;
                if (!textField.equals(that.textField)) return false;
                return this.vectorField.equals(that.vectorField);
            }

            @Override
            public final int hashCode() {
                int result = this.metadataField.hashCode();
                result = 31 * result + (this.primaryKeyField.hashCode());
                result = 31 * result + (this.textField.hashCode());
                result = 31 * result + (this.vectorField.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the storage configuration of the knowledge base.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageConfigurationProperty storageConfigurationProperty = StorageConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .opensearchServerlessConfiguration(OpenSearchServerlessConfigurationProperty.builder()
     *                 .collectionArn("collectionArn")
     *                 .fieldMapping(OpenSearchServerlessFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .textField("textField")
     *                         .vectorField("vectorField")
     *                         .build())
     *                 .vectorIndexName("vectorIndexName")
     *                 .build())
     *         .pineconeConfiguration(PineconeConfigurationProperty.builder()
     *                 .connectionString("connectionString")
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .fieldMapping(PineconeFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .textField("textField")
     *                         .build())
     *                 // the properties below are optional
     *                 .namespace("namespace")
     *                 .build())
     *         .rdsConfiguration(RdsConfigurationProperty.builder()
     *                 .credentialsSecretArn("credentialsSecretArn")
     *                 .databaseName("databaseName")
     *                 .fieldMapping(RdsFieldMappingProperty.builder()
     *                         .metadataField("metadataField")
     *                         .primaryKeyField("primaryKeyField")
     *                         .textField("textField")
     *                         .vectorField("vectorField")
     *                         .build())
     *                 .resourceArn("resourceArn")
     *                 .tableName("tableName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.StorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The vector store service in which the knowledge base is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-opensearchserverlessconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-opensearchserverlessconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpensearchServerlessConfiguration() {
            return null;
        }

        /**
         * Contains the storage configuration of the knowledge base in Pinecone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-pineconeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-pineconeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPineconeConfiguration() {
            return null;
        }

        /**
         * Contains details about the storage configuration of the knowledge base in Amazon RDS.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-rdsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-storageconfiguration.html#cfn-bedrock-knowledgebase-storageconfiguration-rdsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRdsConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageConfigurationProperty> {
            java.lang.String type;
            java.lang.Object opensearchServerlessConfiguration;
            java.lang.Object pineconeConfiguration;
            java.lang.Object rdsConfiguration;

            /**
             * Sets the value of {@link StorageConfigurationProperty#getType}
             * @param type The vector store service in which the knowledge base is stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getOpensearchServerlessConfiguration}
             * @param opensearchServerlessConfiguration Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder opensearchServerlessConfiguration(software.amazon.awscdk.IResolvable opensearchServerlessConfiguration) {
                this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getOpensearchServerlessConfiguration}
             * @param opensearchServerlessConfiguration Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder opensearchServerlessConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.OpenSearchServerlessConfigurationProperty opensearchServerlessConfiguration) {
                this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getPineconeConfiguration}
             * @param pineconeConfiguration Contains the storage configuration of the knowledge base in Pinecone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pineconeConfiguration(software.amazon.awscdk.IResolvable pineconeConfiguration) {
                this.pineconeConfiguration = pineconeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getPineconeConfiguration}
             * @param pineconeConfiguration Contains the storage configuration of the knowledge base in Pinecone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pineconeConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.PineconeConfigurationProperty pineconeConfiguration) {
                this.pineconeConfiguration = pineconeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getRdsConfiguration}
             * @param rdsConfiguration Contains details about the storage configuration of the knowledge base in Amazon RDS.
             *                         For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsConfiguration(software.amazon.awscdk.IResolvable rdsConfiguration) {
                this.rdsConfiguration = rdsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageConfigurationProperty#getRdsConfiguration}
             * @param rdsConfiguration Contains details about the storage configuration of the knowledge base in Amazon RDS.
             *                         For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.RdsConfigurationProperty rdsConfiguration) {
                this.rdsConfiguration = rdsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object opensearchServerlessConfiguration;
            private final java.lang.Object pineconeConfiguration;
            private final java.lang.Object rdsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.opensearchServerlessConfiguration = software.amazon.jsii.Kernel.get(this, "opensearchServerlessConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pineconeConfiguration = software.amazon.jsii.Kernel.get(this, "pineconeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rdsConfiguration = software.amazon.jsii.Kernel.get(this, "rdsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.opensearchServerlessConfiguration = builder.opensearchServerlessConfiguration;
                this.pineconeConfiguration = builder.pineconeConfiguration;
                this.rdsConfiguration = builder.rdsConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getOpensearchServerlessConfiguration() {
                return this.opensearchServerlessConfiguration;
            }

            @Override
            public final java.lang.Object getPineconeConfiguration() {
                return this.pineconeConfiguration;
            }

            @Override
            public final java.lang.Object getRdsConfiguration() {
                return this.rdsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getOpensearchServerlessConfiguration() != null) {
                    data.set("opensearchServerlessConfiguration", om.valueToTree(this.getOpensearchServerlessConfiguration()));
                }
                if (this.getPineconeConfiguration() != null) {
                    data.set("pineconeConfiguration", om.valueToTree(this.getPineconeConfiguration()));
                }
                if (this.getRdsConfiguration() != null) {
                    data.set("rdsConfiguration", om.valueToTree(this.getRdsConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.StorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageConfigurationProperty.Jsii$Proxy that = (StorageConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.opensearchServerlessConfiguration != null ? !this.opensearchServerlessConfiguration.equals(that.opensearchServerlessConfiguration) : that.opensearchServerlessConfiguration != null) return false;
                if (this.pineconeConfiguration != null ? !this.pineconeConfiguration.equals(that.pineconeConfiguration) : that.pineconeConfiguration != null) return false;
                return this.rdsConfiguration != null ? this.rdsConfiguration.equals(that.rdsConfiguration) : that.rdsConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.opensearchServerlessConfiguration != null ? this.opensearchServerlessConfiguration.hashCode() : 0);
                result = 31 * result + (this.pineconeConfiguration != null ? this.pineconeConfiguration.hashCode() : 0);
                result = 31 * result + (this.rdsConfiguration != null ? this.rdsConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about the model used to create vector embeddings for the knowledge base.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VectorKnowledgeBaseConfigurationProperty vectorKnowledgeBaseConfigurationProperty = VectorKnowledgeBaseConfigurationProperty.builder()
     *         .embeddingModelArn("embeddingModelArn")
     *         // the properties below are optional
     *         .embeddingModelConfiguration(EmbeddingModelConfigurationProperty.builder()
     *                 .bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty.builder()
     *                         .dimensions(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.VectorKnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorKnowledgeBaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorKnowledgeBaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the model or inference profile used to create vector embeddings for the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEmbeddingModelArn();

        /**
         * The embeddings model configuration details for the vector model used in Knowledge Base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-knowledgebase-vectorknowledgebaseconfiguration.html#cfn-bedrock-knowledgebase-vectorknowledgebaseconfiguration-embeddingmodelconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddingModelConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorKnowledgeBaseConfigurationProperty> {
            java.lang.String embeddingModelArn;
            java.lang.Object embeddingModelConfiguration;

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getEmbeddingModelArn}
             * @param embeddingModelArn The Amazon Resource Name (ARN) of the model or inference profile used to create vector embeddings for the knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddingModelArn(java.lang.String embeddingModelArn) {
                this.embeddingModelArn = embeddingModelArn;
                return this;
            }

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getEmbeddingModelConfiguration}
             * @param embeddingModelConfiguration The embeddings model configuration details for the vector model used in Knowledge Base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddingModelConfiguration(software.amazon.awscdk.IResolvable embeddingModelConfiguration) {
                this.embeddingModelConfiguration = embeddingModelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorKnowledgeBaseConfigurationProperty#getEmbeddingModelConfiguration}
             * @param embeddingModelConfiguration The embeddings model configuration details for the vector model used in Knowledge Base.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddingModelConfiguration(software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.EmbeddingModelConfigurationProperty embeddingModelConfiguration) {
                this.embeddingModelConfiguration = embeddingModelConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorKnowledgeBaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorKnowledgeBaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorKnowledgeBaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorKnowledgeBaseConfigurationProperty {
            private final java.lang.String embeddingModelArn;
            private final java.lang.Object embeddingModelConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.embeddingModelArn = software.amazon.jsii.Kernel.get(this, "embeddingModelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.embeddingModelConfiguration = software.amazon.jsii.Kernel.get(this, "embeddingModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.embeddingModelArn = java.util.Objects.requireNonNull(builder.embeddingModelArn, "embeddingModelArn is required");
                this.embeddingModelConfiguration = builder.embeddingModelConfiguration;
            }

            @Override
            public final java.lang.String getEmbeddingModelArn() {
                return this.embeddingModelArn;
            }

            @Override
            public final java.lang.Object getEmbeddingModelConfiguration() {
                return this.embeddingModelConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("embeddingModelArn", om.valueToTree(this.getEmbeddingModelArn()));
                if (this.getEmbeddingModelConfiguration() != null) {
                    data.set("embeddingModelConfiguration", om.valueToTree(this.getEmbeddingModelConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.VectorKnowledgeBaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorKnowledgeBaseConfigurationProperty.Jsii$Proxy that = (VectorKnowledgeBaseConfigurationProperty.Jsii$Proxy) o;

                if (!embeddingModelArn.equals(that.embeddingModelArn)) return false;
                return this.embeddingModelConfiguration != null ? this.embeddingModelConfiguration.equals(that.embeddingModelConfiguration) : that.embeddingModelConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.embeddingModelArn.hashCode();
                result = 31 * result + (this.embeddingModelConfiguration != null ? this.embeddingModelConfiguration.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnKnowledgeBase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnKnowledgeBase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnKnowledgeBaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnKnowledgeBaseProps.Builder();
        }

        /**
         * Contains details about the embeddings configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration</a>
         * @param knowledgeBaseConfiguration Contains details about the embeddings configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseConfiguration(final software.amazon.awscdk.IResolvable knowledgeBaseConfiguration) {
            this.props.knowledgeBaseConfiguration(knowledgeBaseConfiguration);
            return this;
        }
        /**
         * Contains details about the embeddings configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-knowledgebaseconfiguration</a>
         * @param knowledgeBaseConfiguration Contains details about the embeddings configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseConfiguration(final software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty knowledgeBaseConfiguration) {
            this.props.knowledgeBaseConfiguration(knowledgeBaseConfiguration);
            return this;
        }

        /**
         * The name of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-name</a>
         * @param name The name of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Contains details about the storage configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration</a>
         * @param storageConfiguration Contains details about the storage configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfiguration(final software.amazon.awscdk.IResolvable storageConfiguration) {
            this.props.storageConfiguration(storageConfiguration);
            return this;
        }
        /**
         * Contains details about the storage configuration of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-storageconfiguration</a>
         * @param storageConfiguration Contains details about the storage configuration of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageConfiguration(final software.amazon.awscdk.services.bedrock.CfnKnowledgeBase.StorageConfigurationProperty storageConfiguration) {
            this.props.storageConfiguration(storageConfiguration);
            return this;
        }

        /**
         * The description of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-description</a>
         * @param description The description of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-knowledgebase.html#cfn-bedrock-knowledgebase-tags</a>
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnKnowledgeBase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnKnowledgeBase build() {
            return new software.amazon.awscdk.services.bedrock.CfnKnowledgeBase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
