package software.amazon.awscdk.services.cloudfront;

/**
 * The properties to create a Key Value Store.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * KeyValueStore storeAsset = KeyValueStore.Builder.create(this, "KeyValueStoreAsset")
 *         .keyValueStoreName("KeyValueStoreAsset")
 *         .source(ImportSource.fromAsset("path-to-data.json"))
 *         .build();
 * KeyValueStore storeInline = KeyValueStore.Builder.create(this, "KeyValueStoreInline")
 *         .keyValueStoreName("KeyValueStoreInline")
 *         .source(ImportSource.fromInline(JSON.stringify(Map.of(
 *                 "data", List.of(Map.of(
 *                         "key", "key1",
 *                         "value", "value1"), Map.of(
 *                         "key", "key2",
 *                         "value", "value2"))))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:04.734Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.KeyValueStoreProps")
@software.amazon.jsii.Jsii.Proxy(KeyValueStoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeyValueStoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A comment for the Key Value Store.
     * <p>
     * Default: No comment will be specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * The unique name of the Key Value Store.
     * <p>
     * Default: A generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyValueStoreName() {
        return null;
    }

    /**
     * The import source for the Key Value Store.
     * <p>
     * This will populate the initial items in the Key Value Store. The
     * source data must be in a valid JSON format.
     * <p>
     * Default: No data will be imported to the store
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ImportSource getSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KeyValueStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeyValueStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeyValueStoreProps> {
        java.lang.String comment;
        java.lang.String keyValueStoreName;
        software.amazon.awscdk.services.cloudfront.ImportSource source;

        /**
         * Sets the value of {@link KeyValueStoreProps#getComment}
         * @param comment A comment for the Key Value Store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link KeyValueStoreProps#getKeyValueStoreName}
         * @param keyValueStoreName The unique name of the Key Value Store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueStoreName(java.lang.String keyValueStoreName) {
            this.keyValueStoreName = keyValueStoreName;
            return this;
        }

        /**
         * Sets the value of {@link KeyValueStoreProps#getSource}
         * @param source The import source for the Key Value Store.
         *               This will populate the initial items in the Key Value Store. The
         *               source data must be in a valid JSON format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.services.cloudfront.ImportSource source) {
            this.source = source;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeyValueStoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeyValueStoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeyValueStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValueStoreProps {
        private final java.lang.String comment;
        private final java.lang.String keyValueStoreName;
        private final software.amazon.awscdk.services.cloudfront.ImportSource source;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyValueStoreName = software.amazon.jsii.Kernel.get(this, "keyValueStoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ImportSource.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.keyValueStoreName = builder.keyValueStoreName;
            this.source = builder.source;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getKeyValueStoreName() {
            return this.keyValueStoreName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ImportSource getSource() {
            return this.source;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getKeyValueStoreName() != null) {
                data.set("keyValueStoreName", om.valueToTree(this.getKeyValueStoreName()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.KeyValueStoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeyValueStoreProps.Jsii$Proxy that = (KeyValueStoreProps.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.keyValueStoreName != null ? !this.keyValueStoreName.equals(that.keyValueStoreName) : that.keyValueStoreName != null) return false;
            return this.source != null ? this.source.equals(that.source) : that.source == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.keyValueStoreName != null ? this.keyValueStoreName.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            return result;
        }
    }
}
