package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Types of EC2 actions available.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Alarm must be configured with an EC2 per-instance metric
 * Alarm alarm;
 * // Attach a reboot when alarm triggers
 * alarm.addAlarmAction(
 * new Ec2Action(Ec2InstanceAction.REBOOT));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:04.984Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch_actions.Ec2InstanceAction")
public enum Ec2InstanceAction {
    /**
     * Stop the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STOP,
    /**
     * Terminatethe instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERMINATE,
    /**
     * Recover the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RECOVER,
    /**
     * Reboot the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REBOOT,
}
