package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Use a Lambda action as an Alarm action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Alarm alarm;
 * Function fn;
 * Alias alias;
 * Version version;
 * // Attach a Lambda Function when alarm triggers
 * alarm.addAlarmAction(
 * new LambdaAction(fn));
 * // Attach a Lambda Function Alias when alarm triggers
 * alarm.addAlarmAction(
 * new LambdaAction(alias));
 * // Attach a Lambda Function version when alarm triggers
 * alarm.addAlarmAction(
 * new LambdaAction(version));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:04.984Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch_actions.LambdaAction")
public class LambdaAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IAlarmAction {

    protected LambdaAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param lambdaFunction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaAction(final @org.jetbrains.annotations.NotNull java.lang.Object lambdaFunction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (
                 !(lambdaFunction instanceof software.amazon.awscdk.services.lambda.IFunction)
                && !(lambdaFunction instanceof software.amazon.awscdk.services.lambda.IVersion)
                && !(lambdaFunction instanceof software.amazon.awscdk.services.lambda.IAlias)
                && !(lambdaFunction.getClass().equals(software.amazon.jsii.JsiiObject.class))
            ) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("lambdaFunction")
                        .append(" to be one of: software.amazon.awscdk.services.lambda.IFunction, software.amazon.awscdk.services.lambda.IVersion, software.amazon.awscdk.services.lambda.IAlias; received ")
                        .append(lambdaFunction.getClass()).toString());
            }
        }
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required") });
    }

    /**
     * Returns an alarm action configuration to use a Lambda action as an alarm action.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html</a>
     * @param scope This parameter is required.
     * @param alarm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmActionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm alarm) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.AlarmActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(alarm, "alarm is required") });
    }
}
