package software.amazon.awscdk.services.codecommit;

/**
 * Represents the contents to initialize the repository with.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository repo = Repository.Builder.create(this, "Repository")
 *         .repositoryName("MyRepositoryName")
 *         .code(Code.fromDirectory(join(__dirname, "directory/"), "develop"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:05.138Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codecommit.Code")
public abstract class Code extends software.amazon.jsii.JsiiObject {

    protected Code(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Code(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Code() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Code from user-supplied asset.
     * <p>
     * @param asset pre-existing asset. This parameter is required.
     * @param branch the name of the branch to create in the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Code fromAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.assets.Asset asset, final @org.jetbrains.annotations.Nullable java.lang.String branch) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Code.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required"), branch });
    }

    /**
     * Code from user-supplied asset.
     * <p>
     * @param asset pre-existing asset. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Code fromAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.assets.Asset asset) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Code.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Code from directory.
     * <p>
     * @param directoryPath the path to the local directory containing the contents to initialize the repository with. This parameter is required.
     * @param branch the name of the branch to create in the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Code fromDirectory(final @org.jetbrains.annotations.NotNull java.lang.String directoryPath, final @org.jetbrains.annotations.Nullable java.lang.String branch) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Code.class, "fromDirectory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Code.class), new Object[] { java.util.Objects.requireNonNull(directoryPath, "directoryPath is required"), branch });
    }

    /**
     * Code from directory.
     * <p>
     * @param directoryPath the path to the local directory containing the contents to initialize the repository with. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Code fromDirectory(final @org.jetbrains.annotations.NotNull java.lang.String directoryPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Code.class, "fromDirectory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Code.class), new Object[] { java.util.Objects.requireNonNull(directoryPath, "directoryPath is required") });
    }

    /**
     * Code from preexisting ZIP file.
     * <p>
     * @param filePath the path to the local ZIP file containing the contents to initialize the repository with. This parameter is required.
     * @param branch the name of the branch to create in the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Code fromZipFile(final @org.jetbrains.annotations.NotNull java.lang.String filePath, final @org.jetbrains.annotations.Nullable java.lang.String branch) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Code.class, "fromZipFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Code.class), new Object[] { java.util.Objects.requireNonNull(filePath, "filePath is required"), branch });
    }

    /**
     * Code from preexisting ZIP file.
     * <p>
     * @param filePath the path to the local ZIP file containing the contents to initialize the repository with. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Code fromZipFile(final @org.jetbrains.annotations.NotNull java.lang.String filePath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Code.class, "fromZipFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Code.class), new Object[] { java.util.Objects.requireNonNull(filePath, "filePath is required") });
    }

    /**
     * This method is called after a repository is passed this instance of Code in its 'code' property.
     * <p>
     * @param scope the binding scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codecommit.Code {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * This method is called after a repository is passed this instance of Code in its 'code' property.
         * <p>
         * @param scope the binding scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
