package software.amazon.awscdk.services.codecommit;

/**
 * Additional options to pass to the notification rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codecommit.*;
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * RepositoryNotifyOnOptions repositoryNotifyOnOptions = RepositoryNotifyOnOptions.builder()
 *         .events(List.of(RepositoryNotificationEvents.COMMIT_COMMENT))
 *         // the properties below are optional
 *         .createdBy("createdBy")
 *         .detailType(DetailType.BASIC)
 *         .enabled(false)
 *         .notificationRuleName("notificationRuleName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:05.146Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codecommit.RepositoryNotifyOnOptions")
@software.amazon.jsii.Jsii.Proxy(RepositoryNotifyOnOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RepositoryNotifyOnOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions {

    /**
     * A list of event types associated with this notification rule for CodeCommit repositories.
     * <p>
     * For a complete list of event types and IDs, see Notification concepts in the Developer Tools Console User Guide.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents> getEvents();

    /**
     * @return a {@link Builder} of {@link RepositoryNotifyOnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RepositoryNotifyOnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RepositoryNotifyOnOptions> {
        java.util.List<software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents> events;
        java.lang.String createdBy;
        software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        java.lang.Boolean enabled;
        java.lang.String notificationRuleName;

        /**
         * Sets the value of {@link RepositoryNotifyOnOptions#getEvents}
         * @param events A list of event types associated with this notification rule for CodeCommit repositories. This parameter is required.
         *               For a complete list of event types and IDs, see Notification concepts in the Developer Tools Console User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder events(java.util.List<? extends software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents> events) {
            this.events = (java.util.List<software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents>)events;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryNotifyOnOptions#getCreatedBy}
         * @param createdBy The name or email alias of the person who created the notification rule.
         *                  If not specified, it means that the creator's alias is not provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(java.lang.String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryNotifyOnOptions#getDetailType}
         * @param detailType The level of detail to include in the notifications for this resource.
         *                   BASIC will include only the contents of the event as it would appear in AWS CloudWatch.
         *                   FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(software.amazon.awscdk.services.codestarnotifications.DetailType detailType) {
            this.detailType = detailType;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryNotifyOnOptions#getEnabled}
         * @param enabled The status of the notification rule.
         *                If the enabled is set to DISABLED, notifications aren't sent for the notification rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryNotifyOnOptions#getNotificationRuleName}
         * @param notificationRuleName The name for the notification rule.
         *                             Notification rule names must be unique in your AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationRuleName(java.lang.String notificationRuleName) {
            this.notificationRuleName = notificationRuleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RepositoryNotifyOnOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RepositoryNotifyOnOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RepositoryNotifyOnOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryNotifyOnOptions {
        private final java.util.List<software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents> events;
        private final java.lang.String createdBy;
        private final software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        private final java.lang.Boolean enabled;
        private final java.lang.String notificationRuleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents.class)));
            this.createdBy = software.amazon.jsii.Kernel.get(this, "createdBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.DetailType.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notificationRuleName = software.amazon.jsii.Kernel.get(this, "notificationRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.events = (java.util.List<software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents>)java.util.Objects.requireNonNull(builder.events, "events is required");
            this.createdBy = builder.createdBy;
            this.detailType = builder.detailType;
            this.enabled = builder.enabled;
            this.notificationRuleName = builder.notificationRuleName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codecommit.RepositoryNotificationEvents> getEvents() {
            return this.events;
        }

        @Override
        public final java.lang.String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final software.amazon.awscdk.services.codestarnotifications.DetailType getDetailType() {
            return this.detailType;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getNotificationRuleName() {
            return this.notificationRuleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("events", om.valueToTree(this.getEvents()));
            if (this.getCreatedBy() != null) {
                data.set("createdBy", om.valueToTree(this.getCreatedBy()));
            }
            if (this.getDetailType() != null) {
                data.set("detailType", om.valueToTree(this.getDetailType()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getNotificationRuleName() != null) {
                data.set("notificationRuleName", om.valueToTree(this.getNotificationRuleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codecommit.RepositoryNotifyOnOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RepositoryNotifyOnOptions.Jsii$Proxy that = (RepositoryNotifyOnOptions.Jsii$Proxy) o;

            if (!events.equals(that.events)) return false;
            if (this.createdBy != null ? !this.createdBy.equals(that.createdBy) : that.createdBy != null) return false;
            if (this.detailType != null ? !this.detailType.equals(that.detailType) : that.detailType != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.notificationRuleName != null ? this.notificationRuleName.equals(that.notificationRuleName) : that.notificationRuleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.events.hashCode();
            result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
            result = 31 * result + (this.detailType != null ? this.detailType.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.notificationRuleName != null ? this.notificationRuleName.hashCode() : 0);
            return result;
        }
    }
}
