package software.amazon.awscdk.services.ecr;

/**
 * Properties for defining a <code>CfnPublicRepository</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.*;
 * Object repositoryCatalogData;
 * Object repositoryPolicyText;
 * CfnPublicRepositoryProps cfnPublicRepositoryProps = CfnPublicRepositoryProps.builder()
 *         .repositoryCatalogData(repositoryCatalogData)
 *         .repositoryName("repositoryName")
 *         .repositoryPolicyText(repositoryPolicyText)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:07.269Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.CfnPublicRepositoryProps")
@software.amazon.jsii.Jsii.Proxy(CfnPublicRepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPublicRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-catalog-data.html">Amazon ECR Public repository catalog data</a> in the <em>Amazon ECR Public User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-repositorycatalogdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-repositorycatalogdata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRepositoryCatalogData() {
        return null;
    }

    /**
     * The name to use for the public repository.
     * <p>
     * The repository name may be specified on its own (such as <code>nginx-web-app</code> ) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code> ). If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the repository name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-repositoryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-repositoryname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
        return null;
    }

    /**
     * The JSON repository policy text to apply to the public repository.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-policies.html">Amazon ECR Public repository policies</a> in the <em>Amazon ECR Public User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-repositorypolicytext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-repositorypolicytext</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRepositoryPolicyText() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-publicrepository.html#cfn-ecr-publicrepository-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPublicRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPublicRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPublicRepositoryProps> {
        java.lang.Object repositoryCatalogData;
        java.lang.String repositoryName;
        java.lang.Object repositoryPolicyText;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPublicRepositoryProps#getRepositoryCatalogData}
         * @param repositoryCatalogData The details about the repository that are publicly visible in the Amazon ECR Public Gallery.
         *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-catalog-data.html">Amazon ECR Public repository catalog data</a> in the <em>Amazon ECR Public User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryCatalogData(java.lang.Object repositoryCatalogData) {
            this.repositoryCatalogData = repositoryCatalogData;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublicRepositoryProps#getRepositoryName}
         * @param repositoryName The name to use for the public repository.
         *                       The repository name may be specified on its own (such as <code>nginx-web-app</code> ) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code> ). If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the repository name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublicRepositoryProps#getRepositoryPolicyText}
         * @param repositoryPolicyText The JSON repository policy text to apply to the public repository.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/public/public-repository-policies.html">Amazon ECR Public repository policies</a> in the <em>Amazon ECR Public User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryPolicyText(java.lang.Object repositoryPolicyText) {
            this.repositoryPolicyText = repositoryPolicyText;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublicRepositoryProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPublicRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPublicRepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPublicRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPublicRepositoryProps {
        private final java.lang.Object repositoryCatalogData;
        private final java.lang.String repositoryName;
        private final java.lang.Object repositoryPolicyText;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repositoryCatalogData = software.amazon.jsii.Kernel.get(this, "repositoryCatalogData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryPolicyText = software.amazon.jsii.Kernel.get(this, "repositoryPolicyText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repositoryCatalogData = builder.repositoryCatalogData;
            this.repositoryName = builder.repositoryName;
            this.repositoryPolicyText = builder.repositoryPolicyText;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getRepositoryCatalogData() {
            return this.repositoryCatalogData;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.Object getRepositoryPolicyText() {
            return this.repositoryPolicyText;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRepositoryCatalogData() != null) {
                data.set("repositoryCatalogData", om.valueToTree(this.getRepositoryCatalogData()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            if (this.getRepositoryPolicyText() != null) {
                data.set("repositoryPolicyText", om.valueToTree(this.getRepositoryPolicyText()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr.CfnPublicRepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPublicRepositoryProps.Jsii$Proxy that = (CfnPublicRepositoryProps.Jsii$Proxy) o;

            if (this.repositoryCatalogData != null ? !this.repositoryCatalogData.equals(that.repositoryCatalogData) : that.repositoryCatalogData != null) return false;
            if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
            if (this.repositoryPolicyText != null ? !this.repositoryPolicyText.equals(that.repositoryPolicyText) : that.repositoryPolicyText != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repositoryCatalogData != null ? this.repositoryCatalogData.hashCode() : 0;
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            result = 31 * result + (this.repositoryPolicyText != null ? this.repositoryPolicyText.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
