package software.amazon.awscdk.services.ecr;

/**
 * Represents an ECR repository.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:07.281Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.IRepository")
@software.amazon.jsii.Jsii.Proxy(IRepository.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IRepository extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource {

    /**
     * The ARN of the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryArn();

    /**
     * The name of the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * The URI of this repository (represents the latest image):.
     * <p>
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUri();

    /**
     * Add a policy statement to the repository's resource policy.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement);

    /**
     * Grant the given principal identity permissions to perform the actions on this repository.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions);

    /**
     * Grant the given identity permissions to pull images in this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPull(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grant the given identity permissions to pull and push images to this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPullPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grant the given identity permissions to push images in this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grant the given identity permissions to read images in this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Define a CloudWatch event that triggers when something happens to this repository.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * Define a CloudWatch event that triggers when something happens to this repository.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailImagePushed(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.OnCloudTrailImagePushedOptions options);

    /**
     * Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
     * <p>
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailImagePushed(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Defines an AWS CloudWatch event rule that can trigger a target when the image scan is completed.
     * <p>
     * @param id The id of the rule. This parameter is required.
     * @param options Options for adding the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onImageScanCompleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.OnImageScanCompletedOptions options);

    /**
     * Defines an AWS CloudWatch event rule that can trigger a target when the image scan is completed.
     * <p>
     * @param id The id of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onImageScanCompleted(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Returns the URI of the repository for a certain digest. Can be used in <code>docker push/pull</code>.
     * <p>
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
     * <p>
     * @param digest Image digest to use (tools usually default to the image with the "latest" tag if omitted).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForDigest(final @org.jetbrains.annotations.Nullable java.lang.String digest);

    /**
     * Returns the URI of the repository for a certain digest. Can be used in <code>docker push/pull</code>.
     * <p>
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForDigest();

    /**
     * Returns the URI of the repository for a certain tag. Can be used in <code>docker push/pull</code>.
     * <p>
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
     * <p>
     * @param tag Image tag to use (tools usually default to "latest" if omitted).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTag(final @org.jetbrains.annotations.Nullable java.lang.String tag);

    /**
     * Returns the URI of the repository for a certain tag. Can be used in <code>docker push/pull</code>.
     * <p>
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTag();

    /**
     * Returns the URI of the repository for a certain tag or digest, inferring based on the syntax of the tag.
     * <p>
     * Can be used in <code>docker push/pull</code>.
     * <p>
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
     * <p>
     * @param tagOrDigest Image tag or digest to use (tools usually default to the image with the "latest" tag if omitted).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTagOrDigest(final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest);

    /**
     * Returns the URI of the repository for a certain tag or digest, inferring based on the syntax of the tag.
     * <p>
     * Can be used in <code>docker push/pull</code>.
     * <p>
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTagOrDigest();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecr.IRepository.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of the repository.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getRepositoryArn() {
            return software.amazon.jsii.Kernel.get(this, "repositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the repository.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
            return software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The URI of this repository (represents the latest image):.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUri() {
            return software.amazon.jsii.Kernel.get(this, "repositoryUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add a policy statement to the repository's resource policy.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Grant the given principal identity permissions to perform the actions on this repository.
         * <p>
         * @param grantee This parameter is required.
         * @param actions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Grant the given identity permissions to pull images in this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPull(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPull", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant the given identity permissions to pull and push images to this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPullPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPullPush", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant the given identity permissions to push images in this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPush", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant the given identity permissions to read images in this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Define a CloudWatch event that triggers when something happens to this repository.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Define a CloudWatch event that triggers when something happens to this repository.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailImagePushed(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.OnCloudTrailImagePushedOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailImagePushed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailImagePushed(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailImagePushed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Defines a CloudWatch event rule which triggers for repository events.
         * <p>
         * Use
         * <code>rule.addEventPattern(pattern)</code> to specify a filter.
         * <p>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines a CloudWatch event rule which triggers for repository events.
         * <p>
         * Use
         * <code>rule.addEventPattern(pattern)</code> to specify a filter.
         * <p>
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Defines an AWS CloudWatch event rule that can trigger a target when the image scan is completed.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onImageScanCompleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.OnImageScanCompletedOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onImageScanCompleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event rule that can trigger a target when the image scan is completed.
         * <p>
         * @param id The id of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onImageScanCompleted(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onImageScanCompleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Returns the URI of the repository for a certain digest. Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
         * <p>
         * @param digest Image digest to use (tools usually default to the image with the "latest" tag if omitted).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForDigest(final @org.jetbrains.annotations.Nullable java.lang.String digest) {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { digest });
        }

        /**
         * Returns the URI of the repository for a certain digest. Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForDigest() {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Returns the URI of the repository for a certain tag. Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
         * <p>
         * @param tag Image tag to use (tools usually default to "latest" if omitted).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTag(final @org.jetbrains.annotations.Nullable java.lang.String tag) {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { tag });
        }

        /**
         * Returns the URI of the repository for a certain tag. Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTag() {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Returns the URI of the repository for a certain tag or digest, inferring based on the syntax of the tag.
         * <p>
         * Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
         * <p>
         * @param tagOrDigest Image tag or digest to use (tools usually default to the image with the "latest" tag if omitted).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTagOrDigest(final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest) {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForTagOrDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { tagOrDigest });
        }

        /**
         * Returns the URI of the repository for a certain tag or digest, inferring based on the syntax of the tag.
         * <p>
         * Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTagOrDigest() {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForTagOrDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }

    /**
     * Internal default implementation for {@link IRepository}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IRepository, software.amazon.awscdk.IResource.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ARN of the repository.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getRepositoryArn() {
            return software.amazon.jsii.Kernel.get(this, "repositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the repository.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
            return software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The URI of this repository (represents the latest image):.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUri() {
            return software.amazon.jsii.Kernel.get(this, "repositoryUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add a policy statement to the repository's resource policy.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Grant the given principal identity permissions to perform the actions on this repository.
         * <p>
         * @param grantee This parameter is required.
         * @param actions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Grant the given identity permissions to pull images in this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPull(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPull", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant the given identity permissions to pull and push images to this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPullPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPullPush", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant the given identity permissions to push images in this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPush", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant the given identity permissions to read images in this repository.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Define a CloudWatch event that triggers when something happens to this repository.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
         * <p>
         * Requires that there exists at least one CloudTrail Trail in your account
         * that captures the event. This method will not create the Trail.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCloudTrailImagePushed(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.OnCloudTrailImagePushedOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onCloudTrailImagePushed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines a CloudWatch event rule which triggers for repository events.
         * <p>
         * Use
         * <code>rule.addEventPattern(pattern)</code> to specify a filter.
         * <p>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Defines an AWS CloudWatch event rule that can trigger a target when the image scan is completed.
         * <p>
         * @param id The id of the rule. This parameter is required.
         * @param options Options for adding the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onImageScanCompleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.OnImageScanCompletedOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onImageScanCompleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Returns the URI of the repository for a certain digest. Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
         * <p>
         * @param digest Image digest to use (tools usually default to the image with the "latest" tag if omitted).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForDigest(final @org.jetbrains.annotations.Nullable java.lang.String digest) {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { digest });
        }

        /**
         * Returns the URI of the repository for a certain tag. Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
         * <p>
         * @param tag Image tag to use (tools usually default to "latest" if omitted).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTag(final @org.jetbrains.annotations.Nullable java.lang.String tag) {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { tag });
        }

        /**
         * Returns the URI of the repository for a certain tag or digest, inferring based on the syntax of the tag.
         * <p>
         * Can be used in <code>docker push/pull</code>.
         * <p>
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
         * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[&#64;DIGEST]
         * <p>
         * @param tagOrDigest Image tag or digest to use (tools usually default to the image with the "latest" tag if omitted).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String repositoryUriForTagOrDigest(final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest) {
            return software.amazon.jsii.Kernel.call(this, "repositoryUriForTagOrDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { tagOrDigest });
        }
    }
}
