package software.amazon.awscdk.services.ecs;

/**
 * The base class for all task definitions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Vpc vpc;
 * FargateService service = FargateService.Builder.create(this, "Service").cluster(cluster).taskDefinition(taskDefinition).build();
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB").vpc(vpc).internetFacing(true).build();
 * ApplicationListener listener = lb.addListener("Listener", BaseApplicationListenerProps.builder().port(80).build());
 * service.registerLoadBalancerTargets(EcsTarget.builder()
 *         .containerName("web")
 *         .containerPort(80)
 *         .newTargetGroupId("ECS")
 *         .listener(ListenerConfig.applicationListener(listener, AddApplicationTargetsProps.builder()
 *                 .protocol(ApplicationProtocol.HTTPS)
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:07.626Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.TaskDefinition")
public class TaskDefinition extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ecs.ITaskDefinition {

    protected TaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the TaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a task definition from the specified task definition ARN.
     * <p>
     * The task will have a compatibility of EC2+Fargate.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param taskDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinition fromTaskDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String taskDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.TaskDefinition.class, "fromTaskDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ITaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(taskDefinitionArn, "taskDefinitionArn is required") });
    }

    /**
     * Create a task definition from a task definition reference.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinition fromTaskDefinitionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinitionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.TaskDefinition.class, "fromTaskDefinitionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ITaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds a new container to the task definition.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition addContainer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinitionOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds the specified extension to the task definition.
     * <p>
     * Extension can be used to apply a packaged modification to
     * a task definition.
     * <p>
     * @param extension This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinitionExtension extension) {
        software.amazon.jsii.Kernel.call(this, "addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
    }

    /**
     * Adds a firelens log router to the task definition.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensLogRouter addFirelensLogRouter(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensLogRouterDefinitionOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addFirelensLogRouter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FirelensLogRouter.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds an inference accelerator to the task definition.
     * <p>
     * @param inferenceAccelerator This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addInferenceAccelerator(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.InferenceAccelerator inferenceAccelerator) {
        software.amazon.jsii.Kernel.call(this, "addInferenceAccelerator", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inferenceAccelerator, "inferenceAccelerator is required") });
    }

    /**
     * Adds the specified placement constraint to the task definition.
     * <p>
     * @param constraint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPlacementConstraint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementConstraint constraint) {
        software.amazon.jsii.Kernel.call(this, "addPlacementConstraint", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constraint, "constraint is required") });
    }

    /**
     * Adds a policy statement to the task execution IAM role.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToExecutionRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToExecutionRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds a policy statement to the task IAM role.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToTaskRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToTaskRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds a volume to the task definition.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Volume volume) {
        software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * Returns the container that match the provided containerName.
     * <p>
     * @param containerName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerDefinition findContainer(final @org.jetbrains.annotations.NotNull java.lang.String containerName) {
        return software.amazon.jsii.Kernel.call(this, "findContainer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class), new Object[] { java.util.Objects.requireNonNull(containerName, "containerName is required") });
    }

    /**
     * Determine the existing port mapping for the provided name.
     * <p>
     * @return PortMapping for the provided name, if it exists.
     * @param name : port mapping name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PortMapping findPortMappingByName(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "findPortMappingByName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PortMapping.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Grants permissions to run this task definition.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>ecs:RunTask</li>
     * <li>iam:PassRole</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant consume rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRun(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRun", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Creates the task execution IAM role if it doesn't already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole obtainExecutionRole() {
        return software.amazon.jsii.Kernel.call(this, "obtainExecutionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The task launch type compatibility requirement.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Compatibility getCompatibility() {
        return software.amazon.jsii.Kernel.get(this, "compatibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Compatibility.class));
    }

    /**
     * The container definitions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.ContainerDefinition> getContainers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class))));
    }

    /**
     * The name of a family that this task definition is registered to.
     * <p>
     * A family groups multiple versions of a task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFamily() {
        return software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Public getter method to access list of inference accelerators attached to the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> getInferenceAccelerators() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "inferenceAccelerators", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.InferenceAccelerator.class))));
    }

    /**
     * Return true if the task definition can be run on an EC2 cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsEc2Compatible() {
        return software.amazon.jsii.Kernel.get(this, "isEc2Compatible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Return true if the task definition can be run on a ECS anywhere cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsExternalCompatible() {
        return software.amazon.jsii.Kernel.get(this, "isExternalCompatible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Return true if the task definition can be run on a Fargate cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsFargateCompatible() {
        return software.amazon.jsii.Kernel.get(this, "isFargateCompatible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The networking mode to use for the containers in the task.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
        return software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.NetworkMode.class));
    }

    /**
     * The full Amazon Resource Name (ARN) of the task definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTaskDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getTaskRole() {
        return software.amazon.jsii.Kernel.get(this, "taskRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The amount (in GiB) of ephemeral storage to be allocated to the task.
     * <p>
     * Only supported in Fargate platform version 1.4.0 or later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getEphemeralStorageGiB() {
        return software.amazon.jsii.Kernel.get(this, "ephemeralStorageGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Execution role for this task definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The process namespace to use for the containers in the task.
     * <p>
     * Only supported for tasks that are hosted on AWS Fargate if the tasks
     * are using platform version 1.4.0 or later (Linux). Not supported in
     * Windows containers. If pidMode is specified for a Fargate task,
     * then runtimePlatform.operatingSystemFamily must also be specified.  For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_definition_pidmode">Task Definition Parameters</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PidMode getPidMode() {
        return software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PidMode.class));
    }

    /**
     * Whether this task definition has at least a container that references a specific JSON field of a secret stored in Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReferencesSecretJsonField() {
        return software.amazon.jsii.Kernel.get(this, "referencesSecretJsonField", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Default container for this task.
     * <p>
     * Load balancers will send traffic to this container. The first
     * essential container that is added to this task will become the default
     * container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerDefinition getDefaultContainer() {
        return software.amazon.jsii.Kernel.get(this, "defaultContainer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class));
    }

    /**
     * Default container for this task.
     * <p>
     * Load balancers will send traffic to this container. The first
     * essential container that is added to this task will become the default
     * container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultContainer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerDefinition value) {
        software.amazon.jsii.Kernel.set(this, "defaultContainer", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.TaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.TaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.TaskDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.TaskDefinitionProps.Builder();
        }

        /**
         * The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
         * <p>
         * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * <p>
         * Default: - An execution role will be automatically created if you use ECR images in your task definition.
         * <p>
         * @return {@code this}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * The name of a family that this task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that this task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props.family(family);
            return this;
        }

        /**
         * The configuration details for the App Mesh proxy.
         * <p>
         * Default: - No proxy configuration.
         * <p>
         * @return {@code this}
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.props.proxyConfiguration(proxyConfiguration);
            return this;
        }

        /**
         * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * <p>
         * Default: - A task role is automatically created for you.
         * <p>
         * @return {@code this}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(final software.amazon.awscdk.services.iam.IRole taskRole) {
            this.props.taskRole(taskRole);
            return this;
        }

        /**
         * The list of volume definitions for the task.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * <p>
         * Default: - No volumes are passed to the Docker daemon on a container instance.
         * <p>
         * @return {@code this}
         * @param volumes The list of volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        /**
         * The task launch type compatiblity requirement.
         * <p>
         * @return {@code this}
         * @param compatibility The task launch type compatiblity requirement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibility(final software.amazon.awscdk.services.ecs.Compatibility compatibility) {
            this.props.compatibility(compatibility);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * If you are using the EC2 launch type, this field is optional and any value can be used.
         * If you are using the Fargate launch type, this field is required and you must use one of the following values,
         * which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * <p>
         * 8192 (8 vCPU) - Available memory values: Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB)
         * <p>
         * 16384 (16 vCPU) - Available memory values: Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB)
         * <p>
         * Default: - CPU units are not specified.
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.String cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * The amount (in GiB) of ephemeral storage to be allocated to the task.
         * <p>
         * Only supported in Fargate platform version 1.4.0 or later.
         * <p>
         * Default: - Undefined, in which case, the task will receive 20GiB ephemeral storage.
         * <p>
         * @return {@code this}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(final java.lang.Number ephemeralStorageGiB) {
            this.props.ephemeralStorageGiB(ephemeralStorageGiB);
            return this;
        }

        /**
         * The inference accelerators to use for the containers in the task.
         * <p>
         * Not supported in Fargate.
         * <p>
         * Default: - No inference accelerators.
         * <p>
         * @return {@code this}
         * @param inferenceAccelerators The inference accelerators to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(final java.util.List<? extends software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators) {
            this.props.inferenceAccelerators(inferenceAccelerators);
            return this;
        }

        /**
         * The IPC resource namespace to use for the containers in the task.
         * <p>
         * Not supported in Fargate and Windows containers.
         * <p>
         * Default: - IpcMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param ipcMode The IPC resource namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(final software.amazon.awscdk.services.ecs.IpcMode ipcMode) {
            this.props.ipcMode(ipcMode);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * If using the EC2 launch type, this field is optional and any value can be used.
         * If using the Fargate launch type, this field is required and you must use one of the following values,
         * which determines your range of valid values for the cpu parameter:
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * <p>
         * Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
         * <p>
         * Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
         * <p>
         * Default: - Memory used by task is not specified.
         * <p>
         * @return {@code this}
         * @param memoryMiB The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryMiB(final java.lang.String memoryMiB) {
            this.props.memoryMiB(memoryMiB);
            return this;
        }

        /**
         * The networking mode to use for the containers in the task.
         * <p>
         * On Fargate, the only supported networking mode is AwsVpc.
         * <p>
         * Default: - NetworkMode.Bridge for EC2 & External tasks, AwsVpc for Fargate tasks.
         * <p>
         * @return {@code this}
         * @param networkMode The networking mode to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        /**
         * The process namespace to use for the containers in the task.
         * <p>
         * Only supported for tasks that are hosted on AWS Fargate if the tasks
         * are using platform version 1.4.0 or later (Linux). Only the TASK option
         * is supported for Linux-based Fargate containers. Not supported in Windows
         * containers. If pidMode is specified for a Fargate task, then
         * runtimePlatform.operatingSystemFamily must also be specified.  For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_definition_pidmode">Task Definition Parameters</a>.
         * <p>
         * Default: - PidMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param pidMode The process namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(final software.amazon.awscdk.services.ecs.PidMode pidMode) {
            this.props.pidMode(pidMode);
            return this;
        }

        /**
         * The placement constraints to use for tasks in the service.
         * <p>
         * You can specify a maximum of 10 constraints per task (this limit includes
         * constraints in the task definition and those specified at run time).
         * <p>
         * Not supported in Fargate.
         * <p>
         * Default: - No placement constraints.
         * <p>
         * @return {@code this}
         * @param placementConstraints The placement constraints to use for tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        /**
         * The operating system that your task definitions are running on.
         * <p>
         * A runtimePlatform is supported only for tasks using the Fargate launch type.
         * <p>
         * Default: - Undefined.
         * <p>
         * @return {@code this}
         * @param runtimePlatform The operating system that your task definitions are running on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.props.runtimePlatform(runtimePlatform);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.TaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.TaskDefinition build() {
            return new software.amazon.awscdk.services.ecs.TaskDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
