package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * How to interpret the load balancing target identifiers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * // Target group with slow start mode enabled
 * ApplicationTargetGroup tg = ApplicationTargetGroup.Builder.create(this, "TG")
 *         .targetType(TargetType.INSTANCE)
 *         .slowStart(Duration.seconds(60))
 *         .port(80)
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:08.227Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TargetType")
public enum TargetType {
    /**
     * Targets identified by instance ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSTANCE,
    /**
     * Targets identified by IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IP,
    /**
     * Target is a single Lambda Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
    /**
     * Target is a single Application Load Balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALB,
}
