package software.amazon.awscdk.services.imagebuilder;

/**
 * The infrastructure configuration allows you to specify the infrastructure within which to build and test your image.
 * <p>
 * In the infrastructure configuration, you can specify instance types, subnets, and security groups to associate with your instance. You can also associate an Amazon EC2 key pair with the instance used to build your image. This allows you to log on to your instance to troubleshoot if your build fails and you set terminateInstanceOnFailure to false.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnInfrastructureConfiguration cfnInfrastructureConfiguration = CfnInfrastructureConfiguration.Builder.create(this, "MyCfnInfrastructureConfiguration")
 *         .instanceProfileName("instanceProfileName")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .instanceMetadataOptions(InstanceMetadataOptionsProperty.builder()
 *                 .httpPutResponseHopLimit(123)
 *                 .httpTokens("httpTokens")
 *                 .build())
 *         .instanceTypes(List.of("instanceTypes"))
 *         .keyPair("keyPair")
 *         .logging(LoggingProperty.builder()
 *                 .s3Logs(S3LogsProperty.builder()
 *                         .s3BucketName("s3BucketName")
 *                         .s3KeyPrefix("s3KeyPrefix")
 *                         .build())
 *                 .build())
 *         .placement(PlacementProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .hostId("hostId")
 *                 .hostResourceGroupArn("hostResourceGroupArn")
 *                 .tenancy("tenancy")
 *                 .build())
 *         .resourceTags(Map.of(
 *                 "resourceTagsKey", "resourceTags"))
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snsTopicArn("snsTopicArn")
 *         .subnetId("subnetId")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .terminateInstanceOnFailure(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:09.378Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration")
public class CfnInfrastructureConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnInfrastructureConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInfrastructureConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInfrastructureConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the infrastructure configuration.
     * <p>
     * The following pattern is applied: <code>^arn:aws[^:]*:imagebuilder:[^:]+:(?:\d{12}|aws):(?:image-recipe|infrastructure-configuration|distribution-configuration|component|image|image-pipeline)/[a-z0-9-_]+(?:/(?:(?:x|\d+)\.(?:x|\d+)\.(?:x|\d+))(?:/\d+)?)?$</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The instance profile of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceProfileName() {
        return software.amazon.jsii.Kernel.get(this, "instanceProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance profile of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceProfileName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceProfileName", java.util.Objects.requireNonNull(value, "instanceProfileName is required"));
    }

    /**
     * The name of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The description of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The instance metadata option settings for the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceMetadataOptions() {
        return software.amazon.jsii.Kernel.get(this, "instanceMetadataOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The instance metadata option settings for the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceMetadataOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceMetadataOptions", value);
    }

    /**
     * The instance metadata option settings for the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceMetadataOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.InstanceMetadataOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "instanceMetadataOptions", value);
    }

    /**
     * The instance types of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceTypes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The instance types of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceTypes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "instanceTypes", value);
    }

    /**
     * The Amazon EC2 key pair of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyPair() {
        return software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon EC2 key pair of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyPair(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyPair", value);
    }

    /**
     * The logging configuration defines where Image Builder uploads your logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
        return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The logging configuration defines where Image Builder uploads your logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logging", value);
    }

    /**
     * The logging configuration defines where Image Builder uploads your logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.LoggingProperty value) {
        software.amazon.jsii.Kernel.set(this, "logging", value);
    }

    /**
     * The instance placement settings that define where the instances that are launched from your image will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
        return software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The instance placement settings that define where the instances that are launched from your image will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacement(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "placement", value);
    }

    /**
     * The instance placement settings that define where the instances that are launched from your image will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacement(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.PlacementProperty value) {
        software.amazon.jsii.Kernel.set(this, "placement", value);
    }

    /**
     * The tags attached to the resource created by Image Builder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tags attached to the resource created by Image Builder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceTags", value);
    }

    /**
     * The tags attached to the resource created by Image Builder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourceTags", value);
    }

    /**
     * The security group IDs of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The security group IDs of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the SNS topic for the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the SNS topic for the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnsTopicArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snsTopicArn", value);
    }

    /**
     * The subnet ID of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The subnet ID of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subnetId", value);
    }

    /**
     * The tags of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The terminate instance on failure configuration of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstanceOnFailure() {
        return software.amazon.jsii.Kernel.get(this, "terminateInstanceOnFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The terminate instance on failure configuration of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstanceOnFailure(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstanceOnFailure", value);
    }

    /**
     * The terminate instance on failure configuration of the infrastructure configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstanceOnFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstanceOnFailure", value);
    }
    /**
     * The instance metadata options that apply to the HTTP requests that pipeline builds use to launch EC2 build and test instances.
     * <p>
     * For more information about instance metadata options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <strong>Amazon EC2 User Guide</strong> for Linux instances, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <strong>Amazon EC2 Windows Guide</strong> for Windows instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * InstanceMetadataOptionsProperty instanceMetadataOptionsProperty = InstanceMetadataOptionsProperty.builder()
     *         .httpPutResponseHopLimit(123)
     *         .httpTokens("httpTokens")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-instancemetadataoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-instancemetadataoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.InstanceMetadataOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceMetadataOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceMetadataOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Limit the number of hops that an instance metadata request can traverse to reach its destination.
         * <p>
         * The default is one hop. However, if HTTP tokens are required, container image builds need a minimum of two hops.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-instancemetadataoptions.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions-httpputresponsehoplimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-instancemetadataoptions.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions-httpputresponsehoplimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPutResponseHopLimit() {
            return null;
        }

        /**
         * Indicates whether a signed token header is required for instance metadata retrieval requests.
         * <p>
         * The values affect the response as follows:
         * <p>
         * <ul>
         * <li><em>required</em> – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all cases.</li>
         * <li><em>optional</em> – You can include a signed token header in your request to retrieve instance metadata, or you can leave it out. If you include it, version 2.0 credentials are returned for the IAM role. Otherwise, version 1.0 credentials are returned.</li>
         * </ul>
         * <p>
         * The default setting is <em>optional</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-instancemetadataoptions.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions-httptokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-instancemetadataoptions.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions-httptokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpTokens() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceMetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceMetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceMetadataOptionsProperty> {
            java.lang.Number httpPutResponseHopLimit;
            java.lang.String httpTokens;

            /**
             * Sets the value of {@link InstanceMetadataOptionsProperty#getHttpPutResponseHopLimit}
             * @param httpPutResponseHopLimit Limit the number of hops that an instance metadata request can traverse to reach its destination.
             *                                The default is one hop. However, if HTTP tokens are required, container image builds need a minimum of two hops.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPutResponseHopLimit(java.lang.Number httpPutResponseHopLimit) {
                this.httpPutResponseHopLimit = httpPutResponseHopLimit;
                return this;
            }

            /**
             * Sets the value of {@link InstanceMetadataOptionsProperty#getHttpTokens}
             * @param httpTokens Indicates whether a signed token header is required for instance metadata retrieval requests.
             *                   The values affect the response as follows:
             *                   <p>
             *                   <ul>
             *                   <li><em>required</em> – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all cases.</li>
             *                   <li><em>optional</em> – You can include a signed token header in your request to retrieve instance metadata, or you can leave it out. If you include it, version 2.0 credentials are returned for the IAM role. Otherwise, version 1.0 credentials are returned.</li>
             *                   </ul>
             *                   <p>
             *                   The default setting is <em>optional</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpTokens(java.lang.String httpTokens) {
                this.httpTokens = httpTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceMetadataOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceMetadataOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceMetadataOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceMetadataOptionsProperty {
            private final java.lang.Number httpPutResponseHopLimit;
            private final java.lang.String httpTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpPutResponseHopLimit = software.amazon.jsii.Kernel.get(this, "httpPutResponseHopLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.httpTokens = software.amazon.jsii.Kernel.get(this, "httpTokens", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
                this.httpTokens = builder.httpTokens;
            }

            @Override
            public final java.lang.Number getHttpPutResponseHopLimit() {
                return this.httpPutResponseHopLimit;
            }

            @Override
            public final java.lang.String getHttpTokens() {
                return this.httpTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpPutResponseHopLimit() != null) {
                    data.set("httpPutResponseHopLimit", om.valueToTree(this.getHttpPutResponseHopLimit()));
                }
                if (this.getHttpTokens() != null) {
                    data.set("httpTokens", om.valueToTree(this.getHttpTokens()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.InstanceMetadataOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceMetadataOptionsProperty.Jsii$Proxy that = (InstanceMetadataOptionsProperty.Jsii$Proxy) o;

                if (this.httpPutResponseHopLimit != null ? !this.httpPutResponseHopLimit.equals(that.httpPutResponseHopLimit) : that.httpPutResponseHopLimit != null) return false;
                return this.httpTokens != null ? this.httpTokens.equals(that.httpTokens) : that.httpTokens == null;
            }

            @Override
            public final int hashCode() {
                int result = this.httpPutResponseHopLimit != null ? this.httpPutResponseHopLimit.hashCode() : 0;
                result = 31 * result + (this.httpTokens != null ? this.httpTokens.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Logging configuration defines where Image Builder uploads your logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * LoggingProperty loggingProperty = LoggingProperty.builder()
     *         .s3Logs(S3LogsProperty.builder()
     *                 .s3BucketName("s3BucketName")
     *                 .s3KeyPrefix("s3KeyPrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 logging configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html#cfn-imagebuilder-infrastructureconfiguration-logging-s3logs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html#cfn-imagebuilder-infrastructureconfiguration-logging-s3logs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Logs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            java.lang.Object s3Logs;

            /**
             * Sets the value of {@link LoggingProperty#getS3Logs}
             * @param s3Logs The Amazon S3 logging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.IResolvable s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getS3Logs}
             * @param s3Logs The Amazon S3 logging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.S3LogsProperty s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.Object s3Logs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Logs = software.amazon.jsii.Kernel.get(this, "s3Logs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Logs = builder.s3Logs;
            }

            @Override
            public final java.lang.Object getS3Logs() {
                return this.s3Logs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Logs() != null) {
                    data.set("s3Logs", om.valueToTree(this.getS3Logs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                return this.s3Logs != null ? this.s3Logs.equals(that.s3Logs) : that.s3Logs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Logs != null ? this.s3Logs.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * By default, EC2 instances run on shared tenancy hardware.
     * <p>
     * This means that multiple AWS accounts might share the same physical hardware. When you use dedicated hardware, the physical server that hosts your instances is dedicated to your AWS account . Instance placement settings contain the details for the physical hardware where instances that Image Builder launches during image creation will run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * PlacementProperty placementProperty = PlacementProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .hostId("hostId")
     *         .hostResourceGroupArn("hostResourceGroupArn")
     *         .tenancy("tenancy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.PlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zone where your build and test instances will launch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The ID of the Dedicated Host on which build and test instances run.
         * <p>
         * This only applies if <code>tenancy</code> is <code>host</code> . If you specify the host ID, you must not specify the resource group ARN. If you specify both, Image Builder returns an error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-hostid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-hostid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances.
         * <p>
         * This only applies if <code>tenancy</code> is <code>host</code> . If you specify the resource group ARN, you must not specify the host ID. If you specify both, Image Builder returns an error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-hostresourcegrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-hostresourcegrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
            return null;
        }

        /**
         * The tenancy of the instance.
         * <p>
         * An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.
         * <p>
         * If tenancy is set to <code>host</code> , then you can optionally specify one target for placement – either host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't specify any placement target, Amazon EC2 will try to find an available host for your build and test instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-tenancy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-placement.html#cfn-imagebuilder-infrastructureconfiguration-placement-tenancy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementProperty> {
            java.lang.String availabilityZone;
            java.lang.String hostId;
            java.lang.String hostResourceGroupArn;
            java.lang.String tenancy;

            /**
             * Sets the value of {@link PlacementProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone where your build and test instances will launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostId}
             * @param hostId The ID of the Dedicated Host on which build and test instances run.
             *               This only applies if <code>tenancy</code> is <code>host</code> . If you specify the host ID, you must not specify the resource group ARN. If you specify both, Image Builder returns an error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostId(java.lang.String hostId) {
                this.hostId = hostId;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostResourceGroupArn}
             * @param hostResourceGroupArn The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances.
             *                             This only applies if <code>tenancy</code> is <code>host</code> . If you specify the resource group ARN, you must not specify the host ID. If you specify both, Image Builder returns an error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostResourceGroupArn(java.lang.String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getTenancy}
             * @param tenancy The tenancy of the instance.
             *                An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.
             *                <p>
             *                If tenancy is set to <code>host</code> , then you can optionally specify one target for placement – either host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't specify any placement target, Amazon EC2 will try to find an available host for your build and test instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String hostId;
            private final java.lang.String hostResourceGroupArn;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostId = software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostResourceGroupArn = software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.hostId = builder.hostId;
                this.hostResourceGroupArn = builder.hostResourceGroupArn;
                this.tenancy = builder.tenancy;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getHostId() {
                return this.hostId;
            }

            @Override
            public final java.lang.String getHostResourceGroupArn() {
                return this.hostResourceGroupArn;
            }

            @Override
            public final java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getHostId() != null) {
                    data.set("hostId", om.valueToTree(this.getHostId()));
                }
                if (this.getHostResourceGroupArn() != null) {
                    data.set("hostResourceGroupArn", om.valueToTree(this.getHostResourceGroupArn()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.PlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementProperty.Jsii$Proxy that = (PlacementProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
                if (this.hostResourceGroupArn != null ? !this.hostResourceGroupArn.equals(that.hostResourceGroupArn) : that.hostResourceGroupArn != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
                result = 31 * result + (this.hostResourceGroupArn != null ? this.hostResourceGroupArn.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Amazon S3 logging configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * S3LogsProperty s3LogsProperty = S3LogsProperty.builder()
     *         .s3BucketName("s3BucketName")
     *         .s3KeyPrefix("s3KeyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.S3LogsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LogsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LogsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket in which to store the logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * The Amazon S3 path to the bucket where the logs are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LogsProperty> {
            java.lang.String s3BucketName;
            java.lang.String s3KeyPrefix;

            /**
             * Sets the value of {@link S3LogsProperty#getS3BucketName}
             * @param s3BucketName The S3 bucket in which to store the logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3LogsProperty#getS3KeyPrefix}
             * @param s3KeyPrefix The Amazon S3 path to the bucket where the logs are stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LogsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LogsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LogsProperty {
            private final java.lang.String s3BucketName;
            private final java.lang.String s3KeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3BucketName = builder.s3BucketName;
                this.s3KeyPrefix = builder.s3KeyPrefix;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getS3KeyPrefix() {
                return this.s3KeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getS3KeyPrefix() != null) {
                    data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfiguration.S3LogsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LogsProperty.Jsii$Proxy that = (S3LogsProperty.Jsii$Proxy) o;

                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                return this.s3KeyPrefix != null ? this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3BucketName != null ? this.s3BucketName.hashCode() : 0;
                result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfigurationProps.Builder();
        }

        /**
         * The instance profile of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename</a>
         * @param instanceProfileName The instance profile of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileName(final java.lang.String instanceProfileName) {
            this.props.instanceProfileName(instanceProfileName);
            return this;
        }

        /**
         * The name of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-name</a>
         * @param name The name of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The description of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description</a>
         * @param description The description of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The instance metadata option settings for the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions</a>
         * @param instanceMetadataOptions The instance metadata option settings for the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataOptions(final software.amazon.awscdk.IResolvable instanceMetadataOptions) {
            this.props.instanceMetadataOptions(instanceMetadataOptions);
            return this;
        }
        /**
         * The instance metadata option settings for the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions</a>
         * @param instanceMetadataOptions The instance metadata option settings for the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataOptions(final software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.InstanceMetadataOptionsProperty instanceMetadataOptions) {
            this.props.instanceMetadataOptions(instanceMetadataOptions);
            return this;
        }

        /**
         * The instance types of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes</a>
         * @param instanceTypes The instance types of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypes(final java.util.List<java.lang.String> instanceTypes) {
            this.props.instanceTypes(instanceTypes);
            return this;
        }

        /**
         * The Amazon EC2 key pair of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair</a>
         * @param keyPair The Amazon EC2 key pair of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(final java.lang.String keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        /**
         * The logging configuration defines where Image Builder uploads your logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging</a>
         * @param logging The logging configuration defines where Image Builder uploads your logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.IResolvable logging) {
            this.props.logging(logging);
            return this;
        }
        /**
         * The logging configuration defines where Image Builder uploads your logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging</a>
         * @param logging The logging configuration defines where Image Builder uploads your logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.LoggingProperty logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * The instance placement settings that define where the instances that are launched from your image will run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-placement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-placement</a>
         * @param placement The instance placement settings that define where the instances that are launched from your image will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placement(final software.amazon.awscdk.IResolvable placement) {
            this.props.placement(placement);
            return this;
        }
        /**
         * The instance placement settings that define where the instances that are launched from your image will run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-placement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-placement</a>
         * @param placement The instance placement settings that define where the instances that are launched from your image will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placement(final software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.PlacementProperty placement) {
            this.props.placement(placement);
            return this;
        }

        /**
         * The tags attached to the resource created by Image Builder.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags</a>
         * @param resourceTags The tags attached to the resource created by Image Builder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(final software.amazon.awscdk.IResolvable resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }
        /**
         * The tags attached to the resource created by Image Builder.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags</a>
         * @param resourceTags The tags attached to the resource created by Image Builder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(final java.util.Map<java.lang.String, java.lang.String> resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        /**
         * The security group IDs of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids</a>
         * @param securityGroupIds The security group IDs of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the SNS topic for the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn</a>
         * @param snsTopicArn The Amazon Resource Name (ARN) of the SNS topic for the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArn(final java.lang.String snsTopicArn) {
            this.props.snsTopicArn(snsTopicArn);
            return this;
        }

        /**
         * The subnet ID of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid</a>
         * @param subnetId The subnet ID of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(final java.lang.String subnetId) {
            this.props.subnetId(subnetId);
            return this;
        }

        /**
         * The tags of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags</a>
         * @param tags The tags of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The terminate instance on failure configuration of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure</a>
         * @param terminateInstanceOnFailure The terminate instance on failure configuration of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstanceOnFailure(final java.lang.Boolean terminateInstanceOnFailure) {
            this.props.terminateInstanceOnFailure(terminateInstanceOnFailure);
            return this;
        }
        /**
         * The terminate instance on failure configuration of the infrastructure configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure</a>
         * @param terminateInstanceOnFailure The terminate instance on failure configuration of the infrastructure configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstanceOnFailure(final software.amazon.awscdk.IResolvable terminateInstanceOnFailure) {
            this.props.terminateInstanceOnFailure(terminateInstanceOnFailure);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration build() {
            return new software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
