package software.amazon.awscdk.services.ivschat;

/**
 * Properties for defining a <code>CfnRoom</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ivschat.*;
 * CfnRoomProps cfnRoomProps = CfnRoomProps.builder()
 *         .loggingConfigurationIdentifiers(List.of("loggingConfigurationIdentifiers"))
 *         .maximumMessageLength(123)
 *         .maximumMessageRatePerSecond(123)
 *         .messageReviewHandler(MessageReviewHandlerProperty.builder()
 *                 .fallbackResult("fallbackResult")
 *                 .uri("uri")
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:09.902Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivschat.CfnRoomProps")
@software.amazon.jsii.Jsii.Proxy(CfnRoomProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRoomProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of logging-configuration identifiers attached to the room.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-loggingconfigurationidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-loggingconfigurationidentifiers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLoggingConfigurationIdentifiers() {
        return null;
    }

    /**
     * Maximum number of characters in a single message.
     * <p>
     * Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes.
     * <p>
     * Default: - 500
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-maximummessagelength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-maximummessagelength</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMessageLength() {
        return null;
    }

    /**
     * Maximum number of messages per second that can be sent to the room (by all clients).
     * <p>
     * Default: - 10
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-maximummessageratepersecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-maximummessageratepersecond</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMessageRatePerSecond() {
        return null;
    }

    /**
     * Configuration information for optional review of messages.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-messagereviewhandler">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-messagereviewhandler</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMessageReviewHandler() {
        return null;
    }

    /**
     * Room name.
     * <p>
     * The value does not need to be unique.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivschat-room-tag.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivschat-room.html#cfn-ivschat-room-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRoomProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRoomProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRoomProps> {
        java.util.List<java.lang.String> loggingConfigurationIdentifiers;
        java.lang.Number maximumMessageLength;
        java.lang.Number maximumMessageRatePerSecond;
        java.lang.Object messageReviewHandler;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRoomProps#getLoggingConfigurationIdentifiers}
         * @param loggingConfigurationIdentifiers List of logging-configuration identifiers attached to the room.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfigurationIdentifiers(java.util.List<java.lang.String> loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers = loggingConfigurationIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoomProps#getMaximumMessageLength}
         * @param maximumMessageLength Maximum number of characters in a single message.
         *                             Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMessageLength(java.lang.Number maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoomProps#getMaximumMessageRatePerSecond}
         * @param maximumMessageRatePerSecond Maximum number of messages per second that can be sent to the room (by all clients).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMessageRatePerSecond(java.lang.Number maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoomProps#getMessageReviewHandler}
         * @param messageReviewHandler Configuration information for optional review of messages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageReviewHandler(software.amazon.awscdk.IResolvable messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoomProps#getMessageReviewHandler}
         * @param messageReviewHandler Configuration information for optional review of messages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageReviewHandler(software.amazon.awscdk.services.ivschat.CfnRoom.MessageReviewHandlerProperty messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoomProps#getName}
         * @param name Room name.
         *             The value does not need to be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoomProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivschat-room-tag.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRoomProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRoomProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRoomProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRoomProps {
        private final java.util.List<java.lang.String> loggingConfigurationIdentifiers;
        private final java.lang.Number maximumMessageLength;
        private final java.lang.Number maximumMessageRatePerSecond;
        private final java.lang.Object messageReviewHandler;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loggingConfigurationIdentifiers = software.amazon.jsii.Kernel.get(this, "loggingConfigurationIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maximumMessageLength = software.amazon.jsii.Kernel.get(this, "maximumMessageLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumMessageRatePerSecond = software.amazon.jsii.Kernel.get(this, "maximumMessageRatePerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.messageReviewHandler = software.amazon.jsii.Kernel.get(this, "messageReviewHandler", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loggingConfigurationIdentifiers = builder.loggingConfigurationIdentifiers;
            this.maximumMessageLength = builder.maximumMessageLength;
            this.maximumMessageRatePerSecond = builder.maximumMessageRatePerSecond;
            this.messageReviewHandler = builder.messageReviewHandler;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getLoggingConfigurationIdentifiers() {
            return this.loggingConfigurationIdentifiers;
        }

        @Override
        public final java.lang.Number getMaximumMessageLength() {
            return this.maximumMessageLength;
        }

        @Override
        public final java.lang.Number getMaximumMessageRatePerSecond() {
            return this.maximumMessageRatePerSecond;
        }

        @Override
        public final java.lang.Object getMessageReviewHandler() {
            return this.messageReviewHandler;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLoggingConfigurationIdentifiers() != null) {
                data.set("loggingConfigurationIdentifiers", om.valueToTree(this.getLoggingConfigurationIdentifiers()));
            }
            if (this.getMaximumMessageLength() != null) {
                data.set("maximumMessageLength", om.valueToTree(this.getMaximumMessageLength()));
            }
            if (this.getMaximumMessageRatePerSecond() != null) {
                data.set("maximumMessageRatePerSecond", om.valueToTree(this.getMaximumMessageRatePerSecond()));
            }
            if (this.getMessageReviewHandler() != null) {
                data.set("messageReviewHandler", om.valueToTree(this.getMessageReviewHandler()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivschat.CfnRoomProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRoomProps.Jsii$Proxy that = (CfnRoomProps.Jsii$Proxy) o;

            if (this.loggingConfigurationIdentifiers != null ? !this.loggingConfigurationIdentifiers.equals(that.loggingConfigurationIdentifiers) : that.loggingConfigurationIdentifiers != null) return false;
            if (this.maximumMessageLength != null ? !this.maximumMessageLength.equals(that.maximumMessageLength) : that.maximumMessageLength != null) return false;
            if (this.maximumMessageRatePerSecond != null ? !this.maximumMessageRatePerSecond.equals(that.maximumMessageRatePerSecond) : that.maximumMessageRatePerSecond != null) return false;
            if (this.messageReviewHandler != null ? !this.messageReviewHandler.equals(that.messageReviewHandler) : that.messageReviewHandler != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loggingConfigurationIdentifiers != null ? this.loggingConfigurationIdentifiers.hashCode() : 0;
            result = 31 * result + (this.maximumMessageLength != null ? this.maximumMessageLength.hashCode() : 0);
            result = 31 * result + (this.maximumMessageRatePerSecond != null ? this.maximumMessageRatePerSecond.hashCode() : 0);
            result = 31 * result + (this.messageReviewHandler != null ? this.messageReviewHandler.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
