package software.amazon.awscdk.services.lambda;

/**
 * Result of binding <code>Code</code> into a <code>Function</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CodeConfig codeConfig = CodeConfig.builder()
 *         .image(CodeImageConfig.builder()
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .cmd(List.of("cmd"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .inlineCode("inlineCode")
 *         .s3Location(Location.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 // the properties below are optional
 *                 .objectVersion("objectVersion")
 *                 .build())
 *         .sourceKMSKeyArn("sourceKMSKeyArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.389Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CodeConfig")
@software.amazon.jsii.Jsii.Proxy(CodeConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Docker image configuration (mutually exclusive with <code>s3Location</code> and <code>inlineCode</code>).
     * <p>
     * Default: - code is not an ECR container image
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CodeImageConfig getImage() {
        return null;
    }

    /**
     * Inline code (mutually exclusive with <code>s3Location</code> and <code>image</code>).
     * <p>
     * Default: - code is not inline code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInlineCode() {
        return null;
    }

    /**
     * The location of the code in S3 (mutually exclusive with <code>inlineCode</code> and <code>image</code>).
     * <p>
     * Default: - code is not an s3 location
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Location getS3Location() {
        return null;
    }

    /**
     * The ARN of the KMS key used to encrypt the handler code.
     * <p>
     * Default: - the default server-side encryption with Amazon S3 managed keys(SSE-S3) key will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceKMSKeyArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeConfig> {
        software.amazon.awscdk.services.lambda.CodeImageConfig image;
        java.lang.String inlineCode;
        software.amazon.awscdk.services.s3.Location s3Location;
        java.lang.String sourceKmsKeyArn;

        /**
         * Sets the value of {@link CodeConfig#getImage}
         * @param image Docker image configuration (mutually exclusive with <code>s3Location</code> and <code>inlineCode</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.lambda.CodeImageConfig image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfig#getInlineCode}
         * @param inlineCode Inline code (mutually exclusive with <code>s3Location</code> and <code>image</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlineCode(java.lang.String inlineCode) {
            this.inlineCode = inlineCode;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfig#getS3Location}
         * @param s3Location The location of the code in S3 (mutually exclusive with <code>inlineCode</code> and <code>image</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Location(software.amazon.awscdk.services.s3.Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfig#getSourceKmsKeyArn}
         * @param sourceKmsKeyArn The ARN of the KMS key used to encrypt the handler code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceKmsKeyArn(java.lang.String sourceKmsKeyArn) {
            this.sourceKmsKeyArn = sourceKmsKeyArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfig {
        private final software.amazon.awscdk.services.lambda.CodeImageConfig image;
        private final java.lang.String inlineCode;
        private final software.amazon.awscdk.services.s3.Location s3Location;
        private final java.lang.String sourceKmsKeyArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeImageConfig.class));
            this.inlineCode = software.amazon.jsii.Kernel.get(this, "inlineCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
            this.sourceKmsKeyArn = software.amazon.jsii.Kernel.get(this, "sourceKMSKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = builder.image;
            this.inlineCode = builder.inlineCode;
            this.s3Location = builder.s3Location;
            this.sourceKmsKeyArn = builder.sourceKmsKeyArn;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.CodeImageConfig getImage() {
            return this.image;
        }

        @Override
        public final java.lang.String getInlineCode() {
            return this.inlineCode;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Location getS3Location() {
            return this.s3Location;
        }

        @Override
        public final java.lang.String getSourceKMSKeyArn() {
            return this.sourceKmsKeyArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getImage() != null) {
                data.set("image", om.valueToTree(this.getImage()));
            }
            if (this.getInlineCode() != null) {
                data.set("inlineCode", om.valueToTree(this.getInlineCode()));
            }
            if (this.getS3Location() != null) {
                data.set("s3Location", om.valueToTree(this.getS3Location()));
            }
            if (this.getSourceKMSKeyArn() != null) {
                data.set("sourceKMSKeyArn", om.valueToTree(this.getSourceKMSKeyArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CodeConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeConfig.Jsii$Proxy that = (CodeConfig.Jsii$Proxy) o;

            if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
            if (this.inlineCode != null ? !this.inlineCode.equals(that.inlineCode) : that.inlineCode != null) return false;
            if (this.s3Location != null ? !this.s3Location.equals(that.s3Location) : that.s3Location != null) return false;
            return this.sourceKmsKeyArn != null ? this.sourceKmsKeyArn.equals(that.sourceKmsKeyArn) : that.sourceKmsKeyArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image != null ? this.image.hashCode() : 0;
            result = 31 * result + (this.inlineCode != null ? this.inlineCode.hashCode() : 0);
            result = 31 * result + (this.s3Location != null ? this.s3Location.hashCode() : 0);
            result = 31 * result + (this.sourceKmsKeyArn != null ? this.sourceKmsKeyArn.hashCode() : 0);
            return result;
        }
    }
}
