package software.amazon.awscdk.services.lambda;

/**
 * Lambda function runtime environment.
 * <p>
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a <code>Runtime</code> object, e.g: <code>new Runtime('nodejs99.99')</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.signer.*;
 * SigningProfile signingProfile = SigningProfile.Builder.create(this, "SigningProfile")
 *         .platform(Platform.AWS_LAMBDA_SHA384_ECDSA)
 *         .build();
 * CodeSigningConfig codeSigningConfig = CodeSigningConfig.Builder.create(this, "CodeSigningConfig")
 *         .signingProfiles(List.of(signingProfile))
 *         .build();
 * Function.Builder.create(this, "Function")
 *         .codeSigningConfig(codeSigningConfig)
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.482Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Runtime")
public class Runtime extends software.amazon.jsii.JsiiObject {

    protected Runtime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Runtime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL = java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "ALL", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class))));
        DOTNET_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "DOTNET_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        DOTNET_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "DOTNET_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        DOTNET_CORE_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "DOTNET_CORE_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        DOTNET_CORE_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "DOTNET_CORE_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        DOTNET_CORE_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "DOTNET_CORE_2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        DOTNET_CORE_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "DOTNET_CORE_3_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        FROM_IMAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "FROM_IMAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        GO_1_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "GO_1_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        JAVA_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "JAVA_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        JAVA_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "JAVA_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        JAVA_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "JAVA_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        JAVA_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "JAVA_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        JAVA_8_CORRETTO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "JAVA_8_CORRETTO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_10_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_10_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_12_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_12_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_14_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_14_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_16_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_16_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_18_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_18_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_20_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_20_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_22_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_22_X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_4_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_4_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_6_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_6_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_8_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_8_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        NODEJS_LATEST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "NODEJS_LATEST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PROVIDED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PROVIDED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PROVIDED_AL2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PROVIDED_AL2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PROVIDED_AL2023 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PROVIDED_AL2023", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_2_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_2_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        PYTHON_3_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "PYTHON_3_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        RUBY_2_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "RUBY_2_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        RUBY_2_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "RUBY_2_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        RUBY_3_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "RUBY_3_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
        RUBY_3_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Runtime.class, "RUBY_3_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class));
    }

    /**
     * @param name This parameter is required.
     * @param family
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Runtime(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.RuntimeFamily family, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.LambdaRuntimeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), family, props });
    }

    /**
     * @param name This parameter is required.
     * @param family
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Runtime(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.RuntimeFamily family) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), family });
    }

    /**
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Runtime(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * @param other This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean runtimeEquals(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Runtime other) {
        return software.amazon.jsii.Kernel.call(this, "runtimeEquals", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A list of all known <code>Runtime</code>'s.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.util.List<software.amazon.awscdk.services.lambda.Runtime> ALL;

    /**
     * The .NET 6 runtime (dotnet6).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime DOTNET_6;

    /**
     * The .NET 8 runtime (dotnet8).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime DOTNET_8;

    /**
     * (deprecated) The .NET Core 1.0 runtime (dotnetcore1.0).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime DOTNET_CORE_1;

    /**
     * (deprecated) The .NET Core 2.0 runtime (dotnetcore2.0).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime DOTNET_CORE_2;

    /**
     * (deprecated) The .NET Core 2.1 runtime (dotnetcore2.1).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime DOTNET_CORE_2_1;

    /**
     * (deprecated) The .NET Core 3.1 runtime (dotnetcore3.1).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest .NET Core runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime DOTNET_CORE_3_1;

    /**
     * A special runtime entry to be used when function is using a docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime FROM_IMAGE;

    /**
     * (deprecated) The Go 1.x runtime (go1.x).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the PROVIDED_AL2023 runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime GO_1_X;

    /**
     * The Java 11 runtime (java11).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime JAVA_11;

    /**
     * The Java 17 runtime (java17).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime JAVA_17;

    /**
     * The Java 21 runtime (java21).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime JAVA_21;

    /**
     * (deprecated) The Java 8 runtime (java8).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Java runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime JAVA_8;

    /**
     * The Java 8 Corretto runtime (java8.al2).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime JAVA_8_CORRETTO;

    /**
     * (deprecated) The NodeJS runtime (nodejs).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS;

    /**
     * (deprecated) The NodeJS 10.x runtime (nodejs10.x).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_10_X;

    /**
     * (deprecated) The NodeJS 12.x runtime (nodejs12.x).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_12_X;

    /**
     * (deprecated) The NodeJS 14.x runtime (nodejs14.x).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_14_X;

    /**
     * (deprecated) The NodeJS 16.x runtime (nodejs16.x).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_16_X;

    /**
     * The NodeJS 18.x runtime (nodejs18.x).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_18_X;

    /**
     * The NodeJS 20.x runtime (nodejs20.x).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_20_X;

    /**
     * The NodeJS 22.x runtime (nodejs22.x).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_22_X;

    /**
     * (deprecated) The NodeJS 4.3 runtime (nodejs4.3).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_4_3;

    /**
     * (deprecated) The NodeJS 6.10 runtime (nodejs6.10).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_6_10;

    /**
     * (deprecated) The NodeJS 8.10 runtime (nodejs8.10).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_8_10;

    /**
     * The latest NodeJS version currently available in ALL regions (not necessarily the latest NodeJS version available in YOUR region).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime NODEJS_LATEST;

    /**
     * (deprecated) The custom provided runtime (provided).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest provided.al2023 runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime PROVIDED;

    /**
     * The custom provided runtime with Amazon Linux 2 (provided.al2).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PROVIDED_AL2;

    /**
     * The custom provided runtime with Amazon Linux 2023 (provided.al2023).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PROVIDED_AL2023;

    /**
     * (deprecated) The Python 2.7 runtime (python2.7).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_2_7;

    /**
     * The Python 3.10 runtime (python3.10).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_10;

    /**
     * The Python 3.11 runtime (python3.11).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_11;

    /**
     * The Python 3.12 runtime (python3.12).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_12;

    /**
     * The Python 3.13 runtime (python3.13).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_13;

    /**
     * (deprecated) The Python 3.6 runtime (python3.6) (not recommended).
     * <p>
     * The Python 3.6 runtime is deprecated as of July 2022.
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_6;

    /**
     * (deprecated) The Python 3.7 runtime (python3.7).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_7;

    /**
     * The Python 3.8 runtime (python3.8).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_8;

    /**
     * The Python 3.9 runtime (python3.9).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime PYTHON_3_9;

    /**
     * (deprecated) The Ruby 2.5 runtime (ruby2.5).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Ruby runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime RUBY_2_5;

    /**
     * (deprecated) The Ruby 2.7 runtime (ruby2.7).
     * <p>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Ruby runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.lambda.Runtime RUBY_2_7;

    /**
     * The Ruby 3.2 runtime (ruby3.2).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime RUBY_3_2;

    /**
     * The Ruby 3.3 runtime (ruby3.3).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.Runtime RUBY_3_3;

    /**
     * The bundling Docker image for this runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImage getBundlingImage() {
        return software.amazon.jsii.Kernel.get(this, "bundlingImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class));
    }

    /**
     * Enabled for runtime enums that always target the latest available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsVariable() {
        return software.amazon.jsii.Kernel.get(this, "isVariable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The name of this runtime, as expected by the Lambda resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getSupportsCodeGuruProfiling() {
        return software.amazon.jsii.Kernel.get(this, "supportsCodeGuruProfiling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether the <code>ZipFile</code> (aka inline code) property can be used with this runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getSupportsInlineCode() {
        return software.amazon.jsii.Kernel.get(this, "supportsInlineCode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether this runtime supports snapstart.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getSupportsSnapStart() {
        return software.amazon.jsii.Kernel.get(this, "supportsSnapStart", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The runtime family.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.RuntimeFamily getFamily() {
        return software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.RuntimeFamily.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.Runtime}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.Runtime> {
        /**
         * @return a new instance of {@link Builder}.
         * @param name This parameter is required.
         * @param family
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String name, final software.amazon.awscdk.services.lambda.RuntimeFamily family) {
            return new Builder(name, family);
        }
        /**
         * @return a new instance of {@link Builder}.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String name) {
            return new Builder(name, null);
        }

        private final java.lang.String name;
        private final software.amazon.awscdk.services.lambda.RuntimeFamily family;
        private software.amazon.awscdk.services.lambda.LambdaRuntimeProps.Builder props;

        private Builder(final java.lang.String name, final software.amazon.awscdk.services.lambda.RuntimeFamily family) {
            this.name = name;
            this.family = family;
        }

        /**
         * The Docker image name to be used for bundling in this runtime.
         * <p>
         * Default: - the latest docker image "amazon/public.ecr.aws/sam/build-<runtime>" from https://gallery.ecr.aws
         * <p>
         * @return {@code this}
         * @param bundlingDockerImage The Docker image name to be used for bundling in this runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundlingDockerImage(final java.lang.String bundlingDockerImage) {
            this.props().bundlingDockerImage(bundlingDockerImage);
            return this;
        }

        /**
         * Whether the runtime enum is meant to change over time, IE NODEJS_LATEST.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param isVariable Whether the runtime enum is meant to change over time, IE NODEJS_LATEST. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isVariable(final java.lang.Boolean isVariable) {
            this.props().isVariable(isVariable);
            return this;
        }

        /**
         * Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param supportsCodeGuruProfiling Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsCodeGuruProfiling(final java.lang.Boolean supportsCodeGuruProfiling) {
            this.props().supportsCodeGuruProfiling(supportsCodeGuruProfiling);
            return this;
        }

        /**
         * Whether the <code>ZipFile</code> (aka inline code) property can be used with this runtime.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param supportsInlineCode Whether the <code>ZipFile</code> (aka inline code) property can be used with this runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsInlineCode(final java.lang.Boolean supportsInlineCode) {
            this.props().supportsInlineCode(supportsInlineCode);
            return this;
        }

        /**
         * Whether this runtime supports SnapStart.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param supportsSnapStart Whether this runtime supports SnapStart. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsSnapStart(final java.lang.Boolean supportsSnapStart) {
            this.props().supportsSnapStart(supportsSnapStart);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.Runtime}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.Runtime build() {
            return new software.amazon.awscdk.services.lambda.Runtime(
                this.name,
                this.family,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.LambdaRuntimeProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.lambda.LambdaRuntimeProps.Builder();
            }
            return this.props;
        }
    }
}
