package software.amazon.awscdk.services.lambda;

/**
 * Specify the runtime update mode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function.Builder.create(this, "Lambda")
 *         .runtimeManagementMode(RuntimeManagementMode.AUTO)
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.483Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.RuntimeManagementMode")
public class RuntimeManagementMode extends software.amazon.jsii.JsiiObject {

    protected RuntimeManagementMode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RuntimeManagementMode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AUTO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.RuntimeManagementMode.class, "AUTO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.RuntimeManagementMode.class));
        FUNCTION_UPDATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.RuntimeManagementMode.class, "FUNCTION_UPDATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.RuntimeManagementMode.class));
    }

    /**
     * @param mode This parameter is required.
     * @param arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RuntimeManagementMode(final @org.jetbrains.annotations.NotNull java.lang.String mode, final @org.jetbrains.annotations.Nullable java.lang.String arn) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(mode, "mode is required"), arn });
    }

    /**
     * @param mode This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RuntimeManagementMode(final @org.jetbrains.annotations.NotNull java.lang.String mode) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(mode, "mode is required") });
    }

    /**
     * You specify a runtime version in your function configuration.
     * <p>
     * The function uses this runtime version indefinitely.
     * In the rare case in which a new runtime version is incompatible with an existing function,
     * you can use this mode to roll back your function to an earlier runtime version.
     * <p>
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.RuntimeManagementMode manual(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.RuntimeManagementMode.class, "manual", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.RuntimeManagementMode.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Automatically update to the most recent and secure runtime version using Two-phase runtime version rollout.
     * <p>
     * We recommend this mode for most customers so that you always benefit from runtime updates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.RuntimeManagementMode AUTO;

    /**
     * When you update your function, Lambda updates the runtime of your function to the most recent and secure runtime version.
     * <p>
     * This approach synchronizes runtime updates with function deployments,
     * giving you control over when Lambda applies runtime updates.
     * With this mode, you can detect and mitigate rare runtime update incompatibilities early.
     * When using this mode, you must regularly update your functions to keep their runtime up to date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.RuntimeManagementMode FUNCTION_UPDATE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-runtimemanagementconfig.html.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnFunction.RuntimeManagementConfigProperty getRuntimeManagementConfig() {
        return software.amazon.jsii.Kernel.get(this, "runtimeManagementConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CfnFunction.RuntimeManagementConfigProperty.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
