package software.amazon.awscdk.services.lambda.eventsources;

/**
 * S3EventSourceV2 Use S3 bucket notifications as an event source for AWS Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.lambda.eventsources.S3EventSourceV2;
 * Function fn;
 * IBucket bucket = Bucket.fromBucketName(this, "Bucket", "amzn-s3-demo-bucket");
 * fn.addEventSource(S3EventSourceV2.Builder.create(bucket)
 *         .events(List.of(EventType.OBJECT_CREATED, EventType.OBJECT_REMOVED))
 *         .filters(List.of(NotificationKeyFilter.builder().prefix("subdir/").build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.529Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.S3EventSourceV2")
public class S3EventSourceV2 extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSource {

    protected S3EventSourceV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3EventSourceV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3EventSourceV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by <code>lambda.addEventSource</code> to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.S3EventSourceV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.S3EventSourceV2> {
        /**
         * @return a new instance of {@link Builder}.
         * @param bucket This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.s3.IBucket bucket) {
            return new Builder(bucket);
        }

        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps.Builder props;

        private Builder(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            this.props = new software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps.Builder();
        }

        /**
         * The s3 event types that will trigger the notification.
         * <p>
         * @return {@code this}
         * @param events The s3 event types that will trigger the notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.List<? extends software.amazon.awscdk.services.s3.EventType> events) {
            this.props.events(events);
            return this;
        }

        /**
         * S3 object key filter rules to determine which objects trigger this event.
         * <p>
         * Each filter must include a <code>prefix</code> and/or <code>suffix</code> that will be matched
         * against the s3 object key. Refer to the S3 Developer Guide for details
         * about allowed filter rules.
         * <p>
         * @return {@code this}
         * @param filters S3 object key filter rules to determine which objects trigger this event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final java.util.List<? extends software.amazon.awscdk.services.s3.NotificationKeyFilter> filters) {
            this.props.filters(filters);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.S3EventSourceV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.S3EventSourceV2 build() {
            return new software.amazon.awscdk.services.lambda.eventsources.S3EventSourceV2(
                this.bucket,
                this.props.build()
            );
        }
    }
}
