package software.amazon.awscdk.services.lex;

/**
 * <blockquote><p>Amazon Lex V2 is the only supported version in AWS CloudFormation .<p></blockquote>
 * <p>
 * Specifies an Amazon Lex conversational bot.
 * <p>
 * You must configure an intent based on the <code>AMAZON.FallbackIntent</code> built-in intent. If you don't add one, creating the bot will fail.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lex-bot.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:10.566Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot")
public class CfnBot extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnBot(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBot(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lex.CfnBot.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBot(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lex.CfnBotProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * By default, data stored by Amazon Lex is encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDataPrivacy() {
        return software.amazon.jsii.Kernel.get(this, "dataPrivacy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * By default, data stored by Amazon Lex is encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataPrivacy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "dataPrivacy", java.util.Objects.requireNonNull(value, "dataPrivacy is required"));
    }

    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getIdleSessionTtlInSeconds() {
        return software.amazon.jsii.Kernel.get(this, "idleSessionTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdleSessionTtlInSeconds(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "idleSessionTtlInSeconds", java.util.Objects.requireNonNull(value, "idleSessionTtlInSeconds is required"));
    }

    /**
     * The name of the bot locale.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the bot locale.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoBuildBotLocales() {
        return software.amazon.jsii.Kernel.get(this, "autoBuildBotLocales", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoBuildBotLocales(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoBuildBotLocales", value);
    }

    /**
     * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoBuildBotLocales(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoBuildBotLocales", value);
    }

    /**
     * The Amazon S3 location of files used to import a bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotFileS3Location() {
        return software.amazon.jsii.Kernel.get(this, "botFileS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon S3 location of files used to import a bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotFileS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botFileS3Location", value);
    }

    /**
     * The Amazon S3 location of files used to import a bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotFileS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "botFileS3Location", value);
    }

    /**
     * A list of locales for the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotLocales() {
        return software.amazon.jsii.Kernel.get(this, "botLocales", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of locales for the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotLocales(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botLocales", value);
    }

    /**
     * A list of locales for the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotLocales(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lex.CfnBot.BotLocaleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lex.CfnBot.BotLocaleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "botLocales", value);
    }

    /**
     * A list of tags to add to the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotTags() {
        return software.amazon.jsii.Kernel.get(this, "botTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of tags to add to the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botTags", value);
    }

    /**
     * A list of tags to add to the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "botTags", value);
    }

    /**
     * The description of the version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies configuration settings for the alias used to test the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTestBotAliasSettings() {
        return software.amazon.jsii.Kernel.get(this, "testBotAliasSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration settings for the alias used to test the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "testBotAliasSettings", value);
    }

    /**
     * Specifies configuration settings for the alias used to test the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lex.CfnBot.TestBotAliasSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "testBotAliasSettings", value);
    }

    /**
     * A list of tags to add to the test alias for a bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTestBotAliasTags() {
        return software.amazon.jsii.Kernel.get(this, "testBotAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of tags to add to the test alias for a bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "testBotAliasTags", value);
    }

    /**
     * A list of tags to add to the test alias for a bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "testBotAliasTags", value);
    }
    /**
     * Provides settings that enable advanced recognition settings for slot values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AdvancedRecognitionSettingProperty advancedRecognitionSettingProperty = AdvancedRecognitionSettingProperty.builder()
     *         .audioRecognitionStrategy("audioRecognitionStrategy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-advancedrecognitionsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-advancedrecognitionsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AdvancedRecognitionSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedRecognitionSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedRecognitionSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables using the slot values as a custom vocabulary for recognizing user utterances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-advancedrecognitionsetting.html#cfn-lex-bot-advancedrecognitionsetting-audiorecognitionstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-advancedrecognitionsetting.html#cfn-lex-bot-advancedrecognitionsetting-audiorecognitionstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioRecognitionStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedRecognitionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedRecognitionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedRecognitionSettingProperty> {
            java.lang.String audioRecognitionStrategy;

            /**
             * Sets the value of {@link AdvancedRecognitionSettingProperty#getAudioRecognitionStrategy}
             * @param audioRecognitionStrategy Enables using the slot values as a custom vocabulary for recognizing user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioRecognitionStrategy(java.lang.String audioRecognitionStrategy) {
                this.audioRecognitionStrategy = audioRecognitionStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedRecognitionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedRecognitionSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedRecognitionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedRecognitionSettingProperty {
            private final java.lang.String audioRecognitionStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioRecognitionStrategy = software.amazon.jsii.Kernel.get(this, "audioRecognitionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioRecognitionStrategy = builder.audioRecognitionStrategy;
            }

            @Override
            public final java.lang.String getAudioRecognitionStrategy() {
                return this.audioRecognitionStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioRecognitionStrategy() != null) {
                    data.set("audioRecognitionStrategy", om.valueToTree(this.getAudioRecognitionStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AdvancedRecognitionSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedRecognitionSettingProperty.Jsii$Proxy that = (AdvancedRecognitionSettingProperty.Jsii$Proxy) o;

                return this.audioRecognitionStrategy != null ? this.audioRecognitionStrategy.equals(that.audioRecognitionStrategy) : that.audioRecognitionStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioRecognitionStrategy != null ? this.audioRecognitionStrategy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the allowed input types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AllowedInputTypesProperty allowedInputTypesProperty = AllowedInputTypesProperty.builder()
     *         .allowAudioInput(false)
     *         .allowDtmfInput(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AllowedInputTypesProperty")
    @software.amazon.jsii.Jsii.Proxy(AllowedInputTypesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AllowedInputTypesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether audio input is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html#cfn-lex-bot-allowedinputtypes-allowaudioinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html#cfn-lex-bot-allowedinputtypes-allowaudioinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllowAudioInput();

        /**
         * Indicates whether DTMF input is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html#cfn-lex-bot-allowedinputtypes-allowdtmfinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-allowedinputtypes.html#cfn-lex-bot-allowedinputtypes-allowdtmfinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllowDtmfInput();

        /**
         * @return a {@link Builder} of {@link AllowedInputTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AllowedInputTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AllowedInputTypesProperty> {
            java.lang.Object allowAudioInput;
            java.lang.Object allowDtmfInput;

            /**
             * Sets the value of {@link AllowedInputTypesProperty#getAllowAudioInput}
             * @param allowAudioInput Indicates whether audio input is allowed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAudioInput(java.lang.Boolean allowAudioInput) {
                this.allowAudioInput = allowAudioInput;
                return this;
            }

            /**
             * Sets the value of {@link AllowedInputTypesProperty#getAllowAudioInput}
             * @param allowAudioInput Indicates whether audio input is allowed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAudioInput(software.amazon.awscdk.IResolvable allowAudioInput) {
                this.allowAudioInput = allowAudioInput;
                return this;
            }

            /**
             * Sets the value of {@link AllowedInputTypesProperty#getAllowDtmfInput}
             * @param allowDtmfInput Indicates whether DTMF input is allowed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowDtmfInput(java.lang.Boolean allowDtmfInput) {
                this.allowDtmfInput = allowDtmfInput;
                return this;
            }

            /**
             * Sets the value of {@link AllowedInputTypesProperty#getAllowDtmfInput}
             * @param allowDtmfInput Indicates whether DTMF input is allowed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowDtmfInput(software.amazon.awscdk.IResolvable allowDtmfInput) {
                this.allowDtmfInput = allowDtmfInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AllowedInputTypesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AllowedInputTypesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AllowedInputTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllowedInputTypesProperty {
            private final java.lang.Object allowAudioInput;
            private final java.lang.Object allowDtmfInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowAudioInput = software.amazon.jsii.Kernel.get(this, "allowAudioInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowDtmfInput = software.amazon.jsii.Kernel.get(this, "allowDtmfInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowAudioInput = java.util.Objects.requireNonNull(builder.allowAudioInput, "allowAudioInput is required");
                this.allowDtmfInput = java.util.Objects.requireNonNull(builder.allowDtmfInput, "allowDtmfInput is required");
            }

            @Override
            public final java.lang.Object getAllowAudioInput() {
                return this.allowAudioInput;
            }

            @Override
            public final java.lang.Object getAllowDtmfInput() {
                return this.allowDtmfInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowAudioInput", om.valueToTree(this.getAllowAudioInput()));
                data.set("allowDtmfInput", om.valueToTree(this.getAllowDtmfInput()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AllowedInputTypesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AllowedInputTypesProperty.Jsii$Proxy that = (AllowedInputTypesProperty.Jsii$Proxy) o;

                if (!allowAudioInput.equals(that.allowAudioInput)) return false;
                return this.allowDtmfInput.equals(that.allowDtmfInput);
            }

            @Override
            public final int hashCode() {
                int result = this.allowAudioInput.hashCode();
                result = 31 * result + (this.allowDtmfInput.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the audio and DTMF input specification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioAndDTMFInputSpecificationProperty audioAndDTMFInputSpecificationProperty = AudioAndDTMFInputSpecificationProperty.builder()
     *         .startTimeoutMs(123)
     *         // the properties below are optional
     *         .audioSpecification(AudioSpecificationProperty.builder()
     *                 .endTimeoutMs(123)
     *                 .maxLengthMs(123)
     *                 .build())
     *         .dtmfSpecification(DTMFSpecificationProperty.builder()
     *                 .deletionCharacter("deletionCharacter")
     *                 .endCharacter("endCharacter")
     *                 .endTimeoutMs(123)
     *                 .maxLength(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AudioAndDTMFInputSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioAndDTMFInputSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioAndDTMFInputSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Time for which a bot waits before assuming that the customer isn't going to speak or press a key.
         * <p>
         * This timeout is shared between Audio and DTMF inputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-starttimeoutms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-starttimeoutms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStartTimeoutMs();

        /**
         * Specifies the settings on audio input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-audiospecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-audiospecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioSpecification() {
            return null;
        }

        /**
         * Specifies the settings on DTMF input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-dtmfspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audioanddtmfinputspecification.html#cfn-lex-bot-audioanddtmfinputspecification-dtmfspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDtmfSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioAndDTMFInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioAndDTMFInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioAndDTMFInputSpecificationProperty> {
            java.lang.Number startTimeoutMs;
            java.lang.Object audioSpecification;
            java.lang.Object dtmfSpecification;

            /**
             * Sets the value of {@link AudioAndDTMFInputSpecificationProperty#getStartTimeoutMs}
             * @param startTimeoutMs Time for which a bot waits before assuming that the customer isn't going to speak or press a key. This parameter is required.
             *                       This timeout is shared between Audio and DTMF inputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTimeoutMs(java.lang.Number startTimeoutMs) {
                this.startTimeoutMs = startTimeoutMs;
                return this;
            }

            /**
             * Sets the value of {@link AudioAndDTMFInputSpecificationProperty#getAudioSpecification}
             * @param audioSpecification Specifies the settings on audio input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSpecification(software.amazon.awscdk.IResolvable audioSpecification) {
                this.audioSpecification = audioSpecification;
                return this;
            }

            /**
             * Sets the value of {@link AudioAndDTMFInputSpecificationProperty#getAudioSpecification}
             * @param audioSpecification Specifies the settings on audio input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSpecification(software.amazon.awscdk.services.lex.CfnBot.AudioSpecificationProperty audioSpecification) {
                this.audioSpecification = audioSpecification;
                return this;
            }

            /**
             * Sets the value of {@link AudioAndDTMFInputSpecificationProperty#getDtmfSpecification}
             * @param dtmfSpecification Specifies the settings on DTMF input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dtmfSpecification(software.amazon.awscdk.IResolvable dtmfSpecification) {
                this.dtmfSpecification = dtmfSpecification;
                return this;
            }

            /**
             * Sets the value of {@link AudioAndDTMFInputSpecificationProperty#getDtmfSpecification}
             * @param dtmfSpecification Specifies the settings on DTMF input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dtmfSpecification(software.amazon.awscdk.services.lex.CfnBot.DTMFSpecificationProperty dtmfSpecification) {
                this.dtmfSpecification = dtmfSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioAndDTMFInputSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioAndDTMFInputSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioAndDTMFInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioAndDTMFInputSpecificationProperty {
            private final java.lang.Number startTimeoutMs;
            private final java.lang.Object audioSpecification;
            private final java.lang.Object dtmfSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startTimeoutMs = software.amazon.jsii.Kernel.get(this, "startTimeoutMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.audioSpecification = software.amazon.jsii.Kernel.get(this, "audioSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dtmfSpecification = software.amazon.jsii.Kernel.get(this, "dtmfSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startTimeoutMs = java.util.Objects.requireNonNull(builder.startTimeoutMs, "startTimeoutMs is required");
                this.audioSpecification = builder.audioSpecification;
                this.dtmfSpecification = builder.dtmfSpecification;
            }

            @Override
            public final java.lang.Number getStartTimeoutMs() {
                return this.startTimeoutMs;
            }

            @Override
            public final java.lang.Object getAudioSpecification() {
                return this.audioSpecification;
            }

            @Override
            public final java.lang.Object getDtmfSpecification() {
                return this.dtmfSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startTimeoutMs", om.valueToTree(this.getStartTimeoutMs()));
                if (this.getAudioSpecification() != null) {
                    data.set("audioSpecification", om.valueToTree(this.getAudioSpecification()));
                }
                if (this.getDtmfSpecification() != null) {
                    data.set("dtmfSpecification", om.valueToTree(this.getDtmfSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AudioAndDTMFInputSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioAndDTMFInputSpecificationProperty.Jsii$Proxy that = (AudioAndDTMFInputSpecificationProperty.Jsii$Proxy) o;

                if (!startTimeoutMs.equals(that.startTimeoutMs)) return false;
                if (this.audioSpecification != null ? !this.audioSpecification.equals(that.audioSpecification) : that.audioSpecification != null) return false;
                return this.dtmfSpecification != null ? this.dtmfSpecification.equals(that.dtmfSpecification) : that.dtmfSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startTimeoutMs.hashCode();
                result = 31 * result + (this.audioSpecification != null ? this.audioSpecification.hashCode() : 0);
                result = 31 * result + (this.dtmfSpecification != null ? this.dtmfSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The location of audio log files collected when conversation logging is enabled for a bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioLogDestinationProperty audioLogDestinationProperty = AudioLogDestinationProperty.builder()
     *         .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                 .logPrefix("logPrefix")
     *                 .s3BucketArn("s3BucketArn")
     *                 // the properties below are optional
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AudioLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon S3 bucket where the audio files are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologdestination.html#cfn-lex-bot-audiologdestination-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologdestination.html#cfn-lex-bot-audiologdestination-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Bucket();

        /**
         * @return a {@link Builder} of {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLogDestinationProperty> {
            java.lang.Object s3Bucket;

            /**
             * Sets the value of {@link AudioLogDestinationProperty#getS3Bucket}
             * @param s3Bucket Specifies the Amazon S3 bucket where the audio files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(software.amazon.awscdk.IResolvable s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogDestinationProperty#getS3Bucket}
             * @param s3Bucket Specifies the Amazon S3 bucket where the audio files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(software.amazon.awscdk.services.lex.CfnBot.S3BucketLogDestinationProperty s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLogDestinationProperty {
            private final java.lang.Object s3Bucket;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
            }

            @Override
            public final java.lang.Object getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AudioLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLogDestinationProperty.Jsii$Proxy that = (AudioLogDestinationProperty.Jsii$Proxy) o;

                return this.s3Bucket.equals(that.s3Bucket);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for logging audio of conversations between Amazon Lex and a user.
     * <p>
     * You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioLogSettingProperty audioLogSettingProperty = AudioLogSettingProperty.builder()
     *         .destination(AudioLogDestinationProperty.builder()
     *                 .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                         .logPrefix("logPrefix")
     *                         .s3BucketArn("s3BucketArn")
     *                         // the properties below are optional
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .build())
     *                 .build())
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AudioLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the location of the audio log files collected when conversation logging is enabled for a bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html#cfn-lex-bot-audiologsetting-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html#cfn-lex-bot-audiologsetting-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Determines whether audio logging in enabled for the bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html#cfn-lex-bot-audiologsetting-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiologsetting.html#cfn-lex-bot-audiologsetting-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLogSettingProperty> {
            java.lang.Object destination;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AudioLogSettingProperty#getDestination}
             * @param destination Specifies the location of the audio log files collected when conversation logging is enabled for a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getDestination}
             * @param destination Specifies the location of the audio log files collected when conversation logging is enabled for a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.lex.CfnBot.AudioLogDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getEnabled}
             * @param enabled Determines whether audio logging in enabled for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getEnabled}
             * @param enabled Determines whether audio logging in enabled for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLogSettingProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AudioLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLogSettingProperty.Jsii$Proxy that = (AudioLogSettingProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the audio input specifications.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioSpecificationProperty audioSpecificationProperty = AudioSpecificationProperty.builder()
     *         .endTimeoutMs(123)
     *         .maxLengthMs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AudioSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html#cfn-lex-bot-audiospecification-endtimeoutms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html#cfn-lex-bot-audiospecification-endtimeoutms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getEndTimeoutMs();

        /**
         * Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html#cfn-lex-bot-audiospecification-maxlengthms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-audiospecification.html#cfn-lex-bot-audiospecification-maxlengthms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxLengthMs();

        /**
         * @return a {@link Builder} of {@link AudioSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioSpecificationProperty> {
            java.lang.Number endTimeoutMs;
            java.lang.Number maxLengthMs;

            /**
             * Sets the value of {@link AudioSpecificationProperty#getEndTimeoutMs}
             * @param endTimeoutMs Time for which a bot waits after the customer stops speaking to assume the utterance is finished. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTimeoutMs(java.lang.Number endTimeoutMs) {
                this.endTimeoutMs = endTimeoutMs;
                return this;
            }

            /**
             * Sets the value of {@link AudioSpecificationProperty#getMaxLengthMs}
             * @param maxLengthMs Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxLengthMs(java.lang.Number maxLengthMs) {
                this.maxLengthMs = maxLengthMs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioSpecificationProperty {
            private final java.lang.Number endTimeoutMs;
            private final java.lang.Number maxLengthMs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTimeoutMs = software.amazon.jsii.Kernel.get(this, "endTimeoutMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxLengthMs = software.amazon.jsii.Kernel.get(this, "maxLengthMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTimeoutMs = java.util.Objects.requireNonNull(builder.endTimeoutMs, "endTimeoutMs is required");
                this.maxLengthMs = java.util.Objects.requireNonNull(builder.maxLengthMs, "maxLengthMs is required");
            }

            @Override
            public final java.lang.Number getEndTimeoutMs() {
                return this.endTimeoutMs;
            }

            @Override
            public final java.lang.Number getMaxLengthMs() {
                return this.maxLengthMs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endTimeoutMs", om.valueToTree(this.getEndTimeoutMs()));
                data.set("maxLengthMs", om.valueToTree(this.getMaxLengthMs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AudioSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioSpecificationProperty.Jsii$Proxy that = (AudioSpecificationProperty.Jsii$Proxy) o;

                if (!endTimeoutMs.equals(that.endTimeoutMs)) return false;
                return this.maxLengthMs.equals(that.maxLengthMs);
            }

            @Override
            public final int hashCode() {
                int result = this.endTimeoutMs.hashCode();
                result = 31 * result + (this.maxLengthMs.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies locale settings for a single locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * BotAliasLocaleSettingsItemProperty botAliasLocaleSettingsItemProperty = BotAliasLocaleSettingsItemProperty.builder()
     *         .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .codeHookSpecification(CodeHookSpecificationProperty.builder()
     *                         .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                                 .lambdaArn("lambdaArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .localeId("localeId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsItemProperty")
    @software.amazon.jsii.Jsii.Proxy(BotAliasLocaleSettingsItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotAliasLocaleSettingsItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies locale settings for a locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html#cfn-lex-bot-botaliaslocalesettingsitem-botaliaslocalesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html#cfn-lex-bot-botaliaslocalesettingsitem-botaliaslocalesetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBotAliasLocaleSetting();

        /**
         * Specifies the locale that the settings apply to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html#cfn-lex-bot-botaliaslocalesettingsitem-localeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettingsitem.html#cfn-lex-bot-botaliaslocalesettingsitem-localeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocaleId();

        /**
         * @return a {@link Builder} of {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotAliasLocaleSettingsItemProperty> {
            java.lang.Object botAliasLocaleSetting;
            java.lang.String localeId;

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getBotAliasLocaleSetting}
             * @param botAliasLocaleSetting Specifies locale settings for a locale. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSetting(software.amazon.awscdk.IResolvable botAliasLocaleSetting) {
                this.botAliasLocaleSetting = botAliasLocaleSetting;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getBotAliasLocaleSetting}
             * @param botAliasLocaleSetting Specifies locale settings for a locale. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSetting(software.amazon.awscdk.services.lex.CfnBot.BotAliasLocaleSettingsProperty botAliasLocaleSetting) {
                this.botAliasLocaleSetting = botAliasLocaleSetting;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getLocaleId}
             * @param localeId Specifies the locale that the settings apply to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeId(java.lang.String localeId) {
                this.localeId = localeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotAliasLocaleSettingsItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotAliasLocaleSettingsItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotAliasLocaleSettingsItemProperty {
            private final java.lang.Object botAliasLocaleSetting;
            private final java.lang.String localeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.botAliasLocaleSetting = software.amazon.jsii.Kernel.get(this, "botAliasLocaleSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.localeId = software.amazon.jsii.Kernel.get(this, "localeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.botAliasLocaleSetting = java.util.Objects.requireNonNull(builder.botAliasLocaleSetting, "botAliasLocaleSetting is required");
                this.localeId = java.util.Objects.requireNonNull(builder.localeId, "localeId is required");
            }

            @Override
            public final java.lang.Object getBotAliasLocaleSetting() {
                return this.botAliasLocaleSetting;
            }

            @Override
            public final java.lang.String getLocaleId() {
                return this.localeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("botAliasLocaleSetting", om.valueToTree(this.getBotAliasLocaleSetting()));
                data.set("localeId", om.valueToTree(this.getLocaleId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotAliasLocaleSettingsItemProperty.Jsii$Proxy that = (BotAliasLocaleSettingsItemProperty.Jsii$Proxy) o;

                if (!botAliasLocaleSetting.equals(that.botAliasLocaleSetting)) return false;
                return this.localeId.equals(that.localeId);
            }

            @Override
            public final int hashCode() {
                int result = this.botAliasLocaleSetting.hashCode();
                result = 31 * result + (this.localeId.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies settings that are unique to a locale.
     * <p>
     * For example, you can use different Lambda function depending on the bot's locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * BotAliasLocaleSettingsProperty botAliasLocaleSettingsProperty = BotAliasLocaleSettingsProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .codeHookSpecification(CodeHookSpecificationProperty.builder()
     *                 .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                         .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                         .lambdaArn("lambdaArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(BotAliasLocaleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotAliasLocaleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether the locale is enabled for the bot.
         * <p>
         * If the value is <code>false</code> , the locale isn't available for use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html#cfn-lex-bot-botaliaslocalesettings-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html#cfn-lex-bot-botaliaslocalesettings-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Specifies the Lambda function that should be used in the locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html#cfn-lex-bot-botaliaslocalesettings-codehookspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botaliaslocalesettings.html#cfn-lex-bot-botaliaslocalesettings-codehookspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeHookSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotAliasLocaleSettingsProperty> {
            java.lang.Object enabled;
            java.lang.Object codeHookSpecification;

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getEnabled}
             * @param enabled Determines whether the locale is enabled for the bot. This parameter is required.
             *                If the value is <code>false</code> , the locale isn't available for use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getEnabled}
             * @param enabled Determines whether the locale is enabled for the bot. This parameter is required.
             *                If the value is <code>false</code> , the locale isn't available for use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getCodeHookSpecification}
             * @param codeHookSpecification Specifies the Lambda function that should be used in the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookSpecification(software.amazon.awscdk.IResolvable codeHookSpecification) {
                this.codeHookSpecification = codeHookSpecification;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getCodeHookSpecification}
             * @param codeHookSpecification Specifies the Lambda function that should be used in the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookSpecification(software.amazon.awscdk.services.lex.CfnBot.CodeHookSpecificationProperty codeHookSpecification) {
                this.codeHookSpecification = codeHookSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotAliasLocaleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotAliasLocaleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotAliasLocaleSettingsProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object codeHookSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeHookSpecification = software.amazon.jsii.Kernel.get(this, "codeHookSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.codeHookSpecification = builder.codeHookSpecification;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getCodeHookSpecification() {
                return this.codeHookSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getCodeHookSpecification() != null) {
                    data.set("codeHookSpecification", om.valueToTree(this.getCodeHookSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotAliasLocaleSettingsProperty.Jsii$Proxy that = (BotAliasLocaleSettingsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.codeHookSpecification != null ? this.codeHookSpecification.equals(that.codeHookSpecification) : that.codeHookSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.codeHookSpecification != null ? this.codeHookSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides configuration information for a locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.BotLocaleProperty")
    @software.amazon.jsii.Jsii.Proxy(BotLocaleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotLocaleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the language and locale that the bot will be used in.
         * <p>
         * The string must match one of the supported locales.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-localeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-localeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocaleId();

        /**
         * Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code> , <code>AMAZON.KendraSearchIntent</code> , or both when returning alternative intents. You must configure an <code>AMAZON.FallbackIntent</code> . <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-nluconfidencethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-nluconfidencethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNluConfidenceThreshold();

        /**
         * Specifies a custom vocabulary to use with a specific locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-customvocabulary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-customvocabulary</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomVocabulary() {
            return null;
        }

        /**
         * A description of the bot locale.
         * <p>
         * Use this to help identify the bot locale in lists.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * One or more intents defined for the locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-intents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-intents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntents() {
            return null;
        }

        /**
         * One or more slot types defined for the locale.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-slottypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-slottypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotTypes() {
            return null;
        }

        /**
         * Defines settings for using an Amazon Polly voice to communicate with a user.
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><code>standard</code></li>
         * <li><code>neural</code></li>
         * <li><code>long-form</code></li>
         * <li><code>generative</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-voicesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-botlocale.html#cfn-lex-bot-botlocale-voicesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVoiceSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BotLocaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotLocaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotLocaleProperty> {
            java.lang.String localeId;
            java.lang.Number nluConfidenceThreshold;
            java.lang.Object customVocabulary;
            java.lang.String description;
            java.lang.Object intents;
            java.lang.Object slotTypes;
            java.lang.Object voiceSettings;

            /**
             * Sets the value of {@link BotLocaleProperty#getLocaleId}
             * @param localeId The identifier of the language and locale that the bot will be used in. This parameter is required.
             *                 The string must match one of the supported locales.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeId(java.lang.String localeId) {
                this.localeId = localeId;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getNluConfidenceThreshold}
             * @param nluConfidenceThreshold Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code> , <code>AMAZON.KendraSearchIntent</code> , or both when returning alternative intents. You must configure an <code>AMAZON.FallbackIntent</code> . <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nluConfidenceThreshold(java.lang.Number nluConfidenceThreshold) {
                this.nluConfidenceThreshold = nluConfidenceThreshold;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getCustomVocabulary}
             * @param customVocabulary Specifies a custom vocabulary to use with a specific locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabulary(software.amazon.awscdk.IResolvable customVocabulary) {
                this.customVocabulary = customVocabulary;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getCustomVocabulary}
             * @param customVocabulary Specifies a custom vocabulary to use with a specific locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabulary(software.amazon.awscdk.services.lex.CfnBot.CustomVocabularyProperty customVocabulary) {
                this.customVocabulary = customVocabulary;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getDescription}
             * @param description A description of the bot locale.
             *                    Use this to help identify the bot locale in lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getIntents}
             * @param intents One or more intents defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intents(software.amazon.awscdk.IResolvable intents) {
                this.intents = intents;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getIntents}
             * @param intents One or more intents defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intents(java.util.List<? extends java.lang.Object> intents) {
                this.intents = intents;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getSlotTypes}
             * @param slotTypes One or more slot types defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypes(software.amazon.awscdk.IResolvable slotTypes) {
                this.slotTypes = slotTypes;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getSlotTypes}
             * @param slotTypes One or more slot types defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypes(java.util.List<? extends java.lang.Object> slotTypes) {
                this.slotTypes = slotTypes;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getVoiceSettings}
             * @param voiceSettings Defines settings for using an Amazon Polly voice to communicate with a user.
             *                      Valid values include:
             *                      <p>
             *                      <ul>
             *                      <li><code>standard</code></li>
             *                      <li><code>neural</code></li>
             *                      <li><code>long-form</code></li>
             *                      <li><code>generative</code></li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voiceSettings(software.amazon.awscdk.IResolvable voiceSettings) {
                this.voiceSettings = voiceSettings;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getVoiceSettings}
             * @param voiceSettings Defines settings for using an Amazon Polly voice to communicate with a user.
             *                      Valid values include:
             *                      <p>
             *                      <ul>
             *                      <li><code>standard</code></li>
             *                      <li><code>neural</code></li>
             *                      <li><code>long-form</code></li>
             *                      <li><code>generative</code></li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voiceSettings(software.amazon.awscdk.services.lex.CfnBot.VoiceSettingsProperty voiceSettings) {
                this.voiceSettings = voiceSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotLocaleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotLocaleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotLocaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotLocaleProperty {
            private final java.lang.String localeId;
            private final java.lang.Number nluConfidenceThreshold;
            private final java.lang.Object customVocabulary;
            private final java.lang.String description;
            private final java.lang.Object intents;
            private final java.lang.Object slotTypes;
            private final java.lang.Object voiceSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localeId = software.amazon.jsii.Kernel.get(this, "localeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nluConfidenceThreshold = software.amazon.jsii.Kernel.get(this, "nluConfidenceThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customVocabulary = software.amazon.jsii.Kernel.get(this, "customVocabulary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.intents = software.amazon.jsii.Kernel.get(this, "intents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slotTypes = software.amazon.jsii.Kernel.get(this, "slotTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.voiceSettings = software.amazon.jsii.Kernel.get(this, "voiceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localeId = java.util.Objects.requireNonNull(builder.localeId, "localeId is required");
                this.nluConfidenceThreshold = java.util.Objects.requireNonNull(builder.nluConfidenceThreshold, "nluConfidenceThreshold is required");
                this.customVocabulary = builder.customVocabulary;
                this.description = builder.description;
                this.intents = builder.intents;
                this.slotTypes = builder.slotTypes;
                this.voiceSettings = builder.voiceSettings;
            }

            @Override
            public final java.lang.String getLocaleId() {
                return this.localeId;
            }

            @Override
            public final java.lang.Number getNluConfidenceThreshold() {
                return this.nluConfidenceThreshold;
            }

            @Override
            public final java.lang.Object getCustomVocabulary() {
                return this.customVocabulary;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getIntents() {
                return this.intents;
            }

            @Override
            public final java.lang.Object getSlotTypes() {
                return this.slotTypes;
            }

            @Override
            public final java.lang.Object getVoiceSettings() {
                return this.voiceSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localeId", om.valueToTree(this.getLocaleId()));
                data.set("nluConfidenceThreshold", om.valueToTree(this.getNluConfidenceThreshold()));
                if (this.getCustomVocabulary() != null) {
                    data.set("customVocabulary", om.valueToTree(this.getCustomVocabulary()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getIntents() != null) {
                    data.set("intents", om.valueToTree(this.getIntents()));
                }
                if (this.getSlotTypes() != null) {
                    data.set("slotTypes", om.valueToTree(this.getSlotTypes()));
                }
                if (this.getVoiceSettings() != null) {
                    data.set("voiceSettings", om.valueToTree(this.getVoiceSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.BotLocaleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotLocaleProperty.Jsii$Proxy that = (BotLocaleProperty.Jsii$Proxy) o;

                if (!localeId.equals(that.localeId)) return false;
                if (!nluConfidenceThreshold.equals(that.nluConfidenceThreshold)) return false;
                if (this.customVocabulary != null ? !this.customVocabulary.equals(that.customVocabulary) : that.customVocabulary != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.intents != null ? !this.intents.equals(that.intents) : that.intents != null) return false;
                if (this.slotTypes != null ? !this.slotTypes.equals(that.slotTypes) : that.slotTypes != null) return false;
                return this.voiceSettings != null ? this.voiceSettings.equals(that.voiceSettings) : that.voiceSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localeId.hashCode();
                result = 31 * result + (this.nluConfidenceThreshold.hashCode());
                result = 31 * result + (this.customVocabulary != null ? this.customVocabulary.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.intents != null ? this.intents.hashCode() : 0);
                result = 31 * result + (this.slotTypes != null ? this.slotTypes.hashCode() : 0);
                result = 31 * result + (this.voiceSettings != null ? this.voiceSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a button to use on a response card used to gather slot values from a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ButtonProperty buttonProperty = ButtonProperty.builder()
     *         .text("text")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ButtonProperty")
    @software.amazon.jsii.Jsii.Proxy(ButtonProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ButtonProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text that appears on the button.
         * <p>
         * Use this to tell the user what value is returned when they choose this button.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html#cfn-lex-bot-button-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html#cfn-lex-bot-button-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * The value returned to Amazon Lex when the user chooses this button.
         * <p>
         * This must be one of the slot values configured for the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html#cfn-lex-bot-button-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-button.html#cfn-lex-bot-button-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ButtonProperty> {
            java.lang.String text;
            java.lang.String value;

            /**
             * Sets the value of {@link ButtonProperty#getText}
             * @param text The text that appears on the button. This parameter is required.
             *             Use this to tell the user what value is returned when they choose this button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link ButtonProperty#getValue}
             * @param value The value returned to Amazon Lex when the user chooses this button. This parameter is required.
             *              This must be one of the slot values configured for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ButtonProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ButtonProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ButtonProperty {
            private final java.lang.String text;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ButtonProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ButtonProperty.Jsii$Proxy that = (ButtonProperty.Jsii$Proxy) o;

                if (!text.equals(that.text)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The Amazon CloudWatch Logs log group where the text and metadata logs are delivered.
     * <p>
     * The log group must exist before you enable logging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CloudWatchLogGroupLogDestinationProperty cloudWatchLogGroupLogDestinationProperty = CloudWatchLogGroupLogDestinationProperty.builder()
     *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *         .logPrefix("logPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CloudWatchLogGroupLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogGroupLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html#cfn-lex-bot-cloudwatchloggrouplogdestination-cloudwatchloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html#cfn-lex-bot-cloudwatchloggrouplogdestination-cloudwatchloggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCloudWatchLogGroupArn();

        /**
         * The prefix of the log stream name within the log group that you specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html#cfn-lex-bot-cloudwatchloggrouplogdestination-logprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-cloudwatchloggrouplogdestination.html#cfn-lex-bot-cloudwatchloggrouplogdestination-logprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogPrefix();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogGroupLogDestinationProperty> {
            java.lang.String cloudWatchLogGroupArn;
            java.lang.String logPrefix;

            /**
             * Sets the value of {@link CloudWatchLogGroupLogDestinationProperty#getCloudWatchLogGroupArn}
             * @param cloudWatchLogGroupArn The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogGroupArn(java.lang.String cloudWatchLogGroupArn) {
                this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogGroupLogDestinationProperty#getLogPrefix}
             * @param logPrefix The prefix of the log stream name within the log group that you specified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPrefix(java.lang.String logPrefix) {
                this.logPrefix = logPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogGroupLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogGroupLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogGroupLogDestinationProperty {
            private final java.lang.String cloudWatchLogGroupArn;
            private final java.lang.String logPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logPrefix = software.amazon.jsii.Kernel.get(this, "logPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogGroupArn = java.util.Objects.requireNonNull(builder.cloudWatchLogGroupArn, "cloudWatchLogGroupArn is required");
                this.logPrefix = java.util.Objects.requireNonNull(builder.logPrefix, "logPrefix is required");
            }

            @Override
            public final java.lang.String getCloudWatchLogGroupArn() {
                return this.cloudWatchLogGroupArn;
            }

            @Override
            public final java.lang.String getLogPrefix() {
                return this.logPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchLogGroupArn", om.valueToTree(this.getCloudWatchLogGroupArn()));
                data.set("logPrefix", om.valueToTree(this.getLogPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CloudWatchLogGroupLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy that = (CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy) o;

                if (!cloudWatchLogGroupArn.equals(that.cloudWatchLogGroupArn)) return false;
                return this.logPrefix.equals(that.logPrefix);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogGroupArn.hashCode();
                result = 31 * result + (this.logPrefix.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about code hooks that Amazon Lex calls during a conversation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CodeHookSpecificationProperty codeHookSpecificationProperty = CodeHookSpecificationProperty.builder()
     *         .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                 .lambdaArn("lambdaArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-codehookspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-codehookspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CodeHookSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeHookSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeHookSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-codehookspecification.html#cfn-lex-bot-codehookspecification-lambdacodehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-codehookspecification.html#cfn-lex-bot-codehookspecification-lambdacodehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLambdaCodeHook();

        /**
         * @return a {@link Builder} of {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeHookSpecificationProperty> {
            java.lang.Object lambdaCodeHook;

            /**
             * Sets the value of {@link CodeHookSpecificationProperty#getLambdaCodeHook}
             * @param lambdaCodeHook Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaCodeHook(software.amazon.awscdk.IResolvable lambdaCodeHook) {
                this.lambdaCodeHook = lambdaCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link CodeHookSpecificationProperty#getLambdaCodeHook}
             * @param lambdaCodeHook Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaCodeHook(software.amazon.awscdk.services.lex.CfnBot.LambdaCodeHookProperty lambdaCodeHook) {
                this.lambdaCodeHook = lambdaCodeHook;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeHookSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeHookSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeHookSpecificationProperty {
            private final java.lang.Object lambdaCodeHook;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaCodeHook = software.amazon.jsii.Kernel.get(this, "lambdaCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaCodeHook = java.util.Objects.requireNonNull(builder.lambdaCodeHook, "lambdaCodeHook is required");
            }

            @Override
            public final java.lang.Object getLambdaCodeHook() {
                return this.lambdaCodeHook;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaCodeHook", om.valueToTree(this.getLambdaCodeHook()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CodeHookSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeHookSpecificationProperty.Jsii$Proxy that = (CodeHookSpecificationProperty.Jsii$Proxy) o;

                return this.lambdaCodeHook.equals(that.lambdaCodeHook);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaCodeHook.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides an expression that evaluates to true or false.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ConditionProperty conditionProperty = ConditionProperty.builder()
     *         .expressionString("expressionString")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-condition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-condition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The expression string that is evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-condition.html#cfn-lex-bot-condition-expressionstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-condition.html#cfn-lex-bot-condition-expressionstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpressionString();

        /**
         * @return a {@link Builder} of {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionProperty> {
            java.lang.String expressionString;

            /**
             * Sets the value of {@link ConditionProperty#getExpressionString}
             * @param expressionString The expression string that is evaluated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expressionString(java.lang.String expressionString) {
                this.expressionString = expressionString;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionProperty {
            private final java.lang.String expressionString;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expressionString = software.amazon.jsii.Kernel.get(this, "expressionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expressionString = java.util.Objects.requireNonNull(builder.expressionString, "expressionString is required");
            }

            @Override
            public final java.lang.String getExpressionString() {
                return this.expressionString;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expressionString", om.valueToTree(this.getExpressionString()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionProperty.Jsii$Proxy that = (ConditionProperty.Jsii$Proxy) o;

                return this.expressionString.equals(that.expressionString);
            }

            @Override
            public final int hashCode() {
                int result = this.expressionString.hashCode();
                return result;
            }
        }
    }
    /**
     * A set of actions that Amazon Lex should run if the condition is matched.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * ConditionalBranchProperty conditionalBranchProperty = ConditionalBranchProperty.builder()
     *         .condition(ConditionProperty.builder()
     *                 .expressionString("expressionString")
     *                 .build())
     *         .name("name")
     *         .nextStep(DialogStateProperty.builder()
     *                 .dialogAction(DialogActionProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .slotToElicit("slotToElicit")
     *                         .suppressNextMessage(false)
     *                         .build())
     *                 .intent(IntentOverrideProperty.builder()
     *                         .name("name")
     *                         .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                                 .slotName("slotName")
     *                                 .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                         .shape("shape")
     *                                         .value(SlotValueProperty.builder()
     *                                                 .interpretedValue("interpretedValue")
     *                                                 .build())
     *                                         .values(List.of(slotValueOverrideProperty_))
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .response(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ConditionalBranchProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionalBranchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionalBranchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains the expression to evaluate.
         * <p>
         * If the condition is true, the branch's actions are taken.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCondition();

        /**
         * The name of the branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The next step in the conversation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-nextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-nextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNextStep();

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-response">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalbranch.html#cfn-lex-bot-conditionalbranch-response</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionalBranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionalBranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionalBranchProperty> {
            java.lang.Object condition;
            java.lang.String name;
            java.lang.Object nextStep;
            java.lang.Object response;

            /**
             * Sets the value of {@link ConditionalBranchProperty#getCondition}
             * @param condition Contains the expression to evaluate. This parameter is required.
             *                  If the condition is true, the branch's actions are taken.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.IResolvable condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalBranchProperty#getCondition}
             * @param condition Contains the expression to evaluate. This parameter is required.
             *                  If the condition is true, the branch's actions are taken.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.services.lex.CfnBot.ConditionProperty condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalBranchProperty#getName}
             * @param name The name of the branch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalBranchProperty#getNextStep}
             * @param nextStep The next step in the conversation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.IResolvable nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalBranchProperty#getNextStep}
             * @param nextStep The next step in the conversation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalBranchProperty#getResponse}
             * @param response Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder response(software.amazon.awscdk.IResolvable response) {
                this.response = response;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalBranchProperty#getResponse}
             * @param response Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder response(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty response) {
                this.response = response;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionalBranchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionalBranchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionalBranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionalBranchProperty {
            private final java.lang.Object condition;
            private final java.lang.String name;
            private final java.lang.Object nextStep;
            private final java.lang.Object response;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nextStep = software.amazon.jsii.Kernel.get(this, "nextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.response = software.amazon.jsii.Kernel.get(this, "response", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.nextStep = java.util.Objects.requireNonNull(builder.nextStep, "nextStep is required");
                this.response = builder.response;
            }

            @Override
            public final java.lang.Object getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getNextStep() {
                return this.nextStep;
            }

            @Override
            public final java.lang.Object getResponse() {
                return this.response;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("nextStep", om.valueToTree(this.getNextStep()));
                if (this.getResponse() != null) {
                    data.set("response", om.valueToTree(this.getResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ConditionalBranchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionalBranchProperty.Jsii$Proxy that = (ConditionalBranchProperty.Jsii$Proxy) o;

                if (!condition.equals(that.condition)) return false;
                if (!name.equals(that.name)) return false;
                if (!nextStep.equals(that.nextStep)) return false;
                return this.response != null ? this.response.equals(that.response) : that.response == null;
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.nextStep.hashCode());
                result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides a list of conditional branches.
     * <p>
     * Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * ConditionalSpecificationProperty conditionalSpecificationProperty = ConditionalSpecificationProperty.builder()
     *         .conditionalBranches(List.of(ConditionalBranchProperty.builder()
     *                 .condition(ConditionProperty.builder()
     *                         .expressionString("expressionString")
     *                         .build())
     *                 .name("name")
     *                 .nextStep(DialogStateProperty.builder()
     *                         .dialogAction(DialogActionProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .slotToElicit("slotToElicit")
     *                                 .suppressNextMessage(false)
     *                                 .build())
     *                         .intent(IntentOverrideProperty.builder()
     *                                 .name("name")
     *                                 .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                                         .slotName("slotName")
     *                                         .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                                 .shape("shape")
     *                                                 .value(SlotValueProperty.builder()
     *                                                         .interpretedValue("interpretedValue")
     *                                                         .build())
     *                                                 .values(List.of(slotValueOverrideProperty_))
     *                                                 .build())
     *                                         .build()))
     *                                 .build())
     *                         .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                                 .key("key")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .response(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .build()))
     *         .defaultBranch(DefaultConditionalBranchProperty.builder()
     *                 .nextStep(DialogStateProperty.builder()
     *                         .dialogAction(DialogActionProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .slotToElicit("slotToElicit")
     *                                 .suppressNextMessage(false)
     *                                 .build())
     *                         .intent(IntentOverrideProperty.builder()
     *                                 .name("name")
     *                                 .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                                         .slotName("slotName")
     *                                         .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                                 .shape("shape")
     *                                                 .value(SlotValueProperty.builder()
     *                                                         .interpretedValue("interpretedValue")
     *                                                         .build())
     *                                                 .values(List.of(slotValueOverrideProperty_))
     *                                                 .build())
     *                                         .build()))
     *                                 .build())
     *                         .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                                 .key("key")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .response(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .build())
     *         .isActive(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ConditionalSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionalSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionalSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of conditional branches.
         * <p>
         * A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-conditionalbranches">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-conditionalbranches</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConditionalBranches();

        /**
         * The conditional branch that should be followed when the conditions for other branches are not satisfied.
         * <p>
         * A conditional branch is made up of a condition, a response and a next step.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-defaultbranch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-defaultbranch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultBranch();

        /**
         * Determines whether a conditional branch is active.
         * <p>
         * When <code>IsActive</code> is false, the conditions are not evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-isactive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conditionalspecification.html#cfn-lex-bot-conditionalspecification-isactive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsActive();

        /**
         * @return a {@link Builder} of {@link ConditionalSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionalSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionalSpecificationProperty> {
            java.lang.Object conditionalBranches;
            java.lang.Object defaultBranch;
            java.lang.Object isActive;

            /**
             * Sets the value of {@link ConditionalSpecificationProperty#getConditionalBranches}
             * @param conditionalBranches A list of conditional branches. This parameter is required.
             *                            A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionalBranches(software.amazon.awscdk.IResolvable conditionalBranches) {
                this.conditionalBranches = conditionalBranches;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalSpecificationProperty#getConditionalBranches}
             * @param conditionalBranches A list of conditional branches. This parameter is required.
             *                            A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionalBranches(java.util.List<? extends java.lang.Object> conditionalBranches) {
                this.conditionalBranches = conditionalBranches;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalSpecificationProperty#getDefaultBranch}
             * @param defaultBranch The conditional branch that should be followed when the conditions for other branches are not satisfied. This parameter is required.
             *                      A conditional branch is made up of a condition, a response and a next step.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultBranch(software.amazon.awscdk.IResolvable defaultBranch) {
                this.defaultBranch = defaultBranch;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalSpecificationProperty#getDefaultBranch}
             * @param defaultBranch The conditional branch that should be followed when the conditions for other branches are not satisfied. This parameter is required.
             *                      A conditional branch is made up of a condition, a response and a next step.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultBranch(software.amazon.awscdk.services.lex.CfnBot.DefaultConditionalBranchProperty defaultBranch) {
                this.defaultBranch = defaultBranch;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalSpecificationProperty#getIsActive}
             * @param isActive Determines whether a conditional branch is active. This parameter is required.
             *                 When <code>IsActive</code> is false, the conditions are not evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link ConditionalSpecificationProperty#getIsActive}
             * @param isActive Determines whether a conditional branch is active. This parameter is required.
             *                 When <code>IsActive</code> is false, the conditions are not evaluated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionalSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionalSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionalSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionalSpecificationProperty {
            private final java.lang.Object conditionalBranches;
            private final java.lang.Object defaultBranch;
            private final java.lang.Object isActive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditionalBranches = software.amazon.jsii.Kernel.get(this, "conditionalBranches", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultBranch = software.amazon.jsii.Kernel.get(this, "defaultBranch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditionalBranches = java.util.Objects.requireNonNull(builder.conditionalBranches, "conditionalBranches is required");
                this.defaultBranch = java.util.Objects.requireNonNull(builder.defaultBranch, "defaultBranch is required");
                this.isActive = java.util.Objects.requireNonNull(builder.isActive, "isActive is required");
            }

            @Override
            public final java.lang.Object getConditionalBranches() {
                return this.conditionalBranches;
            }

            @Override
            public final java.lang.Object getDefaultBranch() {
                return this.defaultBranch;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conditionalBranches", om.valueToTree(this.getConditionalBranches()));
                data.set("defaultBranch", om.valueToTree(this.getDefaultBranch()));
                data.set("isActive", om.valueToTree(this.getIsActive()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ConditionalSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionalSpecificationProperty.Jsii$Proxy that = (ConditionalSpecificationProperty.Jsii$Proxy) o;

                if (!conditionalBranches.equals(that.conditionalBranches)) return false;
                if (!defaultBranch.equals(that.defaultBranch)) return false;
                return this.isActive.equals(that.isActive);
            }

            @Override
            public final int hashCode() {
                int result = this.conditionalBranches.hashCode();
                result = 31 * result + (this.defaultBranch.hashCode());
                result = 31 * result + (this.isActive.hashCode());
                return result;
            }
        }
    }
    /**
     * Configures conversation logging that saves audio, text, and metadata for the conversations with your users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ConversationLogSettingsProperty conversationLogSettingsProperty = ConversationLogSettingsProperty.builder()
     *         .audioLogSettings(List.of(AudioLogSettingProperty.builder()
     *                 .destination(AudioLogDestinationProperty.builder()
     *                         .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                                 .logPrefix("logPrefix")
     *                                 .s3BucketArn("s3BucketArn")
     *                                 // the properties below are optional
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .build())
     *                         .build())
     *                 .enabled(false)
     *                 .build()))
     *         .textLogSettings(List.of(TextLogSettingProperty.builder()
     *                 .destination(TextLogDestinationProperty.builder()
     *                         .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                                 .logPrefix("logPrefix")
     *                                 .build())
     *                         .build())
     *                 .enabled(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ConversationLogSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConversationLogSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConversationLogSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 settings for logging audio to an S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html#cfn-lex-bot-conversationlogsettings-audiologsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html#cfn-lex-bot-conversationlogsettings-audiologsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioLogSettings() {
            return null;
        }

        /**
         * The Amazon CloudWatch Logs settings for logging text and metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html#cfn-lex-bot-conversationlogsettings-textlogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-conversationlogsettings.html#cfn-lex-bot-conversationlogsettings-textlogsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTextLogSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConversationLogSettingsProperty> {
            java.lang.Object audioLogSettings;
            java.lang.Object textLogSettings;

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getAudioLogSettings}
             * @param audioLogSettings The Amazon S3 settings for logging audio to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLogSettings(software.amazon.awscdk.IResolvable audioLogSettings) {
                this.audioLogSettings = audioLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getAudioLogSettings}
             * @param audioLogSettings The Amazon S3 settings for logging audio to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLogSettings(java.util.List<? extends java.lang.Object> audioLogSettings) {
                this.audioLogSettings = audioLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getTextLogSettings}
             * @param textLogSettings The Amazon CloudWatch Logs settings for logging text and metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textLogSettings(software.amazon.awscdk.IResolvable textLogSettings) {
                this.textLogSettings = textLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getTextLogSettings}
             * @param textLogSettings The Amazon CloudWatch Logs settings for logging text and metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textLogSettings(java.util.List<? extends java.lang.Object> textLogSettings) {
                this.textLogSettings = textLogSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConversationLogSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConversationLogSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConversationLogSettingsProperty {
            private final java.lang.Object audioLogSettings;
            private final java.lang.Object textLogSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioLogSettings = software.amazon.jsii.Kernel.get(this, "audioLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textLogSettings = software.amazon.jsii.Kernel.get(this, "textLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioLogSettings = builder.audioLogSettings;
                this.textLogSettings = builder.textLogSettings;
            }

            @Override
            public final java.lang.Object getAudioLogSettings() {
                return this.audioLogSettings;
            }

            @Override
            public final java.lang.Object getTextLogSettings() {
                return this.textLogSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioLogSettings() != null) {
                    data.set("audioLogSettings", om.valueToTree(this.getAudioLogSettings()));
                }
                if (this.getTextLogSettings() != null) {
                    data.set("textLogSettings", om.valueToTree(this.getTextLogSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ConversationLogSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConversationLogSettingsProperty.Jsii$Proxy that = (ConversationLogSettingsProperty.Jsii$Proxy) o;

                if (this.audioLogSettings != null ? !this.audioLogSettings.equals(that.audioLogSettings) : that.audioLogSettings != null) return false;
                return this.textLogSettings != null ? this.textLogSettings.equals(that.textLogSettings) : that.textLogSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioLogSettings != null ? this.audioLogSettings.hashCode() : 0;
                result = 31 * result + (this.textLogSettings != null ? this.textLogSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom response string that Amazon Lex sends to your application.
     * <p>
     * You define the content and structure the string.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CustomPayloadProperty customPayloadProperty = CustomPayloadProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-custompayload.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-custompayload.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CustomPayloadProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPayloadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPayloadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The string that is sent to your application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-custompayload.html#cfn-lex-bot-custompayload-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-custompayload.html#cfn-lex-bot-custompayload-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link CustomPayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPayloadProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link CustomPayloadProperty#getValue}
             * @param value The string that is sent to your application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPayloadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPayloadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPayloadProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CustomPayloadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPayloadProperty.Jsii$Proxy that = (CustomPayloadProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an entry in a custom vocabulary.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CustomVocabularyItemProperty customVocabularyItemProperty = CustomVocabularyItemProperty.builder()
     *         .phrase("phrase")
     *         // the properties below are optional
     *         .displayAs("displayAs")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomVocabularyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomVocabularyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies 1 - 4 words that should be recognized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-phrase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-phrase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPhrase();

        /**
         * The DisplayAs value for the custom vocabulary item from the custom vocabulary list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-displayas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-displayas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisplayAs() {
            return null;
        }

        /**
         * Specifies the degree to which the phrase recognition is boosted.
         * <p>
         * The default value is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabularyitem.html#cfn-lex-bot-customvocabularyitem-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomVocabularyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomVocabularyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomVocabularyItemProperty> {
            java.lang.String phrase;
            java.lang.String displayAs;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CustomVocabularyItemProperty#getPhrase}
             * @param phrase Specifies 1 - 4 words that should be recognized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phrase(java.lang.String phrase) {
                this.phrase = phrase;
                return this;
            }

            /**
             * Sets the value of {@link CustomVocabularyItemProperty#getDisplayAs}
             * @param displayAs The DisplayAs value for the custom vocabulary item from the custom vocabulary list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayAs(java.lang.String displayAs) {
                this.displayAs = displayAs;
                return this;
            }

            /**
             * Sets the value of {@link CustomVocabularyItemProperty#getWeight}
             * @param weight Specifies the degree to which the phrase recognition is boosted.
             *               The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomVocabularyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomVocabularyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomVocabularyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomVocabularyItemProperty {
            private final java.lang.String phrase;
            private final java.lang.String displayAs;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.phrase = software.amazon.jsii.Kernel.get(this, "phrase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.displayAs = software.amazon.jsii.Kernel.get(this, "displayAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.phrase = java.util.Objects.requireNonNull(builder.phrase, "phrase is required");
                this.displayAs = builder.displayAs;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getPhrase() {
                return this.phrase;
            }

            @Override
            public final java.lang.String getDisplayAs() {
                return this.displayAs;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("phrase", om.valueToTree(this.getPhrase()));
                if (this.getDisplayAs() != null) {
                    data.set("displayAs", om.valueToTree(this.getDisplayAs()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomVocabularyItemProperty.Jsii$Proxy that = (CustomVocabularyItemProperty.Jsii$Proxy) o;

                if (!phrase.equals(that.phrase)) return false;
                if (this.displayAs != null ? !this.displayAs.equals(that.displayAs) : that.displayAs != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.phrase.hashCode();
                result = 31 * result + (this.displayAs != null ? this.displayAs.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a custom vocabulary.
     * <p>
     * A custom vocabulary is a list of words that you expect to be used during a conversation with your bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CustomVocabularyProperty customVocabularyProperty = CustomVocabularyProperty.builder()
     *         .customVocabularyItems(List.of(CustomVocabularyItemProperty.builder()
     *                 .phrase("phrase")
     *                 // the properties below are optional
     *                 .displayAs("displayAs")
     *                 .weight(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabulary.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabulary.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomVocabularyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomVocabularyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a list of words that you expect to be used during a conversation with your bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabulary.html#cfn-lex-bot-customvocabulary-customvocabularyitems">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-customvocabulary.html#cfn-lex-bot-customvocabulary-customvocabularyitems</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCustomVocabularyItems();

        /**
         * @return a {@link Builder} of {@link CustomVocabularyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomVocabularyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomVocabularyProperty> {
            java.lang.Object customVocabularyItems;

            /**
             * Sets the value of {@link CustomVocabularyProperty#getCustomVocabularyItems}
             * @param customVocabularyItems Specifies a list of words that you expect to be used during a conversation with your bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabularyItems(software.amazon.awscdk.IResolvable customVocabularyItems) {
                this.customVocabularyItems = customVocabularyItems;
                return this;
            }

            /**
             * Sets the value of {@link CustomVocabularyProperty#getCustomVocabularyItems}
             * @param customVocabularyItems Specifies a list of words that you expect to be used during a conversation with your bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabularyItems(java.util.List<? extends java.lang.Object> customVocabularyItems) {
                this.customVocabularyItems = customVocabularyItems;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomVocabularyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomVocabularyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomVocabularyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomVocabularyProperty {
            private final java.lang.Object customVocabularyItems;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customVocabularyItems = software.amazon.jsii.Kernel.get(this, "customVocabularyItems", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customVocabularyItems = java.util.Objects.requireNonNull(builder.customVocabularyItems, "customVocabularyItems is required");
            }

            @Override
            public final java.lang.Object getCustomVocabularyItems() {
                return this.customVocabularyItems;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customVocabularyItems", om.valueToTree(this.getCustomVocabularyItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomVocabularyProperty.Jsii$Proxy that = (CustomVocabularyProperty.Jsii$Proxy) o;

                return this.customVocabularyItems.equals(that.customVocabularyItems);
            }

            @Override
            public final int hashCode() {
                int result = this.customVocabularyItems.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the DTMF input specifications.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * DTMFSpecificationProperty dTMFSpecificationProperty = DTMFSpecificationProperty.builder()
     *         .deletionCharacter("deletionCharacter")
     *         .endCharacter("endCharacter")
     *         .endTimeoutMs(123)
     *         .maxLength(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DTMFSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(DTMFSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DTMFSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-deletioncharacter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-deletioncharacter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeletionCharacter();

        /**
         * The DTMF character that immediately ends input.
         * <p>
         * If the user does not press this character, the input ends after the end timeout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-endcharacter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-endcharacter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndCharacter();

        /**
         * How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-endtimeoutms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-endtimeoutms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getEndTimeoutMs();

        /**
         * The maximum number of DTMF digits allowed in an utterance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-maxlength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dtmfspecification.html#cfn-lex-bot-dtmfspecification-maxlength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxLength();

        /**
         * @return a {@link Builder} of {@link DTMFSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DTMFSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DTMFSpecificationProperty> {
            java.lang.String deletionCharacter;
            java.lang.String endCharacter;
            java.lang.Number endTimeoutMs;
            java.lang.Number maxLength;

            /**
             * Sets the value of {@link DTMFSpecificationProperty#getDeletionCharacter}
             * @param deletionCharacter The DTMF character that clears the accumulated DTMF digits and immediately ends the input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deletionCharacter(java.lang.String deletionCharacter) {
                this.deletionCharacter = deletionCharacter;
                return this;
            }

            /**
             * Sets the value of {@link DTMFSpecificationProperty#getEndCharacter}
             * @param endCharacter The DTMF character that immediately ends input. This parameter is required.
             *                     If the user does not press this character, the input ends after the end timeout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endCharacter(java.lang.String endCharacter) {
                this.endCharacter = endCharacter;
                return this;
            }

            /**
             * Sets the value of {@link DTMFSpecificationProperty#getEndTimeoutMs}
             * @param endTimeoutMs How long the bot should wait after the last DTMF character input before assuming that the input has concluded. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTimeoutMs(java.lang.Number endTimeoutMs) {
                this.endTimeoutMs = endTimeoutMs;
                return this;
            }

            /**
             * Sets the value of {@link DTMFSpecificationProperty#getMaxLength}
             * @param maxLength The maximum number of DTMF digits allowed in an utterance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxLength(java.lang.Number maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DTMFSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DTMFSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DTMFSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DTMFSpecificationProperty {
            private final java.lang.String deletionCharacter;
            private final java.lang.String endCharacter;
            private final java.lang.Number endTimeoutMs;
            private final java.lang.Number maxLength;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deletionCharacter = software.amazon.jsii.Kernel.get(this, "deletionCharacter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endCharacter = software.amazon.jsii.Kernel.get(this, "endCharacter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endTimeoutMs = software.amazon.jsii.Kernel.get(this, "endTimeoutMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxLength = software.amazon.jsii.Kernel.get(this, "maxLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deletionCharacter = java.util.Objects.requireNonNull(builder.deletionCharacter, "deletionCharacter is required");
                this.endCharacter = java.util.Objects.requireNonNull(builder.endCharacter, "endCharacter is required");
                this.endTimeoutMs = java.util.Objects.requireNonNull(builder.endTimeoutMs, "endTimeoutMs is required");
                this.maxLength = java.util.Objects.requireNonNull(builder.maxLength, "maxLength is required");
            }

            @Override
            public final java.lang.String getDeletionCharacter() {
                return this.deletionCharacter;
            }

            @Override
            public final java.lang.String getEndCharacter() {
                return this.endCharacter;
            }

            @Override
            public final java.lang.Number getEndTimeoutMs() {
                return this.endTimeoutMs;
            }

            @Override
            public final java.lang.Number getMaxLength() {
                return this.maxLength;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deletionCharacter", om.valueToTree(this.getDeletionCharacter()));
                data.set("endCharacter", om.valueToTree(this.getEndCharacter()));
                data.set("endTimeoutMs", om.valueToTree(this.getEndTimeoutMs()));
                data.set("maxLength", om.valueToTree(this.getMaxLength()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DTMFSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DTMFSpecificationProperty.Jsii$Proxy that = (DTMFSpecificationProperty.Jsii$Proxy) o;

                if (!deletionCharacter.equals(that.deletionCharacter)) return false;
                if (!endCharacter.equals(that.endCharacter)) return false;
                if (!endTimeoutMs.equals(that.endTimeoutMs)) return false;
                return this.maxLength.equals(that.maxLength);
            }

            @Override
            public final int hashCode() {
                int result = this.deletionCharacter.hashCode();
                result = 31 * result + (this.endCharacter.hashCode());
                result = 31 * result + (this.endTimeoutMs.hashCode());
                result = 31 * result + (this.maxLength.hashCode());
                return result;
            }
        }
    }
    /**
     * By default, data stored by Amazon Lex is encrypted.
     * <p>
     * The <code>DataPrivacy</code> structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * DataPrivacyProperty dataPrivacyProperty = DataPrivacyProperty.builder()
     *         .childDirected(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dataprivacy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dataprivacy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DataPrivacyProperty")
    @software.amazon.jsii.Jsii.Proxy(DataPrivacyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataPrivacyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field.
         * <p>
         * By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <em>is</em> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <em>is not</em> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://docs.aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dataprivacy.html#cfn-lex-bot-dataprivacy-childdirected">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dataprivacy.html#cfn-lex-bot-dataprivacy-childdirected</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getChildDirected();

        /**
         * @return a {@link Builder} of {@link DataPrivacyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataPrivacyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataPrivacyProperty> {
            java.lang.Object childDirected;

            /**
             * Sets the value of {@link DataPrivacyProperty#getChildDirected}
             * @param childDirected For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. This parameter is required.
             *                      By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <em>is</em> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <em>is not</em> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://docs.aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childDirected(java.lang.Boolean childDirected) {
                this.childDirected = childDirected;
                return this;
            }

            /**
             * Sets the value of {@link DataPrivacyProperty#getChildDirected}
             * @param childDirected For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. This parameter is required.
             *                      By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <em>is</em> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <em>is not</em> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://docs.aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childDirected(software.amazon.awscdk.IResolvable childDirected) {
                this.childDirected = childDirected;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataPrivacyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataPrivacyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataPrivacyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataPrivacyProperty {
            private final java.lang.Object childDirected;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.childDirected = software.amazon.jsii.Kernel.get(this, "childDirected", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.childDirected = java.util.Objects.requireNonNull(builder.childDirected, "childDirected is required");
            }

            @Override
            public final java.lang.Object getChildDirected() {
                return this.childDirected;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("childDirected", om.valueToTree(this.getChildDirected()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DataPrivacyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataPrivacyProperty.Jsii$Proxy that = (DataPrivacyProperty.Jsii$Proxy) o;

                return this.childDirected.equals(that.childDirected);
            }

            @Override
            public final int hashCode() {
                int result = this.childDirected.hashCode();
                return result;
            }
        }
    }
    /**
     * A set of actions that Amazon Lex should run if none of the other conditions are met.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * DefaultConditionalBranchProperty defaultConditionalBranchProperty = DefaultConditionalBranchProperty.builder()
     *         .nextStep(DialogStateProperty.builder()
     *                 .dialogAction(DialogActionProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .slotToElicit("slotToElicit")
     *                         .suppressNextMessage(false)
     *                         .build())
     *                 .intent(IntentOverrideProperty.builder()
     *                         .name("name")
     *                         .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                                 .slotName("slotName")
     *                                 .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                         .shape("shape")
     *                                         .value(SlotValueProperty.builder()
     *                                                 .interpretedValue("interpretedValue")
     *                                                 .build())
     *                                         .values(List.of(slotValueOverrideProperty_))
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .response(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DefaultConditionalBranchProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultConditionalBranchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultConditionalBranchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The next step in the conversation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html#cfn-lex-bot-defaultconditionalbranch-nextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html#cfn-lex-bot-defaultconditionalbranch-nextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html#cfn-lex-bot-defaultconditionalbranch-response">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-defaultconditionalbranch.html#cfn-lex-bot-defaultconditionalbranch-response</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultConditionalBranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultConditionalBranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultConditionalBranchProperty> {
            java.lang.Object nextStep;
            java.lang.Object response;

            /**
             * Sets the value of {@link DefaultConditionalBranchProperty#getNextStep}
             * @param nextStep The next step in the conversation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.IResolvable nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Sets the value of {@link DefaultConditionalBranchProperty#getNextStep}
             * @param nextStep The next step in the conversation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Sets the value of {@link DefaultConditionalBranchProperty#getResponse}
             * @param response Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder response(software.amazon.awscdk.IResolvable response) {
                this.response = response;
                return this;
            }

            /**
             * Sets the value of {@link DefaultConditionalBranchProperty#getResponse}
             * @param response Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder response(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty response) {
                this.response = response;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultConditionalBranchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultConditionalBranchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultConditionalBranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultConditionalBranchProperty {
            private final java.lang.Object nextStep;
            private final java.lang.Object response;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nextStep = software.amazon.jsii.Kernel.get(this, "nextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.response = software.amazon.jsii.Kernel.get(this, "response", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nextStep = builder.nextStep;
                this.response = builder.response;
            }

            @Override
            public final java.lang.Object getNextStep() {
                return this.nextStep;
            }

            @Override
            public final java.lang.Object getResponse() {
                return this.response;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNextStep() != null) {
                    data.set("nextStep", om.valueToTree(this.getNextStep()));
                }
                if (this.getResponse() != null) {
                    data.set("response", om.valueToTree(this.getResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DefaultConditionalBranchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultConditionalBranchProperty.Jsii$Proxy that = (DefaultConditionalBranchProperty.Jsii$Proxy) o;

                if (this.nextStep != null ? !this.nextStep.equals(that.nextStep) : that.nextStep != null) return false;
                return this.response != null ? this.response.equals(that.response) : that.response == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nextStep != null ? this.nextStep.hashCode() : 0;
                result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the action that the bot executes at runtime when the conversation reaches this step.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * DialogActionProperty dialogActionProperty = DialogActionProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .slotToElicit("slotToElicit")
     *         .suppressNextMessage(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DialogActionProperty")
    @software.amazon.jsii.Jsii.Proxy(DialogActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DialogActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that the bot should execute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * If the dialog action is <code>ElicitSlot</code> , defines the slot to elicit from the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-slottoelicit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-slottoelicit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlotToElicit() {
            return null;
        }

        /**
         * When true the next message for the intent is not used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-suppressnextmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogaction.html#cfn-lex-bot-dialogaction-suppressnextmessage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuppressNextMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DialogActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DialogActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DialogActionProperty> {
            java.lang.String type;
            java.lang.String slotToElicit;
            java.lang.Object suppressNextMessage;

            /**
             * Sets the value of {@link DialogActionProperty#getType}
             * @param type The action that the bot should execute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DialogActionProperty#getSlotToElicit}
             * @param slotToElicit If the dialog action is <code>ElicitSlot</code> , defines the slot to elicit from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotToElicit(java.lang.String slotToElicit) {
                this.slotToElicit = slotToElicit;
                return this;
            }

            /**
             * Sets the value of {@link DialogActionProperty#getSuppressNextMessage}
             * @param suppressNextMessage When true the next message for the intent is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suppressNextMessage(java.lang.Boolean suppressNextMessage) {
                this.suppressNextMessage = suppressNextMessage;
                return this;
            }

            /**
             * Sets the value of {@link DialogActionProperty#getSuppressNextMessage}
             * @param suppressNextMessage When true the next message for the intent is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suppressNextMessage(software.amazon.awscdk.IResolvable suppressNextMessage) {
                this.suppressNextMessage = suppressNextMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DialogActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DialogActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DialogActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DialogActionProperty {
            private final java.lang.String type;
            private final java.lang.String slotToElicit;
            private final java.lang.Object suppressNextMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotToElicit = software.amazon.jsii.Kernel.get(this, "slotToElicit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suppressNextMessage = software.amazon.jsii.Kernel.get(this, "suppressNextMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.slotToElicit = builder.slotToElicit;
                this.suppressNextMessage = builder.suppressNextMessage;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getSlotToElicit() {
                return this.slotToElicit;
            }

            @Override
            public final java.lang.Object getSuppressNextMessage() {
                return this.suppressNextMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getSlotToElicit() != null) {
                    data.set("slotToElicit", om.valueToTree(this.getSlotToElicit()));
                }
                if (this.getSuppressNextMessage() != null) {
                    data.set("suppressNextMessage", om.valueToTree(this.getSuppressNextMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DialogActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DialogActionProperty.Jsii$Proxy that = (DialogActionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.slotToElicit != null ? !this.slotToElicit.equals(that.slotToElicit) : that.slotToElicit != null) return false;
                return this.suppressNextMessage != null ? this.suppressNextMessage.equals(that.suppressNextMessage) : that.suppressNextMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.slotToElicit != null ? this.slotToElicit.hashCode() : 0);
                result = 31 * result + (this.suppressNextMessage != null ? this.suppressNextMessage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DialogCodeHookInvocationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(DialogCodeHookInvocationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DialogCodeHookInvocationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a Lambda function should be invoked for the dialog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-enablecodehookinvocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-enablecodehookinvocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableCodeHookInvocation();

        /**
         * Determines whether a dialog code hook is used when the intent is activated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-isactive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-isactive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsActive();

        /**
         * Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-postcodehookspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-postcodehookspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPostCodeHookSpecification();

        /**
         * A label that indicates the dialog step from which the dialog code hook is happening.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-invocationlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehookinvocationsetting.html#cfn-lex-bot-dialogcodehookinvocationsetting-invocationlabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvocationLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DialogCodeHookInvocationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DialogCodeHookInvocationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DialogCodeHookInvocationSettingProperty> {
            java.lang.Object enableCodeHookInvocation;
            java.lang.Object isActive;
            java.lang.Object postCodeHookSpecification;
            java.lang.String invocationLabel;

            /**
             * Sets the value of {@link DialogCodeHookInvocationSettingProperty#getEnableCodeHookInvocation}
             * @param enableCodeHookInvocation Indicates whether a Lambda function should be invoked for the dialog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCodeHookInvocation(java.lang.Boolean enableCodeHookInvocation) {
                this.enableCodeHookInvocation = enableCodeHookInvocation;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookInvocationSettingProperty#getEnableCodeHookInvocation}
             * @param enableCodeHookInvocation Indicates whether a Lambda function should be invoked for the dialog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCodeHookInvocation(software.amazon.awscdk.IResolvable enableCodeHookInvocation) {
                this.enableCodeHookInvocation = enableCodeHookInvocation;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookInvocationSettingProperty#getIsActive}
             * @param isActive Determines whether a dialog code hook is used when the intent is activated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookInvocationSettingProperty#getIsActive}
             * @param isActive Determines whether a dialog code hook is used when the intent is activated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookInvocationSettingProperty#getPostCodeHookSpecification}
             * @param postCodeHookSpecification Contains the responses and actions that Amazon Lex takes after the Lambda function is complete. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postCodeHookSpecification(software.amazon.awscdk.IResolvable postCodeHookSpecification) {
                this.postCodeHookSpecification = postCodeHookSpecification;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookInvocationSettingProperty#getPostCodeHookSpecification}
             * @param postCodeHookSpecification Contains the responses and actions that Amazon Lex takes after the Lambda function is complete. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postCodeHookSpecification(software.amazon.awscdk.services.lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty postCodeHookSpecification) {
                this.postCodeHookSpecification = postCodeHookSpecification;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookInvocationSettingProperty#getInvocationLabel}
             * @param invocationLabel A label that indicates the dialog step from which the dialog code hook is happening.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationLabel(java.lang.String invocationLabel) {
                this.invocationLabel = invocationLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DialogCodeHookInvocationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DialogCodeHookInvocationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DialogCodeHookInvocationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DialogCodeHookInvocationSettingProperty {
            private final java.lang.Object enableCodeHookInvocation;
            private final java.lang.Object isActive;
            private final java.lang.Object postCodeHookSpecification;
            private final java.lang.String invocationLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableCodeHookInvocation = software.amazon.jsii.Kernel.get(this, "enableCodeHookInvocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postCodeHookSpecification = software.amazon.jsii.Kernel.get(this, "postCodeHookSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.invocationLabel = software.amazon.jsii.Kernel.get(this, "invocationLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableCodeHookInvocation = java.util.Objects.requireNonNull(builder.enableCodeHookInvocation, "enableCodeHookInvocation is required");
                this.isActive = java.util.Objects.requireNonNull(builder.isActive, "isActive is required");
                this.postCodeHookSpecification = java.util.Objects.requireNonNull(builder.postCodeHookSpecification, "postCodeHookSpecification is required");
                this.invocationLabel = builder.invocationLabel;
            }

            @Override
            public final java.lang.Object getEnableCodeHookInvocation() {
                return this.enableCodeHookInvocation;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            public final java.lang.Object getPostCodeHookSpecification() {
                return this.postCodeHookSpecification;
            }

            @Override
            public final java.lang.String getInvocationLabel() {
                return this.invocationLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enableCodeHookInvocation", om.valueToTree(this.getEnableCodeHookInvocation()));
                data.set("isActive", om.valueToTree(this.getIsActive()));
                data.set("postCodeHookSpecification", om.valueToTree(this.getPostCodeHookSpecification()));
                if (this.getInvocationLabel() != null) {
                    data.set("invocationLabel", om.valueToTree(this.getInvocationLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DialogCodeHookInvocationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DialogCodeHookInvocationSettingProperty.Jsii$Proxy that = (DialogCodeHookInvocationSettingProperty.Jsii$Proxy) o;

                if (!enableCodeHookInvocation.equals(that.enableCodeHookInvocation)) return false;
                if (!isActive.equals(that.isActive)) return false;
                if (!postCodeHookSpecification.equals(that.postCodeHookSpecification)) return false;
                return this.invocationLabel != null ? this.invocationLabel.equals(that.invocationLabel) : that.invocationLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableCodeHookInvocation.hashCode();
                result = 31 * result + (this.isActive.hashCode());
                result = 31 * result + (this.postCodeHookSpecification.hashCode());
                result = 31 * result + (this.invocationLabel != null ? this.invocationLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings that determine the Lambda function that Amazon Lex uses for processing user responses.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * DialogCodeHookSettingProperty dialogCodeHookSettingProperty = DialogCodeHookSettingProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehooksetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehooksetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DialogCodeHookSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(DialogCodeHookSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DialogCodeHookSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the dialog code hook so that it processes user requests.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehooksetting.html#cfn-lex-bot-dialogcodehooksetting-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogcodehooksetting.html#cfn-lex-bot-dialogcodehooksetting-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link DialogCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DialogCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DialogCodeHookSettingProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link DialogCodeHookSettingProperty#getEnabled}
             * @param enabled Enables the dialog code hook so that it processes user requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookSettingProperty#getEnabled}
             * @param enabled Enables the dialog code hook so that it processes user requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DialogCodeHookSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DialogCodeHookSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DialogCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DialogCodeHookSettingProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DialogCodeHookSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DialogCodeHookSettingProperty.Jsii$Proxy that = (DialogCodeHookSettingProperty.Jsii$Proxy) o;

                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                return result;
            }
        }
    }
    /**
     * The current state of the conversation with the user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * DialogStateProperty dialogStateProperty = DialogStateProperty.builder()
     *         .dialogAction(DialogActionProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .slotToElicit("slotToElicit")
     *                 .suppressNextMessage(false)
     *                 .build())
     *         .intent(IntentOverrideProperty.builder()
     *                 .name("name")
     *                 .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                         .slotName("slotName")
     *                         .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                 .shape("shape")
     *                                 .value(SlotValueProperty.builder()
     *                                         .interpretedValue("interpretedValue")
     *                                         .build())
     *                                 .values(List.of(slotValueOverrideProperty_))
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                 .key("key")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DialogStateProperty")
    @software.amazon.jsii.Jsii.Proxy(DialogStateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DialogStateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the action that the bot executes at runtime when the conversation reaches this step.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-dialogaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-dialogaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDialogAction() {
            return null;
        }

        /**
         * Override settings to configure the intent state.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-intent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-intent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntent() {
            return null;
        }

        /**
         * Map of key/value pairs representing session-specific context information.
         * <p>
         * It contains application information passed between Amazon Lex and a client application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-sessionattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-dialogstate.html#cfn-lex-bot-dialogstate-sessionattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSessionAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DialogStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DialogStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DialogStateProperty> {
            java.lang.Object dialogAction;
            java.lang.Object intent;
            java.lang.Object sessionAttributes;

            /**
             * Sets the value of {@link DialogStateProperty#getDialogAction}
             * @param dialogAction Defines the action that the bot executes at runtime when the conversation reaches this step.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialogAction(software.amazon.awscdk.IResolvable dialogAction) {
                this.dialogAction = dialogAction;
                return this;
            }

            /**
             * Sets the value of {@link DialogStateProperty#getDialogAction}
             * @param dialogAction Defines the action that the bot executes at runtime when the conversation reaches this step.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialogAction(software.amazon.awscdk.services.lex.CfnBot.DialogActionProperty dialogAction) {
                this.dialogAction = dialogAction;
                return this;
            }

            /**
             * Sets the value of {@link DialogStateProperty#getIntent}
             * @param intent Override settings to configure the intent state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intent(software.amazon.awscdk.IResolvable intent) {
                this.intent = intent;
                return this;
            }

            /**
             * Sets the value of {@link DialogStateProperty#getIntent}
             * @param intent Override settings to configure the intent state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intent(software.amazon.awscdk.services.lex.CfnBot.IntentOverrideProperty intent) {
                this.intent = intent;
                return this;
            }

            /**
             * Sets the value of {@link DialogStateProperty#getSessionAttributes}
             * @param sessionAttributes Map of key/value pairs representing session-specific context information.
             *                          It contains application information passed between Amazon Lex and a client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionAttributes(software.amazon.awscdk.IResolvable sessionAttributes) {
                this.sessionAttributes = sessionAttributes;
                return this;
            }

            /**
             * Sets the value of {@link DialogStateProperty#getSessionAttributes}
             * @param sessionAttributes Map of key/value pairs representing session-specific context information.
             *                          It contains application information passed between Amazon Lex and a client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionAttributes(java.util.List<? extends java.lang.Object> sessionAttributes) {
                this.sessionAttributes = sessionAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DialogStateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DialogStateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DialogStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DialogStateProperty {
            private final java.lang.Object dialogAction;
            private final java.lang.Object intent;
            private final java.lang.Object sessionAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dialogAction = software.amazon.jsii.Kernel.get(this, "dialogAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intent = software.amazon.jsii.Kernel.get(this, "intent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sessionAttributes = software.amazon.jsii.Kernel.get(this, "sessionAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dialogAction = builder.dialogAction;
                this.intent = builder.intent;
                this.sessionAttributes = builder.sessionAttributes;
            }

            @Override
            public final java.lang.Object getDialogAction() {
                return this.dialogAction;
            }

            @Override
            public final java.lang.Object getIntent() {
                return this.intent;
            }

            @Override
            public final java.lang.Object getSessionAttributes() {
                return this.sessionAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDialogAction() != null) {
                    data.set("dialogAction", om.valueToTree(this.getDialogAction()));
                }
                if (this.getIntent() != null) {
                    data.set("intent", om.valueToTree(this.getIntent()));
                }
                if (this.getSessionAttributes() != null) {
                    data.set("sessionAttributes", om.valueToTree(this.getSessionAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DialogStateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DialogStateProperty.Jsii$Proxy that = (DialogStateProperty.Jsii$Proxy) o;

                if (this.dialogAction != null ? !this.dialogAction.equals(that.dialogAction) : that.dialogAction != null) return false;
                if (this.intent != null ? !this.intent.equals(that.intent) : that.intent != null) return false;
                return this.sessionAttributes != null ? this.sessionAttributes.equals(that.sessionAttributes) : that.sessionAttributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dialogAction != null ? this.dialogAction.hashCode() : 0;
                result = 31 * result + (this.intent != null ? this.intent.hashCode() : 0);
                result = 31 * result + (this.sessionAttributes != null ? this.sessionAttributes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings that specify the dialog code hook that is called by Amazon Lex between eliciting slot values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ElicitationCodeHookInvocationSettingProperty elicitationCodeHookInvocationSettingProperty = ElicitationCodeHookInvocationSettingProperty.builder()
     *         .enableCodeHookInvocation(false)
     *         // the properties below are optional
     *         .invocationLabel("invocationLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ElicitationCodeHookInvocationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ElicitationCodeHookInvocationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElicitationCodeHookInvocationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a Lambda function should be invoked for the dialog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html#cfn-lex-bot-elicitationcodehookinvocationsetting-enablecodehookinvocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html#cfn-lex-bot-elicitationcodehookinvocationsetting-enablecodehookinvocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableCodeHookInvocation();

        /**
         * A label that indicates the dialog step from which the dialog code hook is happening.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html#cfn-lex-bot-elicitationcodehookinvocationsetting-invocationlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-elicitationcodehookinvocationsetting.html#cfn-lex-bot-elicitationcodehookinvocationsetting-invocationlabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvocationLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElicitationCodeHookInvocationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElicitationCodeHookInvocationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElicitationCodeHookInvocationSettingProperty> {
            java.lang.Object enableCodeHookInvocation;
            java.lang.String invocationLabel;

            /**
             * Sets the value of {@link ElicitationCodeHookInvocationSettingProperty#getEnableCodeHookInvocation}
             * @param enableCodeHookInvocation Indicates whether a Lambda function should be invoked for the dialog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCodeHookInvocation(java.lang.Boolean enableCodeHookInvocation) {
                this.enableCodeHookInvocation = enableCodeHookInvocation;
                return this;
            }

            /**
             * Sets the value of {@link ElicitationCodeHookInvocationSettingProperty#getEnableCodeHookInvocation}
             * @param enableCodeHookInvocation Indicates whether a Lambda function should be invoked for the dialog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCodeHookInvocation(software.amazon.awscdk.IResolvable enableCodeHookInvocation) {
                this.enableCodeHookInvocation = enableCodeHookInvocation;
                return this;
            }

            /**
             * Sets the value of {@link ElicitationCodeHookInvocationSettingProperty#getInvocationLabel}
             * @param invocationLabel A label that indicates the dialog step from which the dialog code hook is happening.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationLabel(java.lang.String invocationLabel) {
                this.invocationLabel = invocationLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElicitationCodeHookInvocationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElicitationCodeHookInvocationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElicitationCodeHookInvocationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElicitationCodeHookInvocationSettingProperty {
            private final java.lang.Object enableCodeHookInvocation;
            private final java.lang.String invocationLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableCodeHookInvocation = software.amazon.jsii.Kernel.get(this, "enableCodeHookInvocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.invocationLabel = software.amazon.jsii.Kernel.get(this, "invocationLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableCodeHookInvocation = java.util.Objects.requireNonNull(builder.enableCodeHookInvocation, "enableCodeHookInvocation is required");
                this.invocationLabel = builder.invocationLabel;
            }

            @Override
            public final java.lang.Object getEnableCodeHookInvocation() {
                return this.enableCodeHookInvocation;
            }

            @Override
            public final java.lang.String getInvocationLabel() {
                return this.invocationLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enableCodeHookInvocation", om.valueToTree(this.getEnableCodeHookInvocation()));
                if (this.getInvocationLabel() != null) {
                    data.set("invocationLabel", om.valueToTree(this.getInvocationLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ElicitationCodeHookInvocationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElicitationCodeHookInvocationSettingProperty.Jsii$Proxy that = (ElicitationCodeHookInvocationSettingProperty.Jsii$Proxy) o;

                if (!enableCodeHookInvocation.equals(that.enableCodeHookInvocation)) return false;
                return this.invocationLabel != null ? this.invocationLabel.equals(that.invocationLabel) : that.invocationLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableCodeHookInvocation.hashCode();
                result = 31 * result + (this.invocationLabel != null ? this.invocationLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information about the external source of the slot type's definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ExternalSourceSettingProperty externalSourceSettingProperty = ExternalSourceSettingProperty.builder()
     *         .grammarSlotTypeSetting(GrammarSlotTypeSettingProperty.builder()
     *                 .source(GrammarSlotTypeSourceProperty.builder()
     *                         .s3BucketName("s3BucketName")
     *                         .s3ObjectKey("s3ObjectKey")
     *                         // the properties below are optional
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-externalsourcesetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-externalsourcesetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ExternalSourceSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ExternalSourceSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExternalSourceSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings required for a slot type based on a grammar that you provide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-externalsourcesetting.html#cfn-lex-bot-externalsourcesetting-grammarslottypesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-externalsourcesetting.html#cfn-lex-bot-externalsourcesetting-grammarslottypesetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrammarSlotTypeSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExternalSourceSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExternalSourceSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExternalSourceSettingProperty> {
            java.lang.Object grammarSlotTypeSetting;

            /**
             * Sets the value of {@link ExternalSourceSettingProperty#getGrammarSlotTypeSetting}
             * @param grammarSlotTypeSetting Settings required for a slot type based on a grammar that you provide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grammarSlotTypeSetting(software.amazon.awscdk.IResolvable grammarSlotTypeSetting) {
                this.grammarSlotTypeSetting = grammarSlotTypeSetting;
                return this;
            }

            /**
             * Sets the value of {@link ExternalSourceSettingProperty#getGrammarSlotTypeSetting}
             * @param grammarSlotTypeSetting Settings required for a slot type based on a grammar that you provide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grammarSlotTypeSetting(software.amazon.awscdk.services.lex.CfnBot.GrammarSlotTypeSettingProperty grammarSlotTypeSetting) {
                this.grammarSlotTypeSetting = grammarSlotTypeSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExternalSourceSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExternalSourceSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExternalSourceSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExternalSourceSettingProperty {
            private final java.lang.Object grammarSlotTypeSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grammarSlotTypeSetting = software.amazon.jsii.Kernel.get(this, "grammarSlotTypeSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grammarSlotTypeSetting = builder.grammarSlotTypeSetting;
            }

            @Override
            public final java.lang.Object getGrammarSlotTypeSetting() {
                return this.grammarSlotTypeSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrammarSlotTypeSetting() != null) {
                    data.set("grammarSlotTypeSetting", om.valueToTree(this.getGrammarSlotTypeSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ExternalSourceSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExternalSourceSettingProperty.Jsii$Proxy that = (ExternalSourceSettingProperty.Jsii$Proxy) o;

                return this.grammarSlotTypeSetting != null ? this.grammarSlotTypeSetting.equals(that.grammarSlotTypeSetting) : that.grammarSlotTypeSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grammarSlotTypeSetting != null ? this.grammarSlotTypeSetting.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Determines if a Lambda function should be invoked for a specific intent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentCodeHookSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentCodeHookSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentCodeHookSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a Lambda function should be invoked to fulfill a specific intent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
         * <p>
         * Fulfillment updates can be used only with streaming conversations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-fulfillmentupdatesspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-fulfillmentupdatesspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFulfillmentUpdatesSpecification() {
            return null;
        }

        /**
         * Determines whether the fulfillment code hook is used.
         * <p>
         * When <code>active</code> is false, the code hook doesn't run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-isactive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-isactive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsActive() {
            return null;
        }

        /**
         * Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
         * <p>
         * Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-postfulfillmentstatusspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentcodehooksetting.html#cfn-lex-bot-fulfillmentcodehooksetting-postfulfillmentstatusspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostFulfillmentStatusSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentCodeHookSettingProperty> {
            java.lang.Object enabled;
            java.lang.Object fulfillmentUpdatesSpecification;
            java.lang.Object isActive;
            java.lang.Object postFulfillmentStatusSpecification;

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getEnabled}
             * @param enabled Indicates whether a Lambda function should be invoked to fulfill a specific intent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getEnabled}
             * @param enabled Indicates whether a Lambda function should be invoked to fulfill a specific intent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getFulfillmentUpdatesSpecification}
             * @param fulfillmentUpdatesSpecification Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
             *                                        Fulfillment updates can be used only with streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentUpdatesSpecification(software.amazon.awscdk.IResolvable fulfillmentUpdatesSpecification) {
                this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getFulfillmentUpdatesSpecification}
             * @param fulfillmentUpdatesSpecification Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
             *                                        Fulfillment updates can be used only with streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentUpdatesSpecification(software.amazon.awscdk.services.lex.CfnBot.FulfillmentUpdatesSpecificationProperty fulfillmentUpdatesSpecification) {
                this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getIsActive}
             * @param isActive Determines whether the fulfillment code hook is used.
             *                 When <code>active</code> is false, the code hook doesn't run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getIsActive}
             * @param isActive Determines whether the fulfillment code hook is used.
             *                 When <code>active</code> is false, the code hook doesn't run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getPostFulfillmentStatusSpecification}
             * @param postFulfillmentStatusSpecification Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
             *                                           Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postFulfillmentStatusSpecification(software.amazon.awscdk.IResolvable postFulfillmentStatusSpecification) {
                this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getPostFulfillmentStatusSpecification}
             * @param postFulfillmentStatusSpecification Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
             *                                           Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postFulfillmentStatusSpecification(software.amazon.awscdk.services.lex.CfnBot.PostFulfillmentStatusSpecificationProperty postFulfillmentStatusSpecification) {
                this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentCodeHookSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentCodeHookSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentCodeHookSettingProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object fulfillmentUpdatesSpecification;
            private final java.lang.Object isActive;
            private final java.lang.Object postFulfillmentStatusSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fulfillmentUpdatesSpecification = software.amazon.jsii.Kernel.get(this, "fulfillmentUpdatesSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postFulfillmentStatusSpecification = software.amazon.jsii.Kernel.get(this, "postFulfillmentStatusSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.fulfillmentUpdatesSpecification = builder.fulfillmentUpdatesSpecification;
                this.isActive = builder.isActive;
                this.postFulfillmentStatusSpecification = builder.postFulfillmentStatusSpecification;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getFulfillmentUpdatesSpecification() {
                return this.fulfillmentUpdatesSpecification;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            public final java.lang.Object getPostFulfillmentStatusSpecification() {
                return this.postFulfillmentStatusSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getFulfillmentUpdatesSpecification() != null) {
                    data.set("fulfillmentUpdatesSpecification", om.valueToTree(this.getFulfillmentUpdatesSpecification()));
                }
                if (this.getIsActive() != null) {
                    data.set("isActive", om.valueToTree(this.getIsActive()));
                }
                if (this.getPostFulfillmentStatusSpecification() != null) {
                    data.set("postFulfillmentStatusSpecification", om.valueToTree(this.getPostFulfillmentStatusSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentCodeHookSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentCodeHookSettingProperty.Jsii$Proxy that = (FulfillmentCodeHookSettingProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.fulfillmentUpdatesSpecification != null ? !this.fulfillmentUpdatesSpecification.equals(that.fulfillmentUpdatesSpecification) : that.fulfillmentUpdatesSpecification != null) return false;
                if (this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null) return false;
                return this.postFulfillmentStatusSpecification != null ? this.postFulfillmentStatusSpecification.equals(that.postFulfillmentStatusSpecification) : that.postFulfillmentStatusSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.fulfillmentUpdatesSpecification != null ? this.fulfillmentUpdatesSpecification.hashCode() : 0);
                result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
                result = 31 * result + (this.postFulfillmentStatusSpecification != null ? this.postFulfillmentStatusSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * FulfillmentStartResponseSpecificationProperty fulfillmentStartResponseSpecificationProperty = FulfillmentStartResponseSpecificationProperty.builder()
     *         .delayInSeconds(123)
     *         .messageGroups(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentStartResponseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentStartResponseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentStartResponseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The delay between when the Lambda fulfillment function starts running and the start message is played.
         * <p>
         * If the Lambda function returns before the delay is over, the start message isn't played.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html#cfn-lex-bot-fulfillmentstartresponsespecification-delayinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html#cfn-lex-bot-fulfillmentstartresponsespecification-delayinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDelayInSeconds();

        /**
         * 1 - 5 message groups that contain start messages.
         * <p>
         * Amazon Lex chooses one of the messages to play to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html#cfn-lex-bot-fulfillmentstartresponsespecification-messagegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html#cfn-lex-bot-fulfillmentstartresponsespecification-messagegroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroups();

        /**
         * Determines whether the user can interrupt the start message while it is playing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html#cfn-lex-bot-fulfillmentstartresponsespecification-allowinterrupt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentstartresponsespecification.html#cfn-lex-bot-fulfillmentstartresponsespecification-allowinterrupt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentStartResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentStartResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentStartResponseSpecificationProperty> {
            java.lang.Number delayInSeconds;
            java.lang.Object messageGroups;
            java.lang.Object allowInterrupt;

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getDelayInSeconds}
             * @param delayInSeconds The delay between when the Lambda fulfillment function starts running and the start message is played. This parameter is required.
             *                       If the Lambda function returns before the delay is over, the start message isn't played.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delayInSeconds(java.lang.Number delayInSeconds) {
                this.delayInSeconds = delayInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups 1 - 5 message groups that contain start messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(software.amazon.awscdk.IResolvable messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups 1 - 5 message groups that contain start messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(java.util.List<? extends java.lang.Object> messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt the start message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt the start message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentStartResponseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentStartResponseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentStartResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentStartResponseSpecificationProperty {
            private final java.lang.Number delayInSeconds;
            private final java.lang.Object messageGroups;
            private final java.lang.Object allowInterrupt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delayInSeconds = software.amazon.jsii.Kernel.get(this, "delayInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messageGroups = software.amazon.jsii.Kernel.get(this, "messageGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delayInSeconds = java.util.Objects.requireNonNull(builder.delayInSeconds, "delayInSeconds is required");
                this.messageGroups = java.util.Objects.requireNonNull(builder.messageGroups, "messageGroups is required");
                this.allowInterrupt = builder.allowInterrupt;
            }

            @Override
            public final java.lang.Number getDelayInSeconds() {
                return this.delayInSeconds;
            }

            @Override
            public final java.lang.Object getMessageGroups() {
                return this.messageGroups;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("delayInSeconds", om.valueToTree(this.getDelayInSeconds()));
                data.set("messageGroups", om.valueToTree(this.getMessageGroups()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentStartResponseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentStartResponseSpecificationProperty.Jsii$Proxy that = (FulfillmentStartResponseSpecificationProperty.Jsii$Proxy) o;

                if (!delayInSeconds.equals(that.delayInSeconds)) return false;
                if (!messageGroups.equals(that.messageGroups)) return false;
                return this.allowInterrupt != null ? this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delayInSeconds.hashCode();
                result = 31 * result + (this.messageGroups.hashCode());
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides settings for a message that is sent periodically to the user while a fulfillment Lambda function is running.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * FulfillmentUpdateResponseSpecificationProperty fulfillmentUpdateResponseSpecificationProperty = FulfillmentUpdateResponseSpecificationProperty.builder()
     *         .frequencyInSeconds(123)
     *         .messageGroups(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentUpdateResponseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentUpdateResponseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency that a message is sent to the user.
         * <p>
         * When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html#cfn-lex-bot-fulfillmentupdateresponsespecification-frequencyinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html#cfn-lex-bot-fulfillmentupdateresponsespecification-frequencyinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFrequencyInSeconds();

        /**
         * 1 - 5 message groups that contain update messages.
         * <p>
         * Amazon Lex chooses one of the messages to play to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html#cfn-lex-bot-fulfillmentupdateresponsespecification-messagegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html#cfn-lex-bot-fulfillmentupdateresponsespecification-messagegroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroups();

        /**
         * Determines whether the user can interrupt an update message while it is playing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html#cfn-lex-bot-fulfillmentupdateresponsespecification-allowinterrupt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdateresponsespecification.html#cfn-lex-bot-fulfillmentupdateresponsespecification-allowinterrupt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentUpdateResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentUpdateResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentUpdateResponseSpecificationProperty> {
            java.lang.Number frequencyInSeconds;
            java.lang.Object messageGroups;
            java.lang.Object allowInterrupt;

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getFrequencyInSeconds}
             * @param frequencyInSeconds The frequency that a message is sent to the user. This parameter is required.
             *                           When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequencyInSeconds(java.lang.Number frequencyInSeconds) {
                this.frequencyInSeconds = frequencyInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups 1 - 5 message groups that contain update messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(software.amazon.awscdk.IResolvable messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups 1 - 5 message groups that contain update messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(java.util.List<? extends java.lang.Object> messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt an update message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt an update message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentUpdateResponseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentUpdateResponseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentUpdateResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentUpdateResponseSpecificationProperty {
            private final java.lang.Number frequencyInSeconds;
            private final java.lang.Object messageGroups;
            private final java.lang.Object allowInterrupt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequencyInSeconds = software.amazon.jsii.Kernel.get(this, "frequencyInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messageGroups = software.amazon.jsii.Kernel.get(this, "messageGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequencyInSeconds = java.util.Objects.requireNonNull(builder.frequencyInSeconds, "frequencyInSeconds is required");
                this.messageGroups = java.util.Objects.requireNonNull(builder.messageGroups, "messageGroups is required");
                this.allowInterrupt = builder.allowInterrupt;
            }

            @Override
            public final java.lang.Number getFrequencyInSeconds() {
                return this.frequencyInSeconds;
            }

            @Override
            public final java.lang.Object getMessageGroups() {
                return this.messageGroups;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("frequencyInSeconds", om.valueToTree(this.getFrequencyInSeconds()));
                data.set("messageGroups", om.valueToTree(this.getMessageGroups()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentUpdateResponseSpecificationProperty.Jsii$Proxy that = (FulfillmentUpdateResponseSpecificationProperty.Jsii$Proxy) o;

                if (!frequencyInSeconds.equals(that.frequencyInSeconds)) return false;
                if (!messageGroups.equals(that.messageGroups)) return false;
                return this.allowInterrupt != null ? this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.frequencyInSeconds.hashCode();
                result = 31 * result + (this.messageGroups.hashCode());
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information for updating the user on the progress of fulfilling an intent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * FulfillmentUpdatesSpecificationProperty fulfillmentUpdatesSpecificationProperty = FulfillmentUpdatesSpecificationProperty.builder()
     *         .active(false)
     *         // the properties below are optional
     *         .startResponse(FulfillmentStartResponseSpecificationProperty.builder()
     *                 .delayInSeconds(123)
     *                 .messageGroups(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .timeoutInSeconds(123)
     *         .updateResponse(FulfillmentUpdateResponseSpecificationProperty.builder()
     *                 .frequencyInSeconds(123)
     *                 .messageGroups(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdatesSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentUpdatesSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentUpdatesSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
         * <p>
         * If the <code>active</code> field is set to true, the <code>startResponse</code> , <code>updateResponse</code> , and <code>timeoutInSeconds</code> fields are required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-active">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-active</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActive();

        /**
         * Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-startresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-startresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartResponse() {
            return null;
        }

        /**
         * The length of time that the fulfillment Lambda function should run before it times out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-timeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-timeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
            return null;
        }

        /**
         * Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-updateresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-fulfillmentupdatesspecification.html#cfn-lex-bot-fulfillmentupdatesspecification-updateresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentUpdatesSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentUpdatesSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentUpdatesSpecificationProperty> {
            java.lang.Object active;
            java.lang.Object startResponse;
            java.lang.Number timeoutInSeconds;
            java.lang.Object updateResponse;

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getActive}
             * @param active Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent. This parameter is required.
             *               If the <code>active</code> field is set to true, the <code>startResponse</code> , <code>updateResponse</code> , and <code>timeoutInSeconds</code> fields are required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder active(java.lang.Boolean active) {
                this.active = active;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getActive}
             * @param active Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent. This parameter is required.
             *               If the <code>active</code> field is set to true, the <code>startResponse</code> , <code>updateResponse</code> , and <code>timeoutInSeconds</code> fields are required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder active(software.amazon.awscdk.IResolvable active) {
                this.active = active;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getStartResponse}
             * @param startResponse Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startResponse(software.amazon.awscdk.IResolvable startResponse) {
                this.startResponse = startResponse;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getStartResponse}
             * @param startResponse Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startResponse(software.amazon.awscdk.services.lex.CfnBot.FulfillmentStartResponseSpecificationProperty startResponse) {
                this.startResponse = startResponse;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds The length of time that the fulfillment Lambda function should run before it times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getUpdateResponse}
             * @param updateResponse Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateResponse(software.amazon.awscdk.IResolvable updateResponse) {
                this.updateResponse = updateResponse;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getUpdateResponse}
             * @param updateResponse Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateResponse(software.amazon.awscdk.services.lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty updateResponse) {
                this.updateResponse = updateResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentUpdatesSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentUpdatesSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentUpdatesSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentUpdatesSpecificationProperty {
            private final java.lang.Object active;
            private final java.lang.Object startResponse;
            private final java.lang.Number timeoutInSeconds;
            private final java.lang.Object updateResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.active = software.amazon.jsii.Kernel.get(this, "active", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startResponse = software.amazon.jsii.Kernel.get(this, "startResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.updateResponse = software.amazon.jsii.Kernel.get(this, "updateResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.active = java.util.Objects.requireNonNull(builder.active, "active is required");
                this.startResponse = builder.startResponse;
                this.timeoutInSeconds = builder.timeoutInSeconds;
                this.updateResponse = builder.updateResponse;
            }

            @Override
            public final java.lang.Object getActive() {
                return this.active;
            }

            @Override
            public final java.lang.Object getStartResponse() {
                return this.startResponse;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            public final java.lang.Object getUpdateResponse() {
                return this.updateResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("active", om.valueToTree(this.getActive()));
                if (this.getStartResponse() != null) {
                    data.set("startResponse", om.valueToTree(this.getStartResponse()));
                }
                if (this.getTimeoutInSeconds() != null) {
                    data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                }
                if (this.getUpdateResponse() != null) {
                    data.set("updateResponse", om.valueToTree(this.getUpdateResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdatesSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentUpdatesSpecificationProperty.Jsii$Proxy that = (FulfillmentUpdatesSpecificationProperty.Jsii$Proxy) o;

                if (!active.equals(that.active)) return false;
                if (this.startResponse != null ? !this.startResponse.equals(that.startResponse) : that.startResponse != null) return false;
                if (this.timeoutInSeconds != null ? !this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds != null) return false;
                return this.updateResponse != null ? this.updateResponse.equals(that.updateResponse) : that.updateResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.active.hashCode();
                result = 31 * result + (this.startResponse != null ? this.startResponse.hashCode() : 0);
                result = 31 * result + (this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.updateResponse != null ? this.updateResponse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings requried for a slot type based on a grammar that you provide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * GrammarSlotTypeSettingProperty grammarSlotTypeSettingProperty = GrammarSlotTypeSettingProperty.builder()
     *         .source(GrammarSlotTypeSourceProperty.builder()
     *                 .s3BucketName("s3BucketName")
     *                 .s3ObjectKey("s3ObjectKey")
     *                 // the properties below are optional
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(GrammarSlotTypeSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrammarSlotTypeSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the grammar used to create the slot type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesetting.html#cfn-lex-bot-grammarslottypesetting-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesetting.html#cfn-lex-bot-grammarslottypesetting-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrammarSlotTypeSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrammarSlotTypeSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrammarSlotTypeSettingProperty> {
            java.lang.Object source;

            /**
             * Sets the value of {@link GrammarSlotTypeSettingProperty#getSource}
             * @param source The source of the grammar used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link GrammarSlotTypeSettingProperty#getSource}
             * @param source The source of the grammar used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.lex.CfnBot.GrammarSlotTypeSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrammarSlotTypeSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrammarSlotTypeSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrammarSlotTypeSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrammarSlotTypeSettingProperty {
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = builder.source;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrammarSlotTypeSettingProperty.Jsii$Proxy that = (GrammarSlotTypeSettingProperty.Jsii$Proxy) o;

                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source != null ? this.source.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * GrammarSlotTypeSourceProperty grammarSlotTypeSourceProperty = GrammarSlotTypeSourceProperty.builder()
     *         .s3BucketName("s3BucketName")
     *         .s3ObjectKey("s3ObjectKey")
     *         // the properties below are optional
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(GrammarSlotTypeSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrammarSlotTypeSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket that contains the grammar source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html#cfn-lex-bot-grammarslottypesource-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html#cfn-lex-bot-grammarslottypesource-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

        /**
         * The path to the grammar in the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html#cfn-lex-bot-grammarslottypesource-s3objectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html#cfn-lex-bot-grammarslottypesource-s3objectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectKey();

        /**
         * The AWS KMS key required to decrypt the contents of the grammar, if any.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html#cfn-lex-bot-grammarslottypesource-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-grammarslottypesource.html#cfn-lex-bot-grammarslottypesource-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrammarSlotTypeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrammarSlotTypeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrammarSlotTypeSourceProperty> {
            java.lang.String s3BucketName;
            java.lang.String s3ObjectKey;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link GrammarSlotTypeSourceProperty#getS3BucketName}
             * @param s3BucketName The name of the Amazon S3 bucket that contains the grammar source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link GrammarSlotTypeSourceProperty#getS3ObjectKey}
             * @param s3ObjectKey The path to the grammar in the Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectKey(java.lang.String s3ObjectKey) {
                this.s3ObjectKey = s3ObjectKey;
                return this;
            }

            /**
             * Sets the value of {@link GrammarSlotTypeSourceProperty#getKmsKeyArn}
             * @param kmsKeyArn The AWS KMS key required to decrypt the contents of the grammar, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrammarSlotTypeSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrammarSlotTypeSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrammarSlotTypeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrammarSlotTypeSourceProperty {
            private final java.lang.String s3BucketName;
            private final java.lang.String s3ObjectKey;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectKey = software.amazon.jsii.Kernel.get(this, "s3ObjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3BucketName = java.util.Objects.requireNonNull(builder.s3BucketName, "s3BucketName is required");
                this.s3ObjectKey = java.util.Objects.requireNonNull(builder.s3ObjectKey, "s3ObjectKey is required");
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getS3ObjectKey() {
                return this.s3ObjectKey;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                data.set("s3ObjectKey", om.valueToTree(this.getS3ObjectKey()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrammarSlotTypeSourceProperty.Jsii$Proxy that = (GrammarSlotTypeSourceProperty.Jsii$Proxy) o;

                if (!s3BucketName.equals(that.s3BucketName)) return false;
                if (!s3ObjectKey.equals(that.s3ObjectKey)) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3BucketName.hashCode();
                result = 31 * result + (this.s3ObjectKey.hashCode());
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A card that is shown to the user by a messaging platform.
     * <p>
     * You define the contents of the card, the card is displayed by the platform.
     * <p>
     * When you use a response card, the response from the user is constrained to the text associated with a button on the card.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ImageResponseCardProperty imageResponseCardProperty = ImageResponseCardProperty.builder()
     *         .title("title")
     *         // the properties below are optional
     *         .buttons(List.of(ButtonProperty.builder()
     *                 .text("text")
     *                 .value("value")
     *                 .build()))
     *         .imageUrl("imageUrl")
     *         .subtitle("subtitle")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ImageResponseCardProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageResponseCardProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageResponseCardProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The title to display on the response card.
         * <p>
         * The format of the title is determined by the platform displaying the response card.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTitle();

        /**
         * A list of buttons that should be displayed on the response card.
         * <p>
         * The arrangement of the buttons is determined by the platform that displays the button.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-buttons">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-buttons</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getButtons() {
            return null;
        }

        /**
         * The URL of an image to display on the response card.
         * <p>
         * The image URL must be publicly available so that the platform displaying the response card has access to the image.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-imageurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-imageurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageUrl() {
            return null;
        }

        /**
         * The subtitle to display on the response card.
         * <p>
         * The format of the subtitle is determined by the platform displaying the response card.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-subtitle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-imageresponsecard.html#cfn-lex-bot-imageresponsecard-subtitle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubtitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageResponseCardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageResponseCardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageResponseCardProperty> {
            java.lang.String title;
            java.lang.Object buttons;
            java.lang.String imageUrl;
            java.lang.String subtitle;

            /**
             * Sets the value of {@link ImageResponseCardProperty#getTitle}
             * @param title The title to display on the response card. This parameter is required.
             *              The format of the title is determined by the platform displaying the response card.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getButtons}
             * @param buttons A list of buttons that should be displayed on the response card.
             *                The arrangement of the buttons is determined by the platform that displays the button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttons(software.amazon.awscdk.IResolvable buttons) {
                this.buttons = buttons;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getButtons}
             * @param buttons A list of buttons that should be displayed on the response card.
             *                The arrangement of the buttons is determined by the platform that displays the button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttons(java.util.List<? extends java.lang.Object> buttons) {
                this.buttons = buttons;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getImageUrl}
             * @param imageUrl The URL of an image to display on the response card.
             *                 The image URL must be publicly available so that the platform displaying the response card has access to the image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUrl(java.lang.String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getSubtitle}
             * @param subtitle The subtitle to display on the response card.
             *                 The format of the subtitle is determined by the platform displaying the response card.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitle(java.lang.String subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageResponseCardProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageResponseCardProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageResponseCardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageResponseCardProperty {
            private final java.lang.String title;
            private final java.lang.Object buttons;
            private final java.lang.String imageUrl;
            private final java.lang.String subtitle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.buttons = software.amazon.jsii.Kernel.get(this, "buttons", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageUrl = software.amazon.jsii.Kernel.get(this, "imageUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subtitle = software.amazon.jsii.Kernel.get(this, "subtitle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
                this.buttons = builder.buttons;
                this.imageUrl = builder.imageUrl;
                this.subtitle = builder.subtitle;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.Object getButtons() {
                return this.buttons;
            }

            @Override
            public final java.lang.String getImageUrl() {
                return this.imageUrl;
            }

            @Override
            public final java.lang.String getSubtitle() {
                return this.subtitle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("title", om.valueToTree(this.getTitle()));
                if (this.getButtons() != null) {
                    data.set("buttons", om.valueToTree(this.getButtons()));
                }
                if (this.getImageUrl() != null) {
                    data.set("imageUrl", om.valueToTree(this.getImageUrl()));
                }
                if (this.getSubtitle() != null) {
                    data.set("subtitle", om.valueToTree(this.getSubtitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ImageResponseCardProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageResponseCardProperty.Jsii$Proxy that = (ImageResponseCardProperty.Jsii$Proxy) o;

                if (!title.equals(that.title)) return false;
                if (this.buttons != null ? !this.buttons.equals(that.buttons) : that.buttons != null) return false;
                if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) return false;
                return this.subtitle != null ? this.subtitle.equals(that.subtitle) : that.subtitle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.title.hashCode();
                result = 31 * result + (this.buttons != null ? this.buttons.hashCode() : 0);
                result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
                result = 31 * result + (this.subtitle != null ? this.subtitle.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration setting for a response sent to the user before Amazon Lex starts eliciting slots.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.InitialResponseSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(InitialResponseSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitialResponseSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-codehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-codehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeHook() {
            return null;
        }

        /**
         * Provides a list of conditional branches.
         * <p>
         * Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-conditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-conditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditional() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-initialresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-initialresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInitialResponse() {
            return null;
        }

        /**
         * The next step in the conversation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-nextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-initialresponsesetting.html#cfn-lex-bot-initialresponsesetting-nextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNextStep() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InitialResponseSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitialResponseSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitialResponseSettingProperty> {
            java.lang.Object codeHook;
            java.lang.Object conditional;
            java.lang.Object initialResponse;
            java.lang.Object nextStep;

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getCodeHook}
             * @param codeHook Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHook(software.amazon.awscdk.IResolvable codeHook) {
                this.codeHook = codeHook;
                return this;
            }

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getCodeHook}
             * @param codeHook Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHook(software.amazon.awscdk.services.lex.CfnBot.DialogCodeHookInvocationSettingProperty codeHook) {
                this.codeHook = codeHook;
                return this;
            }

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getConditional}
             * @param conditional Provides a list of conditional branches.
             *                    Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.IResolvable conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getConditional}
             * @param conditional Provides a list of conditional branches.
             *                    Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getInitialResponse}
             * @param initialResponse Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialResponse(software.amazon.awscdk.IResolvable initialResponse) {
                this.initialResponse = initialResponse;
                return this;
            }

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getInitialResponse}
             * @param initialResponse Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty initialResponse) {
                this.initialResponse = initialResponse;
                return this;
            }

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getNextStep}
             * @param nextStep The next step in the conversation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.IResolvable nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Sets the value of {@link InitialResponseSettingProperty#getNextStep}
             * @param nextStep The next step in the conversation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitialResponseSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitialResponseSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitialResponseSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitialResponseSettingProperty {
            private final java.lang.Object codeHook;
            private final java.lang.Object conditional;
            private final java.lang.Object initialResponse;
            private final java.lang.Object nextStep;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeHook = software.amazon.jsii.Kernel.get(this, "codeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.conditional = software.amazon.jsii.Kernel.get(this, "conditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.initialResponse = software.amazon.jsii.Kernel.get(this, "initialResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nextStep = software.amazon.jsii.Kernel.get(this, "nextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeHook = builder.codeHook;
                this.conditional = builder.conditional;
                this.initialResponse = builder.initialResponse;
                this.nextStep = builder.nextStep;
            }

            @Override
            public final java.lang.Object getCodeHook() {
                return this.codeHook;
            }

            @Override
            public final java.lang.Object getConditional() {
                return this.conditional;
            }

            @Override
            public final java.lang.Object getInitialResponse() {
                return this.initialResponse;
            }

            @Override
            public final java.lang.Object getNextStep() {
                return this.nextStep;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCodeHook() != null) {
                    data.set("codeHook", om.valueToTree(this.getCodeHook()));
                }
                if (this.getConditional() != null) {
                    data.set("conditional", om.valueToTree(this.getConditional()));
                }
                if (this.getInitialResponse() != null) {
                    data.set("initialResponse", om.valueToTree(this.getInitialResponse()));
                }
                if (this.getNextStep() != null) {
                    data.set("nextStep", om.valueToTree(this.getNextStep()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.InitialResponseSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitialResponseSettingProperty.Jsii$Proxy that = (InitialResponseSettingProperty.Jsii$Proxy) o;

                if (this.codeHook != null ? !this.codeHook.equals(that.codeHook) : that.codeHook != null) return false;
                if (this.conditional != null ? !this.conditional.equals(that.conditional) : that.conditional != null) return false;
                if (this.initialResponse != null ? !this.initialResponse.equals(that.initialResponse) : that.initialResponse != null) return false;
                return this.nextStep != null ? this.nextStep.equals(that.nextStep) : that.nextStep == null;
            }

            @Override
            public final int hashCode() {
                int result = this.codeHook != null ? this.codeHook.hashCode() : 0;
                result = 31 * result + (this.conditional != null ? this.conditional.hashCode() : 0);
                result = 31 * result + (this.initialResponse != null ? this.initialResponse.hashCode() : 0);
                result = 31 * result + (this.nextStep != null ? this.nextStep.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A context that must be active for an intent to be selected by Amazon Lex.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * InputContextProperty inputContextProperty = InputContextProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-inputcontext.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-inputcontext.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.InputContextProperty")
    @software.amazon.jsii.Jsii.Proxy(InputContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the context.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-inputcontext.html#cfn-lex-bot-inputcontext-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-inputcontext.html#cfn-lex-bot-inputcontext-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link InputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputContextProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link InputContextProperty#getName}
             * @param name The name of the context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputContextProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.InputContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputContextProperty.Jsii$Proxy that = (InputContextProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides a statement the Amazon Lex conveys to the user when the intent is successfully fulfilled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * IntentClosingSettingProperty intentClosingSettingProperty = IntentClosingSettingProperty.builder()
     *         .closingResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .conditional(ConditionalSpecificationProperty.builder()
     *                 .conditionalBranches(List.of(ConditionalBranchProperty.builder()
     *                         .condition(ConditionProperty.builder()
     *                                 .expressionString("expressionString")
     *                                 .build())
     *                         .name("name")
     *                         .nextStep(DialogStateProperty.builder()
     *                                 .dialogAction(DialogActionProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .slotToElicit("slotToElicit")
     *                                         .suppressNextMessage(false)
     *                                         .build())
     *                                 .intent(IntentOverrideProperty.builder()
     *                                         .name("name")
     *                                         .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                                                 .slotName("slotName")
     *                                                 .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                                         .shape("shape")
     *                                                         .value(SlotValueProperty.builder()
     *                                                                 .interpretedValue("interpretedValue")
     *                                                                 .build())
     *                                                         .values(List.of(slotValueOverrideProperty_))
     *                                                         .build())
     *                                                 .build()))
     *                                         .build())
     *                                 .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                                         .key("key")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         // the properties below are optional
     *                         .response(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .build()))
     *                 .defaultBranch(DefaultConditionalBranchProperty.builder()
     *                         .nextStep(DialogStateProperty.builder()
     *                                 .dialogAction(DialogActionProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .slotToElicit("slotToElicit")
     *                                         .suppressNextMessage(false)
     *                                         .build())
     *                                 .intent(IntentOverrideProperty.builder()
     *                                         .name("name")
     *                                         .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                                                 .slotName("slotName")
     *                                                 .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                                         .shape("shape")
     *                                                         .value(SlotValueProperty.builder()
     *                                                                 .interpretedValue("interpretedValue")
     *                                                                 .build())
     *                                                         .values(List.of(slotValueOverrideProperty_))
     *                                                         .build())
     *                                                 .build()))
     *                                         .build())
     *                                 .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                                         .key("key")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .response(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .build())
     *                 .isActive(false)
     *                 .build())
     *         .isActive(false)
     *         .nextStep(DialogStateProperty.builder()
     *                 .dialogAction(DialogActionProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .slotToElicit("slotToElicit")
     *                         .suppressNextMessage(false)
     *                         .build())
     *                 .intent(IntentOverrideProperty.builder()
     *                         .name("name")
     *                         .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                                 .slotName("slotName")
     *                                 .slotValueOverride(SlotValueOverrideProperty.builder()
     *                                         .shape("shape")
     *                                         .value(SlotValueProperty.builder()
     *                                                 .interpretedValue("interpretedValue")
     *                                                 .build())
     *                                         .values(List.of(slotValueOverrideProperty_))
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .sessionAttributes(List.of(SessionAttributeProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.IntentClosingSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(IntentClosingSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntentClosingSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The response that Amazon Lex sends to the user when the intent is complete.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-closingresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-closingresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClosingResponse() {
            return null;
        }

        /**
         * A list of conditional branches associated with the intent's closing response.
         * <p>
         * These branches are executed when the <code>nextStep</code> attribute is set to <code>EvalutateConditional</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-conditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-conditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditional() {
            return null;
        }

        /**
         * Specifies whether an intent's closing response is used.
         * <p>
         * When this field is false, the closing response isn't sent to the user. If the <code>IsActive</code> field isn't specified, the default is true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-isactive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-isactive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsActive() {
            return null;
        }

        /**
         * Specifies the next step that the bot executes after playing the intent's closing response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-nextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentclosingsetting.html#cfn-lex-bot-intentclosingsetting-nextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNextStep() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntentClosingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntentClosingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntentClosingSettingProperty> {
            java.lang.Object closingResponse;
            java.lang.Object conditional;
            java.lang.Object isActive;
            java.lang.Object nextStep;

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getClosingResponse}
             * @param closingResponse The response that Amazon Lex sends to the user when the intent is complete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder closingResponse(software.amazon.awscdk.IResolvable closingResponse) {
                this.closingResponse = closingResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getClosingResponse}
             * @param closingResponse The response that Amazon Lex sends to the user when the intent is complete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder closingResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty closingResponse) {
                this.closingResponse = closingResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getConditional}
             * @param conditional A list of conditional branches associated with the intent's closing response.
             *                    These branches are executed when the <code>nextStep</code> attribute is set to <code>EvalutateConditional</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.IResolvable conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getConditional}
             * @param conditional A list of conditional branches associated with the intent's closing response.
             *                    These branches are executed when the <code>nextStep</code> attribute is set to <code>EvalutateConditional</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getIsActive}
             * @param isActive Specifies whether an intent's closing response is used.
             *                 When this field is false, the closing response isn't sent to the user. If the <code>IsActive</code> field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getIsActive}
             * @param isActive Specifies whether an intent's closing response is used.
             *                 When this field is false, the closing response isn't sent to the user. If the <code>IsActive</code> field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getNextStep}
             * @param nextStep Specifies the next step that the bot executes after playing the intent's closing response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.IResolvable nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getNextStep}
             * @param nextStep Specifies the next step that the bot executes after playing the intent's closing response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty nextStep) {
                this.nextStep = nextStep;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntentClosingSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntentClosingSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntentClosingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntentClosingSettingProperty {
            private final java.lang.Object closingResponse;
            private final java.lang.Object conditional;
            private final java.lang.Object isActive;
            private final java.lang.Object nextStep;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.closingResponse = software.amazon.jsii.Kernel.get(this, "closingResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.conditional = software.amazon.jsii.Kernel.get(this, "conditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nextStep = software.amazon.jsii.Kernel.get(this, "nextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.closingResponse = builder.closingResponse;
                this.conditional = builder.conditional;
                this.isActive = builder.isActive;
                this.nextStep = builder.nextStep;
            }

            @Override
            public final java.lang.Object getClosingResponse() {
                return this.closingResponse;
            }

            @Override
            public final java.lang.Object getConditional() {
                return this.conditional;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            public final java.lang.Object getNextStep() {
                return this.nextStep;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClosingResponse() != null) {
                    data.set("closingResponse", om.valueToTree(this.getClosingResponse()));
                }
                if (this.getConditional() != null) {
                    data.set("conditional", om.valueToTree(this.getConditional()));
                }
                if (this.getIsActive() != null) {
                    data.set("isActive", om.valueToTree(this.getIsActive()));
                }
                if (this.getNextStep() != null) {
                    data.set("nextStep", om.valueToTree(this.getNextStep()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.IntentClosingSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntentClosingSettingProperty.Jsii$Proxy that = (IntentClosingSettingProperty.Jsii$Proxy) o;

                if (this.closingResponse != null ? !this.closingResponse.equals(that.closingResponse) : that.closingResponse != null) return false;
                if (this.conditional != null ? !this.conditional.equals(that.conditional) : that.conditional != null) return false;
                if (this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null) return false;
                return this.nextStep != null ? this.nextStep.equals(that.nextStep) : that.nextStep == null;
            }

            @Override
            public final int hashCode() {
                int result = this.closingResponse != null ? this.closingResponse.hashCode() : 0;
                result = 31 * result + (this.conditional != null ? this.conditional.hashCode() : 0);
                result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
                result = 31 * result + (this.nextStep != null ? this.nextStep.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides a prompt for making sure that the user is ready for the intent to be fulfilled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.IntentConfirmationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(IntentConfirmationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntentConfirmationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-promptspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-promptspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPromptSpecification();

        /**
         * The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step.
         * <p>
         * The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is <code>InvokeDialogCodeHook</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-codehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-codehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeHook() {
            return null;
        }

        /**
         * A list of conditional branches to evaluate after the intent is closed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-confirmationconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-confirmationconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfirmationConditional() {
            return null;
        }

        /**
         * Specifies the next step that the bot executes when the customer confirms the intent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-confirmationnextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-confirmationnextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfirmationNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-confirmationresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-confirmationresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfirmationResponse() {
            return null;
        }

        /**
         * A list of conditional branches to evaluate after the intent is declined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-declinationconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-declinationconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeclinationConditional() {
            return null;
        }

        /**
         * Specifies the next step that the bot executes when the customer declines the intent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-declinationnextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-declinationnextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeclinationNextStep() {
            return null;
        }

        /**
         * When the user answers "no" to the question defined in <code>promptSpecification</code> , Amazon Lex responds with this response to acknowledge that the intent was canceled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-declinationresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-declinationresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeclinationResponse() {
            return null;
        }

        /**
         * The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation prompt retries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-elicitationcodehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-elicitationcodehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElicitationCodeHook() {
            return null;
        }

        /**
         * Provides a list of conditional branches.
         * <p>
         * Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-failureconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-failureconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureConditional() {
            return null;
        }

        /**
         * The next step to take in the conversation if the confirmation step fails.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-failurenextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-failurenextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input when the intent confirmation fails.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-failureresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-failureresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureResponse() {
            return null;
        }

        /**
         * Specifies whether the intent's confirmation is sent to the user.
         * <p>
         * When this field is false, confirmation and declination responses aren't sent. If the <code>IsActive</code> field isn't specified, the default is true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-isactive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentconfirmationsetting.html#cfn-lex-bot-intentconfirmationsetting-isactive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsActive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntentConfirmationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntentConfirmationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntentConfirmationSettingProperty> {
            java.lang.Object promptSpecification;
            java.lang.Object codeHook;
            java.lang.Object confirmationConditional;
            java.lang.Object confirmationNextStep;
            java.lang.Object confirmationResponse;
            java.lang.Object declinationConditional;
            java.lang.Object declinationNextStep;
            java.lang.Object declinationResponse;
            java.lang.Object elicitationCodeHook;
            java.lang.Object failureConditional;
            java.lang.Object failureNextStep;
            java.lang.Object failureResponse;
            java.lang.Object isActive;

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getPromptSpecification}
             * @param promptSpecification Prompts the user to confirm the intent. This question should have a yes or no answer. This parameter is required.
             *                            Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.IResolvable promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getPromptSpecification}
             * @param promptSpecification Prompts the user to confirm the intent. This question should have a yes or no answer. This parameter is required.
             *                            Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.services.lex.CfnBot.PromptSpecificationProperty promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getCodeHook}
             * @param codeHook The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step.
             *                 The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is <code>InvokeDialogCodeHook</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHook(software.amazon.awscdk.IResolvable codeHook) {
                this.codeHook = codeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getCodeHook}
             * @param codeHook The <code>DialogCodeHookInvocationSetting</code> object associated with intent's confirmation step.
             *                 The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is <code>InvokeDialogCodeHook</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHook(software.amazon.awscdk.services.lex.CfnBot.DialogCodeHookInvocationSettingProperty codeHook) {
                this.codeHook = codeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getConfirmationConditional}
             * @param confirmationConditional A list of conditional branches to evaluate after the intent is closed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confirmationConditional(software.amazon.awscdk.IResolvable confirmationConditional) {
                this.confirmationConditional = confirmationConditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getConfirmationConditional}
             * @param confirmationConditional A list of conditional branches to evaluate after the intent is closed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confirmationConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty confirmationConditional) {
                this.confirmationConditional = confirmationConditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getConfirmationNextStep}
             * @param confirmationNextStep Specifies the next step that the bot executes when the customer confirms the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confirmationNextStep(software.amazon.awscdk.IResolvable confirmationNextStep) {
                this.confirmationNextStep = confirmationNextStep;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getConfirmationNextStep}
             * @param confirmationNextStep Specifies the next step that the bot executes when the customer confirms the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confirmationNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty confirmationNextStep) {
                this.confirmationNextStep = confirmationNextStep;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getConfirmationResponse}
             * @param confirmationResponse Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confirmationResponse(software.amazon.awscdk.IResolvable confirmationResponse) {
                this.confirmationResponse = confirmationResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getConfirmationResponse}
             * @param confirmationResponse Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confirmationResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty confirmationResponse) {
                this.confirmationResponse = confirmationResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationConditional}
             * @param declinationConditional A list of conditional branches to evaluate after the intent is declined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationConditional(software.amazon.awscdk.IResolvable declinationConditional) {
                this.declinationConditional = declinationConditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationConditional}
             * @param declinationConditional A list of conditional branches to evaluate after the intent is declined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty declinationConditional) {
                this.declinationConditional = declinationConditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationNextStep}
             * @param declinationNextStep Specifies the next step that the bot executes when the customer declines the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationNextStep(software.amazon.awscdk.IResolvable declinationNextStep) {
                this.declinationNextStep = declinationNextStep;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationNextStep}
             * @param declinationNextStep Specifies the next step that the bot executes when the customer declines the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty declinationNextStep) {
                this.declinationNextStep = declinationNextStep;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationResponse}
             * @param declinationResponse When the user answers "no" to the question defined in <code>promptSpecification</code> , Amazon Lex responds with this response to acknowledge that the intent was canceled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationResponse(software.amazon.awscdk.IResolvable declinationResponse) {
                this.declinationResponse = declinationResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationResponse}
             * @param declinationResponse When the user answers "no" to the question defined in <code>promptSpecification</code> , Amazon Lex responds with this response to acknowledge that the intent was canceled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty declinationResponse) {
                this.declinationResponse = declinationResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getElicitationCodeHook}
             * @param elicitationCodeHook The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation prompt retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elicitationCodeHook(software.amazon.awscdk.IResolvable elicitationCodeHook) {
                this.elicitationCodeHook = elicitationCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getElicitationCodeHook}
             * @param elicitationCodeHook The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation prompt retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elicitationCodeHook(software.amazon.awscdk.services.lex.CfnBot.ElicitationCodeHookInvocationSettingProperty elicitationCodeHook) {
                this.elicitationCodeHook = elicitationCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getFailureConditional}
             * @param failureConditional Provides a list of conditional branches.
             *                           Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.IResolvable failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getFailureConditional}
             * @param failureConditional Provides a list of conditional branches.
             *                           Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getFailureNextStep}
             * @param failureNextStep The next step to take in the conversation if the confirmation step fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.IResolvable failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getFailureNextStep}
             * @param failureNextStep The next step to take in the conversation if the confirmation step fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input when the intent confirmation fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.IResolvable failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input when the intent confirmation fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getIsActive}
             * @param isActive Specifies whether the intent's confirmation is sent to the user.
             *                 When this field is false, confirmation and declination responses aren't sent. If the <code>IsActive</code> field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getIsActive}
             * @param isActive Specifies whether the intent's confirmation is sent to the user.
             *                 When this field is false, confirmation and declination responses aren't sent. If the <code>IsActive</code> field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntentConfirmationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntentConfirmationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntentConfirmationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntentConfirmationSettingProperty {
            private final java.lang.Object promptSpecification;
            private final java.lang.Object codeHook;
            private final java.lang.Object confirmationConditional;
            private final java.lang.Object confirmationNextStep;
            private final java.lang.Object confirmationResponse;
            private final java.lang.Object declinationConditional;
            private final java.lang.Object declinationNextStep;
            private final java.lang.Object declinationResponse;
            private final java.lang.Object elicitationCodeHook;
            private final java.lang.Object failureConditional;
            private final java.lang.Object failureNextStep;
            private final java.lang.Object failureResponse;
            private final java.lang.Object isActive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.promptSpecification = software.amazon.jsii.Kernel.get(this, "promptSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeHook = software.amazon.jsii.Kernel.get(this, "codeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.confirmationConditional = software.amazon.jsii.Kernel.get(this, "confirmationConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.confirmationNextStep = software.amazon.jsii.Kernel.get(this, "confirmationNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.confirmationResponse = software.amazon.jsii.Kernel.get(this, "confirmationResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.declinationConditional = software.amazon.jsii.Kernel.get(this, "declinationConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.declinationNextStep = software.amazon.jsii.Kernel.get(this, "declinationNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.declinationResponse = software.amazon.jsii.Kernel.get(this, "declinationResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elicitationCodeHook = software.amazon.jsii.Kernel.get(this, "elicitationCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureConditional = software.amazon.jsii.Kernel.get(this, "failureConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureNextStep = software.amazon.jsii.Kernel.get(this, "failureNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureResponse = software.amazon.jsii.Kernel.get(this, "failureResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.promptSpecification = java.util.Objects.requireNonNull(builder.promptSpecification, "promptSpecification is required");
                this.codeHook = builder.codeHook;
                this.confirmationConditional = builder.confirmationConditional;
                this.confirmationNextStep = builder.confirmationNextStep;
                this.confirmationResponse = builder.confirmationResponse;
                this.declinationConditional = builder.declinationConditional;
                this.declinationNextStep = builder.declinationNextStep;
                this.declinationResponse = builder.declinationResponse;
                this.elicitationCodeHook = builder.elicitationCodeHook;
                this.failureConditional = builder.failureConditional;
                this.failureNextStep = builder.failureNextStep;
                this.failureResponse = builder.failureResponse;
                this.isActive = builder.isActive;
            }

            @Override
            public final java.lang.Object getPromptSpecification() {
                return this.promptSpecification;
            }

            @Override
            public final java.lang.Object getCodeHook() {
                return this.codeHook;
            }

            @Override
            public final java.lang.Object getConfirmationConditional() {
                return this.confirmationConditional;
            }

            @Override
            public final java.lang.Object getConfirmationNextStep() {
                return this.confirmationNextStep;
            }

            @Override
            public final java.lang.Object getConfirmationResponse() {
                return this.confirmationResponse;
            }

            @Override
            public final java.lang.Object getDeclinationConditional() {
                return this.declinationConditional;
            }

            @Override
            public final java.lang.Object getDeclinationNextStep() {
                return this.declinationNextStep;
            }

            @Override
            public final java.lang.Object getDeclinationResponse() {
                return this.declinationResponse;
            }

            @Override
            public final java.lang.Object getElicitationCodeHook() {
                return this.elicitationCodeHook;
            }

            @Override
            public final java.lang.Object getFailureConditional() {
                return this.failureConditional;
            }

            @Override
            public final java.lang.Object getFailureNextStep() {
                return this.failureNextStep;
            }

            @Override
            public final java.lang.Object getFailureResponse() {
                return this.failureResponse;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("promptSpecification", om.valueToTree(this.getPromptSpecification()));
                if (this.getCodeHook() != null) {
                    data.set("codeHook", om.valueToTree(this.getCodeHook()));
                }
                if (this.getConfirmationConditional() != null) {
                    data.set("confirmationConditional", om.valueToTree(this.getConfirmationConditional()));
                }
                if (this.getConfirmationNextStep() != null) {
                    data.set("confirmationNextStep", om.valueToTree(this.getConfirmationNextStep()));
                }
                if (this.getConfirmationResponse() != null) {
                    data.set("confirmationResponse", om.valueToTree(this.getConfirmationResponse()));
                }
                if (this.getDeclinationConditional() != null) {
                    data.set("declinationConditional", om.valueToTree(this.getDeclinationConditional()));
                }
                if (this.getDeclinationNextStep() != null) {
                    data.set("declinationNextStep", om.valueToTree(this.getDeclinationNextStep()));
                }
                if (this.getDeclinationResponse() != null) {
                    data.set("declinationResponse", om.valueToTree(this.getDeclinationResponse()));
                }
                if (this.getElicitationCodeHook() != null) {
                    data.set("elicitationCodeHook", om.valueToTree(this.getElicitationCodeHook()));
                }
                if (this.getFailureConditional() != null) {
                    data.set("failureConditional", om.valueToTree(this.getFailureConditional()));
                }
                if (this.getFailureNextStep() != null) {
                    data.set("failureNextStep", om.valueToTree(this.getFailureNextStep()));
                }
                if (this.getFailureResponse() != null) {
                    data.set("failureResponse", om.valueToTree(this.getFailureResponse()));
                }
                if (this.getIsActive() != null) {
                    data.set("isActive", om.valueToTree(this.getIsActive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.IntentConfirmationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntentConfirmationSettingProperty.Jsii$Proxy that = (IntentConfirmationSettingProperty.Jsii$Proxy) o;

                if (!promptSpecification.equals(that.promptSpecification)) return false;
                if (this.codeHook != null ? !this.codeHook.equals(that.codeHook) : that.codeHook != null) return false;
                if (this.confirmationConditional != null ? !this.confirmationConditional.equals(that.confirmationConditional) : that.confirmationConditional != null) return false;
                if (this.confirmationNextStep != null ? !this.confirmationNextStep.equals(that.confirmationNextStep) : that.confirmationNextStep != null) return false;
                if (this.confirmationResponse != null ? !this.confirmationResponse.equals(that.confirmationResponse) : that.confirmationResponse != null) return false;
                if (this.declinationConditional != null ? !this.declinationConditional.equals(that.declinationConditional) : that.declinationConditional != null) return false;
                if (this.declinationNextStep != null ? !this.declinationNextStep.equals(that.declinationNextStep) : that.declinationNextStep != null) return false;
                if (this.declinationResponse != null ? !this.declinationResponse.equals(that.declinationResponse) : that.declinationResponse != null) return false;
                if (this.elicitationCodeHook != null ? !this.elicitationCodeHook.equals(that.elicitationCodeHook) : that.elicitationCodeHook != null) return false;
                if (this.failureConditional != null ? !this.failureConditional.equals(that.failureConditional) : that.failureConditional != null) return false;
                if (this.failureNextStep != null ? !this.failureNextStep.equals(that.failureNextStep) : that.failureNextStep != null) return false;
                if (this.failureResponse != null ? !this.failureResponse.equals(that.failureResponse) : that.failureResponse != null) return false;
                return this.isActive != null ? this.isActive.equals(that.isActive) : that.isActive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.promptSpecification.hashCode();
                result = 31 * result + (this.codeHook != null ? this.codeHook.hashCode() : 0);
                result = 31 * result + (this.confirmationConditional != null ? this.confirmationConditional.hashCode() : 0);
                result = 31 * result + (this.confirmationNextStep != null ? this.confirmationNextStep.hashCode() : 0);
                result = 31 * result + (this.confirmationResponse != null ? this.confirmationResponse.hashCode() : 0);
                result = 31 * result + (this.declinationConditional != null ? this.declinationConditional.hashCode() : 0);
                result = 31 * result + (this.declinationNextStep != null ? this.declinationNextStep.hashCode() : 0);
                result = 31 * result + (this.declinationResponse != null ? this.declinationResponse.hashCode() : 0);
                result = 31 * result + (this.elicitationCodeHook != null ? this.elicitationCodeHook.hashCode() : 0);
                result = 31 * result + (this.failureConditional != null ? this.failureConditional.hashCode() : 0);
                result = 31 * result + (this.failureNextStep != null ? this.failureNextStep.hashCode() : 0);
                result = 31 * result + (this.failureResponse != null ? this.failureResponse.hashCode() : 0);
                result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Override settings to configure the intent state.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * IntentOverrideProperty intentOverrideProperty = IntentOverrideProperty.builder()
     *         .name("name")
     *         .slots(List.of(SlotValueOverrideMapProperty.builder()
     *                 .slotName("slotName")
     *                 .slotValueOverride(SlotValueOverrideProperty.builder()
     *                         .shape("shape")
     *                         .value(SlotValueProperty.builder()
     *                                 .interpretedValue("interpretedValue")
     *                                 .build())
     *                         .values(List.of(slotValueOverrideProperty_))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.IntentOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(IntentOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntentOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the intent.
         * <p>
         * Only required when you're switching intents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentoverride.html#cfn-lex-bot-intentoverride-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentoverride.html#cfn-lex-bot-intentoverride-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A map of all of the slot value overrides for the intent.
         * <p>
         * The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentoverride.html#cfn-lex-bot-intentoverride-slots">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intentoverride.html#cfn-lex-bot-intentoverride-slots</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlots() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntentOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntentOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntentOverrideProperty> {
            java.lang.String name;
            java.lang.Object slots;

            /**
             * Sets the value of {@link IntentOverrideProperty#getName}
             * @param name The name of the intent.
             *             Only required when you're switching intents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link IntentOverrideProperty#getSlots}
             * @param slots A map of all of the slot value overrides for the intent.
             *              The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slots(software.amazon.awscdk.IResolvable slots) {
                this.slots = slots;
                return this;
            }

            /**
             * Sets the value of {@link IntentOverrideProperty#getSlots}
             * @param slots A map of all of the slot value overrides for the intent.
             *              The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slots(java.util.List<? extends java.lang.Object> slots) {
                this.slots = slots;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntentOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntentOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntentOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntentOverrideProperty {
            private final java.lang.String name;
            private final java.lang.Object slots;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slots = software.amazon.jsii.Kernel.get(this, "slots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.slots = builder.slots;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSlots() {
                return this.slots;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSlots() != null) {
                    data.set("slots", om.valueToTree(this.getSlots()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.IntentOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntentOverrideProperty.Jsii$Proxy that = (IntentOverrideProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.slots != null ? this.slots.equals(that.slots) : that.slots == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.slots != null ? this.slots.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents an action that the user wants to perform.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.IntentProperty")
    @software.amazon.jsii.Jsii.Proxy(IntentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the intent.
         * <p>
         * Intent names must be unique within the locale that contains the intent and can't match the name of any built-in intent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A description of the intent.
         * <p>
         * Use the description to help identify the intent in lists.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Specifies that Amazon Lex invokes the alias Lambda function for each user input.
         * <p>
         * You can invoke this Lambda function to personalize user interaction.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-dialogcodehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-dialogcodehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDialogCodeHook() {
            return null;
        }

        /**
         * Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment.
         * <p>
         * You can invoke this function to complete the bot's transaction with the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-fulfillmentcodehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-fulfillmentcodehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFulfillmentCodeHook() {
            return null;
        }

        /**
         * Configuration setting for a response sent to the user before Amazon Lex starts eliciting slots.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-initialresponsesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-initialresponsesetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInitialResponseSetting() {
            return null;
        }

        /**
         * A list of contexts that must be active for this intent to be considered by Amazon Lex .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-inputcontexts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-inputcontexts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputContexts() {
            return null;
        }

        /**
         * Sets the response that Amazon Lex sends to the user when the intent is closed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-intentclosingsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-intentclosingsetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntentClosingSetting() {
            return null;
        }

        /**
         * Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent.
         * <p>
         * If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-intentconfirmationsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-intentconfirmationsetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntentConfirmationSetting() {
            return null;
        }

        /**
         * Provides configuration information for the <code>AMAZON.KendraSearchIntent</code> intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user's utterance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-kendraconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-kendraconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKendraConfiguration() {
            return null;
        }

        /**
         * A list of contexts that the intent activates when it is fulfilled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-outputcontexts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-outputcontexts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputContexts() {
            return null;
        }

        /**
         * A unique identifier for the built-in intent to base this intent on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-parentintentsignature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-parentintentsignature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParentIntentSignature() {
            return null;
        }

        /**
         * A list of utterances that a user might say to signal the intent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-sampleutterances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-sampleutterances</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSampleUtterances() {
            return null;
        }

        /**
         * Indicates the priority for slots.
         * <p>
         * Amazon Lex prompts the user for slot values in priority order.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-slotpriorities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-slotpriorities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotPriorities() {
            return null;
        }

        /**
         * A list of slots that the intent requires for fulfillment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-slots">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-intent.html#cfn-lex-bot-intent-slots</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlots() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntentProperty> {
            java.lang.String name;
            java.lang.String description;
            java.lang.Object dialogCodeHook;
            java.lang.Object fulfillmentCodeHook;
            java.lang.Object initialResponseSetting;
            java.lang.Object inputContexts;
            java.lang.Object intentClosingSetting;
            java.lang.Object intentConfirmationSetting;
            java.lang.Object kendraConfiguration;
            java.lang.Object outputContexts;
            java.lang.String parentIntentSignature;
            java.lang.Object sampleUtterances;
            java.lang.Object slotPriorities;
            java.lang.Object slots;

            /**
             * Sets the value of {@link IntentProperty#getName}
             * @param name The name of the intent. This parameter is required.
             *             Intent names must be unique within the locale that contains the intent and can't match the name of any built-in intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getDescription}
             * @param description A description of the intent.
             *                    Use the description to help identify the intent in lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getDialogCodeHook}
             * @param dialogCodeHook Specifies that Amazon Lex invokes the alias Lambda function for each user input.
             *                       You can invoke this Lambda function to personalize user interaction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialogCodeHook(software.amazon.awscdk.IResolvable dialogCodeHook) {
                this.dialogCodeHook = dialogCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getDialogCodeHook}
             * @param dialogCodeHook Specifies that Amazon Lex invokes the alias Lambda function for each user input.
             *                       You can invoke this Lambda function to personalize user interaction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialogCodeHook(software.amazon.awscdk.services.lex.CfnBot.DialogCodeHookSettingProperty dialogCodeHook) {
                this.dialogCodeHook = dialogCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getFulfillmentCodeHook}
             * @param fulfillmentCodeHook Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment.
             *                            You can invoke this function to complete the bot's transaction with the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentCodeHook(software.amazon.awscdk.IResolvable fulfillmentCodeHook) {
                this.fulfillmentCodeHook = fulfillmentCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getFulfillmentCodeHook}
             * @param fulfillmentCodeHook Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment.
             *                            You can invoke this function to complete the bot's transaction with the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentCodeHook(software.amazon.awscdk.services.lex.CfnBot.FulfillmentCodeHookSettingProperty fulfillmentCodeHook) {
                this.fulfillmentCodeHook = fulfillmentCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getInitialResponseSetting}
             * @param initialResponseSetting Configuration setting for a response sent to the user before Amazon Lex starts eliciting slots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialResponseSetting(software.amazon.awscdk.IResolvable initialResponseSetting) {
                this.initialResponseSetting = initialResponseSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getInitialResponseSetting}
             * @param initialResponseSetting Configuration setting for a response sent to the user before Amazon Lex starts eliciting slots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialResponseSetting(software.amazon.awscdk.services.lex.CfnBot.InitialResponseSettingProperty initialResponseSetting) {
                this.initialResponseSetting = initialResponseSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getInputContexts}
             * @param inputContexts A list of contexts that must be active for this intent to be considered by Amazon Lex .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputContexts(software.amazon.awscdk.IResolvable inputContexts) {
                this.inputContexts = inputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getInputContexts}
             * @param inputContexts A list of contexts that must be active for this intent to be considered by Amazon Lex .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputContexts(java.util.List<? extends java.lang.Object> inputContexts) {
                this.inputContexts = inputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentClosingSetting}
             * @param intentClosingSetting Sets the response that Amazon Lex sends to the user when the intent is closed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentClosingSetting(software.amazon.awscdk.IResolvable intentClosingSetting) {
                this.intentClosingSetting = intentClosingSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentClosingSetting}
             * @param intentClosingSetting Sets the response that Amazon Lex sends to the user when the intent is closed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentClosingSetting(software.amazon.awscdk.services.lex.CfnBot.IntentClosingSettingProperty intentClosingSetting) {
                this.intentClosingSetting = intentClosingSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentConfirmationSetting}
             * @param intentConfirmationSetting Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent.
             *                                  If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentConfirmationSetting(software.amazon.awscdk.IResolvable intentConfirmationSetting) {
                this.intentConfirmationSetting = intentConfirmationSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentConfirmationSetting}
             * @param intentConfirmationSetting Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent.
             *                                  If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentConfirmationSetting(software.amazon.awscdk.services.lex.CfnBot.IntentConfirmationSettingProperty intentConfirmationSetting) {
                this.intentConfirmationSetting = intentConfirmationSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getKendraConfiguration}
             * @param kendraConfiguration Provides configuration information for the <code>AMAZON.KendraSearchIntent</code> intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user's utterance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraConfiguration(software.amazon.awscdk.IResolvable kendraConfiguration) {
                this.kendraConfiguration = kendraConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getKendraConfiguration}
             * @param kendraConfiguration Provides configuration information for the <code>AMAZON.KendraSearchIntent</code> intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user's utterance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraConfiguration(software.amazon.awscdk.services.lex.CfnBot.KendraConfigurationProperty kendraConfiguration) {
                this.kendraConfiguration = kendraConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getOutputContexts}
             * @param outputContexts A list of contexts that the intent activates when it is fulfilled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputContexts(software.amazon.awscdk.IResolvable outputContexts) {
                this.outputContexts = outputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getOutputContexts}
             * @param outputContexts A list of contexts that the intent activates when it is fulfilled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputContexts(java.util.List<? extends java.lang.Object> outputContexts) {
                this.outputContexts = outputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getParentIntentSignature}
             * @param parentIntentSignature A unique identifier for the built-in intent to base this intent on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentIntentSignature(java.lang.String parentIntentSignature) {
                this.parentIntentSignature = parentIntentSignature;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSampleUtterances}
             * @param sampleUtterances A list of utterances that a user might say to signal the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(software.amazon.awscdk.IResolvable sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSampleUtterances}
             * @param sampleUtterances A list of utterances that a user might say to signal the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(java.util.List<? extends java.lang.Object> sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlotPriorities}
             * @param slotPriorities Indicates the priority for slots.
             *                       Amazon Lex prompts the user for slot values in priority order.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotPriorities(software.amazon.awscdk.IResolvable slotPriorities) {
                this.slotPriorities = slotPriorities;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlotPriorities}
             * @param slotPriorities Indicates the priority for slots.
             *                       Amazon Lex prompts the user for slot values in priority order.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotPriorities(java.util.List<? extends java.lang.Object> slotPriorities) {
                this.slotPriorities = slotPriorities;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlots}
             * @param slots A list of slots that the intent requires for fulfillment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slots(software.amazon.awscdk.IResolvable slots) {
                this.slots = slots;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlots}
             * @param slots A list of slots that the intent requires for fulfillment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slots(java.util.List<? extends java.lang.Object> slots) {
                this.slots = slots;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntentProperty {
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object dialogCodeHook;
            private final java.lang.Object fulfillmentCodeHook;
            private final java.lang.Object initialResponseSetting;
            private final java.lang.Object inputContexts;
            private final java.lang.Object intentClosingSetting;
            private final java.lang.Object intentConfirmationSetting;
            private final java.lang.Object kendraConfiguration;
            private final java.lang.Object outputContexts;
            private final java.lang.String parentIntentSignature;
            private final java.lang.Object sampleUtterances;
            private final java.lang.Object slotPriorities;
            private final java.lang.Object slots;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dialogCodeHook = software.amazon.jsii.Kernel.get(this, "dialogCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fulfillmentCodeHook = software.amazon.jsii.Kernel.get(this, "fulfillmentCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.initialResponseSetting = software.amazon.jsii.Kernel.get(this, "initialResponseSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputContexts = software.amazon.jsii.Kernel.get(this, "inputContexts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intentClosingSetting = software.amazon.jsii.Kernel.get(this, "intentClosingSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intentConfirmationSetting = software.amazon.jsii.Kernel.get(this, "intentConfirmationSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kendraConfiguration = software.amazon.jsii.Kernel.get(this, "kendraConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputContexts = software.amazon.jsii.Kernel.get(this, "outputContexts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parentIntentSignature = software.amazon.jsii.Kernel.get(this, "parentIntentSignature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleUtterances = software.amazon.jsii.Kernel.get(this, "sampleUtterances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slotPriorities = software.amazon.jsii.Kernel.get(this, "slotPriorities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slots = software.amazon.jsii.Kernel.get(this, "slots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.dialogCodeHook = builder.dialogCodeHook;
                this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
                this.initialResponseSetting = builder.initialResponseSetting;
                this.inputContexts = builder.inputContexts;
                this.intentClosingSetting = builder.intentClosingSetting;
                this.intentConfirmationSetting = builder.intentConfirmationSetting;
                this.kendraConfiguration = builder.kendraConfiguration;
                this.outputContexts = builder.outputContexts;
                this.parentIntentSignature = builder.parentIntentSignature;
                this.sampleUtterances = builder.sampleUtterances;
                this.slotPriorities = builder.slotPriorities;
                this.slots = builder.slots;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getDialogCodeHook() {
                return this.dialogCodeHook;
            }

            @Override
            public final java.lang.Object getFulfillmentCodeHook() {
                return this.fulfillmentCodeHook;
            }

            @Override
            public final java.lang.Object getInitialResponseSetting() {
                return this.initialResponseSetting;
            }

            @Override
            public final java.lang.Object getInputContexts() {
                return this.inputContexts;
            }

            @Override
            public final java.lang.Object getIntentClosingSetting() {
                return this.intentClosingSetting;
            }

            @Override
            public final java.lang.Object getIntentConfirmationSetting() {
                return this.intentConfirmationSetting;
            }

            @Override
            public final java.lang.Object getKendraConfiguration() {
                return this.kendraConfiguration;
            }

            @Override
            public final java.lang.Object getOutputContexts() {
                return this.outputContexts;
            }

            @Override
            public final java.lang.String getParentIntentSignature() {
                return this.parentIntentSignature;
            }

            @Override
            public final java.lang.Object getSampleUtterances() {
                return this.sampleUtterances;
            }

            @Override
            public final java.lang.Object getSlotPriorities() {
                return this.slotPriorities;
            }

            @Override
            public final java.lang.Object getSlots() {
                return this.slots;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDialogCodeHook() != null) {
                    data.set("dialogCodeHook", om.valueToTree(this.getDialogCodeHook()));
                }
                if (this.getFulfillmentCodeHook() != null) {
                    data.set("fulfillmentCodeHook", om.valueToTree(this.getFulfillmentCodeHook()));
                }
                if (this.getInitialResponseSetting() != null) {
                    data.set("initialResponseSetting", om.valueToTree(this.getInitialResponseSetting()));
                }
                if (this.getInputContexts() != null) {
                    data.set("inputContexts", om.valueToTree(this.getInputContexts()));
                }
                if (this.getIntentClosingSetting() != null) {
                    data.set("intentClosingSetting", om.valueToTree(this.getIntentClosingSetting()));
                }
                if (this.getIntentConfirmationSetting() != null) {
                    data.set("intentConfirmationSetting", om.valueToTree(this.getIntentConfirmationSetting()));
                }
                if (this.getKendraConfiguration() != null) {
                    data.set("kendraConfiguration", om.valueToTree(this.getKendraConfiguration()));
                }
                if (this.getOutputContexts() != null) {
                    data.set("outputContexts", om.valueToTree(this.getOutputContexts()));
                }
                if (this.getParentIntentSignature() != null) {
                    data.set("parentIntentSignature", om.valueToTree(this.getParentIntentSignature()));
                }
                if (this.getSampleUtterances() != null) {
                    data.set("sampleUtterances", om.valueToTree(this.getSampleUtterances()));
                }
                if (this.getSlotPriorities() != null) {
                    data.set("slotPriorities", om.valueToTree(this.getSlotPriorities()));
                }
                if (this.getSlots() != null) {
                    data.set("slots", om.valueToTree(this.getSlots()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.IntentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntentProperty.Jsii$Proxy that = (IntentProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.dialogCodeHook != null ? !this.dialogCodeHook.equals(that.dialogCodeHook) : that.dialogCodeHook != null) return false;
                if (this.fulfillmentCodeHook != null ? !this.fulfillmentCodeHook.equals(that.fulfillmentCodeHook) : that.fulfillmentCodeHook != null) return false;
                if (this.initialResponseSetting != null ? !this.initialResponseSetting.equals(that.initialResponseSetting) : that.initialResponseSetting != null) return false;
                if (this.inputContexts != null ? !this.inputContexts.equals(that.inputContexts) : that.inputContexts != null) return false;
                if (this.intentClosingSetting != null ? !this.intentClosingSetting.equals(that.intentClosingSetting) : that.intentClosingSetting != null) return false;
                if (this.intentConfirmationSetting != null ? !this.intentConfirmationSetting.equals(that.intentConfirmationSetting) : that.intentConfirmationSetting != null) return false;
                if (this.kendraConfiguration != null ? !this.kendraConfiguration.equals(that.kendraConfiguration) : that.kendraConfiguration != null) return false;
                if (this.outputContexts != null ? !this.outputContexts.equals(that.outputContexts) : that.outputContexts != null) return false;
                if (this.parentIntentSignature != null ? !this.parentIntentSignature.equals(that.parentIntentSignature) : that.parentIntentSignature != null) return false;
                if (this.sampleUtterances != null ? !this.sampleUtterances.equals(that.sampleUtterances) : that.sampleUtterances != null) return false;
                if (this.slotPriorities != null ? !this.slotPriorities.equals(that.slotPriorities) : that.slotPriorities != null) return false;
                return this.slots != null ? this.slots.equals(that.slots) : that.slots == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.dialogCodeHook != null ? this.dialogCodeHook.hashCode() : 0);
                result = 31 * result + (this.fulfillmentCodeHook != null ? this.fulfillmentCodeHook.hashCode() : 0);
                result = 31 * result + (this.initialResponseSetting != null ? this.initialResponseSetting.hashCode() : 0);
                result = 31 * result + (this.inputContexts != null ? this.inputContexts.hashCode() : 0);
                result = 31 * result + (this.intentClosingSetting != null ? this.intentClosingSetting.hashCode() : 0);
                result = 31 * result + (this.intentConfirmationSetting != null ? this.intentConfirmationSetting.hashCode() : 0);
                result = 31 * result + (this.kendraConfiguration != null ? this.kendraConfiguration.hashCode() : 0);
                result = 31 * result + (this.outputContexts != null ? this.outputContexts.hashCode() : 0);
                result = 31 * result + (this.parentIntentSignature != null ? this.parentIntentSignature.hashCode() : 0);
                result = 31 * result + (this.sampleUtterances != null ? this.sampleUtterances.hashCode() : 0);
                result = 31 * result + (this.slotPriorities != null ? this.slotPriorities.hashCode() : 0);
                result = 31 * result + (this.slots != null ? this.slots.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides configuration information for the <code>AMAZON.KendraSearchIntent</code> intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user's utterance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * KendraConfigurationProperty kendraConfigurationProperty = KendraConfigurationProperty.builder()
     *         .kendraIndex("kendraIndex")
     *         // the properties below are optional
     *         .queryFilterString("queryFilterString")
     *         .queryFilterStringEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.KendraConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KendraConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KendraConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the <code>AMAZON.KendraSearchIntent</code> intent to search. The index must be in the same account and Region as the Amazon Lex bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html#cfn-lex-bot-kendraconfiguration-kendraindex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html#cfn-lex-bot-kendraconfiguration-kendraindex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKendraIndex();

        /**
         * A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query.
         * <p>
         * The filter is in the format defined by Amazon Kendra. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html#cfn-lex-bot-kendraconfiguration-queryfilterstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html#cfn-lex-bot-kendraconfiguration-queryfilterstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQueryFilterString() {
            return null;
        }

        /**
         * Determines whether the <code>AMAZON.KendraSearchIntent</code> intent uses a custom query string to query the Amazon Kendra index.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html#cfn-lex-bot-kendraconfiguration-queryfilterstringenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-kendraconfiguration.html#cfn-lex-bot-kendraconfiguration-queryfilterstringenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryFilterStringEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KendraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KendraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KendraConfigurationProperty> {
            java.lang.String kendraIndex;
            java.lang.String queryFilterString;
            java.lang.Object queryFilterStringEnabled;

            /**
             * Sets the value of {@link KendraConfigurationProperty#getKendraIndex}
             * @param kendraIndex The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the <code>AMAZON.KendraSearchIntent</code> intent to search. The index must be in the same account and Region as the Amazon Lex bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraIndex(java.lang.String kendraIndex) {
                this.kendraIndex = kendraIndex;
                return this;
            }

            /**
             * Sets the value of {@link KendraConfigurationProperty#getQueryFilterString}
             * @param queryFilterString A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query.
             *                          The filter is in the format defined by Amazon Kendra. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryFilterString(java.lang.String queryFilterString) {
                this.queryFilterString = queryFilterString;
                return this;
            }

            /**
             * Sets the value of {@link KendraConfigurationProperty#getQueryFilterStringEnabled}
             * @param queryFilterStringEnabled Determines whether the <code>AMAZON.KendraSearchIntent</code> intent uses a custom query string to query the Amazon Kendra index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryFilterStringEnabled(java.lang.Boolean queryFilterStringEnabled) {
                this.queryFilterStringEnabled = queryFilterStringEnabled;
                return this;
            }

            /**
             * Sets the value of {@link KendraConfigurationProperty#getQueryFilterStringEnabled}
             * @param queryFilterStringEnabled Determines whether the <code>AMAZON.KendraSearchIntent</code> intent uses a custom query string to query the Amazon Kendra index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryFilterStringEnabled(software.amazon.awscdk.IResolvable queryFilterStringEnabled) {
                this.queryFilterStringEnabled = queryFilterStringEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KendraConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KendraConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KendraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KendraConfigurationProperty {
            private final java.lang.String kendraIndex;
            private final java.lang.String queryFilterString;
            private final java.lang.Object queryFilterStringEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kendraIndex = software.amazon.jsii.Kernel.get(this, "kendraIndex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryFilterString = software.amazon.jsii.Kernel.get(this, "queryFilterString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryFilterStringEnabled = software.amazon.jsii.Kernel.get(this, "queryFilterStringEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kendraIndex = java.util.Objects.requireNonNull(builder.kendraIndex, "kendraIndex is required");
                this.queryFilterString = builder.queryFilterString;
                this.queryFilterStringEnabled = builder.queryFilterStringEnabled;
            }

            @Override
            public final java.lang.String getKendraIndex() {
                return this.kendraIndex;
            }

            @Override
            public final java.lang.String getQueryFilterString() {
                return this.queryFilterString;
            }

            @Override
            public final java.lang.Object getQueryFilterStringEnabled() {
                return this.queryFilterStringEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kendraIndex", om.valueToTree(this.getKendraIndex()));
                if (this.getQueryFilterString() != null) {
                    data.set("queryFilterString", om.valueToTree(this.getQueryFilterString()));
                }
                if (this.getQueryFilterStringEnabled() != null) {
                    data.set("queryFilterStringEnabled", om.valueToTree(this.getQueryFilterStringEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.KendraConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KendraConfigurationProperty.Jsii$Proxy that = (KendraConfigurationProperty.Jsii$Proxy) o;

                if (!kendraIndex.equals(that.kendraIndex)) return false;
                if (this.queryFilterString != null ? !this.queryFilterString.equals(that.queryFilterString) : that.queryFilterString != null) return false;
                return this.queryFilterStringEnabled != null ? this.queryFilterStringEnabled.equals(that.queryFilterStringEnabled) : that.queryFilterStringEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kendraIndex.hashCode();
                result = 31 * result + (this.queryFilterString != null ? this.queryFilterString.hashCode() : 0);
                result = 31 * result + (this.queryFilterStringEnabled != null ? this.queryFilterStringEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * LambdaCodeHookProperty lambdaCodeHookProperty = LambdaCodeHookProperty.builder()
     *         .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *         .lambdaArn("lambdaArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-lambdacodehook.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-lambdacodehook.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.LambdaCodeHookProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaCodeHookProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaCodeHookProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-lambdacodehook.html#cfn-lex-bot-lambdacodehook-codehookinterfaceversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-lambdacodehook.html#cfn-lex-bot-lambdacodehook-codehookinterfaceversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCodeHookInterfaceVersion();

        /**
         * The Amazon Resource Name (ARN) of the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-lambdacodehook.html#cfn-lex-bot-lambdacodehook-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-lambdacodehook.html#cfn-lex-bot-lambdacodehook-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * @return a {@link Builder} of {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaCodeHookProperty> {
            java.lang.String codeHookInterfaceVersion;
            java.lang.String lambdaArn;

            /**
             * Sets the value of {@link LambdaCodeHookProperty#getCodeHookInterfaceVersion}
             * @param codeHookInterfaceVersion The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookInterfaceVersion(java.lang.String codeHookInterfaceVersion) {
                this.codeHookInterfaceVersion = codeHookInterfaceVersion;
                return this;
            }

            /**
             * Sets the value of {@link LambdaCodeHookProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of the Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaCodeHookProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaCodeHookProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaCodeHookProperty {
            private final java.lang.String codeHookInterfaceVersion;
            private final java.lang.String lambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeHookInterfaceVersion = software.amazon.jsii.Kernel.get(this, "codeHookInterfaceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeHookInterfaceVersion = java.util.Objects.requireNonNull(builder.codeHookInterfaceVersion, "codeHookInterfaceVersion is required");
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
            }

            @Override
            public final java.lang.String getCodeHookInterfaceVersion() {
                return this.codeHookInterfaceVersion;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("codeHookInterfaceVersion", om.valueToTree(this.getCodeHookInterfaceVersion()));
                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.LambdaCodeHookProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaCodeHookProperty.Jsii$Proxy that = (LambdaCodeHookProperty.Jsii$Proxy) o;

                if (!codeHookInterfaceVersion.equals(that.codeHookInterfaceVersion)) return false;
                return this.lambdaArn.equals(that.lambdaArn);
            }

            @Override
            public final int hashCode() {
                int result = this.codeHookInterfaceVersion.hashCode();
                result = 31 * result + (this.lambdaArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides one or more messages that Amazon Lex should send to the user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * MessageGroupProperty messageGroupProperty = MessageGroupProperty.builder()
     *         .message(MessageProperty.builder()
     *                 .customPayload(CustomPayloadProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                         .title("title")
     *                         // the properties below are optional
     *                         .buttons(List.of(ButtonProperty.builder()
     *                                 .text("text")
     *                                 .value("value")
     *                                 .build()))
     *                         .imageUrl("imageUrl")
     *                         .subtitle("subtitle")
     *                         .build())
     *                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .ssmlMessage(SSMLMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .variations(List.of(MessageProperty.builder()
     *                 .customPayload(CustomPayloadProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                         .title("title")
     *                         // the properties below are optional
     *                         .buttons(List.of(ButtonProperty.builder()
     *                                 .text("text")
     *                                 .value("value")
     *                                 .build()))
     *                         .imageUrl("imageUrl")
     *                         .subtitle("subtitle")
     *                         .build())
     *                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .ssmlMessage(SSMLMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-messagegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-messagegroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.MessageGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The primary message that Amazon Lex should send to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-messagegroup.html#cfn-lex-bot-messagegroup-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-messagegroup.html#cfn-lex-bot-messagegroup-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessage();

        /**
         * Message variations to send to the user.
         * <p>
         * When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-messagegroup.html#cfn-lex-bot-messagegroup-variations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-messagegroup.html#cfn-lex-bot-messagegroup-variations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageGroupProperty> {
            java.lang.Object message;
            java.lang.Object variations;

            /**
             * Sets the value of {@link MessageGroupProperty#getMessage}
             * @param message The primary message that Amazon Lex should send to the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(software.amazon.awscdk.IResolvable message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link MessageGroupProperty#getMessage}
             * @param message The primary message that Amazon Lex should send to the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(software.amazon.awscdk.services.lex.CfnBot.MessageProperty message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link MessageGroupProperty#getVariations}
             * @param variations Message variations to send to the user.
             *                   When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variations(software.amazon.awscdk.IResolvable variations) {
                this.variations = variations;
                return this;
            }

            /**
             * Sets the value of {@link MessageGroupProperty#getVariations}
             * @param variations Message variations to send to the user.
             *                   When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variations(java.util.List<? extends java.lang.Object> variations) {
                this.variations = variations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageGroupProperty {
            private final java.lang.Object message;
            private final java.lang.Object variations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variations = software.amazon.jsii.Kernel.get(this, "variations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
                this.variations = builder.variations;
            }

            @Override
            public final java.lang.Object getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.Object getVariations() {
                return this.variations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("message", om.valueToTree(this.getMessage()));
                if (this.getVariations() != null) {
                    data.set("variations", om.valueToTree(this.getVariations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.MessageGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageGroupProperty.Jsii$Proxy that = (MessageGroupProperty.Jsii$Proxy) o;

                if (!message.equals(that.message)) return false;
                return this.variations != null ? this.variations.equals(that.variations) : that.variations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message.hashCode();
                result = 31 * result + (this.variations != null ? this.variations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The object that provides message text and its type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * MessageProperty messageProperty = MessageProperty.builder()
     *         .customPayload(CustomPayloadProperty.builder()
     *                 .value("value")
     *                 .build())
     *         .imageResponseCard(ImageResponseCardProperty.builder()
     *                 .title("title")
     *                 // the properties below are optional
     *                 .buttons(List.of(ButtonProperty.builder()
     *                         .text("text")
     *                         .value("value")
     *                         .build()))
     *                 .imageUrl("imageUrl")
     *                 .subtitle("subtitle")
     *                 .build())
     *         .plainTextMessage(PlainTextMessageProperty.builder()
     *                 .value("value")
     *                 .build())
     *         .ssmlMessage(SSMLMessageProperty.builder()
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.MessageProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A message in a custom format defined by the client application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-custompayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-custompayload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPayload() {
            return null;
        }

        /**
         * A message that defines a response card that the client application can show to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-imageresponsecard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-imageresponsecard</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageResponseCard() {
            return null;
        }

        /**
         * A message in plain text format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-plaintextmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-plaintextmessage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlainTextMessage() {
            return null;
        }

        /**
         * A message in Speech Synthesis Markup Language (SSML).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-ssmlmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-message.html#cfn-lex-bot-message-ssmlmessage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSsmlMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageProperty> {
            java.lang.Object customPayload;
            java.lang.Object imageResponseCard;
            java.lang.Object plainTextMessage;
            java.lang.Object ssmlMessage;

            /**
             * Sets the value of {@link MessageProperty#getCustomPayload}
             * @param customPayload A message in a custom format defined by the client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPayload(software.amazon.awscdk.IResolvable customPayload) {
                this.customPayload = customPayload;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getCustomPayload}
             * @param customPayload A message in a custom format defined by the client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPayload(software.amazon.awscdk.services.lex.CfnBot.CustomPayloadProperty customPayload) {
                this.customPayload = customPayload;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getImageResponseCard}
             * @param imageResponseCard A message that defines a response card that the client application can show to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageResponseCard(software.amazon.awscdk.IResolvable imageResponseCard) {
                this.imageResponseCard = imageResponseCard;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getImageResponseCard}
             * @param imageResponseCard A message that defines a response card that the client application can show to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageResponseCard(software.amazon.awscdk.services.lex.CfnBot.ImageResponseCardProperty imageResponseCard) {
                this.imageResponseCard = imageResponseCard;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getPlainTextMessage}
             * @param plainTextMessage A message in plain text format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainTextMessage(software.amazon.awscdk.IResolvable plainTextMessage) {
                this.plainTextMessage = plainTextMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getPlainTextMessage}
             * @param plainTextMessage A message in plain text format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainTextMessage(software.amazon.awscdk.services.lex.CfnBot.PlainTextMessageProperty plainTextMessage) {
                this.plainTextMessage = plainTextMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getSsmlMessage}
             * @param ssmlMessage A message in Speech Synthesis Markup Language (SSML).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmlMessage(software.amazon.awscdk.IResolvable ssmlMessage) {
                this.ssmlMessage = ssmlMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getSsmlMessage}
             * @param ssmlMessage A message in Speech Synthesis Markup Language (SSML).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmlMessage(software.amazon.awscdk.services.lex.CfnBot.SSMLMessageProperty ssmlMessage) {
                this.ssmlMessage = ssmlMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageProperty {
            private final java.lang.Object customPayload;
            private final java.lang.Object imageResponseCard;
            private final java.lang.Object plainTextMessage;
            private final java.lang.Object ssmlMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customPayload = software.amazon.jsii.Kernel.get(this, "customPayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageResponseCard = software.amazon.jsii.Kernel.get(this, "imageResponseCard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.plainTextMessage = software.amazon.jsii.Kernel.get(this, "plainTextMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ssmlMessage = software.amazon.jsii.Kernel.get(this, "ssmlMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customPayload = builder.customPayload;
                this.imageResponseCard = builder.imageResponseCard;
                this.plainTextMessage = builder.plainTextMessage;
                this.ssmlMessage = builder.ssmlMessage;
            }

            @Override
            public final java.lang.Object getCustomPayload() {
                return this.customPayload;
            }

            @Override
            public final java.lang.Object getImageResponseCard() {
                return this.imageResponseCard;
            }

            @Override
            public final java.lang.Object getPlainTextMessage() {
                return this.plainTextMessage;
            }

            @Override
            public final java.lang.Object getSsmlMessage() {
                return this.ssmlMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomPayload() != null) {
                    data.set("customPayload", om.valueToTree(this.getCustomPayload()));
                }
                if (this.getImageResponseCard() != null) {
                    data.set("imageResponseCard", om.valueToTree(this.getImageResponseCard()));
                }
                if (this.getPlainTextMessage() != null) {
                    data.set("plainTextMessage", om.valueToTree(this.getPlainTextMessage()));
                }
                if (this.getSsmlMessage() != null) {
                    data.set("ssmlMessage", om.valueToTree(this.getSsmlMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.MessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageProperty.Jsii$Proxy that = (MessageProperty.Jsii$Proxy) o;

                if (this.customPayload != null ? !this.customPayload.equals(that.customPayload) : that.customPayload != null) return false;
                if (this.imageResponseCard != null ? !this.imageResponseCard.equals(that.imageResponseCard) : that.imageResponseCard != null) return false;
                if (this.plainTextMessage != null ? !this.plainTextMessage.equals(that.plainTextMessage) : that.plainTextMessage != null) return false;
                return this.ssmlMessage != null ? this.ssmlMessage.equals(that.ssmlMessage) : that.ssmlMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customPayload != null ? this.customPayload.hashCode() : 0;
                result = 31 * result + (this.imageResponseCard != null ? this.imageResponseCard.hashCode() : 0);
                result = 31 * result + (this.plainTextMessage != null ? this.plainTextMessage.hashCode() : 0);
                result = 31 * result + (this.ssmlMessage != null ? this.ssmlMessage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Indicates whether a slot can return multiple values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * MultipleValuesSettingProperty multipleValuesSettingProperty = MultipleValuesSettingProperty.builder()
     *         .allowMultipleValues(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-multiplevaluessetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-multiplevaluessetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.MultipleValuesSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(MultipleValuesSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultipleValuesSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a slot can return multiple values.
         * <p>
         * When <code>true</code> , the slot may return more than one value in a response. When <code>false</code> , the slot returns only a single value.
         * <p>
         * Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code> .
         * <p>
         * If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-multiplevaluessetting.html#cfn-lex-bot-multiplevaluessetting-allowmultiplevalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-multiplevaluessetting.html#cfn-lex-bot-multiplevaluessetting-allowmultiplevalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowMultipleValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultipleValuesSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultipleValuesSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultipleValuesSettingProperty> {
            java.lang.Object allowMultipleValues;

            /**
             * Sets the value of {@link MultipleValuesSettingProperty#getAllowMultipleValues}
             * @param allowMultipleValues Indicates whether a slot can return multiple values.
             *                            When <code>true</code> , the slot may return more than one value in a response. When <code>false</code> , the slot returns only a single value.
             *                            <p>
             *                            Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code> .
             *                            <p>
             *                            If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMultipleValues(java.lang.Boolean allowMultipleValues) {
                this.allowMultipleValues = allowMultipleValues;
                return this;
            }

            /**
             * Sets the value of {@link MultipleValuesSettingProperty#getAllowMultipleValues}
             * @param allowMultipleValues Indicates whether a slot can return multiple values.
             *                            When <code>true</code> , the slot may return more than one value in a response. When <code>false</code> , the slot returns only a single value.
             *                            <p>
             *                            Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code> .
             *                            <p>
             *                            If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMultipleValues(software.amazon.awscdk.IResolvable allowMultipleValues) {
                this.allowMultipleValues = allowMultipleValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultipleValuesSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultipleValuesSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultipleValuesSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultipleValuesSettingProperty {
            private final java.lang.Object allowMultipleValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowMultipleValues = software.amazon.jsii.Kernel.get(this, "allowMultipleValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowMultipleValues = builder.allowMultipleValues;
            }

            @Override
            public final java.lang.Object getAllowMultipleValues() {
                return this.allowMultipleValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowMultipleValues() != null) {
                    data.set("allowMultipleValues", om.valueToTree(this.getAllowMultipleValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.MultipleValuesSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultipleValuesSettingProperty.Jsii$Proxy that = (MultipleValuesSettingProperty.Jsii$Proxy) o;

                return this.allowMultipleValues != null ? this.allowMultipleValues.equals(that.allowMultipleValues) : that.allowMultipleValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowMultipleValues != null ? this.allowMultipleValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Determines whether Amazon Lex obscures slot values in conversation logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ObfuscationSettingProperty obfuscationSettingProperty = ObfuscationSettingProperty.builder()
     *         .obfuscationSettingType("obfuscationSettingType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-obfuscationsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-obfuscationsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ObfuscationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ObfuscationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObfuscationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Value that determines whether Amazon Lex obscures slot values in conversation logs.
         * <p>
         * The default is to obscure the values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-obfuscationsetting.html#cfn-lex-bot-obfuscationsetting-obfuscationsettingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-obfuscationsetting.html#cfn-lex-bot-obfuscationsetting-obfuscationsettingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObfuscationSettingType();

        /**
         * @return a {@link Builder} of {@link ObfuscationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObfuscationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObfuscationSettingProperty> {
            java.lang.String obfuscationSettingType;

            /**
             * Sets the value of {@link ObfuscationSettingProperty#getObfuscationSettingType}
             * @param obfuscationSettingType Value that determines whether Amazon Lex obscures slot values in conversation logs. This parameter is required.
             *                               The default is to obscure the values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obfuscationSettingType(java.lang.String obfuscationSettingType) {
                this.obfuscationSettingType = obfuscationSettingType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObfuscationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObfuscationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObfuscationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObfuscationSettingProperty {
            private final java.lang.String obfuscationSettingType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.obfuscationSettingType = software.amazon.jsii.Kernel.get(this, "obfuscationSettingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.obfuscationSettingType = java.util.Objects.requireNonNull(builder.obfuscationSettingType, "obfuscationSettingType is required");
            }

            @Override
            public final java.lang.String getObfuscationSettingType() {
                return this.obfuscationSettingType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("obfuscationSettingType", om.valueToTree(this.getObfuscationSettingType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ObfuscationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObfuscationSettingProperty.Jsii$Proxy that = (ObfuscationSettingProperty.Jsii$Proxy) o;

                return this.obfuscationSettingType.equals(that.obfuscationSettingType);
            }

            @Override
            public final int hashCode() {
                int result = this.obfuscationSettingType.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes a session context that is activated when an intent is fulfilled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * OutputContextProperty outputContextProperty = OutputContextProperty.builder()
     *         .name("name")
     *         .timeToLiveInSeconds(123)
     *         .turnsToLive(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.OutputContextProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the output context.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html#cfn-lex-bot-outputcontext-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html#cfn-lex-bot-outputcontext-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The amount of time, in seconds, that the output context should remain active.
         * <p>
         * The time is figured from the first time the context is sent to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html#cfn-lex-bot-outputcontext-timetoliveinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html#cfn-lex-bot-outputcontext-timetoliveinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeToLiveInSeconds();

        /**
         * The number of conversation turns that the output context should remain active.
         * <p>
         * The number of turns is counted from the first time that the context is sent to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html#cfn-lex-bot-outputcontext-turnstolive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-outputcontext.html#cfn-lex-bot-outputcontext-turnstolive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTurnsToLive();

        /**
         * @return a {@link Builder} of {@link OutputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputContextProperty> {
            java.lang.String name;
            java.lang.Number timeToLiveInSeconds;
            java.lang.Number turnsToLive;

            /**
             * Sets the value of {@link OutputContextProperty#getName}
             * @param name The name of the output context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OutputContextProperty#getTimeToLiveInSeconds}
             * @param timeToLiveInSeconds The amount of time, in seconds, that the output context should remain active. This parameter is required.
             *                            The time is figured from the first time the context is sent to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeToLiveInSeconds(java.lang.Number timeToLiveInSeconds) {
                this.timeToLiveInSeconds = timeToLiveInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link OutputContextProperty#getTurnsToLive}
             * @param turnsToLive The number of conversation turns that the output context should remain active. This parameter is required.
             *                    The number of turns is counted from the first time that the context is sent to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder turnsToLive(java.lang.Number turnsToLive) {
                this.turnsToLive = turnsToLive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputContextProperty {
            private final java.lang.String name;
            private final java.lang.Number timeToLiveInSeconds;
            private final java.lang.Number turnsToLive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeToLiveInSeconds = software.amazon.jsii.Kernel.get(this, "timeToLiveInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.turnsToLive = software.amazon.jsii.Kernel.get(this, "turnsToLive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.timeToLiveInSeconds = java.util.Objects.requireNonNull(builder.timeToLiveInSeconds, "timeToLiveInSeconds is required");
                this.turnsToLive = java.util.Objects.requireNonNull(builder.turnsToLive, "turnsToLive is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getTimeToLiveInSeconds() {
                return this.timeToLiveInSeconds;
            }

            @Override
            public final java.lang.Number getTurnsToLive() {
                return this.turnsToLive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("timeToLiveInSeconds", om.valueToTree(this.getTimeToLiveInSeconds()));
                data.set("turnsToLive", om.valueToTree(this.getTurnsToLive()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.OutputContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputContextProperty.Jsii$Proxy that = (OutputContextProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!timeToLiveInSeconds.equals(that.timeToLiveInSeconds)) return false;
                return this.turnsToLive.equals(that.turnsToLive);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.timeToLiveInSeconds.hashCode());
                result = 31 * result + (this.turnsToLive.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines an ASCII text message to send to the user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * PlainTextMessageProperty plainTextMessageProperty = PlainTextMessageProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-plaintextmessage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-plaintextmessage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PlainTextMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(PlainTextMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlainTextMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message to send to the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-plaintextmessage.html#cfn-lex-bot-plaintextmessage-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-plaintextmessage.html#cfn-lex-bot-plaintextmessage-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link PlainTextMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlainTextMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlainTextMessageProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link PlainTextMessageProperty#getValue}
             * @param value The message to send to the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlainTextMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlainTextMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlainTextMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlainTextMessageProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PlainTextMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlainTextMessageProperty.Jsii$Proxy that = (PlainTextMessageProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies next steps to run after the dialog code hook finishes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PostDialogCodeHookInvocationSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostDialogCodeHookInvocationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-failureconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-failureconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureConditional() {
            return null;
        }

        /**
         * Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-failurenextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-failurenextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input when the code hook fails.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-failureresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-failureresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureResponse() {
            return null;
        }

        /**
         * A list of conditional branches to evaluate after the dialog code hook finishes successfully.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-successconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-successconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessConditional() {
            return null;
        }

        /**
         * Specifics the next step the bot runs after the dialog code hook finishes successfully.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-successnextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-successnextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond when the code hook succeeds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-successresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-successresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessResponse() {
            return null;
        }

        /**
         * A list of conditional branches to evaluate if the code hook times out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-timeoutconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-timeoutconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutConditional() {
            return null;
        }

        /**
         * Specifies the next step that the bot runs when the code hook times out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-timeoutnextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-timeoutnextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond to the user input when the code hook times out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-timeoutresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postdialogcodehookinvocationspecification.html#cfn-lex-bot-postdialogcodehookinvocationspecification-timeoutresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PostDialogCodeHookInvocationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostDialogCodeHookInvocationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostDialogCodeHookInvocationSpecificationProperty> {
            java.lang.Object failureConditional;
            java.lang.Object failureNextStep;
            java.lang.Object failureResponse;
            java.lang.Object successConditional;
            java.lang.Object successNextStep;
            java.lang.Object successResponse;
            java.lang.Object timeoutConditional;
            java.lang.Object timeoutNextStep;
            java.lang.Object timeoutResponse;

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getFailureConditional}
             * @param failureConditional A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.IResolvable failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getFailureConditional}
             * @param failureConditional A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getFailureNextStep}
             * @param failureNextStep Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.IResolvable failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getFailureNextStep}
             * @param failureNextStep Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input when the code hook fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.IResolvable failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input when the code hook fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getSuccessConditional}
             * @param successConditional A list of conditional branches to evaluate after the dialog code hook finishes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successConditional(software.amazon.awscdk.IResolvable successConditional) {
                this.successConditional = successConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getSuccessConditional}
             * @param successConditional A list of conditional branches to evaluate after the dialog code hook finishes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty successConditional) {
                this.successConditional = successConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getSuccessNextStep}
             * @param successNextStep Specifics the next step the bot runs after the dialog code hook finishes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successNextStep(software.amazon.awscdk.IResolvable successNextStep) {
                this.successNextStep = successNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getSuccessNextStep}
             * @param successNextStep Specifics the next step the bot runs after the dialog code hook finishes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty successNextStep) {
                this.successNextStep = successNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getSuccessResponse}
             * @param successResponse Specifies a list of message groups that Amazon Lex uses to respond when the code hook succeeds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponse(software.amazon.awscdk.IResolvable successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getSuccessResponse}
             * @param successResponse Specifies a list of message groups that Amazon Lex uses to respond when the code hook succeeds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getTimeoutConditional}
             * @param timeoutConditional A list of conditional branches to evaluate if the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutConditional(software.amazon.awscdk.IResolvable timeoutConditional) {
                this.timeoutConditional = timeoutConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getTimeoutConditional}
             * @param timeoutConditional A list of conditional branches to evaluate if the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty timeoutConditional) {
                this.timeoutConditional = timeoutConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getTimeoutNextStep}
             * @param timeoutNextStep Specifies the next step that the bot runs when the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutNextStep(software.amazon.awscdk.IResolvable timeoutNextStep) {
                this.timeoutNextStep = timeoutNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getTimeoutNextStep}
             * @param timeoutNextStep Specifies the next step that the bot runs when the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty timeoutNextStep) {
                this.timeoutNextStep = timeoutNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getTimeoutResponse}
             * @param timeoutResponse Specifies a list of message groups that Amazon Lex uses to respond to the user input when the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutResponse(software.amazon.awscdk.IResolvable timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostDialogCodeHookInvocationSpecificationProperty#getTimeoutResponse}
             * @param timeoutResponse Specifies a list of message groups that Amazon Lex uses to respond to the user input when the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostDialogCodeHookInvocationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostDialogCodeHookInvocationSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostDialogCodeHookInvocationSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostDialogCodeHookInvocationSpecificationProperty {
            private final java.lang.Object failureConditional;
            private final java.lang.Object failureNextStep;
            private final java.lang.Object failureResponse;
            private final java.lang.Object successConditional;
            private final java.lang.Object successNextStep;
            private final java.lang.Object successResponse;
            private final java.lang.Object timeoutConditional;
            private final java.lang.Object timeoutNextStep;
            private final java.lang.Object timeoutResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureConditional = software.amazon.jsii.Kernel.get(this, "failureConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureNextStep = software.amazon.jsii.Kernel.get(this, "failureNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureResponse = software.amazon.jsii.Kernel.get(this, "failureResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.successConditional = software.amazon.jsii.Kernel.get(this, "successConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.successNextStep = software.amazon.jsii.Kernel.get(this, "successNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.successResponse = software.amazon.jsii.Kernel.get(this, "successResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutConditional = software.amazon.jsii.Kernel.get(this, "timeoutConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutNextStep = software.amazon.jsii.Kernel.get(this, "timeoutNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutResponse = software.amazon.jsii.Kernel.get(this, "timeoutResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureConditional = builder.failureConditional;
                this.failureNextStep = builder.failureNextStep;
                this.failureResponse = builder.failureResponse;
                this.successConditional = builder.successConditional;
                this.successNextStep = builder.successNextStep;
                this.successResponse = builder.successResponse;
                this.timeoutConditional = builder.timeoutConditional;
                this.timeoutNextStep = builder.timeoutNextStep;
                this.timeoutResponse = builder.timeoutResponse;
            }

            @Override
            public final java.lang.Object getFailureConditional() {
                return this.failureConditional;
            }

            @Override
            public final java.lang.Object getFailureNextStep() {
                return this.failureNextStep;
            }

            @Override
            public final java.lang.Object getFailureResponse() {
                return this.failureResponse;
            }

            @Override
            public final java.lang.Object getSuccessConditional() {
                return this.successConditional;
            }

            @Override
            public final java.lang.Object getSuccessNextStep() {
                return this.successNextStep;
            }

            @Override
            public final java.lang.Object getSuccessResponse() {
                return this.successResponse;
            }

            @Override
            public final java.lang.Object getTimeoutConditional() {
                return this.timeoutConditional;
            }

            @Override
            public final java.lang.Object getTimeoutNextStep() {
                return this.timeoutNextStep;
            }

            @Override
            public final java.lang.Object getTimeoutResponse() {
                return this.timeoutResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureConditional() != null) {
                    data.set("failureConditional", om.valueToTree(this.getFailureConditional()));
                }
                if (this.getFailureNextStep() != null) {
                    data.set("failureNextStep", om.valueToTree(this.getFailureNextStep()));
                }
                if (this.getFailureResponse() != null) {
                    data.set("failureResponse", om.valueToTree(this.getFailureResponse()));
                }
                if (this.getSuccessConditional() != null) {
                    data.set("successConditional", om.valueToTree(this.getSuccessConditional()));
                }
                if (this.getSuccessNextStep() != null) {
                    data.set("successNextStep", om.valueToTree(this.getSuccessNextStep()));
                }
                if (this.getSuccessResponse() != null) {
                    data.set("successResponse", om.valueToTree(this.getSuccessResponse()));
                }
                if (this.getTimeoutConditional() != null) {
                    data.set("timeoutConditional", om.valueToTree(this.getTimeoutConditional()));
                }
                if (this.getTimeoutNextStep() != null) {
                    data.set("timeoutNextStep", om.valueToTree(this.getTimeoutNextStep()));
                }
                if (this.getTimeoutResponse() != null) {
                    data.set("timeoutResponse", om.valueToTree(this.getTimeoutResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PostDialogCodeHookInvocationSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostDialogCodeHookInvocationSpecificationProperty.Jsii$Proxy that = (PostDialogCodeHookInvocationSpecificationProperty.Jsii$Proxy) o;

                if (this.failureConditional != null ? !this.failureConditional.equals(that.failureConditional) : that.failureConditional != null) return false;
                if (this.failureNextStep != null ? !this.failureNextStep.equals(that.failureNextStep) : that.failureNextStep != null) return false;
                if (this.failureResponse != null ? !this.failureResponse.equals(that.failureResponse) : that.failureResponse != null) return false;
                if (this.successConditional != null ? !this.successConditional.equals(that.successConditional) : that.successConditional != null) return false;
                if (this.successNextStep != null ? !this.successNextStep.equals(that.successNextStep) : that.successNextStep != null) return false;
                if (this.successResponse != null ? !this.successResponse.equals(that.successResponse) : that.successResponse != null) return false;
                if (this.timeoutConditional != null ? !this.timeoutConditional.equals(that.timeoutConditional) : that.timeoutConditional != null) return false;
                if (this.timeoutNextStep != null ? !this.timeoutNextStep.equals(that.timeoutNextStep) : that.timeoutNextStep != null) return false;
                return this.timeoutResponse != null ? this.timeoutResponse.equals(that.timeoutResponse) : that.timeoutResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureConditional != null ? this.failureConditional.hashCode() : 0;
                result = 31 * result + (this.failureNextStep != null ? this.failureNextStep.hashCode() : 0);
                result = 31 * result + (this.failureResponse != null ? this.failureResponse.hashCode() : 0);
                result = 31 * result + (this.successConditional != null ? this.successConditional.hashCode() : 0);
                result = 31 * result + (this.successNextStep != null ? this.successNextStep.hashCode() : 0);
                result = 31 * result + (this.successResponse != null ? this.successResponse.hashCode() : 0);
                result = 31 * result + (this.timeoutConditional != null ? this.timeoutConditional.hashCode() : 0);
                result = 31 * result + (this.timeoutNextStep != null ? this.timeoutNextStep.hashCode() : 0);
                result = 31 * result + (this.timeoutResponse != null ? this.timeoutResponse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides a setting that determines whether the post-fulfillment response is sent to the user.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete"></a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PostFulfillmentStatusSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PostFulfillmentStatusSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostFulfillmentStatusSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of conditional branches to evaluate after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-failureconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-failureconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureConditional() {
            return null;
        }

        /**
         * Specifies the next step the bot runs after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-failurenextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-failurenextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't successful.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-failureresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-failureresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureResponse() {
            return null;
        }

        /**
         * A list of conditional branches to evaluate after the fulfillment code hook finishes successfully.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-successconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-successconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessConditional() {
            return null;
        }

        /**
         * Specifies the next step in the conversation that Amazon Lex invokes when the fulfillment code hook completes successfully.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-successnextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-successnextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond when the fulfillment is successful.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-successresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-successresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessResponse() {
            return null;
        }

        /**
         * A list of conditional branches to evaluate if the fulfillment code hook times out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-timeoutconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-timeoutconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutConditional() {
            return null;
        }

        /**
         * Specifies the next step that the bot runs when the fulfillment code hook times out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-timeoutnextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-timeoutnextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't completed within the timeout period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-timeoutresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-postfulfillmentstatusspecification.html#cfn-lex-bot-postfulfillmentstatusspecification-timeoutresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PostFulfillmentStatusSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostFulfillmentStatusSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostFulfillmentStatusSpecificationProperty> {
            java.lang.Object failureConditional;
            java.lang.Object failureNextStep;
            java.lang.Object failureResponse;
            java.lang.Object successConditional;
            java.lang.Object successNextStep;
            java.lang.Object successResponse;
            java.lang.Object timeoutConditional;
            java.lang.Object timeoutNextStep;
            java.lang.Object timeoutResponse;

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureConditional}
             * @param failureConditional A list of conditional branches to evaluate after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.IResolvable failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureConditional}
             * @param failureConditional A list of conditional branches to evaluate after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureNextStep}
             * @param failureNextStep Specifies the next step the bot runs after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.IResolvable failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureNextStep}
             * @param failureNextStep Specifies the next step the bot runs after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.IResolvable failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessConditional}
             * @param successConditional A list of conditional branches to evaluate after the fulfillment code hook finishes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successConditional(software.amazon.awscdk.IResolvable successConditional) {
                this.successConditional = successConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessConditional}
             * @param successConditional A list of conditional branches to evaluate after the fulfillment code hook finishes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty successConditional) {
                this.successConditional = successConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessNextStep}
             * @param successNextStep Specifies the next step in the conversation that Amazon Lex invokes when the fulfillment code hook completes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successNextStep(software.amazon.awscdk.IResolvable successNextStep) {
                this.successNextStep = successNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessNextStep}
             * @param successNextStep Specifies the next step in the conversation that Amazon Lex invokes when the fulfillment code hook completes successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty successNextStep) {
                this.successNextStep = successNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessResponse}
             * @param successResponse Specifies a list of message groups that Amazon Lex uses to respond when the fulfillment is successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponse(software.amazon.awscdk.IResolvable successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessResponse}
             * @param successResponse Specifies a list of message groups that Amazon Lex uses to respond when the fulfillment is successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutConditional}
             * @param timeoutConditional A list of conditional branches to evaluate if the fulfillment code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutConditional(software.amazon.awscdk.IResolvable timeoutConditional) {
                this.timeoutConditional = timeoutConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutConditional}
             * @param timeoutConditional A list of conditional branches to evaluate if the fulfillment code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty timeoutConditional) {
                this.timeoutConditional = timeoutConditional;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutNextStep}
             * @param timeoutNextStep Specifies the next step that the bot runs when the fulfillment code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutNextStep(software.amazon.awscdk.IResolvable timeoutNextStep) {
                this.timeoutNextStep = timeoutNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutNextStep}
             * @param timeoutNextStep Specifies the next step that the bot runs when the fulfillment code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty timeoutNextStep) {
                this.timeoutNextStep = timeoutNextStep;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutResponse}
             * @param timeoutResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't completed within the timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutResponse(software.amazon.awscdk.IResolvable timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutResponse}
             * @param timeoutResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't completed within the timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostFulfillmentStatusSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostFulfillmentStatusSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostFulfillmentStatusSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostFulfillmentStatusSpecificationProperty {
            private final java.lang.Object failureConditional;
            private final java.lang.Object failureNextStep;
            private final java.lang.Object failureResponse;
            private final java.lang.Object successConditional;
            private final java.lang.Object successNextStep;
            private final java.lang.Object successResponse;
            private final java.lang.Object timeoutConditional;
            private final java.lang.Object timeoutNextStep;
            private final java.lang.Object timeoutResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureConditional = software.amazon.jsii.Kernel.get(this, "failureConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureNextStep = software.amazon.jsii.Kernel.get(this, "failureNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureResponse = software.amazon.jsii.Kernel.get(this, "failureResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.successConditional = software.amazon.jsii.Kernel.get(this, "successConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.successNextStep = software.amazon.jsii.Kernel.get(this, "successNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.successResponse = software.amazon.jsii.Kernel.get(this, "successResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutConditional = software.amazon.jsii.Kernel.get(this, "timeoutConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutNextStep = software.amazon.jsii.Kernel.get(this, "timeoutNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutResponse = software.amazon.jsii.Kernel.get(this, "timeoutResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureConditional = builder.failureConditional;
                this.failureNextStep = builder.failureNextStep;
                this.failureResponse = builder.failureResponse;
                this.successConditional = builder.successConditional;
                this.successNextStep = builder.successNextStep;
                this.successResponse = builder.successResponse;
                this.timeoutConditional = builder.timeoutConditional;
                this.timeoutNextStep = builder.timeoutNextStep;
                this.timeoutResponse = builder.timeoutResponse;
            }

            @Override
            public final java.lang.Object getFailureConditional() {
                return this.failureConditional;
            }

            @Override
            public final java.lang.Object getFailureNextStep() {
                return this.failureNextStep;
            }

            @Override
            public final java.lang.Object getFailureResponse() {
                return this.failureResponse;
            }

            @Override
            public final java.lang.Object getSuccessConditional() {
                return this.successConditional;
            }

            @Override
            public final java.lang.Object getSuccessNextStep() {
                return this.successNextStep;
            }

            @Override
            public final java.lang.Object getSuccessResponse() {
                return this.successResponse;
            }

            @Override
            public final java.lang.Object getTimeoutConditional() {
                return this.timeoutConditional;
            }

            @Override
            public final java.lang.Object getTimeoutNextStep() {
                return this.timeoutNextStep;
            }

            @Override
            public final java.lang.Object getTimeoutResponse() {
                return this.timeoutResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureConditional() != null) {
                    data.set("failureConditional", om.valueToTree(this.getFailureConditional()));
                }
                if (this.getFailureNextStep() != null) {
                    data.set("failureNextStep", om.valueToTree(this.getFailureNextStep()));
                }
                if (this.getFailureResponse() != null) {
                    data.set("failureResponse", om.valueToTree(this.getFailureResponse()));
                }
                if (this.getSuccessConditional() != null) {
                    data.set("successConditional", om.valueToTree(this.getSuccessConditional()));
                }
                if (this.getSuccessNextStep() != null) {
                    data.set("successNextStep", om.valueToTree(this.getSuccessNextStep()));
                }
                if (this.getSuccessResponse() != null) {
                    data.set("successResponse", om.valueToTree(this.getSuccessResponse()));
                }
                if (this.getTimeoutConditional() != null) {
                    data.set("timeoutConditional", om.valueToTree(this.getTimeoutConditional()));
                }
                if (this.getTimeoutNextStep() != null) {
                    data.set("timeoutNextStep", om.valueToTree(this.getTimeoutNextStep()));
                }
                if (this.getTimeoutResponse() != null) {
                    data.set("timeoutResponse", om.valueToTree(this.getTimeoutResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PostFulfillmentStatusSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostFulfillmentStatusSpecificationProperty.Jsii$Proxy that = (PostFulfillmentStatusSpecificationProperty.Jsii$Proxy) o;

                if (this.failureConditional != null ? !this.failureConditional.equals(that.failureConditional) : that.failureConditional != null) return false;
                if (this.failureNextStep != null ? !this.failureNextStep.equals(that.failureNextStep) : that.failureNextStep != null) return false;
                if (this.failureResponse != null ? !this.failureResponse.equals(that.failureResponse) : that.failureResponse != null) return false;
                if (this.successConditional != null ? !this.successConditional.equals(that.successConditional) : that.successConditional != null) return false;
                if (this.successNextStep != null ? !this.successNextStep.equals(that.successNextStep) : that.successNextStep != null) return false;
                if (this.successResponse != null ? !this.successResponse.equals(that.successResponse) : that.successResponse != null) return false;
                if (this.timeoutConditional != null ? !this.timeoutConditional.equals(that.timeoutConditional) : that.timeoutConditional != null) return false;
                if (this.timeoutNextStep != null ? !this.timeoutNextStep.equals(that.timeoutNextStep) : that.timeoutNextStep != null) return false;
                return this.timeoutResponse != null ? this.timeoutResponse.equals(that.timeoutResponse) : that.timeoutResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureConditional != null ? this.failureConditional.hashCode() : 0;
                result = 31 * result + (this.failureNextStep != null ? this.failureNextStep.hashCode() : 0);
                result = 31 * result + (this.failureResponse != null ? this.failureResponse.hashCode() : 0);
                result = 31 * result + (this.successConditional != null ? this.successConditional.hashCode() : 0);
                result = 31 * result + (this.successNextStep != null ? this.successNextStep.hashCode() : 0);
                result = 31 * result + (this.successResponse != null ? this.successResponse.hashCode() : 0);
                result = 31 * result + (this.timeoutConditional != null ? this.timeoutConditional.hashCode() : 0);
                result = 31 * result + (this.timeoutNextStep != null ? this.timeoutNextStep.hashCode() : 0);
                result = 31 * result + (this.timeoutResponse != null ? this.timeoutResponse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the settings on a prompt attempt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * PromptAttemptSpecificationProperty promptAttemptSpecificationProperty = PromptAttemptSpecificationProperty.builder()
     *         .allowedInputTypes(AllowedInputTypesProperty.builder()
     *                 .allowAudioInput(false)
     *                 .allowDtmfInput(false)
     *                 .build())
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .audioAndDtmfInputSpecification(AudioAndDTMFInputSpecificationProperty.builder()
     *                 .startTimeoutMs(123)
     *                 // the properties below are optional
     *                 .audioSpecification(AudioSpecificationProperty.builder()
     *                         .endTimeoutMs(123)
     *                         .maxLengthMs(123)
     *                         .build())
     *                 .dtmfSpecification(DTMFSpecificationProperty.builder()
     *                         .deletionCharacter("deletionCharacter")
     *                         .endCharacter("endCharacter")
     *                         .endTimeoutMs(123)
     *                         .maxLength(123)
     *                         .build())
     *                 .build())
     *         .textInputSpecification(TextInputSpecificationProperty.builder()
     *                 .startTimeoutMs(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PromptAttemptSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptAttemptSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptAttemptSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the allowed input types of the prompt attempt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-allowedinputtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-allowedinputtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllowedInputTypes();

        /**
         * Indicates whether the user can interrupt a speech prompt attempt from the bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-allowinterrupt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-allowinterrupt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * Specifies the settings on audio and DTMF input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-audioanddtmfinputspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-audioanddtmfinputspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioAndDtmfInputSpecification() {
            return null;
        }

        /**
         * Specifies the settings on text input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-textinputspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptattemptspecification.html#cfn-lex-bot-promptattemptspecification-textinputspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTextInputSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptAttemptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptAttemptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptAttemptSpecificationProperty> {
            java.lang.Object allowedInputTypes;
            java.lang.Object allowInterrupt;
            java.lang.Object audioAndDtmfInputSpecification;
            java.lang.Object textInputSpecification;

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getAllowedInputTypes}
             * @param allowedInputTypes Indicates the allowed input types of the prompt attempt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedInputTypes(software.amazon.awscdk.IResolvable allowedInputTypes) {
                this.allowedInputTypes = allowedInputTypes;
                return this;
            }

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getAllowedInputTypes}
             * @param allowedInputTypes Indicates the allowed input types of the prompt attempt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedInputTypes(software.amazon.awscdk.services.lex.CfnBot.AllowedInputTypesProperty allowedInputTypes) {
                this.allowedInputTypes = allowedInputTypes;
                return this;
            }

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech prompt attempt from the bot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech prompt attempt from the bot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getAudioAndDtmfInputSpecification}
             * @param audioAndDtmfInputSpecification Specifies the settings on audio and DTMF input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioAndDtmfInputSpecification(software.amazon.awscdk.IResolvable audioAndDtmfInputSpecification) {
                this.audioAndDtmfInputSpecification = audioAndDtmfInputSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getAudioAndDtmfInputSpecification}
             * @param audioAndDtmfInputSpecification Specifies the settings on audio and DTMF input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioAndDtmfInputSpecification(software.amazon.awscdk.services.lex.CfnBot.AudioAndDTMFInputSpecificationProperty audioAndDtmfInputSpecification) {
                this.audioAndDtmfInputSpecification = audioAndDtmfInputSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getTextInputSpecification}
             * @param textInputSpecification Specifies the settings on text input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textInputSpecification(software.amazon.awscdk.IResolvable textInputSpecification) {
                this.textInputSpecification = textInputSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PromptAttemptSpecificationProperty#getTextInputSpecification}
             * @param textInputSpecification Specifies the settings on text input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textInputSpecification(software.amazon.awscdk.services.lex.CfnBot.TextInputSpecificationProperty textInputSpecification) {
                this.textInputSpecification = textInputSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptAttemptSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptAttemptSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptAttemptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptAttemptSpecificationProperty {
            private final java.lang.Object allowedInputTypes;
            private final java.lang.Object allowInterrupt;
            private final java.lang.Object audioAndDtmfInputSpecification;
            private final java.lang.Object textInputSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedInputTypes = software.amazon.jsii.Kernel.get(this, "allowedInputTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioAndDtmfInputSpecification = software.amazon.jsii.Kernel.get(this, "audioAndDtmfInputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textInputSpecification = software.amazon.jsii.Kernel.get(this, "textInputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedInputTypes = java.util.Objects.requireNonNull(builder.allowedInputTypes, "allowedInputTypes is required");
                this.allowInterrupt = builder.allowInterrupt;
                this.audioAndDtmfInputSpecification = builder.audioAndDtmfInputSpecification;
                this.textInputSpecification = builder.textInputSpecification;
            }

            @Override
            public final java.lang.Object getAllowedInputTypes() {
                return this.allowedInputTypes;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            public final java.lang.Object getAudioAndDtmfInputSpecification() {
                return this.audioAndDtmfInputSpecification;
            }

            @Override
            public final java.lang.Object getTextInputSpecification() {
                return this.textInputSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowedInputTypes", om.valueToTree(this.getAllowedInputTypes()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }
                if (this.getAudioAndDtmfInputSpecification() != null) {
                    data.set("audioAndDtmfInputSpecification", om.valueToTree(this.getAudioAndDtmfInputSpecification()));
                }
                if (this.getTextInputSpecification() != null) {
                    data.set("textInputSpecification", om.valueToTree(this.getTextInputSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PromptAttemptSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptAttemptSpecificationProperty.Jsii$Proxy that = (PromptAttemptSpecificationProperty.Jsii$Proxy) o;

                if (!allowedInputTypes.equals(that.allowedInputTypes)) return false;
                if (this.allowInterrupt != null ? !this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt != null) return false;
                if (this.audioAndDtmfInputSpecification != null ? !this.audioAndDtmfInputSpecification.equals(that.audioAndDtmfInputSpecification) : that.audioAndDtmfInputSpecification != null) return false;
                return this.textInputSpecification != null ? this.textInputSpecification.equals(that.textInputSpecification) : that.textInputSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedInputTypes.hashCode();
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                result = 31 * result + (this.audioAndDtmfInputSpecification != null ? this.audioAndDtmfInputSpecification.hashCode() : 0);
                result = 31 * result + (this.textInputSpecification != null ? this.textInputSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * PromptSpecificationProperty promptSpecificationProperty = PromptSpecificationProperty.builder()
     *         .maxRetries(123)
     *         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .messageSelectionStrategy("messageSelectionStrategy")
     *         .promptAttemptsSpecification(Map.of(
     *                 "promptAttemptsSpecificationKey", PromptAttemptSpecificationProperty.builder()
     *                         .allowedInputTypes(AllowedInputTypesProperty.builder()
     *                                 .allowAudioInput(false)
     *                                 .allowDtmfInput(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .audioAndDtmfInputSpecification(AudioAndDTMFInputSpecificationProperty.builder()
     *                                 .startTimeoutMs(123)
     *                                 // the properties below are optional
     *                                 .audioSpecification(AudioSpecificationProperty.builder()
     *                                         .endTimeoutMs(123)
     *                                         .maxLengthMs(123)
     *                                         .build())
     *                                 .dtmfSpecification(DTMFSpecificationProperty.builder()
     *                                         .deletionCharacter("deletionCharacter")
     *                                         .endCharacter("endCharacter")
     *                                         .endTimeoutMs(123)
     *                                         .maxLength(123)
     *                                         .build())
     *                                 .build())
     *                         .textInputSpecification(TextInputSpecificationProperty.builder()
     *                                 .startTimeoutMs(123)
     *                                 .build())
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PromptSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of times the bot tries to elicit a response from the user using this prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-maxretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-maxretries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRetries();

        /**
         * A collection of messages that Amazon Lex can send to the user.
         * <p>
         * Amazon Lex chooses the actual message to send at runtime.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-messagegroupslist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-messagegroupslist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroupsList();

        /**
         * Indicates whether the user can interrupt a speech prompt from the bot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-allowinterrupt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-allowinterrupt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * Indicates how a message is selected from a message group among retries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-messageselectionstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-messageselectionstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageSelectionStrategy() {
            return null;
        }

        /**
         * Specifies the advanced settings on each attempt of the prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-promptattemptsspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-promptspecification.html#cfn-lex-bot-promptspecification-promptattemptsspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPromptAttemptsSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptSpecificationProperty> {
            java.lang.Number maxRetries;
            java.lang.Object messageGroupsList;
            java.lang.Object allowInterrupt;
            java.lang.String messageSelectionStrategy;
            java.lang.Object promptAttemptsSpecification;

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMaxRetries}
             * @param maxRetries The maximum number of times the bot tries to elicit a response from the user using this prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetries(java.lang.Number maxRetries) {
                this.maxRetries = maxRetries;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of messages that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual message to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(software.amazon.awscdk.IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of messages that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual message to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(java.util.List<? extends java.lang.Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech prompt from the bot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech prompt from the bot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMessageSelectionStrategy}
             * @param messageSelectionStrategy Indicates how a message is selected from a message group among retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageSelectionStrategy(java.lang.String messageSelectionStrategy) {
                this.messageSelectionStrategy = messageSelectionStrategy;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getPromptAttemptsSpecification}
             * @param promptAttemptsSpecification Specifies the advanced settings on each attempt of the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptAttemptsSpecification(software.amazon.awscdk.IResolvable promptAttemptsSpecification) {
                this.promptAttemptsSpecification = promptAttemptsSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getPromptAttemptsSpecification}
             * @param promptAttemptsSpecification Specifies the advanced settings on each attempt of the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptAttemptsSpecification(java.util.Map<java.lang.String, ? extends java.lang.Object> promptAttemptsSpecification) {
                this.promptAttemptsSpecification = promptAttemptsSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptSpecificationProperty {
            private final java.lang.Number maxRetries;
            private final java.lang.Object messageGroupsList;
            private final java.lang.Object allowInterrupt;
            private final java.lang.String messageSelectionStrategy;
            private final java.lang.Object promptAttemptsSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messageGroupsList = software.amazon.jsii.Kernel.get(this, "messageGroupsList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageSelectionStrategy = software.amazon.jsii.Kernel.get(this, "messageSelectionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.promptAttemptsSpecification = software.amazon.jsii.Kernel.get(this, "promptAttemptsSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRetries = java.util.Objects.requireNonNull(builder.maxRetries, "maxRetries is required");
                this.messageGroupsList = java.util.Objects.requireNonNull(builder.messageGroupsList, "messageGroupsList is required");
                this.allowInterrupt = builder.allowInterrupt;
                this.messageSelectionStrategy = builder.messageSelectionStrategy;
                this.promptAttemptsSpecification = builder.promptAttemptsSpecification;
            }

            @Override
            public final java.lang.Number getMaxRetries() {
                return this.maxRetries;
            }

            @Override
            public final java.lang.Object getMessageGroupsList() {
                return this.messageGroupsList;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            public final java.lang.String getMessageSelectionStrategy() {
                return this.messageSelectionStrategy;
            }

            @Override
            public final java.lang.Object getPromptAttemptsSpecification() {
                return this.promptAttemptsSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
                data.set("messageGroupsList", om.valueToTree(this.getMessageGroupsList()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }
                if (this.getMessageSelectionStrategy() != null) {
                    data.set("messageSelectionStrategy", om.valueToTree(this.getMessageSelectionStrategy()));
                }
                if (this.getPromptAttemptsSpecification() != null) {
                    data.set("promptAttemptsSpecification", om.valueToTree(this.getPromptAttemptsSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PromptSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptSpecificationProperty.Jsii$Proxy that = (PromptSpecificationProperty.Jsii$Proxy) o;

                if (!maxRetries.equals(that.maxRetries)) return false;
                if (!messageGroupsList.equals(that.messageGroupsList)) return false;
                if (this.allowInterrupt != null ? !this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt != null) return false;
                if (this.messageSelectionStrategy != null ? !this.messageSelectionStrategy.equals(that.messageSelectionStrategy) : that.messageSelectionStrategy != null) return false;
                return this.promptAttemptsSpecification != null ? this.promptAttemptsSpecification.equals(that.promptAttemptsSpecification) : that.promptAttemptsSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxRetries.hashCode();
                result = 31 * result + (this.messageGroupsList.hashCode());
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                result = 31 * result + (this.messageSelectionStrategy != null ? this.messageSelectionStrategy.hashCode() : 0);
                result = 31 * result + (this.promptAttemptsSpecification != null ? this.promptAttemptsSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a list of message groups that Amazon Lex uses to respond the user input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ResponseSpecificationProperty responseSpecificationProperty = ResponseSpecificationProperty.builder()
     *         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-responsespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-responsespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ResponseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ResponseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResponseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A collection of responses that Amazon Lex can send to the user.
         * <p>
         * Amazon Lex chooses the actual response to send at runtime.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-responsespecification.html#cfn-lex-bot-responsespecification-messagegroupslist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-responsespecification.html#cfn-lex-bot-responsespecification-messagegroupslist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroupsList();

        /**
         * Indicates whether the user can interrupt a speech response from Amazon Lex.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-responsespecification.html#cfn-lex-bot-responsespecification-allowinterrupt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-responsespecification.html#cfn-lex-bot-responsespecification-allowinterrupt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResponseSpecificationProperty> {
            java.lang.Object messageGroupsList;
            java.lang.Object allowInterrupt;

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(software.amazon.awscdk.IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(java.util.List<? extends java.lang.Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech response from Amazon Lex.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech response from Amazon Lex.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResponseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResponseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseSpecificationProperty {
            private final java.lang.Object messageGroupsList;
            private final java.lang.Object allowInterrupt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.messageGroupsList = software.amazon.jsii.Kernel.get(this, "messageGroupsList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.messageGroupsList = java.util.Objects.requireNonNull(builder.messageGroupsList, "messageGroupsList is required");
                this.allowInterrupt = builder.allowInterrupt;
            }

            @Override
            public final java.lang.Object getMessageGroupsList() {
                return this.messageGroupsList;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("messageGroupsList", om.valueToTree(this.getMessageGroupsList()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ResponseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResponseSpecificationProperty.Jsii$Proxy that = (ResponseSpecificationProperty.Jsii$Proxy) o;

                if (!messageGroupsList.equals(that.messageGroupsList)) return false;
                return this.allowInterrupt != null ? this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.messageGroupsList.hashCode();
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon S3 bucket for logging audio conversations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * S3BucketLogDestinationProperty s3BucketLogDestinationProperty = S3BucketLogDestinationProperty.builder()
     *         .logPrefix("logPrefix")
     *         .s3BucketArn("s3BucketArn")
     *         // the properties below are optional
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.S3BucketLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3BucketLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3BucketLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 prefix to assign to audio log files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html#cfn-lex-bot-s3bucketlogdestination-logprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html#cfn-lex-bot-s3bucketlogdestination-logprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogPrefix();

        /**
         * The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html#cfn-lex-bot-s3bucketlogdestination-s3bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html#cfn-lex-bot-s3bucketlogdestination-s3bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketArn();

        /**
         * The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html#cfn-lex-bot-s3bucketlogdestination-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3bucketlogdestination.html#cfn-lex-bot-s3bucketlogdestination-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3BucketLogDestinationProperty> {
            java.lang.String logPrefix;
            java.lang.String s3BucketArn;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getLogPrefix}
             * @param logPrefix The S3 prefix to assign to audio log files. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPrefix(java.lang.String logPrefix) {
                this.logPrefix = logPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getS3BucketArn}
             * @param s3BucketArn The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketArn(java.lang.String s3BucketArn) {
                this.s3BucketArn = s3BucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getKmsKeyArn}
             * @param kmsKeyArn The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3BucketLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3BucketLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3BucketLogDestinationProperty {
            private final java.lang.String logPrefix;
            private final java.lang.String s3BucketArn;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logPrefix = software.amazon.jsii.Kernel.get(this, "logPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketArn = software.amazon.jsii.Kernel.get(this, "s3BucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logPrefix = java.util.Objects.requireNonNull(builder.logPrefix, "logPrefix is required");
                this.s3BucketArn = java.util.Objects.requireNonNull(builder.s3BucketArn, "s3BucketArn is required");
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getLogPrefix() {
                return this.logPrefix;
            }

            @Override
            public final java.lang.String getS3BucketArn() {
                return this.s3BucketArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logPrefix", om.valueToTree(this.getLogPrefix()));
                data.set("s3BucketArn", om.valueToTree(this.getS3BucketArn()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.S3BucketLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3BucketLogDestinationProperty.Jsii$Proxy that = (S3BucketLogDestinationProperty.Jsii$Proxy) o;

                if (!logPrefix.equals(that.logPrefix)) return false;
                if (!s3BucketArn.equals(that.s3BucketArn)) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logPrefix.hashCode();
                result = 31 * result + (this.s3BucketArn.hashCode());
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an Amazon S3 bucket location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .s3Bucket("s3Bucket")
     *         .s3ObjectKey("s3ObjectKey")
     *         // the properties below are optional
     *         .s3ObjectVersion("s3ObjectVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html#cfn-lex-bot-s3location-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html#cfn-lex-bot-s3location-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * The path and file name to the object in the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html#cfn-lex-bot-s3location-s3objectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html#cfn-lex-bot-s3location-s3objectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectKey();

        /**
         * The version of the object in the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html#cfn-lex-bot-s3location-s3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-s3location.html#cfn-lex-bot-s3location-s3objectversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String s3Bucket;
            java.lang.String s3ObjectKey;
            java.lang.String s3ObjectVersion;

            /**
             * Sets the value of {@link S3LocationProperty#getS3Bucket}
             * @param s3Bucket The S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getS3ObjectKey}
             * @param s3ObjectKey The path and file name to the object in the S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectKey(java.lang.String s3ObjectKey) {
                this.s3ObjectKey = s3ObjectKey;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getS3ObjectVersion}
             * @param s3ObjectVersion The version of the object in the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectVersion(java.lang.String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String s3Bucket;
            private final java.lang.String s3ObjectKey;
            private final java.lang.String s3ObjectVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectKey = software.amazon.jsii.Kernel.get(this, "s3ObjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectVersion = software.amazon.jsii.Kernel.get(this, "s3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.s3ObjectKey = java.util.Objects.requireNonNull(builder.s3ObjectKey, "s3ObjectKey is required");
                this.s3ObjectVersion = builder.s3ObjectVersion;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3ObjectKey() {
                return this.s3ObjectKey;
            }

            @Override
            public final java.lang.String getS3ObjectVersion() {
                return this.s3ObjectVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                data.set("s3ObjectKey", om.valueToTree(this.getS3ObjectKey()));
                if (this.getS3ObjectVersion() != null) {
                    data.set("s3ObjectVersion", om.valueToTree(this.getS3ObjectVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!s3Bucket.equals(that.s3Bucket)) return false;
                if (!s3ObjectKey.equals(that.s3ObjectKey)) return false;
                return this.s3ObjectVersion != null ? this.s3ObjectVersion.equals(that.s3ObjectVersion) : that.s3ObjectVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                result = 31 * result + (this.s3ObjectKey.hashCode());
                result = 31 * result + (this.s3ObjectVersion != null ? this.s3ObjectVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a Speech Synthesis Markup Language (SSML) prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SSMLMessageProperty sSMLMessageProperty = SSMLMessageProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-ssmlmessage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-ssmlmessage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SSMLMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(SSMLMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SSMLMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The SSML text that defines the prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-ssmlmessage.html#cfn-lex-bot-ssmlmessage-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-ssmlmessage.html#cfn-lex-bot-ssmlmessage-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SSMLMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SSMLMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SSMLMessageProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link SSMLMessageProperty#getValue}
             * @param value The SSML text that defines the prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSMLMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SSMLMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SSMLMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SSMLMessageProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SSMLMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SSMLMessageProperty.Jsii$Proxy that = (SSMLMessageProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * A sample utterance that invokes an intent or respond to a slot elicitation prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SampleUtteranceProperty sampleUtteranceProperty = SampleUtteranceProperty.builder()
     *         .utterance("utterance")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sampleutterance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sampleutterance.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SampleUtteranceProperty")
    @software.amazon.jsii.Jsii.Proxy(SampleUtteranceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SampleUtteranceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A sample utterance that invokes an intent or respond to a slot elicitation prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sampleutterance.html#cfn-lex-bot-sampleutterance-utterance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sampleutterance.html#cfn-lex-bot-sampleutterance-utterance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUtterance();

        /**
         * @return a {@link Builder} of {@link SampleUtteranceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SampleUtteranceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SampleUtteranceProperty> {
            java.lang.String utterance;

            /**
             * Sets the value of {@link SampleUtteranceProperty#getUtterance}
             * @param utterance A sample utterance that invokes an intent or respond to a slot elicitation prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder utterance(java.lang.String utterance) {
                this.utterance = utterance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SampleUtteranceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SampleUtteranceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SampleUtteranceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SampleUtteranceProperty {
            private final java.lang.String utterance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.utterance = software.amazon.jsii.Kernel.get(this, "utterance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.utterance = java.util.Objects.requireNonNull(builder.utterance, "utterance is required");
            }

            @Override
            public final java.lang.String getUtterance() {
                return this.utterance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("utterance", om.valueToTree(this.getUtterance()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SampleUtteranceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SampleUtteranceProperty.Jsii$Proxy that = (SampleUtteranceProperty.Jsii$Proxy) o;

                return this.utterance.equals(that.utterance);
            }

            @Override
            public final int hashCode() {
                int result = this.utterance.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines one of the values for a slot type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SampleValueProperty sampleValueProperty = SampleValueProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-samplevalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-samplevalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SampleValueProperty")
    @software.amazon.jsii.Jsii.Proxy(SampleValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SampleValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value that can be used for a slot type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-samplevalue.html#cfn-lex-bot-samplevalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-samplevalue.html#cfn-lex-bot-samplevalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SampleValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SampleValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SampleValueProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link SampleValueProperty#getValue}
             * @param value The value that can be used for a slot type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SampleValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SampleValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SampleValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SampleValueProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SampleValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SampleValueProperty.Jsii$Proxy that = (SampleValueProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SentimentAnalysisSettingsProperty sentimentAnalysisSettingsProperty = SentimentAnalysisSettingsProperty.builder()
     *         .detectSentiment(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sentimentanalysissettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sentimentanalysissettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SentimentAnalysisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SentimentAnalysisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SentimentAnalysisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sentimentanalysissettings.html#cfn-lex-bot-sentimentanalysissettings-detectsentiment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sentimentanalysissettings.html#cfn-lex-bot-sentimentanalysissettings-detectsentiment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDetectSentiment();

        /**
         * @return a {@link Builder} of {@link SentimentAnalysisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SentimentAnalysisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SentimentAnalysisSettingsProperty> {
            java.lang.Object detectSentiment;

            /**
             * Sets the value of {@link SentimentAnalysisSettingsProperty#getDetectSentiment}
             * @param detectSentiment Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectSentiment(java.lang.Boolean detectSentiment) {
                this.detectSentiment = detectSentiment;
                return this;
            }

            /**
             * Sets the value of {@link SentimentAnalysisSettingsProperty#getDetectSentiment}
             * @param detectSentiment Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detectSentiment(software.amazon.awscdk.IResolvable detectSentiment) {
                this.detectSentiment = detectSentiment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SentimentAnalysisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SentimentAnalysisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SentimentAnalysisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SentimentAnalysisSettingsProperty {
            private final java.lang.Object detectSentiment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.detectSentiment = software.amazon.jsii.Kernel.get(this, "detectSentiment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.detectSentiment = java.util.Objects.requireNonNull(builder.detectSentiment, "detectSentiment is required");
            }

            @Override
            public final java.lang.Object getDetectSentiment() {
                return this.detectSentiment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("detectSentiment", om.valueToTree(this.getDetectSentiment()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SentimentAnalysisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SentimentAnalysisSettingsProperty.Jsii$Proxy that = (SentimentAnalysisSettingsProperty.Jsii$Proxy) o;

                return this.detectSentiment.equals(that.detectSentiment);
            }

            @Override
            public final int hashCode() {
                int result = this.detectSentiment.hashCode();
                return result;
            }
        }
    }
    /**
     * A key/value pair representing session-specific context information.
     * <p>
     * It contains application information passed between Amazon Lex V2 and a client application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SessionAttributeProperty sessionAttributeProperty = SessionAttributeProperty.builder()
     *         .key("key")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sessionattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sessionattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SessionAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(SessionAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SessionAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the session attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sessionattribute.html#cfn-lex-bot-sessionattribute-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sessionattribute.html#cfn-lex-bot-sessionattribute-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The session-specific context information for the session attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sessionattribute.html#cfn-lex-bot-sessionattribute-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-sessionattribute.html#cfn-lex-bot-sessionattribute-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SessionAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SessionAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SessionAttributeProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link SessionAttributeProperty#getKey}
             * @param key The name of the session attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link SessionAttributeProperty#getValue}
             * @param value The session-specific context information for the session attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SessionAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SessionAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SessionAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SessionAttributeProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SessionAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SessionAttributeProperty.Jsii$Proxy that = (SessionAttributeProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings used when Amazon Lex successfully captures a slot value from a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotCaptureSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotCaptureSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotCaptureSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of conditional branches to evaluate after the slot value is captured.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-captureconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-captureconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptureConditional() {
            return null;
        }

        /**
         * Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-capturenextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-capturenextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptureNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-captureresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-captureresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptureResponse() {
            return null;
        }

        /**
         * Code hook called after Amazon Lex successfully captures a slot value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-codehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-codehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeHook() {
            return null;
        }

        /**
         * Code hook called when Amazon Lex doesn't capture a slot value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-elicitationcodehook">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-elicitationcodehook</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElicitationCodeHook() {
            return null;
        }

        /**
         * A list of conditional branches to evaluate when the slot value isn't captured.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-failureconditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-failureconditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureConditional() {
            return null;
        }

        /**
         * Specifies the next step that the bot runs when the slot value code is not recognized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-failurenextstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-failurenextstep</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureNextStep() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input when the slot fails to be captured.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-failureresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotcapturesetting.html#cfn-lex-bot-slotcapturesetting-failureresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotCaptureSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotCaptureSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotCaptureSettingProperty> {
            java.lang.Object captureConditional;
            java.lang.Object captureNextStep;
            java.lang.Object captureResponse;
            java.lang.Object codeHook;
            java.lang.Object elicitationCodeHook;
            java.lang.Object failureConditional;
            java.lang.Object failureNextStep;
            java.lang.Object failureResponse;

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCaptureConditional}
             * @param captureConditional A list of conditional branches to evaluate after the slot value is captured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureConditional(software.amazon.awscdk.IResolvable captureConditional) {
                this.captureConditional = captureConditional;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCaptureConditional}
             * @param captureConditional A list of conditional branches to evaluate after the slot value is captured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty captureConditional) {
                this.captureConditional = captureConditional;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCaptureNextStep}
             * @param captureNextStep Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureNextStep(software.amazon.awscdk.IResolvable captureNextStep) {
                this.captureNextStep = captureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCaptureNextStep}
             * @param captureNextStep Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty captureNextStep) {
                this.captureNextStep = captureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCaptureResponse}
             * @param captureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureResponse(software.amazon.awscdk.IResolvable captureResponse) {
                this.captureResponse = captureResponse;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCaptureResponse}
             * @param captureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty captureResponse) {
                this.captureResponse = captureResponse;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCodeHook}
             * @param codeHook Code hook called after Amazon Lex successfully captures a slot value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHook(software.amazon.awscdk.IResolvable codeHook) {
                this.codeHook = codeHook;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getCodeHook}
             * @param codeHook Code hook called after Amazon Lex successfully captures a slot value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHook(software.amazon.awscdk.services.lex.CfnBot.DialogCodeHookInvocationSettingProperty codeHook) {
                this.codeHook = codeHook;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getElicitationCodeHook}
             * @param elicitationCodeHook Code hook called when Amazon Lex doesn't capture a slot value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elicitationCodeHook(software.amazon.awscdk.IResolvable elicitationCodeHook) {
                this.elicitationCodeHook = elicitationCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getElicitationCodeHook}
             * @param elicitationCodeHook Code hook called when Amazon Lex doesn't capture a slot value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elicitationCodeHook(software.amazon.awscdk.services.lex.CfnBot.ElicitationCodeHookInvocationSettingProperty elicitationCodeHook) {
                this.elicitationCodeHook = elicitationCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getFailureConditional}
             * @param failureConditional A list of conditional branches to evaluate when the slot value isn't captured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.IResolvable failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getFailureConditional}
             * @param failureConditional A list of conditional branches to evaluate when the slot value isn't captured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConditional(software.amazon.awscdk.services.lex.CfnBot.ConditionalSpecificationProperty failureConditional) {
                this.failureConditional = failureConditional;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getFailureNextStep}
             * @param failureNextStep Specifies the next step that the bot runs when the slot value code is not recognized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.IResolvable failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getFailureNextStep}
             * @param failureNextStep Specifies the next step that the bot runs when the slot value code is not recognized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureNextStep(software.amazon.awscdk.services.lex.CfnBot.DialogStateProperty failureNextStep) {
                this.failureNextStep = failureNextStep;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input when the slot fails to be captured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.IResolvable failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link SlotCaptureSettingProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond the user input when the slot fails to be captured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotCaptureSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotCaptureSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotCaptureSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotCaptureSettingProperty {
            private final java.lang.Object captureConditional;
            private final java.lang.Object captureNextStep;
            private final java.lang.Object captureResponse;
            private final java.lang.Object codeHook;
            private final java.lang.Object elicitationCodeHook;
            private final java.lang.Object failureConditional;
            private final java.lang.Object failureNextStep;
            private final java.lang.Object failureResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureConditional = software.amazon.jsii.Kernel.get(this, "captureConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.captureNextStep = software.amazon.jsii.Kernel.get(this, "captureNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.captureResponse = software.amazon.jsii.Kernel.get(this, "captureResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeHook = software.amazon.jsii.Kernel.get(this, "codeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elicitationCodeHook = software.amazon.jsii.Kernel.get(this, "elicitationCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureConditional = software.amazon.jsii.Kernel.get(this, "failureConditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureNextStep = software.amazon.jsii.Kernel.get(this, "failureNextStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureResponse = software.amazon.jsii.Kernel.get(this, "failureResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureConditional = builder.captureConditional;
                this.captureNextStep = builder.captureNextStep;
                this.captureResponse = builder.captureResponse;
                this.codeHook = builder.codeHook;
                this.elicitationCodeHook = builder.elicitationCodeHook;
                this.failureConditional = builder.failureConditional;
                this.failureNextStep = builder.failureNextStep;
                this.failureResponse = builder.failureResponse;
            }

            @Override
            public final java.lang.Object getCaptureConditional() {
                return this.captureConditional;
            }

            @Override
            public final java.lang.Object getCaptureNextStep() {
                return this.captureNextStep;
            }

            @Override
            public final java.lang.Object getCaptureResponse() {
                return this.captureResponse;
            }

            @Override
            public final java.lang.Object getCodeHook() {
                return this.codeHook;
            }

            @Override
            public final java.lang.Object getElicitationCodeHook() {
                return this.elicitationCodeHook;
            }

            @Override
            public final java.lang.Object getFailureConditional() {
                return this.failureConditional;
            }

            @Override
            public final java.lang.Object getFailureNextStep() {
                return this.failureNextStep;
            }

            @Override
            public final java.lang.Object getFailureResponse() {
                return this.failureResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaptureConditional() != null) {
                    data.set("captureConditional", om.valueToTree(this.getCaptureConditional()));
                }
                if (this.getCaptureNextStep() != null) {
                    data.set("captureNextStep", om.valueToTree(this.getCaptureNextStep()));
                }
                if (this.getCaptureResponse() != null) {
                    data.set("captureResponse", om.valueToTree(this.getCaptureResponse()));
                }
                if (this.getCodeHook() != null) {
                    data.set("codeHook", om.valueToTree(this.getCodeHook()));
                }
                if (this.getElicitationCodeHook() != null) {
                    data.set("elicitationCodeHook", om.valueToTree(this.getElicitationCodeHook()));
                }
                if (this.getFailureConditional() != null) {
                    data.set("failureConditional", om.valueToTree(this.getFailureConditional()));
                }
                if (this.getFailureNextStep() != null) {
                    data.set("failureNextStep", om.valueToTree(this.getFailureNextStep()));
                }
                if (this.getFailureResponse() != null) {
                    data.set("failureResponse", om.valueToTree(this.getFailureResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotCaptureSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotCaptureSettingProperty.Jsii$Proxy that = (SlotCaptureSettingProperty.Jsii$Proxy) o;

                if (this.captureConditional != null ? !this.captureConditional.equals(that.captureConditional) : that.captureConditional != null) return false;
                if (this.captureNextStep != null ? !this.captureNextStep.equals(that.captureNextStep) : that.captureNextStep != null) return false;
                if (this.captureResponse != null ? !this.captureResponse.equals(that.captureResponse) : that.captureResponse != null) return false;
                if (this.codeHook != null ? !this.codeHook.equals(that.codeHook) : that.codeHook != null) return false;
                if (this.elicitationCodeHook != null ? !this.elicitationCodeHook.equals(that.elicitationCodeHook) : that.elicitationCodeHook != null) return false;
                if (this.failureConditional != null ? !this.failureConditional.equals(that.failureConditional) : that.failureConditional != null) return false;
                if (this.failureNextStep != null ? !this.failureNextStep.equals(that.failureNextStep) : that.failureNextStep != null) return false;
                return this.failureResponse != null ? this.failureResponse.equals(that.failureResponse) : that.failureResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captureConditional != null ? this.captureConditional.hashCode() : 0;
                result = 31 * result + (this.captureNextStep != null ? this.captureNextStep.hashCode() : 0);
                result = 31 * result + (this.captureResponse != null ? this.captureResponse.hashCode() : 0);
                result = 31 * result + (this.codeHook != null ? this.codeHook.hashCode() : 0);
                result = 31 * result + (this.elicitationCodeHook != null ? this.elicitationCodeHook.hashCode() : 0);
                result = 31 * result + (this.failureConditional != null ? this.failureConditional.hashCode() : 0);
                result = 31 * result + (this.failureNextStep != null ? this.failureNextStep.hashCode() : 0);
                result = 31 * result + (this.failureResponse != null ? this.failureResponse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default value to use when a user doesn't provide a value for a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotDefaultValueProperty slotDefaultValueProperty = SlotDefaultValueProperty.builder()
     *         .defaultValue("defaultValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotDefaultValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotDefaultValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default value to use when a user doesn't provide a value for a slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvalue.html#cfn-lex-bot-slotdefaultvalue-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvalue.html#cfn-lex-bot-slotdefaultvalue-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefaultValue();

        /**
         * @return a {@link Builder} of {@link SlotDefaultValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotDefaultValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotDefaultValueProperty> {
            java.lang.String defaultValue;

            /**
             * Sets the value of {@link SlotDefaultValueProperty#getDefaultValue}
             * @param defaultValue The default value to use when a user doesn't provide a value for a slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotDefaultValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotDefaultValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotDefaultValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotDefaultValueProperty {
            private final java.lang.String defaultValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultValue = java.util.Objects.requireNonNull(builder.defaultValue, "defaultValue is required");
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultValue", om.valueToTree(this.getDefaultValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotDefaultValueProperty.Jsii$Proxy that = (SlotDefaultValueProperty.Jsii$Proxy) o;

                return this.defaultValue.equals(that.defaultValue);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultValue.hashCode();
                return result;
            }
        }
    }
    /**
     * The default value to use when a user doesn't provide a value for a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotDefaultValueSpecificationProperty slotDefaultValueSpecificationProperty = SlotDefaultValueSpecificationProperty.builder()
     *         .defaultValueList(List.of(SlotDefaultValueProperty.builder()
     *                 .defaultValue("defaultValue")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvaluespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvaluespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotDefaultValueSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotDefaultValueSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of default values.
         * <p>
         * Amazon Lex chooses the default value to use in the order that they are presented in the list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvaluespecification.html#cfn-lex-bot-slotdefaultvaluespecification-defaultvaluelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotdefaultvaluespecification.html#cfn-lex-bot-slotdefaultvaluespecification-defaultvaluelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultValueList();

        /**
         * @return a {@link Builder} of {@link SlotDefaultValueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotDefaultValueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotDefaultValueSpecificationProperty> {
            java.lang.Object defaultValueList;

            /**
             * Sets the value of {@link SlotDefaultValueSpecificationProperty#getDefaultValueList}
             * @param defaultValueList A list of default values. This parameter is required.
             *                         Amazon Lex chooses the default value to use in the order that they are presented in the list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueList(software.amazon.awscdk.IResolvable defaultValueList) {
                this.defaultValueList = defaultValueList;
                return this;
            }

            /**
             * Sets the value of {@link SlotDefaultValueSpecificationProperty#getDefaultValueList}
             * @param defaultValueList A list of default values. This parameter is required.
             *                         Amazon Lex chooses the default value to use in the order that they are presented in the list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueList(java.util.List<? extends java.lang.Object> defaultValueList) {
                this.defaultValueList = defaultValueList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotDefaultValueSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotDefaultValueSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotDefaultValueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotDefaultValueSpecificationProperty {
            private final java.lang.Object defaultValueList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultValueList = software.amazon.jsii.Kernel.get(this, "defaultValueList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultValueList = java.util.Objects.requireNonNull(builder.defaultValueList, "defaultValueList is required");
            }

            @Override
            public final java.lang.Object getDefaultValueList() {
                return this.defaultValueList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultValueList", om.valueToTree(this.getDefaultValueList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotDefaultValueSpecificationProperty.Jsii$Proxy that = (SlotDefaultValueSpecificationProperty.Jsii$Proxy) o;

                return this.defaultValueList.equals(that.defaultValueList);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultValueList.hashCode();
                return result;
            }
        }
    }
    /**
     * Sets the priority that Amazon Lex should use when eliciting slot values from a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotPriorityProperty slotPriorityProperty = SlotPriorityProperty.builder()
     *         .priority(123)
     *         .slotName("slotName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotpriority.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotpriority.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotPriorityProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotPriorityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotPriorityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The priority that Amazon Lex should apply to the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotpriority.html#cfn-lex-bot-slotpriority-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotpriority.html#cfn-lex-bot-slotpriority-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * The name of the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotpriority.html#cfn-lex-bot-slotpriority-slotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotpriority.html#cfn-lex-bot-slotpriority-slotname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSlotName();

        /**
         * @return a {@link Builder} of {@link SlotPriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotPriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotPriorityProperty> {
            java.lang.Number priority;
            java.lang.String slotName;

            /**
             * Sets the value of {@link SlotPriorityProperty#getPriority}
             * @param priority The priority that Amazon Lex should apply to the slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link SlotPriorityProperty#getSlotName}
             * @param slotName The name of the slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotName(java.lang.String slotName) {
                this.slotName = slotName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotPriorityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotPriorityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotPriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotPriorityProperty {
            private final java.lang.Number priority;
            private final java.lang.String slotName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.slotName = software.amazon.jsii.Kernel.get(this, "slotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.slotName = java.util.Objects.requireNonNull(builder.slotName, "slotName is required");
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getSlotName() {
                return this.slotName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("priority", om.valueToTree(this.getPriority()));
                data.set("slotName", om.valueToTree(this.getSlotName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotPriorityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotPriorityProperty.Jsii$Proxy that = (SlotPriorityProperty.Jsii$Proxy) o;

                if (!priority.equals(that.priority)) return false;
                return this.slotName.equals(that.slotName);
            }

            @Override
            public final int hashCode() {
                int result = this.priority.hashCode();
                result = 31 * result + (this.slotName.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the definition of a slot.
     * <p>
     * Amazon Lex elicits slot values from uses to fulfill the user's intent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name given to the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the slot type that this slot is based on.
         * <p>
         * The slot type defines the acceptable values for the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-slottypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-slottypename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSlotTypeName();

        /**
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
         * <p>
         * The field can be set to one of the following values:
         * <p>
         * <ul>
         * <li>ORIGINAL_VALUE - Returns the value entered by the user, if the user value is similar to a slot value.</li>
         * <li>TOP_RESOLUTION - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code> , the default is <code>ORIGINAL_VALUE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-valueelicitationsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-valueelicitationsetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValueElicitationSetting();

        /**
         * The description of the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Indicates whether a slot can return multiple values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-multiplevaluessetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-multiplevaluessetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultipleValuesSetting() {
            return null;
        }

        /**
         * Determines whether the contents of the slot are obfuscated in Amazon CloudWatch Logs logs.
         * <p>
         * Use obfuscated slots to protect information such as personally identifiable information (PII) in logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-obfuscationsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slot.html#cfn-lex-bot-slot-obfuscationsetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getObfuscationSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotProperty> {
            java.lang.String name;
            java.lang.String slotTypeName;
            java.lang.Object valueElicitationSetting;
            java.lang.String description;
            java.lang.Object multipleValuesSetting;
            java.lang.Object obfuscationSetting;

            /**
             * Sets the value of {@link SlotProperty#getName}
             * @param name The name given to the slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getSlotTypeName}
             * @param slotTypeName The name of the slot type that this slot is based on. This parameter is required.
             *                     The slot type defines the acceptable values for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypeName(java.lang.String slotTypeName) {
                this.slotTypeName = slotTypeName;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getValueElicitationSetting}
             * @param valueElicitationSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values. This parameter is required.
             *                                The field can be set to one of the following values:
             *                                <p>
             *                                <ul>
             *                                <li>ORIGINAL_VALUE - Returns the value entered by the user, if the user value is similar to a slot value.</li>
             *                                <li>TOP_RESOLUTION - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                                </ul>
             *                                <p>
             *                                If you don't specify the <code>valueSelectionStrategy</code> , the default is <code>ORIGINAL_VALUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueElicitationSetting(software.amazon.awscdk.IResolvable valueElicitationSetting) {
                this.valueElicitationSetting = valueElicitationSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getValueElicitationSetting}
             * @param valueElicitationSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values. This parameter is required.
             *                                The field can be set to one of the following values:
             *                                <p>
             *                                <ul>
             *                                <li>ORIGINAL_VALUE - Returns the value entered by the user, if the user value is similar to a slot value.</li>
             *                                <li>TOP_RESOLUTION - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                                </ul>
             *                                <p>
             *                                If you don't specify the <code>valueSelectionStrategy</code> , the default is <code>ORIGINAL_VALUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueElicitationSetting(software.amazon.awscdk.services.lex.CfnBot.SlotValueElicitationSettingProperty valueElicitationSetting) {
                this.valueElicitationSetting = valueElicitationSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getDescription}
             * @param description The description of the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getMultipleValuesSetting}
             * @param multipleValuesSetting Indicates whether a slot can return multiple values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multipleValuesSetting(software.amazon.awscdk.IResolvable multipleValuesSetting) {
                this.multipleValuesSetting = multipleValuesSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getMultipleValuesSetting}
             * @param multipleValuesSetting Indicates whether a slot can return multiple values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multipleValuesSetting(software.amazon.awscdk.services.lex.CfnBot.MultipleValuesSettingProperty multipleValuesSetting) {
                this.multipleValuesSetting = multipleValuesSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getObfuscationSetting}
             * @param obfuscationSetting Determines whether the contents of the slot are obfuscated in Amazon CloudWatch Logs logs.
             *                           Use obfuscated slots to protect information such as personally identifiable information (PII) in logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obfuscationSetting(software.amazon.awscdk.IResolvable obfuscationSetting) {
                this.obfuscationSetting = obfuscationSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getObfuscationSetting}
             * @param obfuscationSetting Determines whether the contents of the slot are obfuscated in Amazon CloudWatch Logs logs.
             *                           Use obfuscated slots to protect information such as personally identifiable information (PII) in logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obfuscationSetting(software.amazon.awscdk.services.lex.CfnBot.ObfuscationSettingProperty obfuscationSetting) {
                this.obfuscationSetting = obfuscationSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotProperty {
            private final java.lang.String name;
            private final java.lang.String slotTypeName;
            private final java.lang.Object valueElicitationSetting;
            private final java.lang.String description;
            private final java.lang.Object multipleValuesSetting;
            private final java.lang.Object obfuscationSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotTypeName = software.amazon.jsii.Kernel.get(this, "slotTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueElicitationSetting = software.amazon.jsii.Kernel.get(this, "valueElicitationSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.multipleValuesSetting = software.amazon.jsii.Kernel.get(this, "multipleValuesSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.obfuscationSetting = software.amazon.jsii.Kernel.get(this, "obfuscationSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.slotTypeName = java.util.Objects.requireNonNull(builder.slotTypeName, "slotTypeName is required");
                this.valueElicitationSetting = java.util.Objects.requireNonNull(builder.valueElicitationSetting, "valueElicitationSetting is required");
                this.description = builder.description;
                this.multipleValuesSetting = builder.multipleValuesSetting;
                this.obfuscationSetting = builder.obfuscationSetting;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSlotTypeName() {
                return this.slotTypeName;
            }

            @Override
            public final java.lang.Object getValueElicitationSetting() {
                return this.valueElicitationSetting;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getMultipleValuesSetting() {
                return this.multipleValuesSetting;
            }

            @Override
            public final java.lang.Object getObfuscationSetting() {
                return this.obfuscationSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("slotTypeName", om.valueToTree(this.getSlotTypeName()));
                data.set("valueElicitationSetting", om.valueToTree(this.getValueElicitationSetting()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMultipleValuesSetting() != null) {
                    data.set("multipleValuesSetting", om.valueToTree(this.getMultipleValuesSetting()));
                }
                if (this.getObfuscationSetting() != null) {
                    data.set("obfuscationSetting", om.valueToTree(this.getObfuscationSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotProperty.Jsii$Proxy that = (SlotProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!slotTypeName.equals(that.slotTypeName)) return false;
                if (!valueElicitationSetting.equals(that.valueElicitationSetting)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.multipleValuesSetting != null ? !this.multipleValuesSetting.equals(that.multipleValuesSetting) : that.multipleValuesSetting != null) return false;
                return this.obfuscationSetting != null ? this.obfuscationSetting.equals(that.obfuscationSetting) : that.obfuscationSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.slotTypeName.hashCode());
                result = 31 * result + (this.valueElicitationSetting.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.multipleValuesSetting != null ? this.multipleValuesSetting.hashCode() : 0);
                result = 31 * result + (this.obfuscationSetting != null ? this.obfuscationSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a slot type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotTypeProperty slotTypeProperty = SlotTypeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .externalSourceSetting(ExternalSourceSettingProperty.builder()
     *                 .grammarSlotTypeSetting(GrammarSlotTypeSettingProperty.builder()
     *                         .source(GrammarSlotTypeSourceProperty.builder()
     *                                 .s3BucketName("s3BucketName")
     *                                 .s3ObjectKey("s3ObjectKey")
     *                                 // the properties below are optional
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .parentSlotTypeSignature("parentSlotTypeSignature")
     *         .slotTypeValues(List.of(SlotTypeValueProperty.builder()
     *                 .sampleValue(SampleValueProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 // the properties below are optional
     *                 .synonyms(List.of(SampleValueProperty.builder()
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .valueSelectionSetting(SlotValueSelectionSettingProperty.builder()
     *                 .resolutionStrategy("resolutionStrategy")
     *                 // the properties below are optional
     *                 .advancedRecognitionSetting(AdvancedRecognitionSettingProperty.builder()
     *                         .audioRecognitionStrategy("audioRecognitionStrategy")
     *                         .build())
     *                 .regexFilter(SlotValueRegexFilterProperty.builder()
     *                         .pattern("pattern")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the slot type.
         * <p>
         * A slot type name must be unique withing the account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A description of the slot type.
         * <p>
         * Use the description to help identify the slot type in lists.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Sets the type of external information used to create the slot type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-externalsourcesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-externalsourcesetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExternalSourceSetting() {
            return null;
        }

        /**
         * The built-in slot type used as a parent of this slot type.
         * <p>
         * When you define a parent slot type, the new slot type has the configuration of the parent lot type.
         * <p>
         * Only <code>AMAZON.AlphaNumeric</code> is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-parentslottypesignature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-parentslottypesignature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParentSlotTypeSignature() {
            return null;
        }

        /**
         * A list of SlotTypeValue objects that defines the values that the slot type can take.
         * <p>
         * Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-slottypevalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-slottypevalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotTypeValues() {
            return null;
        }

        /**
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
         * <p>
         * The field can be set to one of the following values:
         * <p>
         * <ul>
         * <li><code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</li>
         * <li><code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code> , the default is <code>ORIGINAL_VALUE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-valueselectionsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottype.html#cfn-lex-bot-slottype-valueselectionsetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValueSelectionSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotTypeProperty> {
            java.lang.String name;
            java.lang.String description;
            java.lang.Object externalSourceSetting;
            java.lang.String parentSlotTypeSignature;
            java.lang.Object slotTypeValues;
            java.lang.Object valueSelectionSetting;

            /**
             * Sets the value of {@link SlotTypeProperty#getName}
             * @param name The name of the slot type. This parameter is required.
             *             A slot type name must be unique withing the account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getDescription}
             * @param description A description of the slot type.
             *                    Use the description to help identify the slot type in lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getExternalSourceSetting}
             * @param externalSourceSetting Sets the type of external information used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalSourceSetting(software.amazon.awscdk.IResolvable externalSourceSetting) {
                this.externalSourceSetting = externalSourceSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getExternalSourceSetting}
             * @param externalSourceSetting Sets the type of external information used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalSourceSetting(software.amazon.awscdk.services.lex.CfnBot.ExternalSourceSettingProperty externalSourceSetting) {
                this.externalSourceSetting = externalSourceSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getParentSlotTypeSignature}
             * @param parentSlotTypeSignature The built-in slot type used as a parent of this slot type.
             *                                When you define a parent slot type, the new slot type has the configuration of the parent lot type.
             *                                <p>
             *                                Only <code>AMAZON.AlphaNumeric</code> is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentSlotTypeSignature(java.lang.String parentSlotTypeSignature) {
                this.parentSlotTypeSignature = parentSlotTypeSignature;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getSlotTypeValues}
             * @param slotTypeValues A list of SlotTypeValue objects that defines the values that the slot type can take.
             *                       Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypeValues(software.amazon.awscdk.IResolvable slotTypeValues) {
                this.slotTypeValues = slotTypeValues;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getSlotTypeValues}
             * @param slotTypeValues A list of SlotTypeValue objects that defines the values that the slot type can take.
             *                       Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypeValues(java.util.List<? extends java.lang.Object> slotTypeValues) {
                this.slotTypeValues = slotTypeValues;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getValueSelectionSetting}
             * @param valueSelectionSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
             *                              The field can be set to one of the following values:
             *                              <p>
             *                              <ul>
             *                              <li><code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</li>
             *                              <li><code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                              </ul>
             *                              <p>
             *                              If you don't specify the <code>valueSelectionStrategy</code> , the default is <code>ORIGINAL_VALUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueSelectionSetting(software.amazon.awscdk.IResolvable valueSelectionSetting) {
                this.valueSelectionSetting = valueSelectionSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getValueSelectionSetting}
             * @param valueSelectionSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
             *                              The field can be set to one of the following values:
             *                              <p>
             *                              <ul>
             *                              <li><code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</li>
             *                              <li><code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                              </ul>
             *                              <p>
             *                              If you don't specify the <code>valueSelectionStrategy</code> , the default is <code>ORIGINAL_VALUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueSelectionSetting(software.amazon.awscdk.services.lex.CfnBot.SlotValueSelectionSettingProperty valueSelectionSetting) {
                this.valueSelectionSetting = valueSelectionSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotTypeProperty {
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object externalSourceSetting;
            private final java.lang.String parentSlotTypeSignature;
            private final java.lang.Object slotTypeValues;
            private final java.lang.Object valueSelectionSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalSourceSetting = software.amazon.jsii.Kernel.get(this, "externalSourceSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parentSlotTypeSignature = software.amazon.jsii.Kernel.get(this, "parentSlotTypeSignature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotTypeValues = software.amazon.jsii.Kernel.get(this, "slotTypeValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.valueSelectionSetting = software.amazon.jsii.Kernel.get(this, "valueSelectionSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.externalSourceSetting = builder.externalSourceSetting;
                this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
                this.slotTypeValues = builder.slotTypeValues;
                this.valueSelectionSetting = builder.valueSelectionSetting;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getExternalSourceSetting() {
                return this.externalSourceSetting;
            }

            @Override
            public final java.lang.String getParentSlotTypeSignature() {
                return this.parentSlotTypeSignature;
            }

            @Override
            public final java.lang.Object getSlotTypeValues() {
                return this.slotTypeValues;
            }

            @Override
            public final java.lang.Object getValueSelectionSetting() {
                return this.valueSelectionSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getExternalSourceSetting() != null) {
                    data.set("externalSourceSetting", om.valueToTree(this.getExternalSourceSetting()));
                }
                if (this.getParentSlotTypeSignature() != null) {
                    data.set("parentSlotTypeSignature", om.valueToTree(this.getParentSlotTypeSignature()));
                }
                if (this.getSlotTypeValues() != null) {
                    data.set("slotTypeValues", om.valueToTree(this.getSlotTypeValues()));
                }
                if (this.getValueSelectionSetting() != null) {
                    data.set("valueSelectionSetting", om.valueToTree(this.getValueSelectionSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotTypeProperty.Jsii$Proxy that = (SlotTypeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.externalSourceSetting != null ? !this.externalSourceSetting.equals(that.externalSourceSetting) : that.externalSourceSetting != null) return false;
                if (this.parentSlotTypeSignature != null ? !this.parentSlotTypeSignature.equals(that.parentSlotTypeSignature) : that.parentSlotTypeSignature != null) return false;
                if (this.slotTypeValues != null ? !this.slotTypeValues.equals(that.slotTypeValues) : that.slotTypeValues != null) return false;
                return this.valueSelectionSetting != null ? this.valueSelectionSetting.equals(that.valueSelectionSetting) : that.valueSelectionSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.externalSourceSetting != null ? this.externalSourceSetting.hashCode() : 0);
                result = 31 * result + (this.parentSlotTypeSignature != null ? this.parentSlotTypeSignature.hashCode() : 0);
                result = 31 * result + (this.slotTypeValues != null ? this.slotTypeValues.hashCode() : 0);
                result = 31 * result + (this.valueSelectionSetting != null ? this.valueSelectionSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Each slot type can have a set of values.
     * <p>
     * Each <code>SlotTypeValue</code> represents a value that the slot type can take.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotTypeValueProperty slotTypeValueProperty = SlotTypeValueProperty.builder()
     *         .sampleValue(SampleValueProperty.builder()
     *                 .value("value")
     *                 .build())
     *         // the properties below are optional
     *         .synonyms(List.of(SampleValueProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottypevalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottypevalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotTypeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotTypeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotTypeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of the slot type entry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottypevalue.html#cfn-lex-bot-slottypevalue-samplevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottypevalue.html#cfn-lex-bot-slottypevalue-samplevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSampleValue();

        /**
         * Additional values related to the slot type entry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottypevalue.html#cfn-lex-bot-slottypevalue-synonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slottypevalue.html#cfn-lex-bot-slottypevalue-synonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSynonyms() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotTypeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotTypeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotTypeValueProperty> {
            java.lang.Object sampleValue;
            java.lang.Object synonyms;

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSampleValue}
             * @param sampleValue The value of the slot type entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleValue(software.amazon.awscdk.IResolvable sampleValue) {
                this.sampleValue = sampleValue;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSampleValue}
             * @param sampleValue The value of the slot type entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleValue(software.amazon.awscdk.services.lex.CfnBot.SampleValueProperty sampleValue) {
                this.sampleValue = sampleValue;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSynonyms}
             * @param synonyms Additional values related to the slot type entry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder synonyms(software.amazon.awscdk.IResolvable synonyms) {
                this.synonyms = synonyms;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSynonyms}
             * @param synonyms Additional values related to the slot type entry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder synonyms(java.util.List<? extends java.lang.Object> synonyms) {
                this.synonyms = synonyms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotTypeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotTypeValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotTypeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotTypeValueProperty {
            private final java.lang.Object sampleValue;
            private final java.lang.Object synonyms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sampleValue = software.amazon.jsii.Kernel.get(this, "sampleValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.synonyms = software.amazon.jsii.Kernel.get(this, "synonyms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sampleValue = java.util.Objects.requireNonNull(builder.sampleValue, "sampleValue is required");
                this.synonyms = builder.synonyms;
            }

            @Override
            public final java.lang.Object getSampleValue() {
                return this.sampleValue;
            }

            @Override
            public final java.lang.Object getSynonyms() {
                return this.synonyms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sampleValue", om.valueToTree(this.getSampleValue()));
                if (this.getSynonyms() != null) {
                    data.set("synonyms", om.valueToTree(this.getSynonyms()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotTypeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotTypeValueProperty.Jsii$Proxy that = (SlotTypeValueProperty.Jsii$Proxy) o;

                if (!sampleValue.equals(that.sampleValue)) return false;
                return this.synonyms != null ? this.synonyms.equals(that.synonyms) : that.synonyms == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sampleValue.hashCode();
                result = 31 * result + (this.synonyms != null ? this.synonyms.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the elicitation setting details eliciting a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueElicitationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueElicitationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueElicitationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the slot is required or optional.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-slotconstraint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-slotconstraint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSlotConstraint();

        /**
         * A list of default values for a slot.
         * <p>
         * Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-defaultvaluespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-defaultvaluespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValueSpecification() {
            return null;
        }

        /**
         * The prompt that Amazon Lex uses to elicit the slot value from the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-promptspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-promptspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPromptSpecification() {
            return null;
        }

        /**
         * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
         * <p>
         * This is optional. In most cases, Amazon Lex is capable of understanding user utterances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-sampleutterances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-sampleutterances</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSampleUtterances() {
            return null;
        }

        /**
         * Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-slotcapturesetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-slotcapturesetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotCaptureSetting() {
            return null;
        }

        /**
         * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-waitandcontinuespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueelicitationsetting.html#cfn-lex-bot-slotvalueelicitationsetting-waitandcontinuespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWaitAndContinueSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotValueElicitationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueElicitationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueElicitationSettingProperty> {
            java.lang.String slotConstraint;
            java.lang.Object defaultValueSpecification;
            java.lang.Object promptSpecification;
            java.lang.Object sampleUtterances;
            java.lang.Object slotCaptureSetting;
            java.lang.Object waitAndContinueSpecification;

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSlotConstraint}
             * @param slotConstraint Specifies whether the slot is required or optional. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotConstraint(java.lang.String slotConstraint) {
                this.slotConstraint = slotConstraint;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getDefaultValueSpecification}
             * @param defaultValueSpecification A list of default values for a slot.
             *                                  Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueSpecification(software.amazon.awscdk.IResolvable defaultValueSpecification) {
                this.defaultValueSpecification = defaultValueSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getDefaultValueSpecification}
             * @param defaultValueSpecification A list of default values for a slot.
             *                                  Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueSpecification(software.amazon.awscdk.services.lex.CfnBot.SlotDefaultValueSpecificationProperty defaultValueSpecification) {
                this.defaultValueSpecification = defaultValueSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getPromptSpecification}
             * @param promptSpecification The prompt that Amazon Lex uses to elicit the slot value from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.IResolvable promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getPromptSpecification}
             * @param promptSpecification The prompt that Amazon Lex uses to elicit the slot value from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.services.lex.CfnBot.PromptSpecificationProperty promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSampleUtterances}
             * @param sampleUtterances If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
             *                         This is optional. In most cases, Amazon Lex is capable of understanding user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(software.amazon.awscdk.IResolvable sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSampleUtterances}
             * @param sampleUtterances If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
             *                         This is optional. In most cases, Amazon Lex is capable of understanding user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(java.util.List<? extends java.lang.Object> sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSlotCaptureSetting}
             * @param slotCaptureSetting Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotCaptureSetting(software.amazon.awscdk.IResolvable slotCaptureSetting) {
                this.slotCaptureSetting = slotCaptureSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSlotCaptureSetting}
             * @param slotCaptureSetting Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotCaptureSetting(software.amazon.awscdk.services.lex.CfnBot.SlotCaptureSettingProperty slotCaptureSetting) {
                this.slotCaptureSetting = slotCaptureSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getWaitAndContinueSpecification}
             * @param waitAndContinueSpecification Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitAndContinueSpecification(software.amazon.awscdk.IResolvable waitAndContinueSpecification) {
                this.waitAndContinueSpecification = waitAndContinueSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getWaitAndContinueSpecification}
             * @param waitAndContinueSpecification Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitAndContinueSpecification(software.amazon.awscdk.services.lex.CfnBot.WaitAndContinueSpecificationProperty waitAndContinueSpecification) {
                this.waitAndContinueSpecification = waitAndContinueSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueElicitationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueElicitationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueElicitationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueElicitationSettingProperty {
            private final java.lang.String slotConstraint;
            private final java.lang.Object defaultValueSpecification;
            private final java.lang.Object promptSpecification;
            private final java.lang.Object sampleUtterances;
            private final java.lang.Object slotCaptureSetting;
            private final java.lang.Object waitAndContinueSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.slotConstraint = software.amazon.jsii.Kernel.get(this, "slotConstraint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValueSpecification = software.amazon.jsii.Kernel.get(this, "defaultValueSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.promptSpecification = software.amazon.jsii.Kernel.get(this, "promptSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sampleUtterances = software.amazon.jsii.Kernel.get(this, "sampleUtterances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slotCaptureSetting = software.amazon.jsii.Kernel.get(this, "slotCaptureSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.waitAndContinueSpecification = software.amazon.jsii.Kernel.get(this, "waitAndContinueSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.slotConstraint = java.util.Objects.requireNonNull(builder.slotConstraint, "slotConstraint is required");
                this.defaultValueSpecification = builder.defaultValueSpecification;
                this.promptSpecification = builder.promptSpecification;
                this.sampleUtterances = builder.sampleUtterances;
                this.slotCaptureSetting = builder.slotCaptureSetting;
                this.waitAndContinueSpecification = builder.waitAndContinueSpecification;
            }

            @Override
            public final java.lang.String getSlotConstraint() {
                return this.slotConstraint;
            }

            @Override
            public final java.lang.Object getDefaultValueSpecification() {
                return this.defaultValueSpecification;
            }

            @Override
            public final java.lang.Object getPromptSpecification() {
                return this.promptSpecification;
            }

            @Override
            public final java.lang.Object getSampleUtterances() {
                return this.sampleUtterances;
            }

            @Override
            public final java.lang.Object getSlotCaptureSetting() {
                return this.slotCaptureSetting;
            }

            @Override
            public final java.lang.Object getWaitAndContinueSpecification() {
                return this.waitAndContinueSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("slotConstraint", om.valueToTree(this.getSlotConstraint()));
                if (this.getDefaultValueSpecification() != null) {
                    data.set("defaultValueSpecification", om.valueToTree(this.getDefaultValueSpecification()));
                }
                if (this.getPromptSpecification() != null) {
                    data.set("promptSpecification", om.valueToTree(this.getPromptSpecification()));
                }
                if (this.getSampleUtterances() != null) {
                    data.set("sampleUtterances", om.valueToTree(this.getSampleUtterances()));
                }
                if (this.getSlotCaptureSetting() != null) {
                    data.set("slotCaptureSetting", om.valueToTree(this.getSlotCaptureSetting()));
                }
                if (this.getWaitAndContinueSpecification() != null) {
                    data.set("waitAndContinueSpecification", om.valueToTree(this.getWaitAndContinueSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotValueElicitationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotValueElicitationSettingProperty.Jsii$Proxy that = (SlotValueElicitationSettingProperty.Jsii$Proxy) o;

                if (!slotConstraint.equals(that.slotConstraint)) return false;
                if (this.defaultValueSpecification != null ? !this.defaultValueSpecification.equals(that.defaultValueSpecification) : that.defaultValueSpecification != null) return false;
                if (this.promptSpecification != null ? !this.promptSpecification.equals(that.promptSpecification) : that.promptSpecification != null) return false;
                if (this.sampleUtterances != null ? !this.sampleUtterances.equals(that.sampleUtterances) : that.sampleUtterances != null) return false;
                if (this.slotCaptureSetting != null ? !this.slotCaptureSetting.equals(that.slotCaptureSetting) : that.slotCaptureSetting != null) return false;
                return this.waitAndContinueSpecification != null ? this.waitAndContinueSpecification.equals(that.waitAndContinueSpecification) : that.waitAndContinueSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.slotConstraint.hashCode();
                result = 31 * result + (this.defaultValueSpecification != null ? this.defaultValueSpecification.hashCode() : 0);
                result = 31 * result + (this.promptSpecification != null ? this.promptSpecification.hashCode() : 0);
                result = 31 * result + (this.sampleUtterances != null ? this.sampleUtterances.hashCode() : 0);
                result = 31 * result + (this.slotCaptureSetting != null ? this.slotCaptureSetting.hashCode() : 0);
                result = 31 * result + (this.waitAndContinueSpecification != null ? this.waitAndContinueSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Maps a slot name to the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_SlotValueOverride.html">SlotValueOverride</a> object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * SlotValueOverrideMapProperty slotValueOverrideMapProperty = SlotValueOverrideMapProperty.builder()
     *         .slotName("slotName")
     *         .slotValueOverride(SlotValueOverrideProperty.builder()
     *                 .shape("shape")
     *                 .value(SlotValueProperty.builder()
     *                         .interpretedValue("interpretedValue")
     *                         .build())
     *                 .values(List.of(slotValueOverrideProperty_))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverridemap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverridemap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueOverrideMapProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueOverrideMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueOverrideMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverridemap.html#cfn-lex-bot-slotvalueoverridemap-slotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverridemap.html#cfn-lex-bot-slotvalueoverridemap-slotname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlotName() {
            return null;
        }

        /**
         * The SlotValueOverride object to which the slot name will be mapped.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverridemap.html#cfn-lex-bot-slotvalueoverridemap-slotvalueoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverridemap.html#cfn-lex-bot-slotvalueoverridemap-slotvalueoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotValueOverride() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotValueOverrideMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueOverrideMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueOverrideMapProperty> {
            java.lang.String slotName;
            java.lang.Object slotValueOverride;

            /**
             * Sets the value of {@link SlotValueOverrideMapProperty#getSlotName}
             * @param slotName The name of the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotName(java.lang.String slotName) {
                this.slotName = slotName;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueOverrideMapProperty#getSlotValueOverride}
             * @param slotValueOverride The SlotValueOverride object to which the slot name will be mapped.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotValueOverride(software.amazon.awscdk.IResolvable slotValueOverride) {
                this.slotValueOverride = slotValueOverride;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueOverrideMapProperty#getSlotValueOverride}
             * @param slotValueOverride The SlotValueOverride object to which the slot name will be mapped.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotValueOverride(software.amazon.awscdk.services.lex.CfnBot.SlotValueOverrideProperty slotValueOverride) {
                this.slotValueOverride = slotValueOverride;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueOverrideMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueOverrideMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueOverrideMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueOverrideMapProperty {
            private final java.lang.String slotName;
            private final java.lang.Object slotValueOverride;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.slotName = software.amazon.jsii.Kernel.get(this, "slotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotValueOverride = software.amazon.jsii.Kernel.get(this, "slotValueOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.slotName = builder.slotName;
                this.slotValueOverride = builder.slotValueOverride;
            }

            @Override
            public final java.lang.String getSlotName() {
                return this.slotName;
            }

            @Override
            public final java.lang.Object getSlotValueOverride() {
                return this.slotValueOverride;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSlotName() != null) {
                    data.set("slotName", om.valueToTree(this.getSlotName()));
                }
                if (this.getSlotValueOverride() != null) {
                    data.set("slotValueOverride", om.valueToTree(this.getSlotValueOverride()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotValueOverrideMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotValueOverrideMapProperty.Jsii$Proxy that = (SlotValueOverrideMapProperty.Jsii$Proxy) o;

                if (this.slotName != null ? !this.slotName.equals(that.slotName) : that.slotName != null) return false;
                return this.slotValueOverride != null ? this.slotValueOverride.equals(that.slotValueOverride) : that.slotValueOverride == null;
            }

            @Override
            public final int hashCode() {
                int result = this.slotName != null ? this.slotName.hashCode() : 0;
                result = 31 * result + (this.slotValueOverride != null ? this.slotValueOverride.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The slot values that Amazon Lex uses when it sets slot values in a dialog step.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueOverrideProperty slotValueOverrideProperty_;
     * SlotValueOverrideProperty slotValueOverrideProperty = SlotValueOverrideProperty.builder()
     *         .shape("shape")
     *         .value(SlotValueProperty.builder()
     *                 .interpretedValue("interpretedValue")
     *                 .build())
     *         .values(List.of(slotValueOverrideProperty_))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When the shape value is <code>List</code> , it indicates that the <code>values</code> field contains a list of slot values.
         * <p>
         * When the value is <code>Scalar</code> , it indicates that the <code>value</code> field contains a single value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html#cfn-lex-bot-slotvalueoverride-shape">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html#cfn-lex-bot-slotvalueoverride-shape</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShape() {
            return null;
        }

        /**
         * The current value of the slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html#cfn-lex-bot-slotvalueoverride-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html#cfn-lex-bot-slotvalueoverride-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * A list of one or more values that the user provided for the slot.
         * <p>
         * For example, for a slot that elicits pizza toppings, the values might be "pepperoni" and "pineapple."
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html#cfn-lex-bot-slotvalueoverride-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueoverride.html#cfn-lex-bot-slotvalueoverride-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotValueOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueOverrideProperty> {
            java.lang.String shape;
            java.lang.Object value;
            java.lang.Object values;

            /**
             * Sets the value of {@link SlotValueOverrideProperty#getShape}
             * @param shape When the shape value is <code>List</code> , it indicates that the <code>values</code> field contains a list of slot values.
             *              When the value is <code>Scalar</code> , it indicates that the <code>value</code> field contains a single value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shape(java.lang.String shape) {
                this.shape = shape;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueOverrideProperty#getValue}
             * @param value The current value of the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueOverrideProperty#getValue}
             * @param value The current value of the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.lex.CfnBot.SlotValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueOverrideProperty#getValues}
             * @param values A list of one or more values that the user provided for the slot.
             *               For example, for a slot that elicits pizza toppings, the values might be "pepperoni" and "pineapple."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueOverrideProperty#getValues}
             * @param values A list of one or more values that the user provided for the slot.
             *               For example, for a slot that elicits pizza toppings, the values might be "pepperoni" and "pineapple."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Object> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueOverrideProperty {
            private final java.lang.String shape;
            private final java.lang.Object value;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.shape = software.amazon.jsii.Kernel.get(this, "shape", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.shape = builder.shape;
                this.value = builder.value;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getShape() {
                return this.shape;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getShape() != null) {
                    data.set("shape", om.valueToTree(this.getShape()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotValueOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotValueOverrideProperty.Jsii$Proxy that = (SlotValueOverrideProperty.Jsii$Proxy) o;

                if (this.shape != null ? !this.shape.equals(that.shape) : that.shape != null) return false;
                if (this.value != null ? !this.value.equals(that.value) : that.value != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.shape != null ? this.shape.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The value to set in a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueProperty slotValueProperty = SlotValueProperty.builder()
     *         .interpretedValue("interpretedValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value that Amazon Lex determines for the slot.
         * <p>
         * The actual value depends on the setting of the value selection strategy for the bot. You can choose to use the value entered by the user, or you can have Amazon Lex choose the first value in the <code>resolvedValues</code> list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalue.html#cfn-lex-bot-slotvalue-interpretedvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalue.html#cfn-lex-bot-slotvalue-interpretedvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInterpretedValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueProperty> {
            java.lang.String interpretedValue;

            /**
             * Sets the value of {@link SlotValueProperty#getInterpretedValue}
             * @param interpretedValue The value that Amazon Lex determines for the slot.
             *                         The actual value depends on the setting of the value selection strategy for the bot. You can choose to use the value entered by the user, or you can have Amazon Lex choose the first value in the <code>resolvedValues</code> list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interpretedValue(java.lang.String interpretedValue) {
                this.interpretedValue = interpretedValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueProperty {
            private final java.lang.String interpretedValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interpretedValue = software.amazon.jsii.Kernel.get(this, "interpretedValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interpretedValue = builder.interpretedValue;
            }

            @Override
            public final java.lang.String getInterpretedValue() {
                return this.interpretedValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInterpretedValue() != null) {
                    data.set("interpretedValue", om.valueToTree(this.getInterpretedValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotValueProperty.Jsii$Proxy that = (SlotValueProperty.Jsii$Proxy) o;

                return this.interpretedValue != null ? this.interpretedValue.equals(that.interpretedValue) : that.interpretedValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.interpretedValue != null ? this.interpretedValue.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides a regular expression used to validate the value of a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueRegexFilterProperty slotValueRegexFilterProperty = SlotValueRegexFilterProperty.builder()
     *         .pattern("pattern")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueregexfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueregexfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueRegexFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueRegexFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueRegexFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A regular expression used to validate the value of a slot.
         * <p>
         * Use a standard regular expression. Amazon Lex supports the following characters in the regular expression:
         * <p>
         * <ul>
         * <li>A-Z, a-z</li>
         * <li>0-9</li>
         * <li>Unicode characters ("\⁠u<Unicode>")</li>
         * </ul>
         * <p>
         * Represent Unicode characters with four digits, for example "\⁠u0041" or "\⁠u005A".
         * <p>
         * The following regular expression operators are not supported:
         * <p>
         * <ul>
         * <li>Infinite repeaters: *, +, or {x,} with no upper bound.</li>
         * <li>Wild card (.)</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueregexfilter.html#cfn-lex-bot-slotvalueregexfilter-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lex-bot-slotvalueregexfilter.html#cfn-lex-bot-slotvalueregexfilter-pattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPattern();

        /**
         * @return a {@link Builder} of {@link SlotValueRegexFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueRegexFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueRegexFilterProperty> {
            java.lang.String pattern;

            /**
             * Sets the value of {@link SlotValueRegexFilterProperty#getPattern}
             * @param pattern A regular expression used to validate the value of a slot. This parameter is required.
             *                Use a standard regular expression. Amazon Lex supports the following characters in the regular expression:
             *                <p>
             *                <ul>
             *                <li>A-Z, a-z</li>
             *                <li>0-9</li>
             *                <li>Unicode characters ("\⁠u<Unicode>")</li>
             *                </ul>
             *                <p>
             *                Represent Unicode characters with four digits, for example "\⁠u0041" or "\⁠u005A".
             *                <p>
             *                The following regular expression operators are not supported:
             *                <p>
             *                <ul>
             *                <li>Infinite repeaters: *, +, or {x,} with no upper bound.</li>
             *                <li>Wild card (.)</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueRegexFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueRegexFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueRegexFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueRegexFilterProperty {
            private final java.lang.String pattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
               