package software.amazon.awscdk.services.route53;

/**
 * Container for records, and records contain information about how to route traffic for a specific domain, such as example.com and its subdomains (acme.example.com, zenith.example.com).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key kmsKey = Key.Builder.create(this, "KmsCMK")
 *         .keySpec(KeySpec.ECC_NIST_P256)
 *         .keyUsage(KeyUsage.SIGN_VERIFY)
 *         .build();
 * HostedZone hostedZone = HostedZone.Builder.create(this, "HostedZone")
 *         .zoneName("example.com")
 *         .build();
 * // Enable DNSSEC signing for the zone
 * hostedZone.enableDnssec(ZoneSigningOptions.builder().kmsKey(kmsKey).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:15.216Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.HostedZone")
public class HostedZone extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.route53.IHostedZone {

    protected HostedZone(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HostedZone(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HostedZone(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HostedZoneProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a hosted zone from another stack.
     * <p>
     * Use when both hosted zone ID and hosted zone name are known.
     * <p>
     * @param scope the parent Construct for this Construct. This parameter is required.
     * @param id the logical name of this Construct. This parameter is required.
     * @param attrs the HostedZoneAttributes (hosted zone ID and hosted zone name). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone fromHostedZoneAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HostedZoneAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HostedZone.class, "fromHostedZoneAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import a Route 53 hosted zone defined either outside the CDK, or in a different CDK stack.
     * <p>
     * Use when hosted zone ID is known. If a HostedZone is imported with this method the zoneName cannot be referenced.
     * If the zoneName is needed then the HostedZone should be imported with <code>fromHostedZoneAttributes()</code> or <code>fromLookup()</code>
     * <p>
     * @param scope the parent Construct for this Construct. This parameter is required.
     * @param id the logical name of this Construct. This parameter is required.
     * @param hostedZoneId the ID of the hosted zone to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone fromHostedZoneId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String hostedZoneId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HostedZone.class, "fromHostedZoneId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(hostedZoneId, "hostedZoneId is required") });
    }

    /**
     * Lookup a hosted zone in the current account/region based on query parameters.
     * <p>
     * Requires environment, you must specify env for the stack.
     * <p>
     * Use to easily query hosted zones.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cdk/latest/guide/environments.html">https://docs.aws.amazon.com/cdk/latest/guide/environments.html</a>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param query This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HostedZoneProviderProps query) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HostedZone.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(query, "query is required") });
    }

    /**
     * Add another VPC to this private hosted zone.
     * <p>
     * @param vpc the other VPC to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addVpc(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc) {
        software.amazon.jsii.Kernel.call(this, "addVpc", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required") });
    }

    /**
     * Enable DNSSEC for this hosted zone.
     * <p>
     * This will create a key signing key with the given options and enable DNSSEC signing
     * for the hosted zone.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IKeySigningKey enableDnssec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.ZoneSigningOptions options) {
        return software.amazon.jsii.Kernel.call(this, "enableDnssec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IKeySigningKey.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Grant permissions to add delegation records to this zone.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDelegation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantDelegation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * ARN of this hosted zone, such as arn:${Partition}:route53:::hostedzone/${Id}.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneArn() {
        return software.amazon.jsii.Kernel.get(this, "hostedZoneArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ID of this hosted zone, such as "Z23ABC4XYZL05B".
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * VPCs to which this hosted zone will be added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.route53.CfnHostedZone.VPCProperty> getVpcs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "vpcs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.CfnHostedZone.VPCProperty.class))));
    }

    /**
     * FQDN of this hosted zone.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getZoneName() {
        return software.amazon.jsii.Kernel.get(this, "zoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the set of name servers for the specific hosted zone. For example: ns1.example.com.
     * <p>
     * This attribute will be undefined for private hosted zones or hosted zones imported from another stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHostedZoneNameServers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "hostedZoneNameServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.HostedZone}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.HostedZone> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.HostedZoneProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.HostedZoneProps.Builder();
        }

        /**
         * The name of the domain.
         * <p>
         * For resource record types that include a domain
         * name, specify a fully qualified domain name.
         * <p>
         * @return {@code this}
         * @param zoneName The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(final java.lang.String zoneName) {
            this.props.zoneName(zoneName);
            return this;
        }

        /**
         * Whether to add a trailing dot to the zone name.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param addTrailingDot Whether to add a trailing dot to the zone name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addTrailingDot(final java.lang.Boolean addTrailingDot) {
            this.props.addTrailingDot(addTrailingDot);
            return this;
        }

        /**
         * Any comments that you want to include about the hosted zone.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param comment Any comments that you want to include about the hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
         * <p>
         * Default: disabled
         * <p>
         * @return {@code this}
         * @param queryLogsLogGroupArn The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogsLogGroupArn(final java.lang.String queryLogsLogGroupArn) {
            this.props.queryLogsLogGroupArn(queryLogsLogGroupArn);
            return this;
        }

        /**
         * A VPC that you want to associate with this hosted zone.
         * <p>
         * When you specify
         * this property, a private hosted zone will be created.
         * <p>
         * You can associate additional VPCs to this private zone using <code>addVpc(vpc)</code>.
         * <p>
         * Default: public (no VPCs associated)
         * <p>
         * @return {@code this}
         * @param vpcs A VPC that you want to associate with this hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcs(final java.util.List<? extends software.amazon.awscdk.services.ec2.IVpc> vpcs) {
            this.props.vpcs(vpcs);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53.HostedZone}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.HostedZone build() {
            return new software.amazon.awscdk.services.route53.HostedZone(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
