package software.amazon.awscdk.services.route53;

/**
 * A Key Signing Key for a Route 53 Hosted Zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone hostedZone;
 * Key kmsKey;
 * KeySigningKey.Builder.create(this, "KeySigningKey")
 *         .hostedZone(hostedZone)
 *         .kmsKey(kmsKey)
 *         .keySigningKeyName("ksk")
 *         .status(KeySigningKeyStatus.ACTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:15.221Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.KeySigningKey")
public class KeySigningKey extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.route53.IKeySigningKey {

    protected KeySigningKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KeySigningKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KeySigningKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.KeySigningKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a key signing key from its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IKeySigningKey fromKeySigningKeyAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.KeySigningKeyAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.KeySigningKey.class, "fromKeySigningKeyAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IKeySigningKey.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The hosted zone that the key signing key signs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
        return software.amazon.jsii.Kernel.get(this, "hostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
    }

    /**
     * The ID of the key signing key, derived from the hosted zone ID and its name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeySigningKeyId() {
        return software.amazon.jsii.Kernel.get(this, "keySigningKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the key signing key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeySigningKeyName() {
        return software.amazon.jsii.Kernel.get(this, "keySigningKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.KeySigningKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.KeySigningKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.KeySigningKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.KeySigningKeyProps.Builder();
        }

        /**
         * The hosted zone that this key will be used to sign.
         * <p>
         * @return {@code this}
         * @param hostedZone The hosted zone that this key will be used to sign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(final software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.props.hostedZone(hostedZone);
            return this;
        }

        /**
         * The customer-managed KMS key that that will be used to sign the records.
         * <p>
         * The KMS Key must be unique for each KSK within a hosted zone. Additionally, the
         * KMS key must be an asymetric customer-managed key using the ECC_NIST_P256 algorithm.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html">https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html</a>
         * @param kmsKey The customer-managed KMS key that that will be used to sign the records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * The name for the key signing key.
         * <p>
         * This name must be unique within a hosted zone.
         * <p>
         * Default: an autogenerated name
         * <p>
         * @return {@code this}
         * @param keySigningKeyName The name for the key signing key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySigningKeyName(final java.lang.String keySigningKeyName) {
            this.props.keySigningKeyName(keySigningKeyName);
            return this;
        }

        /**
         * The status of the key signing key.
         * <p>
         * Default: ACTIVE
         * <p>
         * @return {@code this}
         * @param status The status of the key signing key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final software.amazon.awscdk.services.route53.KeySigningKeyStatus status) {
            this.props.status(status);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53.KeySigningKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.KeySigningKey build() {
            return new software.amazon.awscdk.services.route53.KeySigningKey(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
