package software.amazon.awscdk.services.route53recoverycontrol;

/**
 * Creates a safety rule in a control panel in Amazon Route 53 Application Recovery Controller.
 * <p>
 * Safety rules in Amazon Route 53 Application Recovery Controller let you add safeguards around changing routing control states, and enabling and disabling routing controls, to help prevent unwanted outcomes. Note that the name of a safety rule must be unique within a control panel.
 * <p>
 * There are two types of safety rules in Route 53 ARC: assertion rules and gating rules.
 * <p>
 * Assertion rule: An assertion rule enforces that, when you change a routing control state, certain criteria are met. For example, the criteria might be that at least one routing control state is <code>On</code> after the transaction completes so that traffic continues to be directed to at least one cell for the application. This prevents a fail-open scenario.
 * <p>
 * Gating rule: A gating rule lets you configure a gating routing control as an overall on-off switch for a group of routing controls. Or, you can configure more complex gating scenarios, for example, by configuring multiple gating routing controls.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html">Safety rules</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53recoverycontrol.*;
 * CfnSafetyRule cfnSafetyRule = CfnSafetyRule.Builder.create(this, "MyCfnSafetyRule")
 *         .controlPanelArn("controlPanelArn")
 *         .name("name")
 *         .ruleConfig(RuleConfigProperty.builder()
 *                 .inverted(false)
 *                 .threshold(123)
 *                 .type("type")
 *                 .build())
 *         // the properties below are optional
 *         .assertionRule(AssertionRuleProperty.builder()
 *                 .assertedControls(List.of("assertedControls"))
 *                 .waitPeriodMs(123)
 *                 .build())
 *         .gatingRule(GatingRuleProperty.builder()
 *                 .gatingControls(List.of("gatingControls"))
 *                 .targetControls(List.of("targetControls"))
 *                 .waitPeriodMs(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:15.278Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRule")
public class CfnSafetyRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnSafetyRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSafetyRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSafetyRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the safety rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSafetyRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSafetyRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The deployment status of the safety rule.
     * <p>
     * Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the control panel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getControlPanelArn() {
        return software.amazon.jsii.Kernel.get(this, "controlPanelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the control panel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setControlPanelArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "controlPanelArn", java.util.Objects.requireNonNull(value, "controlPanelArn is required"));
    }

    /**
     * The name of the assertion rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the assertion rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRuleConfig() {
        return software.amazon.jsii.Kernel.get(this, "ruleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ruleConfig", java.util.Objects.requireNonNull(value, "ruleConfig is required"));
    }

    /**
     * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.RuleConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "ruleConfig", java.util.Objects.requireNonNull(value, "ruleConfig is required"));
    }

    /**
     * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssertionRule() {
        return software.amazon.jsii.Kernel.get(this, "assertionRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssertionRule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assertionRule", value);
    }

    /**
     * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssertionRule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.AssertionRuleProperty value) {
        software.amazon.jsii.Kernel.set(this, "assertionRule", value);
    }

    /**
     * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGatingRule() {
        return software.amazon.jsii.Kernel.get(this, "gatingRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatingRule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gatingRule", value);
    }

    /**
     * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatingRule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.GatingRuleProperty value) {
        software.amazon.jsii.Kernel.set(this, "gatingRule", value);
    }

    /**
     * The tags associated with the safety rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags associated with the safety rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
     * <p>
     * Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is <code>On</code> after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoverycontrol.*;
     * AssertionRuleProperty assertionRuleProperty = AssertionRuleProperty.builder()
     *         .assertedControls(List.of("assertedControls"))
     *         .waitPeriodMs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-assertionrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-assertionrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRule.AssertionRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(AssertionRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssertionRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
         * <p>
         * For example, you might include three routing controls, one for each of three AWS Regions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-assertionrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule-assertedcontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-assertionrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule-assertedcontrols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAssertedControls();

        /**
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
         * <p>
         * This helps prevent flapping of state. The wait period is 5000 ms by default, but you can choose a custom value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-assertionrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule-waitperiodms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-assertionrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule-waitperiodms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWaitPeriodMs();

        /**
         * @return a {@link Builder} of {@link AssertionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssertionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssertionRuleProperty> {
            java.util.List<java.lang.String> assertedControls;
            java.lang.Number waitPeriodMs;

            /**
             * Sets the value of {@link AssertionRuleProperty#getAssertedControls}
             * @param assertedControls The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. This parameter is required.
             *                         For example, you might include three routing controls, one for each of three AWS Regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assertedControls(java.util.List<java.lang.String> assertedControls) {
                this.assertedControls = assertedControls;
                return this;
            }

            /**
             * Sets the value of {@link AssertionRuleProperty#getWaitPeriodMs}
             * @param waitPeriodMs An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This parameter is required.
             *                     This helps prevent flapping of state. The wait period is 5000 ms by default, but you can choose a custom value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitPeriodMs(java.lang.Number waitPeriodMs) {
                this.waitPeriodMs = waitPeriodMs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssertionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssertionRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssertionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssertionRuleProperty {
            private final java.util.List<java.lang.String> assertedControls;
            private final java.lang.Number waitPeriodMs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assertedControls = software.amazon.jsii.Kernel.get(this, "assertedControls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.waitPeriodMs = software.amazon.jsii.Kernel.get(this, "waitPeriodMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assertedControls = java.util.Objects.requireNonNull(builder.assertedControls, "assertedControls is required");
                this.waitPeriodMs = java.util.Objects.requireNonNull(builder.waitPeriodMs, "waitPeriodMs is required");
            }

            @Override
            public final java.util.List<java.lang.String> getAssertedControls() {
                return this.assertedControls;
            }

            @Override
            public final java.lang.Number getWaitPeriodMs() {
                return this.waitPeriodMs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("assertedControls", om.valueToTree(this.getAssertedControls()));
                data.set("waitPeriodMs", om.valueToTree(this.getWaitPeriodMs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRule.AssertionRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssertionRuleProperty.Jsii$Proxy that = (AssertionRuleProperty.Jsii$Proxy) o;

                if (!assertedControls.equals(that.assertedControls)) return false;
                return this.waitPeriodMs.equals(that.waitPeriodMs);
            }

            @Override
            public final int hashCode() {
                int result = this.assertedControls.hashCode();
                result = 31 * result + (this.waitPeriodMs.hashCode());
                return result;
            }
        }
    }
    /**
     * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
     * <p>
     * For example, if you specify one gating routing control and you set the <code>Type</code> in the rule configuration to <code>OR</code> , that indicates that you must set the gating routing control to <code>On</code> for the rule to evaluate as true; that is, for the gating control switch to be On. When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoverycontrol.*;
     * GatingRuleProperty gatingRuleProperty = GatingRuleProperty.builder()
     *         .gatingControls(List.of("gatingControls"))
     *         .targetControls(List.of("targetControls"))
     *         .waitPeriodMs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRule.GatingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(GatingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of gating routing control Amazon Resource Names (ARNs).
         * <p>
         * For a simple on-off switch, specify the ARN for one routing control. The gating routing controls are evaluated by the rule configuration that you specify to determine if the target routing control states can be changed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule-gatingcontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule-gatingcontrols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getGatingControls();

        /**
         * An array of target routing control Amazon Resource Names (ARNs) for which the states can only be updated if the rule configuration that you specify evaluates to true for the gating routing control.
         * <p>
         * As a simple example, if you have a single gating control, it acts as an overall on-off switch for a set of target routing controls. You can use this to manually override automated failover, for example.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule-targetcontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule-targetcontrols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetControls();

        /**
         * An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
         * <p>
         * This helps prevent flapping of state. The wait period is 5000 ms by default, but you can choose a custom value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule-waitperiodms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-gatingrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule-waitperiodms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWaitPeriodMs();

        /**
         * @return a {@link Builder} of {@link GatingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatingRuleProperty> {
            java.util.List<java.lang.String> gatingControls;
            java.util.List<java.lang.String> targetControls;
            java.lang.Number waitPeriodMs;

            /**
             * Sets the value of {@link GatingRuleProperty#getGatingControls}
             * @param gatingControls An array of gating routing control Amazon Resource Names (ARNs). This parameter is required.
             *                       For a simple on-off switch, specify the ARN for one routing control. The gating routing controls are evaluated by the rule configuration that you specify to determine if the target routing control states can be changed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gatingControls(java.util.List<java.lang.String> gatingControls) {
                this.gatingControls = gatingControls;
                return this;
            }

            /**
             * Sets the value of {@link GatingRuleProperty#getTargetControls}
             * @param targetControls An array of target routing control Amazon Resource Names (ARNs) for which the states can only be updated if the rule configuration that you specify evaluates to true for the gating routing control. This parameter is required.
             *                       As a simple example, if you have a single gating control, it acts as an overall on-off switch for a set of target routing controls. You can use this to manually override automated failover, for example.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetControls(java.util.List<java.lang.String> targetControls) {
                this.targetControls = targetControls;
                return this;
            }

            /**
             * Sets the value of {@link GatingRuleProperty#getWaitPeriodMs}
             * @param waitPeriodMs An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This parameter is required.
             *                     This helps prevent flapping of state. The wait period is 5000 ms by default, but you can choose a custom value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitPeriodMs(java.lang.Number waitPeriodMs) {
                this.waitPeriodMs = waitPeriodMs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatingRuleProperty {
            private final java.util.List<java.lang.String> gatingControls;
            private final java.util.List<java.lang.String> targetControls;
            private final java.lang.Number waitPeriodMs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gatingControls = software.amazon.jsii.Kernel.get(this, "gatingControls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.targetControls = software.amazon.jsii.Kernel.get(this, "targetControls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.waitPeriodMs = software.amazon.jsii.Kernel.get(this, "waitPeriodMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gatingControls = java.util.Objects.requireNonNull(builder.gatingControls, "gatingControls is required");
                this.targetControls = java.util.Objects.requireNonNull(builder.targetControls, "targetControls is required");
                this.waitPeriodMs = java.util.Objects.requireNonNull(builder.waitPeriodMs, "waitPeriodMs is required");
            }

            @Override
            public final java.util.List<java.lang.String> getGatingControls() {
                return this.gatingControls;
            }

            @Override
            public final java.util.List<java.lang.String> getTargetControls() {
                return this.targetControls;
            }

            @Override
            public final java.lang.Number getWaitPeriodMs() {
                return this.waitPeriodMs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("gatingControls", om.valueToTree(this.getGatingControls()));
                data.set("targetControls", om.valueToTree(this.getTargetControls()));
                data.set("waitPeriodMs", om.valueToTree(this.getWaitPeriodMs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRule.GatingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatingRuleProperty.Jsii$Proxy that = (GatingRuleProperty.Jsii$Proxy) o;

                if (!gatingControls.equals(that.gatingControls)) return false;
                if (!targetControls.equals(that.targetControls)) return false;
                return this.waitPeriodMs.equals(that.waitPeriodMs);
            }

            @Override
            public final int hashCode() {
                int result = this.gatingControls.hashCode();
                result = 31 * result + (this.targetControls.hashCode());
                result = 31 * result + (this.waitPeriodMs.hashCode());
                return result;
            }
        }
    }
    /**
     * The rule configuration for an assertion rule.
     * <p>
     * That is, the criteria that you set for specific assertion controls (routing controls) that specify how many controls must be enabled after a transaction completes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoverycontrol.*;
     * RuleConfigProperty ruleConfigProperty = RuleConfigProperty.builder()
     *         .inverted(false)
     *         .threshold(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRule.RuleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Logical negation of the rule.
         * <p>
         * If the rule would usually evaluate true, it's evaluated as false, and vice versa.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html#cfn-route53recoverycontrol-safetyrule-ruleconfig-inverted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html#cfn-route53recoverycontrol-safetyrule-ruleconfig-inverted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInverted();

        /**
         * The value of N, when you specify an <code>ATLEAST</code> rule type.
         * <p>
         * That is, <code>Threshold</code> is the number of controls that must be set when you specify an <code>ATLEAST</code> type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html#cfn-route53recoverycontrol-safetyrule-ruleconfig-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html#cfn-route53recoverycontrol-safetyrule-ruleconfig-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

        /**
         * A rule can be one of the following: <code>ATLEAST</code> , <code>AND</code> , or <code>OR</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html#cfn-route53recoverycontrol-safetyrule-ruleconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoverycontrol-safetyrule-ruleconfig.html#cfn-route53recoverycontrol-safetyrule-ruleconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link RuleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleConfigProperty> {
            java.lang.Object inverted;
            java.lang.Number threshold;
            java.lang.String type;

            /**
             * Sets the value of {@link RuleConfigProperty#getInverted}
             * @param inverted Logical negation of the rule. This parameter is required.
             *                 If the rule would usually evaluate true, it's evaluated as false, and vice versa.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inverted(java.lang.Boolean inverted) {
                this.inverted = inverted;
                return this;
            }

            /**
             * Sets the value of {@link RuleConfigProperty#getInverted}
             * @param inverted Logical negation of the rule. This parameter is required.
             *                 If the rule would usually evaluate true, it's evaluated as false, and vice versa.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inverted(software.amazon.awscdk.IResolvable inverted) {
                this.inverted = inverted;
                return this;
            }

            /**
             * Sets the value of {@link RuleConfigProperty#getThreshold}
             * @param threshold The value of N, when you specify an <code>ATLEAST</code> rule type. This parameter is required.
             *                  That is, <code>Threshold</code> is the number of controls that must be set when you specify an <code>ATLEAST</code> type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link RuleConfigProperty#getType}
             * @param type A rule can be one of the following: <code>ATLEAST</code> , <code>AND</code> , or <code>OR</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleConfigProperty {
            private final java.lang.Object inverted;
            private final java.lang.Number threshold;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inverted = software.amazon.jsii.Kernel.get(this, "inverted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inverted = java.util.Objects.requireNonNull(builder.inverted, "inverted is required");
                this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getInverted() {
                return this.inverted;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inverted", om.valueToTree(this.getInverted()));
                data.set("threshold", om.valueToTree(this.getThreshold()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRule.RuleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleConfigProperty.Jsii$Proxy that = (RuleConfigProperty.Jsii$Proxy) o;

                if (!inverted.equals(that.inverted)) return false;
                if (!threshold.equals(that.threshold)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.inverted.hashCode();
                result = 31 * result + (this.threshold.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRuleProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the control panel.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-controlpanelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-controlpanelarn</a>
         * @param controlPanelArn The Amazon Resource Name (ARN) of the control panel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder controlPanelArn(final java.lang.String controlPanelArn) {
            this.props.controlPanelArn(controlPanelArn);
            return this;
        }

        /**
         * The name of the assertion rule.
         * <p>
         * The name must be unique within a control panel. You can use any non-white space character in the name except the following: &amp; &gt; &lt; ' (single quote) " (double quote) ; (semicolon)
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-name</a>
         * @param name The name of the assertion rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction.
         * <p>
         * For example, if you have three assertion controls, you might specify <code>ATLEAST 2</code> for your rule configuration. This means that at least two assertion controls must be <code>ON</code> , so that at least two AWS Regions have traffic flowing to them.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-ruleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-ruleconfig</a>
         * @param ruleConfig The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleConfig(final software.amazon.awscdk.IResolvable ruleConfig) {
            this.props.ruleConfig(ruleConfig);
            return this;
        }
        /**
         * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction.
         * <p>
         * For example, if you have three assertion controls, you might specify <code>ATLEAST 2</code> for your rule configuration. This means that at least two assertion controls must be <code>ON</code> , so that at least two AWS Regions have traffic flowing to them.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-ruleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-ruleconfig</a>
         * @param ruleConfig The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleConfig(final software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.RuleConfigProperty ruleConfig) {
            this.props.ruleConfig(ruleConfig);
            return this;
        }

        /**
         * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
         * <p>
         * Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is <code>On</code> after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule</a>
         * @param assertionRule An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertionRule(final software.amazon.awscdk.IResolvable assertionRule) {
            this.props.assertionRule(assertionRule);
            return this;
        }
        /**
         * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
         * <p>
         * Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is <code>On</code> after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule</a>
         * @param assertionRule An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertionRule(final software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.AssertionRuleProperty assertionRule) {
            this.props.assertionRule(assertionRule);
            return this;
        }

        /**
         * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
         * <p>
         * For example, if you specify one gating routing control and you set the <code>Type</code> in the rule configuration to <code>OR</code> , that indicates that you must set the gating routing control to <code>On</code> for the rule to evaluate as true; that is, for the gating control switch to be On. When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule</a>
         * @param gatingRule A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatingRule(final software.amazon.awscdk.IResolvable gatingRule) {
            this.props.gatingRule(gatingRule);
            return this;
        }
        /**
         * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
         * <p>
         * For example, if you specify one gating routing control and you set the <code>Type</code> in the rule configuration to <code>OR</code> , that indicates that you must set the gating routing control to <code>On</code> for the rule to evaluate as true; that is, for the gating control switch to be On. When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule</a>
         * @param gatingRule A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatingRule(final software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.GatingRuleProperty gatingRule) {
            this.props.gatingRule(gatingRule);
            return this;
        }

        /**
         * The tags associated with the safety rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-tags</a>
         * @param tags The tags associated with the safety rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule build() {
            return new software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
