package software.amazon.awscdk.services.s3outposts;

/**
 * Properties for defining a <code>CfnEndpoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3outposts.*;
 * CfnEndpointProps cfnEndpointProps = CfnEndpointProps.builder()
 *         .outpostId("outpostId")
 *         .securityGroupId("securityGroupId")
 *         .subnetId("subnetId")
 *         // the properties below are optional
 *         .accessType("accessType")
 *         .customerOwnedIpv4Pool("customerOwnedIpv4Pool")
 *         .failedReason(FailedReasonProperty.builder()
 *                 .errorCode("errorCode")
 *                 .message("message")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:15.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3outposts.CfnEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Outpost.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-outpostid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-outpostid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOutpostId();

    /**
     * The ID of the security group used for the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-securitygroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-securitygroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId();

    /**
     * The ID of the subnet used for the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-subnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * The container for the type of connectivity used to access the Amazon S3 on Outposts endpoint.
     * <p>
     * To use the Amazon VPC , choose <code>Private</code> . To use the endpoint with an on-premises network, choose <code>CustomerOwnedIp</code> . If you choose <code>CustomerOwnedIp</code> , you must also provide the customer-owned IP address pool (CoIP pool).
     * <p>
     * <blockquote>
     * <p>
     * <code>Private</code> is the default access type value.
     * <p>
     * </blockquote>
     * <p>
     * Default: - "Private"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-accesstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-accesstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessType() {
        return null;
    }

    /**
     * The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint.
     * <p>
     * IP addresses are allocated from this pool for the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-customerownedipv4pool">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-customerownedipv4pool</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerOwnedIpv4Pool() {
        return null;
    }

    /**
     * The failure reason, if any, for a create or delete endpoint operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-failedreason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3outposts-endpoint.html#cfn-s3outposts-endpoint-failedreason</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFailedReason() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointProps> {
        java.lang.String outpostId;
        java.lang.String securityGroupId;
        java.lang.String subnetId;
        java.lang.String accessType;
        java.lang.String customerOwnedIpv4Pool;
        java.lang.Object failedReason;

        /**
         * Sets the value of {@link CfnEndpointProps#getOutpostId}
         * @param outpostId The ID of the Outpost. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostId(java.lang.String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getSecurityGroupId}
         * @param securityGroupId The ID of the security group used for the endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getSubnetId}
         * @param subnetId The ID of the subnet used for the endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getAccessType}
         * @param accessType The container for the type of connectivity used to access the Amazon S3 on Outposts endpoint.
         *                   To use the Amazon VPC , choose <code>Private</code> . To use the endpoint with an on-premises network, choose <code>CustomerOwnedIp</code> . If you choose <code>CustomerOwnedIp</code> , you must also provide the customer-owned IP address pool (CoIP pool).
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   <code>Private</code> is the default access type value.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessType(java.lang.String accessType) {
            this.accessType = accessType;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getCustomerOwnedIpv4Pool}
         * @param customerOwnedIpv4Pool The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint.
         *                              IP addresses are allocated from this pool for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerOwnedIpv4Pool(java.lang.String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getFailedReason}
         * @param failedReason The failure reason, if any, for a create or delete endpoint operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failedReason(software.amazon.awscdk.IResolvable failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getFailedReason}
         * @param failedReason The failure reason, if any, for a create or delete endpoint operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failedReason(software.amazon.awscdk.services.s3outposts.CfnEndpoint.FailedReasonProperty failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointProps {
        private final java.lang.String outpostId;
        private final java.lang.String securityGroupId;
        private final java.lang.String subnetId;
        private final java.lang.String accessType;
        private final java.lang.String customerOwnedIpv4Pool;
        private final java.lang.Object failedReason;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.outpostId = software.amazon.jsii.Kernel.get(this, "outpostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupId = software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessType = software.amazon.jsii.Kernel.get(this, "accessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerOwnedIpv4Pool = software.amazon.jsii.Kernel.get(this, "customerOwnedIpv4Pool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failedReason = software.amazon.jsii.Kernel.get(this, "failedReason", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.outpostId = java.util.Objects.requireNonNull(builder.outpostId, "outpostId is required");
            this.securityGroupId = java.util.Objects.requireNonNull(builder.securityGroupId, "securityGroupId is required");
            this.subnetId = java.util.Objects.requireNonNull(builder.subnetId, "subnetId is required");
            this.accessType = builder.accessType;
            this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
            this.failedReason = builder.failedReason;
        }

        @Override
        public final java.lang.String getOutpostId() {
            return this.outpostId;
        }

        @Override
        public final java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.lang.String getAccessType() {
            return this.accessType;
        }

        @Override
        public final java.lang.String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        @Override
        public final java.lang.Object getFailedReason() {
            return this.failedReason;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("outpostId", om.valueToTree(this.getOutpostId()));
            data.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
            data.set("subnetId", om.valueToTree(this.getSubnetId()));
            if (this.getAccessType() != null) {
                data.set("accessType", om.valueToTree(this.getAccessType()));
            }
            if (this.getCustomerOwnedIpv4Pool() != null) {
                data.set("customerOwnedIpv4Pool", om.valueToTree(this.getCustomerOwnedIpv4Pool()));
            }
            if (this.getFailedReason() != null) {
                data.set("failedReason", om.valueToTree(this.getFailedReason()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3outposts.CfnEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointProps.Jsii$Proxy that = (CfnEndpointProps.Jsii$Proxy) o;

            if (!outpostId.equals(that.outpostId)) return false;
            if (!securityGroupId.equals(that.securityGroupId)) return false;
            if (!subnetId.equals(that.subnetId)) return false;
            if (this.accessType != null ? !this.accessType.equals(that.accessType) : that.accessType != null) return false;
            if (this.customerOwnedIpv4Pool != null ? !this.customerOwnedIpv4Pool.equals(that.customerOwnedIpv4Pool) : that.customerOwnedIpv4Pool != null) return false;
            return this.failedReason != null ? this.failedReason.equals(that.failedReason) : that.failedReason == null;
        }

        @Override
        public final int hashCode() {
            int result = this.outpostId.hashCode();
            result = 31 * result + (this.securityGroupId.hashCode());
            result = 31 * result + (this.subnetId.hashCode());
            result = 31 * result + (this.accessType != null ? this.accessType.hashCode() : 0);
            result = 31 * result + (this.customerOwnedIpv4Pool != null ? this.customerOwnedIpv4Pool.hashCode() : 0);
            result = 31 * result + (this.failedReason != null ? this.failedReason.hashCode() : 0);
            return result;
        }
    }
}
