package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnUserProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnUserProfileProps cfnUserProfileProps = CfnUserProfileProps.builder()
 *         .domainId("domainId")
 *         .userProfileName("userProfileName")
 *         // the properties below are optional
 *         .singleSignOnUserIdentifier("singleSignOnUserIdentifier")
 *         .singleSignOnUserValue("singleSignOnUserValue")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userSettings(UserSettingsProperty.builder()
 *                 .codeEditorAppSettings(CodeEditorAppSettingsProperty.builder()
 *                         .appLifecycleManagement(AppLifecycleManagementProperty.builder()
 *                                 .idleSettings(IdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .lifecycleManagement("lifecycleManagement")
 *                                         .maxIdleTimeoutInMinutes(123)
 *                                         .minIdleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
 *                         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .build()))
 *                 .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
 *                         .gid(123)
 *                         .uid(123)
 *                         .build())
 *                 .defaultLandingUri("defaultLandingUri")
 *                 .executionRole("executionRole")
 *                 .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
 *                         .appLifecycleManagement(AppLifecycleManagementProperty.builder()
 *                                 .idleSettings(IdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .lifecycleManagement("lifecycleManagement")
 *                                         .maxIdleTimeoutInMinutes(123)
 *                                         .minIdleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .rStudioServerProAppSettings(RStudioServerProAppSettingsProperty.builder()
 *                         .accessStatus("accessStatus")
 *                         .userGroup("userGroup")
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .sharingSettings(SharingSettingsProperty.builder()
 *                         .notebookOutputOption("notebookOutputOption")
 *                         .s3KmsKeyId("s3KmsKeyId")
 *                         .s3OutputPath("s3OutputPath")
 *                         .build())
 *                 .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
 *                         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
 *                                 .defaultEbsVolumeSizeInGb(123)
 *                                 .maximumEbsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .studioWebPortal("studioWebPortal")
 *                 .studioWebPortalSettings(StudioWebPortalSettingsProperty.builder()
 *                         .hiddenAppTypes(List.of("hiddenAppTypes"))
 *                         .hiddenMlTools(List.of("hiddenMlTools"))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:15.864Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnUserProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-domainid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-domainid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainId();

    /**
     * The user profile name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-userprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-userprofilename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserProfileName();

    /**
     * A specifier for the type of value specified in SingleSignOnUserValue.
     * <p>
     * Currently, the only supported value is "UserName". If the Domain's AuthMode is IAM Identity Center , this field is required. If the Domain's AuthMode is not IAM Identity Center , this field cannot be specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuseridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuseridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSingleSignOnUserIdentifier() {
        return null;
    }

    /**
     * The username of the associated AWS Single Sign-On User for this UserProfile.
     * <p>
     * If the Domain's AuthMode is IAM Identity Center , this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not IAM Identity Center , this field cannot be specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuservalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-singlesignonuservalue</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSingleSignOnUserValue() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * Tags that you specify for the User Profile are also added to all apps that the User Profile launches.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A collection of settings that apply to users of Amazon SageMaker Studio.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html#cfn-sagemaker-userprofile-usersettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserSettings() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserProfileProps> {
        java.lang.String domainId;
        java.lang.String userProfileName;
        java.lang.String singleSignOnUserIdentifier;
        java.lang.String singleSignOnUserValue;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object userSettings;

        /**
         * Sets the value of {@link CfnUserProfileProps#getDomainId}
         * @param domainId The domain ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainId(java.lang.String domainId) {
            this.domainId = domainId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getUserProfileName}
         * @param userProfileName The user profile name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userProfileName(java.lang.String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getSingleSignOnUserIdentifier}
         * @param singleSignOnUserIdentifier A specifier for the type of value specified in SingleSignOnUserValue.
         *                                   Currently, the only supported value is "UserName". If the Domain's AuthMode is IAM Identity Center , this field is required. If the Domain's AuthMode is not IAM Identity Center , this field cannot be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleSignOnUserIdentifier(java.lang.String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getSingleSignOnUserValue}
         * @param singleSignOnUserValue The username of the associated AWS Single Sign-On User for this UserProfile.
         *                              If the Domain's AuthMode is IAM Identity Center , this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not IAM Identity Center , this field cannot be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder singleSignOnUserValue(java.lang.String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             Tags that you specify for the User Profile are also added to all apps that the User Profile launches.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getUserSettings}
         * @param userSettings A collection of settings that apply to users of Amazon SageMaker Studio.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userSettings(software.amazon.awscdk.IResolvable userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getUserSettings}
         * @param userSettings A collection of settings that apply to users of Amazon SageMaker Studio.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userSettings(software.amazon.awscdk.services.sagemaker.CfnUserProfile.UserSettingsProperty userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserProfileProps {
        private final java.lang.String domainId;
        private final java.lang.String userProfileName;
        private final java.lang.String singleSignOnUserIdentifier;
        private final java.lang.String singleSignOnUserValue;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object userSettings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainId = software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userProfileName = software.amazon.jsii.Kernel.get(this, "userProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.singleSignOnUserIdentifier = software.amazon.jsii.Kernel.get(this, "singleSignOnUserIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.singleSignOnUserValue = software.amazon.jsii.Kernel.get(this, "singleSignOnUserValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userSettings = software.amazon.jsii.Kernel.get(this, "userSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainId = java.util.Objects.requireNonNull(builder.domainId, "domainId is required");
            this.userProfileName = java.util.Objects.requireNonNull(builder.userProfileName, "userProfileName is required");
            this.singleSignOnUserIdentifier = builder.singleSignOnUserIdentifier;
            this.singleSignOnUserValue = builder.singleSignOnUserValue;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userSettings = builder.userSettings;
        }

        @Override
        public final java.lang.String getDomainId() {
            return this.domainId;
        }

        @Override
        public final java.lang.String getUserProfileName() {
            return this.userProfileName;
        }

        @Override
        public final java.lang.String getSingleSignOnUserIdentifier() {
            return this.singleSignOnUserIdentifier;
        }

        @Override
        public final java.lang.String getSingleSignOnUserValue() {
            return this.singleSignOnUserValue;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUserSettings() {
            return this.userSettings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainId", om.valueToTree(this.getDomainId()));
            data.set("userProfileName", om.valueToTree(this.getUserProfileName()));
            if (this.getSingleSignOnUserIdentifier() != null) {
                data.set("singleSignOnUserIdentifier", om.valueToTree(this.getSingleSignOnUserIdentifier()));
            }
            if (this.getSingleSignOnUserValue() != null) {
                data.set("singleSignOnUserValue", om.valueToTree(this.getSingleSignOnUserValue()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserSettings() != null) {
                data.set("userSettings", om.valueToTree(this.getUserSettings()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnUserProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserProfileProps.Jsii$Proxy that = (CfnUserProfileProps.Jsii$Proxy) o;

            if (!domainId.equals(that.domainId)) return false;
            if (!userProfileName.equals(that.userProfileName)) return false;
            if (this.singleSignOnUserIdentifier != null ? !this.singleSignOnUserIdentifier.equals(that.singleSignOnUserIdentifier) : that.singleSignOnUserIdentifier != null) return false;
            if (this.singleSignOnUserValue != null ? !this.singleSignOnUserValue.equals(that.singleSignOnUserValue) : that.singleSignOnUserValue != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.userSettings != null ? this.userSettings.equals(that.userSettings) : that.userSettings == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainId.hashCode();
            result = 31 * result + (this.userProfileName.hashCode());
            result = 31 * result + (this.singleSignOnUserIdentifier != null ? this.singleSignOnUserIdentifier.hashCode() : 0);
            result = 31 * result + (this.singleSignOnUserValue != null ? this.singleSignOnUserValue.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userSettings != null ? this.userSettings.hashCode() : 0);
            return result;
        }
    }
}
