package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The classification within a EMR Containers application configuration.
 * <p>
 * Class can be extended to add other classifications.
 * For example, new Classification('xxx-yyy');
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobName("EMR-Containers-Job")
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .build())
 *                 .build())
 *         .applicationConfig(List.of(ApplicationConfiguration.builder()
 *                 .classification(Classification.SPARK_DEFAULTS)
 *                 .properties(Map.of(
 *                         "spark.executor.instances", "1",
 *                         "spark.executor.memory", "512M"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:16.832Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.Classification")
public class Classification extends software.amazon.jsii.JsiiObject {

    protected Classification(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Classification(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        SPARK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class, "SPARK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class));
        SPARK_DEFAULTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class, "SPARK_DEFAULTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class));
        SPARK_ENV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class, "SPARK_ENV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class));
        SPARK_HIVE_SITE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class, "SPARK_HIVE_SITE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class));
        SPARK_LOG4_J = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class, "SPARK_LOG4J", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class));
        SPARK_METRICS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class, "SPARK_METRICS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class));
    }

    /**
     * Creates a new Classification.
     * <p>
     * @param classificationStatement A literal string in case a new EMR classification is released, if not already defined. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Classification(final @org.jetbrains.annotations.NotNull java.lang.String classificationStatement) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(classificationStatement, "classificationStatement is required") });
    }

    /**
     * Sets the maximizeResourceAllocation property to true or false.
     * <p>
     * When true, Amazon EMR automatically configures spark-defaults properties based on cluster hardware configuration.
     * <p>
     * For more info:
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-spark-configure.html#emr-spark-maximizeresourceallocation">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-spark-configure.html#emr-spark-maximizeresourceallocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.Classification SPARK;

    /**
     * Sets values in the spark-defaults.conf file.
     * <p>
     * For more info:
     * <p>
     * @see <a href="https://spark.apache.org/docs/latest/configuration.html">https://spark.apache.org/docs/latest/configuration.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.Classification SPARK_DEFAULTS;

    /**
     * Sets values in the spark-env.sh file.
     * <p>
     * For more info:
     * <p>
     * @see <a href="https://spark.apache.org/docs/latest/configuration.html#environment-variables">https://spark.apache.org/docs/latest/configuration.html#environment-variables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.Classification SPARK_ENV;

    /**
     * Sets values in the hive-site.xml for Spark.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.Classification SPARK_HIVE_SITE;

    /**
     * Sets values in the log4j.properties file.
     * <p>
     * For more settings and info:
     * <p>
     * @see <a href="https://github.com/apache/spark/blob/master/conf/log4j.properties.template">https://github.com/apache/spark/blob/master/conf/log4j.properties.template</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.Classification SPARK_LOG4_J;

    /**
     * Sets values in the metrics.properties file.
     * <p>
     * For more settings and info:
     * <p>
     * @see <a href="https://github.com/apache/spark/blob/master/conf/metrics.properties.template">https://github.com/apache/spark/blob/master/conf/metrics.properties.template</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.Classification SPARK_METRICS;

    /**
     * A literal string in case a new EMR classification is released, if not already defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClassificationStatement() {
        return software.amazon.jsii.Kernel.get(this, "classificationStatement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
